---
title: 'В этом выпуске: Chrome 92, CRUD на Fastify, drag&drop с RxJS, блокирующие загрузку ресурсы, связанные с безопасностью HTTP-заголовки, отключение аккаунтов MDN, а также временное сокращение количества выпусков новостей.'
soundcloudLink: 'https://soundcloud.com/csssr/chrome-92-crud-na-fastify-dragdrop-s-rxjs-blokiruyushchie-zagruzku-resursy-otklyuchenie-akkauntov-mdn'
date: '2021-07-23T00:00:00.000Z'
episodeNumber: 184
tag: 'news'
author: 'Ислам Виндижев'
---

Начну с небольшого анонса. На следующей неделе выпусков новостей не будет, а в последующие две недели новости будут выходить по одному эпизоду в неделю, на это время меня подменит мой коллега Сергей Головин. Ближайший выпуск новостей выйдет 6 августа.

<ParagraphWithImage imageName="manWithLaptop">
  ### Интересные публикации

Довольно часто встречаются материалы о реализации какой-то функциональности. Так, Крис Тшесневски (Chris Trześniewski) написал статью [о реализации drag&drop при помощи Observables RxJS](https://www.thisdot.co/blog/how-to-implement-drag-and-drop-using-rxjs). Он демонстрирует базовую реализацию и дает ссылку на продвинутый пример. По его мнению, с RxJS гораздо проще управлять событиями и поведением, а декларативность добавляет удобства.
</ParagraphWithImage>

Раньше все пользовались Express для бэкенда на JS, потом близкими аналогами, потом пришёл NestJS, который обругали за декораторы (и не только) и в итоге начинают подзабывать. Теперь у нас есть новый фаворит — Fastify. Следующий материал — это отличный шанс с ним познакомиться. Элайджа Триллионз (Elijah Trillionz) написал статью, в которой создает [CRUD на Fastify](https://dev.to/elijahtrillionz/build-a-crud-api-with-fastify-688). Он знакомит читателей с базовыми понятиями и структурой, а затем реализует методы API для работы со статьями абстрактного блога. 

Ни для кого не секрет, что некоторые ресурсы могут [блокировать отрисовку страницы](https://sia.codes/posts/render-blocking-resources/). Сиа Карамалегос (Sia Karamalegos) в своем блоге рассказывает, какие ресурсы это могут быть и как избежать блокировки. Если коротко, она пишет, что нужно минифицировать JS и CSS, применять ленивую загрузку к некритичным ресурсам и использовать атрибуты async, defer и module в соответствии с ситуацией. Естественно, она подробно разбирает каждый пункт.

Как часто вы задумываетесь [о безопасности и HTTP-заголовках](https://habr.com/ru/company/timeweb/blog/568288/), которые с ней связаны? Если редко или хотите разобраться, добро пожаловать в статью Игоря Агапова на Хабре. На примере пары приложений он разбирает заголовки, приводит их в соответствие стандартам безопасности и анализирует их при помощи сервисов WebPageTest и Security Headers. Получился подробный гайд-туториал.

[Пора ли прощаться с библиотекой для тестирования Enzyme](https://www.piotrstaniow.pl/goodbye-enzyme)? На этот вопрос в своей статье пытается ответить Петр Станёв (Piotr Staniów). Он считает, что пора: библиотека слишком медленно начинает поддерживать новые фичи React, сама команда React не советует ей пользоваться, она поддерживается одним человеком (что добавляет риска) и, наконец, на рынке уже много лучших альтернатив. Использовать Enzyme или нет — решать вам, а где-то он мог достаться вам по наследству. В любом случае, подробнее с аргументами Петра можно ознакомиться в статье.

Козима Мильке (Cosima Mielke) на SmashingMagazine собрала в одной статье [ресурсы и инструменты для работы с цветами](https://www.smashingmagazine.com/2021/07/color-tools-resources/). Здесь можно найти как генераторы цветовых схем, так и просто ресурсы для вдохновения и новых идей.

Завершают рубрику две подборки плагинов для VSCode: [первая](https://dev.to/jatinkrr/11-vs-code-extensions-to-increase-your-productivity-2021-29b1) представляет из себя список из 11 отдельных плагинов, а [вторая](https://dev.to/ibrahimcesar/nextjs-developer-extensions-pack-install-the-best-vscode-extensions-with-one-click-32jf) предназначена для разработки с NextJS, состоит из нескольких десятков плагинов, а устанавливается в один клик из магазина плагинов. Посмотрите, возможно, там найдется что-то полезное для вашей повседневной работы.

<ParagraphWithImage imageName="laptopNews" >
  ### Новости релизов

Вышел [Chrome 92](https://chromereleases.googleblog.com/2021/07/stable-channel-update-for-desktop_20.html). В этой версии появилась возможность управлять компонентами Privacy Sandbox, что позволяет отключить новую рекламную фичу Google FLoC. На десктопах по умолчанию включен кеш переходов, была усилена изоляция сайтов и дополнений в разных процессах. Кроме того, была значительно увеличена скорость и эффективность определения фишинговых сайтов. Новая версия использует V8 9.2 и теперь браузер поддерживает метод at() для коллекций. В DevTools появился новый редактор гридов с функцией предпросмотра, были добавлены возможности фильтрации запросов из WebAssembly-кода и переопределения выражений const в веб-консоли, также была улучшена отладка ошибок CORS.
</ParagraphWithImage>

У Firefox очередное обновление [90.0.2](https://www.mozilla.org/en-US/firefox/90.0.2/releasenotes/). Была устранена небольшая проблема с урезанием печати и внесены изменения для включения DNS-over-HTTPS по умолчанию для пользователей из Канады.

Доступно [Safari Technology Preview 128](https://webkit.org/blog/11925/release-notes-for-safari-technology-preview-128/). Был реализован метод timeOrigin() для Performance API, были добавлены оптимизации JavaScript и исправлено несколько багов CSS. Вкладки веб-инспектора тоже получили небольшое обновление: имена CSS-переменных больше не преобразуются в lowercase на вкладке вычисленных значений, а неиспользуемые, унаследованные стили по умолчанию скрыты на вкладке стилей.

Вышел [Laravel 8.51](https://laravel-news.com/laravel-8-51-0). Главное нововведение — вывод стектрейса исключений при падении тестов HTTP-запросов без временного отключения обработки исключений.

Также отмечу июльский [Critical Patch Update](https://blogs.oracle.com/security/post/cpujuly2021) для продуктов Oracle, не забывайте обновляться.

<ParagraphWithImage imageName="laptopNews" >
  ### Другие новости

Напомню, что не так давно MDN начали поддерживать через репозиторий на GitHub. Это стало частью изменений, связанных с кризисом и сокращением расходов на поддержку ресурса. Из-за этого аккаунты MDN, по мнению Mozilla, [стали не нужны](https://hacks.mozilla.org/2021/07/spring-cleaning-mdn-part-1/), на 22 июля была запланирована очистка базы данных и отключение аккаунтов. По идее, это уже должно было произойти, так что если вдруг вы не сможете зайти или в принципе найти форму логина — всё в порядке, так было задумано. Команда Mozilla напоминает, что вы всё ещё [можете контрибьютить](https://developer.mozilla.org/en-US/docs/MDN/Contribute), только теперь это нужно будет делать через GitHub.
</ParagraphWithImage>

  ### Пишите нам и читайте
  [Telegram—канал CSSSR](https://t.me/csssr)

  [Twitter CSSSR](https://twitter.com/csssr_dev)

  [Twitter новостей](https://twitter.com/csssr_news)

  [Telegram ведущего](https://t.me/Vindizh)

  [Twitter ведущего](https://twitter.com/Vindizh)
