---
title: 'Ten Tips and Best Practices for<br> <i>Accurate Task Estimating</i>'
coverImageAlt: 'alt me'
date: '2019-12-02T05:35:07.322Z'
tag: 'management'
author: 'Alisa Matienko'
---

---

**T**ask estimating and time planning are both stress and responsibility, and some developers even come up with ideological excuses against them. However, whether they want it or not, it is all about terms and estimates in the IT-world, rather than code quality. Faster development provides certain advantage over competitors, while an adequate task estimation allows to calculate the costs more accurately. The customer is primarily interested in timing and the exact cost of work. Each of these parameters depends directly on the estimation done by a developer who has been digging into the project during presale. No doubt, the manager will include additional risks, but this will be useless if the developer has miscalculated 3 times before.

Let’s face it — you can’t avoid task estimating, and if you do not estimate the tasks within a given project, then most likely someone else is doing it instead of you. At the same time, the developer able to estimate adequately and precisely is a sort of a godsend for his employer. Such specialists are valuable, they grow faster than those with poor estimating skills.

Our team has travelled a lengthy and bumpy path dealing with poor-quality estimates. These prevented us from staying within budget limits, spoiled our relations with customers, and made us look not that smart. By trial and error, we have come up with a set of rules (tips) that helped to enhance the accuracy of our estimates. Hope you’ll find them useful as well.

<Img imageName="man-on-unicorn" alt="man-on-unicorn" withBigMargin/>

## Secure the Conditions

To begin with, wrong estimates made systematically, along with significant delays, are not always your fault. To make a top-level task estimate, a number of conditions should be met.

### Enough time is allocated for estimation

This is an important and painstaking thing, and if a developer has only 15 minutes to estimate a major feature, then, unsurprisingly, something will drop out. If this is what really happens to you, your duty is to communicate the concerns to the management and try to convince that an extra hour spent on the estimation process can prevent 100 hours of further delay.

### Estimation is integrated into your workflow

You will fail to upgrade your estimating skills to a top-level being in the middle of a complete mess: i.e. when tasks are estimated on a case-by-case basis, or you are suddenly forced to estimate one task while working on another, or it is generally unclear whether you should estimate any or not. The first step towards effective task estimating would be fostering the culture of estimation within your team. A high-level team discipline, among other factors, guaranteers efficiency. Having precise regulation of estimation stages can be helpful, and if the developer can draw the conclusions about the quality of his estimate in the end of the project, then the confusion will be minimal resulting in work efficiency increase. In this case, quality improvement will be just a matter of time.

<ParagraphWithImage imageName="man-and-astronauts">
### Tasks are set correctly
<p>No matter how vast your experience is, you cannot include an estimate into those parts of the functionality that you don’t even have an idea of. To consider the task in detail (both hidden at the initial stage, and those that will emerge later) you need to have a third eye, which is, unfortunately, unrealistic. Nevertheless, you can minimize these risks by preparing reasonable (if not brilliant) Terms of Reference (ToR).</p>
</ParagraphWithImage>

If ToR leave no hope for an accurate estimation, never be afraid to ask questions, even if it takes additional time.

### Ideally, task estimating consists of two phases:

- You carefully read ToR, ask questions to the analyst/customer’s representative.

- Get the answers and estimate the task.

But the truth would be more like this:

- You carefully read ToR and ask questions to the author of the original idea.

- You get the answers that generate even more questions.

- Again.

- And again.

The process can be delayed, however, these time costs will bring more value. By the way, at this stage we often involve testers instead of developers. Mistakes made while stating the problem are expensive, and the more people participate in bugs hunting, the better results you would achieve.

<ParagraphWithImage imageName="man-and-ladder">
## Work on Yourself
<p>Let’s move on to the estimation rules and focus on what you, personally, can do to improve the team’s performance.</p>
</ParagraphWithImage>

### Break the task into sections and do it properly

Eat an elephant one bite at a time. A good decomposition gives a powerful boost to fit into an estimate. This is worth doing, even if you do not plan to distribute tasks between different developers. First, when decomposing, you look at the task a little closer, from either side, you think of an implementation plan, which means you see new features and also those requiring extra time. Secondly, this is an additional possibility of self-control. If you are implementing a monolith task designed for 120 hours, there’s a risk of spending 30 hours on one of its parts instead of 12 that were really worth spending. This works another way with decomposition.

### Compare your estimates and time actually spent

To upgrade the estimating skill, you need to receive feedback on how close to reality your previous estimates really were. You can set a special filter in Jira, or at least create a dedicated Google table.

### Mind the risks

<p>Discuss separately everything that can significantly affect the final estimate. These factors include:</p>

- Unfinished task setting (unprepared layouts and ToR, API issues and everything “to be provided later”);

- Technology that you have not used before;

- Gaps in the description and lack of answers to your questions.

Report these when evaluating the task, make it clear that changes made to task setting would result in labor costs increase.

### Be realistic

When your manager or a team leader is asking you this “how long will it take?” question, he is actually not interested in the amount of time you’ll spend on writing the code. Everyone (well, almost everyone) has come across this. The exact figure will be useless here, since it doesn’t correlate with reality. Count the time you will spend on writing the code, add the time you will spend on smoking, drinking coffee, napping, asking your neighbor for advice, waiting for an answer from the analyst, corrections to layout from the designer, getting stalled with the back-end, falling ten times and rising eleven times. How much time should be put into risks? My advice is to start from 20% when dealing with large tasks and 50% for smaller ones. Then look at the result and, if necessary, adjust the figure.

### Don’t bend

Do not agree to lower your estimate, especially if you are 100% sure this will not work. Teach your colleagues that it will take as much time as it should take. Learn to defend your estimates in a reasoned manner, as people will always try to haggle with you.

### Do not overestimate (significantly)

If it is more or less clear with an underestimation, so what is wrong with overestimation? Wouldn’t it be a nice surprise to complete a task twice as fast as expected? Maybe somewhere, for someone. With some reservations:

This is harmful to discipline. Parkinson’s law says work expands so as to fill the time available for its completion: maybe more, but almost never less. In our experience, only a few can normally complete the task ahead of schedule. The rest use up all the time provided. Therefore, when overestimating (“just in case”) without real risks, bid farewell to this time, because, most likely, it will be simply wasted.

It can also ruin the entire planning and other processes within your team. Developer’s workload is planned in advance for a certain period. If somehow the work designed for a two-week sprint is done in 3-4 days, the rest of the team will be left perplexed, while the “top performer” will find himself without tasks. This seems ridiculous, not heroic. Besides, it makes one seriously doubt the skills of such developer. Secondly, the software development process is not limited to coding. There are other processes for the teammates to participate, including analytics, planning, testing, code review. Since your backlog is empty, all these guys need to drop their current (possibly urgent) work and rush to feed you new tasks and test the old ones. Thus, the efficiency of planning and team interaction are smoothly tending toward zero, generating chaos and destruction.

Perhaps the last tip below.

### Relax 🙂

Mess-ups are inevitable. Sometimes we still mess up ourselves. No surprise here — so many things can go wrong! However, it’s important not to give up and analyze your successes and failures, adapt other people’s processes and rules and invent your own — those that will work specifically for your team.

We hope that these tips above will help to avoid frequent rookie mistakes on this long and fascinating journey.
