---
title: 'The Baltic <span>E-Success</span>:</br> A&nbsp;Brief Introduction to&nbsp;the <i>Estonian IT</i>&nbsp;Industry'
coverImageAlt: 'alt me'
date: '2019-11-14T05:35:07.322Z'
tag: 'business'
---

---

**E**stonia enjoys the reputation of a genuinely digital society. Today, it is Europe’s most ambitious country in terms of technological and IT development. Most of government services are delivered 24/7 and have been digitally linked across one platform, while blockchain technology is often used to secure data integrity. Estonia has the largest number of IT startups per capita, while the alumni of two leading Universities are behind the world-famous tech companies that have changed the market. Let’s have a look at the numbers that make the country claim it is the real E-success and IT leader.

<Img imageName="flag" alt="flag" withBigMargin/>

## Europe’s most developed IT sector

Estonia is one of the smallest European countries with a population of <a href="https://www.worldometers.info/world-population/estonia-population/" rel="nofollow noopener" target="_blank">1,3 million people</a>. However, it is well known for its enormous contribution to the mass adoption and development of various IT solutions. Estonian IT industry, despite its comparatively small share in the global market, has certain well-developed segments. The overall contribution of the national IT sector to the country’s GDP is estimated at 4%.

The emerging strengths of Estonian IT industry include numerous technological solutions offered to the companies and organizations operating in the financial, governmental and cyber security sectors. As of the mid-2017, Estonia had almost 23 thousand of IT professionals, a relatively large number for a small European state. Today, the country’s IT market is receiving an increasing attention from both tech specialists and companies.

What makes Estonia progressive are the governmental initiatives aimed at the extended use of its developing IT industry. Everything is being turned electronic — legislation, voting, education, healthcare, banking, justice, tax systems, etc. E-Residency, a digital platform launched by the Estonian government 5 years ago, is possibly the best known example. Through this platform, residents of other countries get access to a range of government services provided to domestic population.

In 2019, Estonia is anticipated to issue <a href="https://e-estonia.com/digital-nomads-visa-shape-urban-employment/" rel="nofollow noopener" target="_blank">the first visa for “digital nomads”</a>, allowing top talents from around Europe, and beyond, to take on business and working opportunities for 12 months. By now, Estonia has shared its e-governance experience with <a href="https://e-estonia.com/it-sector/" rel="nofollow noopener" target="_blank">60 governments</a> and exported its solutions to over 130 countries worldwide.

## The ambitious startup community

Digital society has also fostered a culture of innovative tech companies. The country’s ambitious startup community has turned Estonia into one of the top countries that have the most established startups (from Fintech to Greentech and beyond) per capita than anywhere else in Europe.

According to statistics from the <a href="https://www.emta.ee/eng" rel="nofollow noopener" target="_blank">Estonian Tax and Customs Board</a>, in 2018, Estonian startups <a href="https://www.startupestonia.ee/blog/2018-records-for-the-estonian-startup-sector-new-wave-of-entrepreneurs-in-the-community" rel="nofollow noopener" target="_blank">employed 3763</a> specialists in their offices in Estonia, an increase of 26% compared to 2981 people in 2017. Same year, the annual turnover generated by the Estonian startups has reached €299 million, which is 9% above the 2017 level (€275 million).

In 2018, the total investments attracted by the Estonian startups have reached almost €328 million. The largest investment so far (€150 million) was made into <a href="https://bolt.eu/ru/" rel="nofollow noopener" target="_blank">Bolt</a> (one of Uber’s competitors), then followed by <a href="https://www.pipedrive.com/" rel="nofollow noopener" target="_blank">Pipedrive</a>(€43 million + €8,7 million), <a href="https://monese.com/" rel="nofollow noopener" target="_blank">Monese</a> (€51,6 million) and <a href="https://www.starship.xyz/" rel="nofollow noopener" target="_blank">Starship Technologies</a> (€21,4 million).

At the moment, there are <a href="https://e-estonia.com/it-sector/" rel="nofollow noopener" target="_blank">4800 IT companies</a> doing business in Estonia that can be segmented by three core types: purely Estonian; Estonian eventually becoming international (local startups that attracted foreign investments); purely international.

## At the top of tax competitiveness rating

Another attractive thing about Estonia is the progressive and competitive tax system. Startups allocating investments to the growth and development of the company, are authorized to pay 0% taxes. This initiative seeks to develop private businesses and stimulates the inflow of small and medium enterprises to the country. In 2019, Estonia reached the highest position in the rating of the world’s most competitive tax systems released by <a href="https://taxfoundation.org/2019-international-index/" rel="nofollow noopener" target="_blank">The International Tax Foundation</a>.

The score in the given index was achieved through a 20% corporate profit tax (applied to distributed profits only), a 20% tax on individual income (not applying to personal dividend income), and a property tax applied to the land’s value only. Foreign profits earned by local companies are also exempted from the profit taxation.

<Separator type="color-line" lineColor="#D3D3FF" imageName="manWithCafeBg" imageTitle="manWithCafeBg" />

## Homegrown IT minds and scholars

Most professionals employed in the Estonian IT field are the graduates from the University of Tartu (UT) or the Tallin Tech University (TalTech), while TalTech’s School of Information Technologies is home to around 70% of all Estonian IT students.

Scientists from the UT specialize in deep learning, machine learning, artificial intelligence, cryptography, etc. The UT alumni are behind the global tech companies, like <a href="https://www.skype.com/" rel="nofollow noopener" target="_blank">Skype</a> (video chatting service), <a href="http://www.playtech.ee/?nav=index&lang=en" rel="nofollow noopener" target="_blank">Playtech</a> (gaming industry’s leading software supplier), <a href="https://transferwise.com/" rel="nofollow noopener" target="_blank">Transferwise</a> (money-transfer service) and <a href="https://www.jrebel.com/" rel="nofollow noopener" target="_blank">JRebel</a> (a software company).

TalTech is active exploring software development, computing systems design, biorobotics and biomedical engineering, cybersecurity. Scholars from TalTech have founded companies like <a href="http://testonica.com/" rel="nofollow noopener" target="_blank">Testonica Lab</a> (electronics manufacturing), <a href="https://www.funderbeam.com/startups/optofluid-technologies" rel="nofollow noopener" target="_blank">Optofluid Technologies</a> (online sensors for dialysis machines), <a href="https://guardtime.com/" rel="nofollow noopener" target="_blank">Guardtime</a> (cybersecurity solutions).

## Just the beginning

Surely, the way to become a digital society in Estonia was challenging. In 2007, the state suffered a severe cyber attack which has affected and almost completely disabled some segments of its digital infrastructure. There were many other challenges the government has wrestled to make a tiny Baltic country one of the most tech-savvy societies in the world. Estonia has undertaken a range of reforms designed to guarantee a complete modernization of a national economy. As a result of its commitment to innovation, you can use medical <span class="no-wrap">e-prescriptions</span>, file taxes, or even buy a car online.

The country now represents a benchmark of a well-built digital society. Some say, that Estonia is running its country like a tech company. True. Yet, this is just the beginning of a long journey, as more tech companies from Estonia are exploring the most trendy technical segments, with Big Data, AI, AR/VR and cyber security among others.

Outsourcing is another trend to follow as it opens new ways to eliminate weaknesses of <span class="no-wrap">in-house</span> project development. <a href="https://loremscriptum.com/#about" rel="nofollow noopener" target="_blank">Outsourcing in the IT world</a> has proved extremely popular due to its economic advantages, and Estonia is not an exception in this respect. As the national IT sector grows, the country will need more professional IT talents, including <span class="no-wrap">back-end</span> and <span class="no-wrap">front-end</span> developers, computer and data scientists, top JavaScript specialists, etc.
