---
title: 'How Close Your <i>Outsourced Team</i> Should Be Located? Pros and Cons'
coverImageAlt: 'Working process'
date: '2020-07-28T05:35:07.322Z'
tag: 'business'
---

---

**T**hose days when you could seriously argue whether it’s a bad or a good idea to bring outsourcers in your business are gone. Now the question is different: how to choose an outsourcing team so as to get maximum benefit and minimum risks.<br class="how-close-br" />
First of all, you should consider from where exactly this team will be working.

If you classify outsourcing by location, you can distinguish three main types:

- A team works together with yours in the same office. All communications — face to face, external and internal developers participate in meetings and brainstorms together.
- A team works from its own office. Communication within the team takes place offline, and interaction with your team are done through regular meetings and the Internet.
- A team is fully distributed, all interaction is remote.

Each type has its own peculiarities. At a contractor’s search stage, your key task is to correctly define the terms of interaction with the future outsourced team and select the most suitable way of working so that these features become advantages.

If one collects opinions about working with outsourced teams from different companies, he or she can learn that sometimes the same initial conditions may result in the opposite outcomes. Some say that a fully distributed outsourced team shows a higher result than a team working from an office. Others recall their experience with remote developers as a complete failure, but note the increase in productivity after inviting the outsourcers to work in their office. The easiest way is to blame the professionalism of the outsourced team for everything. But in fact the truth is that the environment and conditions play a significant role in how effectively a team can work. Let us look into what those conditions are and how to take them into account when choosing a contractor.

<ParagraphWithImage imageName="skydiving-people">
## Team Goals
<p>The correctly defined goals are 90% of success. Make your mind what you would like to achieve outsourcing some job from your in-house IT department: to speed up on-going development, to launch a new one, or to ease the pressure on the supporting team of an already operating product.</p>

In any case, it is important to remember that it will take time for a new team to adapt to your processes and get familiar with the context. The more “legacy” there is in the tasks they will have to perform, the longer this period will be. In critical situations, it can be greatly reduced by placing the developers in the epicenter of events right in the office. This is especially true for a pre-release stage products or those at support, i.e. in all cases when information exchange between yours and the outsourced team should be as fast as possible. However, if you are only planning to launch development, this option may bring no benefits, as new information will be distributed as it generated, but the office costs will certainly increase.
</ParagraphWithImage>

<ParagraphWithImage imageName="skydiving-man">
## Special Teams
<p>If you need a team of HTML developers to quickly launch a batch of typical landings, you can find suitable candidates almost anywhere in the world. But if you’re looking for developers with deep expertise by choosing a team to be located in the office, you limit your choice. Professional distributed teams are able to recruit the best specialists from all over the world, which means you can engage in your project, for example, five signor-developers within one team.</p>
</ParagraphWithImage>

## Company Procedures

You would like the outsourced team to follow your internal procedures. The following shall be taken into consideration:

- Level of control. If your management keeps a strict record of all your employees’ activities, and this is critical for you, the most convenient option would be an outsourced team working in your office. Alternatively, desktop monitoring systems for employees can be considered, but such solutions are often expensive and greatly reduce motivation.
- Well-tuned, clear and structured processes. The clearer the mechanisms within your team work, the less risk of losing time, data and information when working with outsourcers. In small teams, where processes are not yet regulated, outsourcers working close to their office colleagues will be able to handle tasks more efficiently.
- Documentation. Although a project coverage with up-to-date and comprehensive documentation is the generally recognized best practice, reality is not ideal. If your project lacks well-functioning documentation support — the farther the developers are from the team, the more painful their work will be.
- Main communication channels. Take note how your employees communicate. Nowadays, many companies use messengers and video communication inside the office — it is quick, convenient, saves the history of communication, and does not knock out of the “stream” the developers deeply immersed in the problem. If this is your story, then the connection with a distributed team will go seamless. And vice versa, teams that meet three times a day in a meeting room will hardly work smoothly with remote developers or a team from another office.

These points are a “quick test” of your in-house IT department’s readiness for expansion through outsourcing. In order to get the full picture you need to analyze a lot more factors and we’re ready to help with that. Email us and we will give you free advice on all the particulars of connecting the outsourcing team to your development.

One argument against outsourcing often heard from CTOs or team leaders is that “our processes are not adapted to include outsiders at all”. Unfortunately, sometimes this is really true.

The good news is that including the team “inside” your processes is not always necessary. If it has to work on the whole project or the selected particular parts, so you can organize the work in the way that the teams are synchronized only at key points. Experienced professional outsourced teams do not need to be controlled at every stage.

There’s a security issue worths mentioned separately. We can assume that distributed teams definitely lose out when it comes to working on projects that require a high level of data access control. But in reality, it’s a question of experience and the right tools: we’ve been working with banks and companies dealing with cybersecurity for many years and have learned to adjust to almost any requirements.

<ParagraphWithImage imageName="laptop-work">
## Project Completion
<p>Any project comes to an end at some point and at that point one have to decide what to do with the people who no longer have assignments. Having an outsourced team is like an insurance against the necessity to fire or transfer employees to other departments. The costs of “shutting down” distributed teams or those in own office are lower — one doesn’t have to think about abandoned workplaces, passes cancellation and empty spaces. This also applies to putting work on hold: for your in-house developers such standstill is often too much to bear and it is definitely expensive for you.</p>
</ParagraphWithImage>

## Costs

Often the choice of outsourcing development is a choice in favor of economy. In this light, distributed teams look the most advantageous: it is cheaper to have them, and therefore the cost of hiring them is much lower. However, recruiting a team with its own office also creates a lower financial burden than your office outstaffing.

So, to sum it up.

<Table color='purple' withBorders>
  <thead>
    <tr>
      <th />
      <th>Your office outstaffing</th>
      <th>Outsource in its own office</th>
      <th>Distributed team</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th colspan="4" data-text="Aim">Aim</th>
    </tr>
    <tr>
      <th>Emergency help to your project</th>
      <td>++</td>
      <td>+</td>
      <td>-</td>
    </tr>
    <tr>
      <th>Development support or upgrades with new functions</th>
      <td>+</td>
      <td>+</td>
      <td>+</td>
    </tr>
    <tr>
      <th>Launch of new development</th>
      <td>+</td>
      <td>+</td>
      <td>+</td>
    </tr>
    <tr>
      <th colspan="4" data-text="Specialists Qualification">Specialists Qualification</th>
    </tr>
    <tr>
      <th>Regular specialists</th>
      <td>+</td>
      <td>+</td>
      <td>+</td>
    </tr>
    <tr>
      <th>Unique specialists</th>
      <td>--</td>
      <td>-</td>
      <td>+</td>
    </tr>
    <tr>
     <th colspan="4" data-text="Processes">Processes</th>
    </tr>
    <tr>
      <th>Firm control</th>
      <td>++</td>
      <td>+</td>
      <td>-</td>
    </tr>
    <tr>
      <th>Strict processes</th>
      <td>+</td>
      <td>+</td>
      <td>++</td>
    </tr>
    <tr>
      <th>Documentations</th>
      <td>+</td>
      <td>++</td>
      <td>++</td>
    </tr>
    <tr>
      <th>Personal communication</th>
      <td>++</td>
      <td>+</td>
      <td>-</td>
    </tr>
    <tr>
      <th>Communication via messengers</th>
      <td>+</td>
      <td>+</td>
      <td>++</td>
    </tr>
    <tr>
      <th>Security concerns</th>
      <td>+</td>
      <td>+</td>
      <td>+</td>
    </tr>
    <tr>
      <th colspan="4" data-text="Miscellaneous">Miscellaneous</th>
    </tr>
    <tr>
      <th>Project completion</th>
      <td>-</td>
      <td>+</td>
      <td>+</td>
    </tr>
    <tr>
      <th>Low cost</th>
      <td>--</td>
      <td>-</td>
      <td>++</td>
    </tr>
  </tbody>
</Table>

There are no one-size-fits-all solutions, but proper planning and risk assessment at the start of cooperation will help avoid many mistakes. Be honest with yourself and the team your hired — this will make your outsourcing experience the most productive.
