---
title: 'How to Integrate <i>Creative</i> and <i>Web Development</i>'
coverImageAlt: 'alt me'
date: '2019-12-18T05:35:07.322Z'
tag: 'business'
---

<Subtitle>..and why partnerships are better than IT departments or subcontracting.</Subtitle>

---

**W**eb development and creative design have always gone hand-in-hand. In the beginning, websites and internet traffic were relatively simple, with only basic code and designs, and limited specialization. Simply put, there wasn’t much thought putinto making websites truly high performance. However, times have changed, and each field has become increasingly competitive. As budgets for web development have swelled, the challenge of bringing together creative agencies and web developers has become more important.

The history of digital advertising is a gradual trend towards increased specialization. At first, large companies wanted a full-service provider, so they typically turned to major advertising agencies to give them the full spectrum of communications services. Originally, there were two classifications for these services, above-the-line (ATL), focussing on a broad range of customers, or the more targeted <span class="no-wrap">below-the-line</span> (BTL), appealing to specific groups. At first, digital advertising was grouped in with BTL, but over time digital advertising became a separate field in its own right. Now, when a company seeks an advertising agency, they look for ATL, BTL and digital.

Web development is also becoming more and more sophisticated and, with it, budgets for digital promotion have been growing. As the field has developed, specialization has increased, with some companies offering specialized creative services and others, web development, because it is no longer efficient for creative agencies to hire internal developers and build a management model for IT teams.

<Img imageName="swing" alt="swing" withBigMargin />

## Web Development Options for Creative Agencies

### Option 1: Internal IT Department

What are the main challenges of building your own IT department? Well, it takes time to set up a reliable and skilled IT team and significant investment to support it. Additionally, the team needs to have a wide range of skills so that it can handle specialized requests. The agency may instead have to hire or train additional team members for each assignment, which can be time-consuming and expensive.

So, often developing internal technical skills is a <span class="no-wrap">less-than-appealing</span> idea for creative agencies. However, the good news is that when agencies choose to forgo developing their own IT departments, there are several alternatives, better models for web development services:

<ParagraphWithImage imageName="clockwork-bird">
### Option 2: Subcontractor / Freelance
<p>While a simple solution, subcontracting or hiring freelancers lacks predictability and transparency. To win tenders and avoid losing clients, companies often understate costs, without bothering to understand the actual expenses and labor required. Only after they win the bid do they start thinking about who they could give the project to at the price they negotiated.</p>
</ParagraphWithImage>

Reputable agencies refuse to work under these conditions, while freelancers might agree to just about any project, even unfeasible ones. Misjudging their own expertise, resources and time, freelancers tend to place the burden of responsibility for possible issues on the agency and end-client.

Alternatively, and less pessimistically, an experienced agency might design an appropriate campaign, but make a poor choice of developer, something difficult to avoid if you use a different contractor for each project. As a result, the end-customer gets a strong creative idea, with poor implementation and/or a postponed launch date.

<ParagraphWithImage imageName="horse-man">
<p>If you, as a client, are offered development work by an agency through a subcontractor, we recommend you instead take on the task of finding a suitable contractor yourself. Try to find a separate contractor for the web development part of the project, compare the expertise levels of different teams and choose the best one for you. Tech recruiters can be helpful for this task, as they have plenty of experience in identifying tech talent.</p>
</ParagraphWithImage>

The same advice rings true for creative agencies as well: whenever possible don’t work with subcontractors. By hiding the real provider, you’re signing yourself up for all the risk if something goes wrong. Even if your creativity is excellent, you run the risk of damaging your reputation with low-quality development that you can’t control.

### Option 3: Alliance

While possibly a less obvious approach, establishing an alliance is more stable and predictable. Instead of trying to use a new partner for each project, major creative and web development companies can look to team up with each other for a long-term alliance. In these types of alliances, the companies will typically partner with the other for each project, which brings added continuity and reliability. Alliances also take out the need for companies to seek out new contractors for each project, saving time and resources.

Additionally, when working in an alliance, creative agencies do not have to budget for additional risks connected to contractors, because the web development company typically has its own terms with the client. This means there is less risk for the creative agency in an area that isn’t its focus. The same goes for the web developer, which doesn’t need to answer for design and branding elements.

A good alliance can work for nearly any project, with few exceptions is specific cases. For instance, the company requesting the service might have its own internal capabilities in a given field, or want to work with another partner, or some specialized skill or knowledge might be required for a particular project. However, for the most part, well formed alliances have clear advantages over the subcontractor / freelance model.

<Img imageName="men-in-boat" alt="men-in-boat" withBigMargin/>

## The Rules of a Good Alliance

Creative agencies and web development companies that are seriously considering alliances should keep in mind these four keys to success:

### 1. Both teams must be engaged from start

The main advantage of an alliance is the ability to complement each other’s expertise. While working in tandem, web developers can advise creative agencies early on about what ideas might significantly increase project costs and suggest how to implement them in a more <span class="no-wrap">cost-effective</span> way.

Web developers can also advise on which technologies are best suited to a particular project and which would be best to avoid. For example, some projects require costly support of outdated web browsers that few customers would actually use. Costs to support an old browser could amount to a 30% increase in the total cost of the project, while only applicable for a net increase in customers of 0.5%. Of course, the client might decide it still wants to go ahead with supporting the browser, but if both the creative team and the web development team are included in the conversation from the start, the vision will be clearer.

Web developers’ experience can also help more accurately project and meet the client’s deadlines. For instance, if a project needs to be ready for a seasonal peak in activity such as Summer vacations or Autumn fashion, then both teams can be consulted in determining which technologies and designs can be implemented in time.

### 2. Create a transparent system for estimating time and costs

Web developers can provide two types of estimates depending on the availability and quality of source materials: upper-limit and detailed. If a project is ready for implementation, including layouts, functional requirements and an understanding of start and end dates, the developer can provide a more precise estimate, say 5-6 weeks.

On the other hand, if a client needs an early-stage valuation and understanding of which concepts to choose, web developers can give an approximate estimate (e.g. 1-3 months), which will help the creative agency and client to formulate and justify the budget. These kinds of valuation can significantly change after the details of the project become clearer.

### 3. Give each team freedom and flexibility

One of the main advantages of an alliance is that the partners clearly understand the expertise of the other and can vouch for the quality of the end-product. Additionally, each company is free to form several partnerships and choose between them for each project based on the specifications, expertise and strengths of the partner. This approach results in the best possible quality and value for the end-client. However, this also means that signing exclusivity agreements does not make much sense, because a partner’s expertise may not be applicable for some projects.

### 4. Don’t limit yourself geographically, think globally

You can build a successful alliance with a partner from any country. What is more important is understanding that creative agencies should consider the specific features of each country and region. It can be challenging to build an idea that will be successful in an unfamiliar market if your team is immersed in the specifics of its local market. For this reason, it is often best to seek out partnerships with creative agencies based close to clients and who speak the same language, with deep understanding of the local market.

Web development agencies, on the other hand, can be based on different continents, with little-to-no specification for local markets, because code is written in the same languages all over the world and differences in mentality have little effect on end results.

<Img imageName="high-five" alt="high-five" withBigMargin/>

**In conclusion,** when these four rules are followed, alliances between creative agencies and web developers can be the most efficient and effective way for clients to develop their digital presence. Keep them in mind when forming partnerships between web developers and creative design teams, and you will find success in your future projects.
