---
title: 'Космический VPN для сурового фронтенда'
date: '2015-11-21T11:32:00.000Z'
coverImageAlt: 'Или как поднять и настроить свой VPN сервер'
author: 'Паша'
tag: 'web-development'
---

**В**сем привет! С вами один из ведущих разработчиков CSSSR и просто путешественник.

![](/images/pazanov.png)

Уже не раз мы писали о том, что CSSSR — это полностью распределенная компания. География сотрудников постепенно охватывает почти весь земной шар, и многие из нас постоянно в пути. Бывая в самых экзотических уголках вселенной, мы часто сталкиваемся с ограничениями доступа к определенным сервисам и ресурсам, будь то Github, Skype, WhatsApp или Facebook. Я решил рассказать как преодолеть эти ограничения, развернув свой собственный VPN сервер.

#### Чемодан с телефонами

При поиске средств для развертывания VPN самым важным было охватить все устройства, которые оказываются в моем чемодане во время путешествий. Ноутбук (Windows + Ubuntu), телефоны iPhone, Windows Phone, Android и с недавних пор MacBook Air. Все они поддерживают L2TP/IPSec, но иногда возникает необходимость подключиться через OpenVPN или SSTP. Посмотрев множество решений, в конце концов я остановился на **[SoftEther VPN](http://www.softether.org/)**, разработанном в японском университете Tsukuba.

![](/images/vpn/sofether.jpg)

#### Выбор сервера и страны размещения

Имея опыт использования платных VPN серверов, я хорошо понимал, что VPN должен путешествовать с тобой. Так, бессмысленно развертывать VPN в Сингапуре, если ты находишься в Европе. Путешествуя в Азии также не очень разумно использовать VPN сервера в Амстердаме или в Нью-йорке. Таким образом, помимо стабильного доступа и хорошей скорости, нужна возможность быстро развертывать VPN в другой точке галактики.

При выборе провайдера я решил остановиться на **[DigitalOcean](https://www.digitalocean.com/)**, который за три года не подвел меня ни разу. Ребята предлагают размещение как в Европе и США, так и в Азии. Есть возможность делать образы серверов для их быстрого развертывания в новых локациях. Для VPN сервера вполне достаточно базового пакета за **5$ / месяц**, что равноценно стоимости чашки кофе в аэропорту. Новые клиенты могут воспользоваться купонами (например `ALLSSD10`), которые часто публикуют в официальном твиттере и в рекламе, или зарегистрироваться по **[реферальной ссылке](https://www.digitalocean.com/?refcode=d47158e015a5)** и получить **10$** на счет.

#### Устанавливаем VPN сервер

Для начала создаем новый Droplet в DigitalOcean. Я выбрал сервер за 5$ на базе Ubuntu 14 и разместил его в Нью-Йорке, это заняло у меня всего 30 секунд:

![](/images/vpn/server.png)

Первым делом обновляем пакеты:

```js
apt-get update && apt-get upgrade
```

Устанавливаем зависимости:

```js
apt-get install git libreadline-dev libssl-dev libncurses5-dev zlib1g-dev make checkinstall
```

Клонируем репозиторий и настраиваем проект:

```js
git clone https://github.com/SoftEtherVPN/SoftEtherVPN.git
cd SoftEtherVPN\
./configure
```

После вызова `configure` нужно ответить на пару вопросов, выбрать OS и разрядность. В моем случае это Linux и x64. Теперь можно собрать проект и установить VPN сервер:

```js
make
checkinstall
```

При создании пакета и установке также нужно будет ответить на пару вопросов, важный тут только самый первый, когда нужно указать имя для пакета. Я указал `csssrvpn`.

Теперь мы можем запустить наш VPN сервер:

```js
vpnserver start
```

#### Настройка VPN сервера

Настройку можно произвести несколькими способами:

1. Через утилиту `vpncmd`
2. Отредактировав конфигурационный файл `vpn_server.config` (не рекомендуется)
3. При помощи [SoftEther VPN Server Manager](https://www.softether.org/4-docs/1-manual/2._SoftEther_VPN_Essential_Architecture/2.4_VPN_Server_Manager) (только для Windows).

Последний способ самый крутой, интерфейс программы интуитивный и конфигурация занимает пару минут. Тем не менее, в этой статье я расскажу как сконфигурировать сервер при помощи `vpncmd`, так как не все читатели работают с Windows.

Запускаем `vpncmd`, нам будет предложено три варианта:

```js
1. Management of VPN Server or VPN Bridge
2. Management of VPN Client
3. Use of VPN Tools (certificate creation and Network Traffic Speed Test Tool)
```

Выбираем `1. Management of VPN Server or VPN Bridge`, нам будет предложено указать адрес сервера для подключения, нажимаем <kbd>Enter</kbd> для подключение к локальному серверу. Далее последует выбор виртуального хаба, также просто жмем <kbd>Enter</kbd>.

Теперь можно приступить к конфигурации. Первым делом устанавливаем пароль для администрирования сервера:

```js
ServerPasswordSet
```

Далее создаем новый виртуальный хаб, к которому в дальнейшем будут подключаться пользователи:

```js
hubcreate csssrhub
```

Пароль для хаба указывать необязательно, так как мы не планируем делегировать администрирование хаба третьему лицу. После создания хаба, переключаемся в режим его администрирования:

```js
Hub csssrhub
```

Создание пользователей сводится к двум командам:

```js
UserCreate
UserPasswordSet
```

Теперь включим для нашего хаба SecureNAT и DHCP. Выполняется это одной командой:

```js
SecureNATEnable
```

Для Windows, MacOS, iOS, Android и Windows Phone (8.1+) можно использовать **L2TP/IPSec**, включаем:

```js
IPsecEnable
```

На первые три вопроса отвечаем `yes`. Далее указываем ключ который позже будет использоваться для доступа к VPN серверу (Shared Key). После этого нам будет предложено выбрать стандартный хаб чтобы не добавлять его к имени пользователя каждый раз, вводим здесь название хаба созданного ранее (в моем случае `csssrhub`):

```js
Enable L2TP over IPsec Server Function (yes / no): yes
Enable Raw L2TP Server Function (yes / no): yes
Enable EtherIP / L2TPv3 over IPsec Server Function (yes / no): yes
Pre Shared Key for IPsec (Recommended: 9 letters at maximum): MyVPN
Default Virtual HUB in a case of omitting the HUB on the Username: csssrhub
```

На этом конфигурация L2TP/IPSec закончена и можно опробовать подключение.

#### L2TP подключение в iOS

![](/images/vpn/ios.png)

Настройка Android и Windows Phone производится аналогично. Для MacOS настройки также отличаются не очень сильно.

#### LT2P/IPSec подключение в Windows

В Windows создаем обычное VPN подключение и затем настраиваем его.

![](/images/vpn/1.png)

В свойствах подключения меняем тип на L2TP/IPSec:

![](/images/vpn/6.png)

И указываем Shared Key в дополнительных настройках:

![](/images/vpn/7.png)

Всё готово!

#### Заключение

При помощи SoftEther VPN у меня очень быстро получилось поднять свой собственный VPN сервер. Помимо L2TP/IPSec также не составит труда настроить поддержку SSTP и OpenVPN. К сожалению, пока нет поддержки IKEv2, но я надеюсь, что в скором времени она появится.

Желаю всем беззаботных путешествий! Ждём ваших комментариев в [Твиттере](https://twitter.com/csssr_dev)!
