# CSSSR blog

В этом репозитории содержится исходный код для [blog.csssr.com](https://blog.csssr.com).

*Readme так же доступен на [английском языке](./README.md).*

## Описание

Для блога мы используем:
- [Next.js](https://nextjs.org/)
потому что он быстро развивается, хорошо удовлетворяет требования разработчиков и бизнеса, а так же имеет хорошую поддержку
- [markdown](https://www.markdownguide.org/)
потому что его легко использовать и он хорошо распространён
- [markdown-to-jsx](https://probablyup.com/markdown-to-jsx/)
потому что он добавляет больше гибкости в наши md файлы, позволяя нам создавать свои кастомные React компоненты для них
- [imgproxy](https://imgproxy.net/)
потому что он быстрый, надёжный и позволяет нам автоматизировать обработку изображений
- [emotion](https://emotion.sh/docs/introduction)
потому что это одно из лучших решений для CSS-in-JS на данный момент
- [github actions](https://github.com/features/actions)
потому что они напрямую интегрированы в github и облегчают работу с CI
- [static html export](https://nextjs.org/docs/advanced-features/static-html-export)
потому что это позволяет нам достигнуть оптимальной производительности и облегчает процесс деплоя

Мы надеемся, что этот репозитория будет полезен всем, кто создаёт приложения при помощи Next.js, особенно тем, кто заинтересован в создании блога. 

## Читать дальше
- [Запуск проекта](./docs/ru/SETUP.md)
- [Работа с git](./docs/ru/GIT.md)
- [Создание новой статьи](./docs/ru/NEW_ARTICLE.md)
- [Наполнение статьи](./docs/ru/ARTICLE_CONTENT.md)
- [Компоненты](./docs/ru/COMPONENTS.md)

## Лицензия
Блог CSSSR это проект с открытым исходным кодом выпущенный под лицензией [MIT](https://github.com/CSSSR/csssr.blog/LICENSE).