# CSC 119 - Intro to Programming C++ 

## Basic Course Information
| | |
| ------------- | ------------- |
| Course Name | Intro to Programming C++ CSC 119-601 |
| Semester  | Summer 2021  |
| Credits   | 3 Credits  |
| Prerequisites / Corequisites  |  MAT 050 (Quantitative Literacy), MAT 055 (Algebraic Literacy)   |
| In Person Class Times  | Tuesday/Thursday 2:00 PM - 3:50 AM  |
| Location  | Larimer Campus, Blanca Peak 119  |

## Instructor Information

|  | |
| ------------- | ------------- |
| Instructor  | Matthew Ernst  |
| Email   | Matthew.Ernst@frontrange.edu  |
| College Website  |  www.frontrange.edu   |
| Office Location| BP 157|
| Office Hours  | by appointment |
| Department Contact  | Soley Belt, Department Chair, Soley.Belt@frontrange.edu  |

## Technical Support 
|  | |
| -------------------- | -------------------- |
| Intro to Online Learning  | Found under the FRCC Resources menu in D2L. Includes info on how to use D2L, WebEx, Zoom and other learning technologies  |
| 24x7 Help Desk Web Site  | [Click Here](http://help.cccs.edu) |
| 24x7 Help Desk Phone | 1-(888)800-9198 (toll free)  |

## Course Materials
ZyBooks, Visual Studio Code, GitHub

## CCCS Required Syllabus Information

### Catalog Course Description

Emphasizes the design and implementation of structured and logically correct programs with good documentation. Focuses on basic programming concepts, including numbering systems, control structures, modularization, and data processing. A structured programming language is used to implement the student`s program designs. 3.000 Credit hours.

### Course Learning Outcomes

- Input data from the computer keyboard using standard input and output commands via a programming language.
  
- Create a program that demonstrates the use of variables and constants.
  
- Develop and implement basic program elements of processes, loops, and sequences.

- Write a program using control structures and functions.

- Write and modify a program using array processing.

- Design a program that outputs processed data to the computer screen.

- Create a program using File I/O from a program specification.

## Welcome Message

Welcome to CSC119! My name is Matthew Ernst, and I will be your instructor for this course. A little about me, I am currently a graduate student at Colorado State University specializing in artificial intelligence and machine learning in optimal neuron selection for neural networks. Aside from computer science I am a big music/guitar fan. I am excited to be teaching this course this summer. It will be a fresh take on learning C++ by building a raytracer. This may sound intimidating; however, I know all of you will be able to do it. Before class starts, you are more than welcome to email me with any questions about this course. I look forward to meeting you all! 

## Course Overview

### Instructor's Overview of the Course

This course is designed to be an active learning course. This means that the classes homework’s and final project are all intertwined. Specifically, homework’s will build off each other as the course progresses. At the end of this course each student will have a raytracer they can show to future employers. Homework’s are a large portion of this class's grade, do not worry though. Homework’s will be worked on with partners and will have a chance at one redo. The final project will be done individually.

Each student will learn various tools along with a foundation in C++ programming. These tools include Visual Studio Code and GitHub. The materials of this course will be located on GitHub. In the first week of class everyone will setup a GitHub and have access to these materials. Each week I will publish the current weeks lecture’s, homework’s, etc.


### Grade Breakdown

| Activities | Contribution to Overall Grade |
| ---------- | ----------------------------- |
| ZyBooks    | 10% of Overall Grade           |
| Homework   | 70% of Overall Grade          |
| Final Project | 20% of Overall Grade       |

### Grading Scale and Standards

| Letter Grade | Range     |
| ------------ | --------- |
| A            | 90 – 100% |
| B            | 80 – 89%  |
| C            | 70 – 79%  |
| D            | 60 – 69%  |
| F            | 59% and lower    |

### Late Policy

There are many homework assignments, at least one per week. Late assignments will lose 10% each day they are late, including weekends and breaks. After assignment’s are graded, I will be dropping the lowest homework grade. However, remember these assignments build off each other therefore it is important to understand the content from all of them.

### Attendance and Participation

This class will move quickly, especially in the summer section. Attendance is not required; however, IT IS HIGHLY ENCOURAGED. In past classes I have taught, the students that show up to class and ask questions are the ones that succeed the most. Please feel free to come to class and ask any questions about the class or computer science.

### Academic Honesty

Students are expected to uphold FRCC’s Student Code of Conduct relating to academic honesty and assume full responsibility for the content and integrity of the academic work they submit. The guiding principle of academic integrity will be that a student's submitted work, examinations, reports, discussions, and projects must be that of the student's own work and unique to the course. Students are guilty of violating the honor code if they:

•	Represent the work of others as their own (this includes copying material from the Internet for discussion postings or other assignments without proper citation)

•	Use or obtain unauthorized assistance in any academic work.

•	Give unauthorized assistance to other students.

•	Modify, without instructor approval, an examination, paper, record, or report for the purpose of obtaining additional credit.

•	Misrepresent the content of submitted work.

•	The penalty for violating the honor code is severe. Any student violating the honor code is subject to receive a failing grade for the course and will be reported to the Office of Student Affairs. If a student is unclear about whether a particular situation may constitute an honor code violation, the student should contact the instructor to discuss the situation.

### Collaboration. 

Unless otherwise instructed, all work submitted is to be done individually by the student. This means you should not be working in pairs or in a group to write discussion posts, complete assignments or take quizzes and other assessments unless specifically asked to do so by your instructor.

### Plagiarism / Dual Submission. 

Plagiarism, whether intentional or accidental, is academic dishonesty and may incur disciplinary action ranging from receiving a zero on an assignment or failing a course to more severe consequences. Plagiarism means

•	Using someone else’s ideas and not correctly citing that use. This means that if you put someone else’s work into your own words, put it in your work, and do not correctly document it, the idea is plagiarized. 

•	Using someone else’s words without quotation marks and not correctly citing that use. 

•	Using someone else’s images or other works (such as from the Internet) without correctly citing that use.
•	Submitting work that has been turned in for credit in another class or at another institution unless specifically permitted by your instructor. 

•	Students may be required to submit work that is evaluated for originality by Turnitin.com, a plagiarism detection software program that checks for certain forms of plagiarism. 

## Program Expectations

REPLACE WITH CTE 

### Use of Video Conferencing Technology

Students will be notified in advance if audio and/or video recordings will be made of any class meetings, and may opt out of using their microphone or video camera.  To protect student privacy, access to the recordings will be restricted to members of the class, the instructor, and instructional support staff.  Students will also be notified if audio and/or video recordings will be required as part of specific course assignments or online test proctoring.   

A student granted permission by the instructor to make an audio or video recording may use the recording only for his or her own study purposes and may not publish or post the recording on YouTube or any other medium or venue without the instructor's explicit written authorization. 

Please contact your instructor if you have any questions or concerns.

### Campus Closure Procedure

If Front Range Community College or one of its campuses closes due to inclement weather or another emergency, online and real-time remote courses will proceed unless access to Desire2Learn or other online technologies is impacted. If you experience particular hardship or problems completing the course as a result of an emergency, contact your instructor or call Online Learning at 970-204-8250 or 303-404-5513.

### Technical Difficulties

All FRCC Courses have an online course site in Desire2Learn (D2L), and may incorporate other online materials (e.g. publisher content and open educational resources). As a student in an online or real-time remote class, you are responsible for ensuring that you have a reliable internet connection and the necessary equipment to access your online course(s) and any required course materials listed in the course syllabus. Computer failure or problems with internet access are not considered valid excuses for not completing coursework, so be sure to have a backup plan in place so that you can still complete your work on time even if you run into technical problems. Local libraries and computer labs on campuses can be great alternatives, but be sure to check on hours and availability. 

For technical assistance with Desire2Learn, contact the 24x7 Help Desk: (http://help.cccs.edu); 888-800-9198 (toll free). Link to the 24x7 Help Desk and System Check can be found in D2L under the Tech Support Menu. D2L is available 24x7, with the exception of limited maintenance windows posted on the home page. In the unlikely event of an unplanned D2L outage, faculty and staff will be informed so that they can make reasonable adjustments to the course schedule and assignment deadlines. 

## Student Rights, Responsibilites, and Resources

For important information on rights and responsibilities of all FRCC students, as well as the many support resources available to you, please refer to the link to “Student Rights, Responsibilities and Resources” in D2L. Topics include:

•	COVID-19

•	Philosophy of Inclusion

•	Course Questions

•	Access to Course Materials

•	Student Email

•	Student Drop for Non-Attendance 

•	Payment Deadline

•	Financial Aid 

•	Academic Assistance

•	Disability Support Services 

•	Use of Audio / Video Recordings

•	Crisis Counseling and Stress Management

•	FRCC Cares

•	Notice of Non-Discrimination 

•	Mandatory Reporting (Title IX)

•	Student Rights and Responsibilities 



## Course Schedule

See [Here](./Course-Schedule.md).
