/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.StringCompare;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PdfNameTree {
    private static final int leafSize = 64;
    private static final StringCompare stringCompare = new StringCompare();

    public static PdfDictionary writeTree(HashMap hashMap, PdfWriter pdfWriter) throws IOException {
        int n;
        int n2;
        int n3;
        if (hashMap.size() == 0) {
            return null;
        }
        String[] stringArray = new String[hashMap.size()];
        stringArray = hashMap.keySet().toArray(stringArray);
        Arrays.sort(stringArray, stringCompare);
        if (stringArray.length <= 64) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            for (int i = 0; i < stringArray.length; ++i) {
                pdfArray.add(new PdfString(stringArray[i], null));
                pdfArray.add((PdfIndirectReference)hashMap.get(stringArray[i]));
            }
            pdfDictionary.put(PdfName.NAMES, pdfArray);
            return pdfDictionary;
        }
        int n4 = 64;
        PdfIndirectReference[] pdfIndirectReferenceArray = new PdfIndirectReference[(stringArray.length + 64 - 1) / 64];
        for (n3 = 0; n3 < pdfIndirectReferenceArray.length; ++n3) {
            n = Math.min(n2 + 64, stringArray.length);
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            pdfArray.add(new PdfString(stringArray[n2], null));
            pdfArray.add(new PdfString(stringArray[n - 1], null));
            pdfDictionary.put(PdfName.LIMITS, pdfArray);
            pdfArray = new PdfArray();
            for (n2 = n3 * 64; n2 < n; ++n2) {
                pdfArray.add(new PdfString(stringArray[n2], null));
                pdfArray.add((PdfIndirectReference)hashMap.get(stringArray[n2]));
            }
            pdfDictionary.put(PdfName.NAMES, pdfArray);
            pdfIndirectReferenceArray[n3] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
        }
        n3 = pdfIndirectReferenceArray.length;
        while (true) {
            if (n3 <= 64) {
                PdfArray pdfArray = new PdfArray();
                for (n = 0; n < n3; ++n) {
                    pdfArray.add(pdfIndirectReferenceArray[n]);
                }
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                return pdfDictionary;
            }
            n2 = (stringArray.length + (n4 *= 64) - 1) / n4;
            for (n = 0; n < n2; ++n) {
                int n5;
                int n6 = Math.min(n5 + 64, n3);
                PdfDictionary pdfDictionary = new PdfDictionary();
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(new PdfString(stringArray[n * n4], null));
                pdfArray.add(new PdfString(stringArray[Math.min((n + 1) * n4, stringArray.length) - 1], null));
                pdfDictionary.put(PdfName.LIMITS, pdfArray);
                pdfArray = new PdfArray();
                for (n5 = n * 64; n5 < n6; ++n5) {
                    pdfArray.add(pdfIndirectReferenceArray[n5]);
                }
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                pdfIndirectReferenceArray[n] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
            }
            n3 = n2;
        }
    }

    private static void iterateItems(PdfDictionary pdfDictionary, HashMap hashMap) {
        block3: {
            PdfArray pdfArray;
            block2: {
                pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAMES));
                if (pdfArray == null) break block2;
                ArrayList arrayList = pdfArray.getArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    PdfString pdfString = (PdfString)PdfReader.getPdfObject((PdfObject)arrayList.get(i++));
                    hashMap.put(pdfString.toString(), arrayList.get(i));
                }
                break block3;
            }
            pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary.get(PdfName.KIDS));
            if (pdfArray == null) break block3;
            ArrayList arrayList = pdfArray.getArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)arrayList.get(i));
                PdfNameTree.iterateItems(pdfDictionary2, hashMap);
            }
        }
    }

    public static HashMap readTree(PdfDictionary pdfDictionary) {
        HashMap hashMap = new HashMap();
        if (pdfDictionary != null) {
            PdfNameTree.iterateItems(pdfDictionary, hashMap);
        }
        return hashMap;
    }
}

