/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOInputHandler;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.apps.Options;
import org.apache.fop.apps.Starter;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.tools.anttasks.Fop;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.xml.sax.XMLReader;

class FOPTaskStarter
extends Starter {
    Fop task;
    Logger log;
    boolean logFiles;

    FOPTaskStarter(Fop task, Logger aLogger, boolean aLogFiles) throws FOPException {
        this.task = task;
        this.log = aLogger;
        this.logFiles = aLogFiles;
    }

    private int determineRenderer(String format) {
        if (format == null || format.equalsIgnoreCase("application/pdf") || format.equalsIgnoreCase("pdf")) {
            return 1;
        }
        if (format.equalsIgnoreCase("application/postscript") || format.equalsIgnoreCase("ps")) {
            return 7;
        }
        if (format.equalsIgnoreCase("application/vnd.mif") || format.equalsIgnoreCase("mif")) {
            return 3;
        }
        if (format.equalsIgnoreCase("application/vnd.gp-PCL") || format.equalsIgnoreCase("pcl")) {
            return 6;
        }
        if (format.equalsIgnoreCase("text/plain") || format.equalsIgnoreCase("txt")) {
            return 8;
        }
        if (format.equalsIgnoreCase("text/xml") || format.equalsIgnoreCase("at") || format.equalsIgnoreCase("xml")) {
            return 4;
        }
        String err = "Couldn't determine renderer to use: " + format;
        throw new BuildException(err);
    }

    private String determineExtension(int renderer) {
        switch (renderer) {
            case 1: {
                return ".pdf";
            }
            case 7: {
                return ".ps";
            }
            case 3: {
                return ".mif";
            }
            case 6: {
                return ".pcl";
            }
            case 8: {
                return ".txt";
            }
            case 4: {
                return ".xml";
            }
        }
        String err = "Unknown renderer: " + renderer;
        throw new BuildException(err);
    }

    private File replaceExtension(File file, String expectedExt, String newExt) {
        String name = file.getName();
        if (name.toLowerCase().endsWith(expectedExt)) {
            name = name.substring(0, name.length() - expectedExt.length());
        }
        name = name.concat(newExt);
        return new File(file.getParentFile(), name);
    }

    public void run() throws FOPException {
        if (this.task.userConfig != null) {
            new Options(this.task.userConfig);
        }
        try {
            if (this.task.getFofile() != null) {
                if (this.task.getBasedir() != null) {
                    Configuration.put("baseDir", this.task.getBasedir().toURL().toExternalForm());
                } else {
                    Configuration.put("baseDir", this.task.getFofile().getParentFile().toURL().toExternalForm());
                }
            }
            this.task.log("Using base directory: " + Configuration.getValue("baseDir"), 4);
        }
        catch (Exception e) {
            this.task.log("Error setting base directory: " + e, 0);
        }
        int rint = this.determineRenderer(this.task.getFormat());
        String newExtension = this.determineExtension(rint);
        int actioncount = 0;
        if (this.task.getFofile() != null && this.task.getFofile().exists()) {
            File outf = this.task.getOutfile();
            if (outf == null) {
                throw new BuildException("outfile is required when fofile is used");
            }
            if (this.task.getOutdir() != null) {
                outf = new File(this.task.getOutdir(), outf.getName());
            }
            this.render(this.task.getFofile(), outf, rint);
            ++actioncount;
        }
        GlobPatternMapper mapper = new GlobPatternMapper();
        mapper.setFrom("*.fo");
        mapper.setTo("*" + newExtension);
        for (int i = 0; i < this.task.filesets.size(); ++i) {
            FileSet fs = (FileSet)this.task.filesets.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.task.getProject());
            String[] files = ds.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                File f = new File(fs.getDir(this.task.getProject()), files[j]);
                File outf = null;
                if (this.task.getOutdir() != null && files[j].endsWith(".fo")) {
                    String[] sa = mapper.mapFileName(files[j]);
                    outf = new File(this.task.getOutdir(), sa[0]);
                } else {
                    outf = this.replaceExtension(f, ".fo", newExtension);
                    if (this.task.getOutdir() != null) {
                        outf = new File(this.task.getOutdir(), outf.getName());
                    }
                }
                try {
                    if (this.task.getBasedir() != null) {
                        Configuration.put("baseDir", this.task.getBasedir().toURL().toExternalForm());
                    } else {
                        Configuration.put("baseDir", fs.getDir(this.task.getProject()).toURL().toExternalForm());
                    }
                    this.task.log("Using base directory: " + Configuration.getValue("baseDir"), 4);
                }
                catch (Exception e) {
                    this.task.log("Error setting base directory: " + e, 0);
                }
                this.render(f, outf, rint);
                ++actioncount;
            }
        }
        if (actioncount == 0) {
            this.task.log("No files processed. No files were selected by the filesets and no fofile was set.", 1);
        }
    }

    private void render(File foFile, File outFile, int renderer) throws FOPException {
        FOInputHandler inputHandler = new FOInputHandler(foFile);
        XMLReader parser = ((InputHandler)inputHandler).getParser();
        FileOutputStream out = null;
        try {
            File dir = outFile.getParentFile();
            dir.mkdirs();
            out = new FileOutputStream(outFile);
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
        if (this.logFiles) {
            this.task.log(foFile + " -> " + outFile, 2);
        }
        try {
            Driver driver = new Driver(((InputHandler)inputHandler).getInputSource(), out);
            driver.setLogger(this.log);
            driver.setRenderer(renderer);
            if (renderer == 4) {
                HashMap<String, Boolean> rendererOptions = new HashMap<String, Boolean>();
                rendererOptions.put("fineDetail", new Boolean(true));
                driver.getRenderer().setOptions(rendererOptions);
            }
            driver.setXMLReader(parser);
            driver.run();
            ((OutputStream)out).close();
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }
}

