/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.fop.pdf.PDFObject;

public class PDFEncoding
extends PDFObject {
    public static final String MacRomanEncoding = "MacRomanEncoding";
    public static final String MacExpertEncoding = "MacExpertEncoding";
    public static final String WinAnsiEncoding = "WinAnsiEncoding";
    protected String basename;
    protected HashMap differences;

    public PDFEncoding(int number, String basename) {
        super(number);
        this.basename = basename;
        this.differences = new HashMap();
    }

    public void addDifferences(int code, ArrayList sequence) {
        this.differences.put(new Integer(code), sequence);
    }

    public byte[] toPDF() {
        StringBuffer p = new StringBuffer();
        p.append(this.number + " " + this.generation + " obj\n<< /Type /Encoding");
        if (this.basename != null && !this.basename.equals("")) {
            p.append("\n/BaseEncoding /" + this.basename);
        }
        if (!this.differences.isEmpty()) {
            p.append("\n/Differences [ ");
            Iterator codes = this.differences.keySet().iterator();
            while (codes.hasNext()) {
                Object code = codes.next();
                p.append(" ");
                p.append(code);
                ArrayList sequence = (ArrayList)this.differences.get(code);
                for (int i = 0; i < sequence.size(); ++i) {
                    p.append(" /");
                    p.append((String)sequence.get(i));
                }
            }
            p.append(" ]");
        }
        p.append(" >>\nendobj\n");
        try {
            return p.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            return p.toString().getBytes();
        }
    }
}

