/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.fop.image.analyser.AbstractImageReader;

public class JPEGReader
extends AbstractImageReader {
    protected static final int MARK = 255;
    protected static final int NULL = 0;
    protected static final int SOF1 = 192;
    protected static final int SOF2 = 193;
    protected static final int SOF3 = 194;
    protected static final int SOFA = 202;
    protected static final int APP0 = 224;
    protected static final int APPF = 239;
    protected static final int SOS = 218;
    protected static final int SOI = 216;
    protected static final int JPG_SIG_LENGTH = 2;
    protected byte[] header;

    public boolean verifySignature(String uri, BufferedInputStream fis) throws IOException {
        boolean supported;
        this.imageStream = fis;
        this.setDefaultHeader();
        boolean bl = supported = this.header[0] == -1 && this.header[1] == -40;
        if (supported) {
            this.setDimension();
            return true;
        }
        return false;
    }

    public String getMimeType() {
        return "image/jpeg";
    }

    protected void setDefaultHeader() throws IOException {
        this.header = new byte[2];
        try {
            this.imageStream.mark(3);
            this.imageStream.read(this.header);
            this.imageStream.reset();
        }
        catch (IOException ex) {
            try {
                this.imageStream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ex;
        }
    }

    protected void setDimension() throws IOException {
        try {
            int marker = 0;
            block9: while (this.imageStream.available() > 0) {
                while ((marker = this.imageStream.read()) != 255) {
                }
                while ((marker = this.imageStream.read()) == 255) {
                }
                switch (marker) {
                    case 216: {
                        continue block9;
                    }
                    case 0: {
                        continue block9;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 202: {
                        this.skip(3L);
                        this.height = this.read2bytes();
                        this.width = this.read2bytes();
                        break;
                    }
                    default: {
                        long length = this.read2bytes();
                        long skipped = this.skip(length - 2L);
                        if (skipped == length - 2L) continue block9;
                        throw new IOException("Skipping Error");
                    }
                }
                break;
            }
        }
        catch (IOException ioe) {
            try {
                this.imageStream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ioe;
        }
    }

    protected int read2bytes() throws IOException {
        int byte1 = this.imageStream.read();
        int byte2 = this.imageStream.read();
        return byte1 << 8 | byte2;
    }

    protected long skip(long n) throws IOException {
        long discarded;
        for (discarded = 0L; discarded != n; ++discarded) {
            this.imageStream.read();
        }
        return discarded;
    }
}

