/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fop.fonts.Glyphs;
import org.apache.fop.fonts.type1.PFMInputStream;

public class PFMFile
extends AbstractLogEnabled {
    private String windowsName;
    private String postscriptName;
    private short dfItalic;
    private int dfWeight;
    private short dfCharSet;
    private short dfPitchAndFamily;
    private int dfAvgWidth;
    private int dfMaxWidth;
    private int dfMinWidth;
    private short dfFirstChar;
    private short dfLastChar;
    private int etmCapHeight;
    private int etmXHeight;
    private int etmLowerCaseAscent;
    private int etmLowerCaseDescent;
    private int[] extentTable;
    private Map kerningTab = new HashMap();

    public void load(InputStream inStream) throws IOException {
        InputStream bufin = new BufferedInputStream(inStream, 1024);
        ((InputStream)bufin).mark(1024);
        PFMInputStream in = new PFMInputStream(bufin);
        int version = in.readShort();
        long filesize = in.readInt();
        ((InputStream)bufin).reset();
        byte[] buf = new byte[(int)filesize];
        ((InputStream)bufin).read(buf, 0, (int)filesize);
        bufin = new ByteArrayInputStream(buf);
        in = new PFMInputStream(bufin);
        this.loadHeader(in);
        this.loadExtension(in);
    }

    private void loadHeader(PFMInputStream inStream) throws IOException {
        inStream.skip(80L);
        this.dfItalic = inStream.readByte();
        inStream.skip(2L);
        this.dfWeight = inStream.readShort();
        this.dfCharSet = inStream.readByte();
        inStream.skip(4L);
        this.dfPitchAndFamily = inStream.readByte();
        this.dfAvgWidth = inStream.readShort();
        this.dfMaxWidth = inStream.readShort();
        this.dfFirstChar = inStream.readByte();
        this.dfLastChar = inStream.readByte();
        inStream.skip(8L);
        long faceOffset = inStream.readInt();
        inStream.reset();
        inStream.skip(faceOffset);
        this.windowsName = inStream.readString();
        inStream.reset();
        inStream.skip(117L);
    }

    private void loadExtension(PFMInputStream inStream) throws IOException {
        int size = inStream.readShort();
        long extMetricsOffset = inStream.readInt();
        long extentTableOffset = inStream.readInt();
        inStream.skip(4L);
        long kernPairOffset = inStream.readInt();
        long kernTrackOffset = inStream.readInt();
        long driverInfoOffset = inStream.readInt();
        if (kernPairOffset > 0L) {
            inStream.reset();
            inStream.skip(kernPairOffset);
            this.loadKernPairs(inStream);
        }
        inStream.reset();
        inStream.skip(driverInfoOffset);
        this.postscriptName = inStream.readString();
        if (extMetricsOffset != 0L) {
            inStream.reset();
            inStream.skip(extMetricsOffset);
            this.loadExtMetrics(inStream);
        }
        if (extentTableOffset != 0L) {
            inStream.reset();
            inStream.skip(extentTableOffset);
            this.loadExtentTable(inStream);
        }
    }

    private void loadKernPairs(PFMInputStream inStream) throws IOException {
        int i = inStream.readShort();
        this.getLogger().info(i + " kerning pairs");
        while (i > 0) {
            HashMap<Integer, Integer> adjTab;
            short g1 = inStream.readByte();
            --i;
            short g2 = inStream.readByte();
            this.getLogger().debug("Char no: (" + g1 + ", " + g2 + ") kern");
            int adj = inStream.readShort();
            if (adj > 32768) {
                adj = -(65536 - adj);
                this.getLogger().debug("adjust: " + adj);
            }
            if (this.getLogger().isDebugEnabled()) {
                String glyph1 = Glyphs.tex8r[g1];
                String glyph2 = Glyphs.tex8r[g2];
                this.getLogger().debug("glyphs: " + glyph1 + ", " + glyph2);
            }
            if ((adjTab = (HashMap<Integer, Integer>)this.kerningTab.get(new Integer(g1))) == null) {
                adjTab = new HashMap<Integer, Integer>();
            }
            adjTab.put(new Integer(g2), new Integer(adj));
            this.kerningTab.put(new Integer(g1), adjTab);
        }
    }

    private void loadExtMetrics(PFMInputStream inStream) throws IOException {
        int size = inStream.readShort();
        inStream.skip(12L);
        this.etmCapHeight = inStream.readShort();
        this.etmXHeight = inStream.readShort();
        this.etmLowerCaseAscent = inStream.readShort();
        this.etmLowerCaseDescent = inStream.readShort();
    }

    private void loadExtentTable(PFMInputStream inStream) throws IOException {
        this.extentTable = new int[this.dfLastChar - this.dfFirstChar + 1];
        this.dfMinWidth = this.dfMaxWidth;
        for (short i = this.dfFirstChar; i <= this.dfLastChar; i = (short)(i + 1)) {
            this.extentTable[i - this.dfFirstChar] = inStream.readShort();
            if (this.extentTable[i - this.dfFirstChar] >= this.dfMinWidth) continue;
            this.dfMinWidth = this.extentTable[i - this.dfFirstChar];
        }
    }

    public String getWindowsName() {
        return this.windowsName;
    }

    public Map getKerning() {
        return this.kerningTab;
    }

    public String getPostscriptName() {
        return this.postscriptName;
    }

    public short getCharSet() {
        return this.dfCharSet;
    }

    public String getCharSetName() {
        switch (this.dfCharSet) {
            case 0: {
                return "WinAnsi";
            }
            case 128: {
                return "Shift-JIS (Japanese)";
            }
        }
        return "Unknown";
    }

    public short getFirstChar() {
        return this.dfFirstChar;
    }

    public short getLastChar() {
        return this.dfLastChar;
    }

    public int getCapHeight() {
        return this.etmCapHeight;
    }

    public int getXHeight() {
        return this.etmXHeight;
    }

    public int getLowerCaseAscent() {
        return this.etmLowerCaseAscent;
    }

    public int getLowerCaseDescent() {
        return this.etmLowerCaseDescent;
    }

    public boolean getIsProportional() {
        return (this.dfPitchAndFamily & 1) == 1;
    }

    public int[] getFontBBox() {
        int[] bbox = new int[]{!this.getIsProportional() && this.dfAvgWidth == this.dfMaxWidth ? -20 : -100, -(this.getLowerCaseDescent() + 5), this.dfMaxWidth + 10, this.getLowerCaseAscent() + 5};
        return bbox;
    }

    public int getFlags() {
        int flags = 0;
        if (!this.getIsProportional()) {
            flags |= 1;
        }
        if ((this.dfPitchAndFamily & 0x10) == 16) {
            flags |= 2;
        }
        if ((this.dfPitchAndFamily & 0x40) == 64) {
            flags |= 4;
        }
        if (this.dfCharSet == 0) {
            flags |= 6;
        }
        if (this.dfItalic != 0) {
            flags |= 7;
        }
        return flags;
    }

    public int getStemV() {
        if (this.dfItalic != 0) {
            return (int)Math.round((double)this.dfMinWidth * 0.25);
        }
        return (int)Math.round((double)this.dfMinWidth * 0.6);
    }

    public int getItalicAngle() {
        if (this.dfItalic != 0) {
            return -16;
        }
        return 0;
    }

    public int getCharWidth(short which) {
        return this.extentTable[which - this.dfFirstChar];
    }
}

