/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.RowSpanMgr;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.RelativePositionProps;

public abstract class AbstractTableBody
extends FObj {
    int spaceBefore;
    int spaceAfter;
    String id;
    ArrayList columns;
    RowSpanMgr rowSpanMgr;
    AreaContainer areaContainer;

    public AbstractTableBody(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (!(parent instanceof Table)) {
            throw new FOPException("A table body must be child of fo:table, not " + parent.getName(), systemId, line, column);
        }
    }

    public void setColumns(ArrayList columns) {
        this.columns = columns;
    }

    public void setYPosition(int value) {
        this.areaContainer.setYPosition(value);
    }

    public int getYPosition() {
        return this.areaContainer.getCurrentYPosition();
    }

    public int getHeight() {
        return this.areaContainer.getHeight() + this.spaceBefore + this.spaceAfter;
    }

    public int layout(Area area) throws FOPException {
        if (this.marker == -1001) {
            return 1;
        }
        if (this.marker == -1000) {
            AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
            AuralProps mAurProps = this.propMgr.getAuralProps();
            BorderAndPadding bap = this.propMgr.getBorderAndPadding();
            BackgroundProps bProps = this.propMgr.getBackgroundProps();
            RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.id = this.properties.get("id").getString();
            try {
                area.getIDReferences().createID(this.id);
            }
            catch (FOPException e) {
                if (!e.isLocationSet()) {
                    e.setLocation(this.systemId, this.line, this.column);
                }
                throw e;
            }
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.rowSpanMgr == null) {
                this.rowSpanMgr = new RowSpanMgr(this.columns.size());
            }
            this.marker = 0;
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.increaseHeight(this.spaceBefore);
        }
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
        }
        int spaceLeft = area.spaceLeft();
        this.areaContainer = new AreaContainer(this.propMgr.getFontState(area.getFontInfo()), 0, area.getContentHeight(), area.getContentWidth(), area.spaceLeft(), 88);
        this.areaContainer.foCreator = this;
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setParent(area);
        this.areaContainer.setBackground(this.propMgr.getBackgroundProps());
        this.areaContainer.setBorderAndPadding(this.propMgr.getBorderAndPadding());
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        ArrayList<TableRow> keepWith = new ArrayList<TableRow>();
        int numChildren = this.children.size();
        TableRow lastRow = null;
        boolean endKeepGroup = true;
        for (int i = this.marker; i < numChildren; ++i) {
            boolean bRowStartsArea;
            Object child = this.children.get(i);
            if (child instanceof Marker) {
                ((Marker)child).layout(area);
                continue;
            }
            if (!(child instanceof TableRow)) {
                throw new FOPException("Currently only Table Rows are supported in table body, header and footer", this.systemId, this.line, this.column);
            }
            TableRow row = (TableRow)child;
            row.setRowSpanMgr(this.rowSpanMgr);
            row.setColumns(this.columns);
            row.doSetup(this.areaContainer);
            if (row.getKeepWithPrevious().getType() != "KEEP_WITH_AUTO" && lastRow != null && keepWith.indexOf(lastRow) == -1) {
                keepWith.add(lastRow);
            } else {
                if (endKeepGroup && keepWith.size() > 0) {
                    keepWith = new ArrayList();
                }
                if (endKeepGroup && i > this.marker) {
                    this.rowSpanMgr.setIgnoreKeeps(false);
                }
            }
            boolean bl = bRowStartsArea = i == this.marker;
            if (!bRowStartsArea && keepWith.size() > 0 && this.children.indexOf(keepWith.get(0)) == this.marker) {
                bRowStartsArea = true;
            }
            row.setIgnoreKeepTogether(bRowStartsArea && this.startsAC(area));
            int status = row.layout(this.areaContainer);
            if (Status.isIncomplete(status)) {
                if (Status.isPageBreak(status)) {
                    this.marker = i;
                    area.addChild(this.areaContainer);
                    area.increaseHeight(this.areaContainer.getHeight());
                    if (i == numChildren - 1) {
                        this.marker = -1001;
                        if (this.spaceAfter != 0) {
                            area.increaseHeight(this.spaceAfter);
                        }
                    }
                    return status;
                }
                if (keepWith.size() > 0 && !this.rowSpanMgr.ignoreKeeps()) {
                    row.removeLayout(this.areaContainer);
                    for (int j = 0; j < keepWith.size(); ++j) {
                        TableRow tr = (TableRow)keepWith.get(j);
                        tr.removeLayout(this.areaContainer);
                        --i;
                    }
                    if (i == 0) {
                        this.resetMarker();
                        this.rowSpanMgr.setIgnoreKeeps(true);
                        return 2;
                    }
                }
                this.marker = i;
                if (i != 0 && status == 2) {
                    status = 3;
                }
                if (i != 0 || this.areaContainer.getContentHeight() > 0) {
                    area.addChild(this.areaContainer);
                    area.increaseHeight(this.areaContainer.getHeight());
                }
                this.rowSpanMgr.setIgnoreKeeps(true);
                return status;
            }
            if (status == 8 || this.rowSpanMgr.hasUnfinishedSpans()) {
                keepWith.add(row);
                endKeepGroup = false;
            } else {
                endKeepGroup = true;
            }
            lastRow = row;
            area.setMaxHeight(area.getMaxHeight() - spaceLeft + this.areaContainer.getMaxHeight());
            spaceLeft = area.spaceLeft();
        }
        area.addChild(this.areaContainer);
        this.areaContainer.end();
        area.increaseHeight(this.areaContainer.getHeight());
        if (this.spaceAfter != 0) {
            area.increaseHeight(this.spaceAfter);
            area.setMaxHeight(area.getMaxHeight() - this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        return 1;
    }

    public void removeLayout(Area area) {
        if (this.areaContainer != null) {
            area.removeChild(this.areaContainer);
        }
        if (this.spaceBefore != 0) {
            area.increaseHeight(-this.spaceBefore);
        }
        if (this.spaceAfter != 0) {
            area.increaseHeight(-this.spaceAfter);
        }
        this.resetMarker();
        this.removeID(area.getIDReferences());
    }

    private boolean startsAC(Area area) {
        Area parent = null;
        while ((parent = area.getParent()) != null && !parent.hasNonSpaceChildren()) {
            if (parent instanceof AreaContainer && ((AreaContainer)parent).getPosition() == 1) {
                return true;
            }
            area = parent;
        }
        return false;
    }
}

