/*
 * Decompiled with CFR 0.152.
 */
package dacapo.antlr;

import antlr.Tool;
import dacapo.Benchmark;
import dacapo.parser.Config;
import java.io.File;
import java.util.Vector;

public class AntlrHarness
extends Benchmark {
    public AntlrHarness(Config config, File scratch) throws Exception {
        super(config, scratch);
    }

    protected void prepare() throws Exception {
        super.prepare();
        AntlrHarness.copyFileTo(new File(this.scratch, "antlr/CommonTokenTypes.txt"), this.scratch);
    }

    public void postIteration(String size) throws Exception {
        super.postIteration(size);
        if (!AntlrHarness.isPreserve()) {
            AntlrHarness.deleteTree(new File(this.scratch, "antlr/output"));
        }
    }

    public void iterate(String size) {
        String[] args = this.config.getArgs(size);
        int firstGrammarIndex = 0;
        int nIterations = 1;
        String[] newArgs = null;
        Vector<String> v = new Vector<String>(args.length);
        v.addElement("-o");
        v.addElement(this.scratch.getAbsolutePath());
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-grammars")) {
                firstGrammarIndex = i + 1;
                newArgs = new String[v.size() + 1];
                for (int j = 0; j < v.size(); ++j) {
                    newArgs[j] = (String)v.elementAt(j);
                }
                break;
            }
            if (args[i].equals("-iterations")) {
                nIterations = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-o")) {
                ++i;
                continue;
            }
            v.addElement(args[i]);
        }
        for (int iteration = 0; iteration < nIterations; ++iteration) {
            for (int iGrammar = firstGrammarIndex; iGrammar < args.length; ++iGrammar) {
                String grammarFile;
                newArgs[newArgs.length - 1] = grammarFile = new File(this.scratch, args[iGrammar]).getPath();
                System.out.println("Running antlr on grammar " + args[iGrammar]);
                Tool.main(newArgs);
            }
        }
    }
}

