/*
 * Decompiled with CFR 0.152.
 */
package dacapo.chart;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import dacapo.chart.BarChartRenderer;
import dacapo.chart.Datasets;
import dacapo.chart.GraphConstants;
import dacapo.chart.Plotter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class Graph
implements GraphConstants {
    public Graph(URL fromURL, int chartType) {
        this.plotGraph(fromURL, "graph.jpeg", "", chartType, 29, 32, 640, 480, false);
    }

    public Graph(URL fromURL, int chartType, String extraTitle) {
        this.plotGraph(fromURL, "graph.jpeg", extraTitle, chartType, 29, 32, 640, 480, false);
    }

    public Graph(URL fromURL, int chartType, String extraTitle, int timeLine) {
        this.plotGraph(fromURL, "graph.jpeg", extraTitle, chartType, timeLine, 32, 640, 480, false);
    }

    public Graph(URL fromURL, String toFile, int chartType) {
        this.plotGraph(fromURL, toFile, "", chartType, 29, 32, 640, 480, false);
    }

    public Graph(URL fromURL, int chartType, boolean isSmallGraph) {
        this.plotGraph(fromURL, "graph.jpeg", "", chartType, 29, 32, 640, 480, isSmallGraph);
    }

    public Graph(URL fromURL, int chartType, boolean isSmallGraph, String extraTitle) {
        this.plotGraph(fromURL, "graph.jpeg", extraTitle, chartType, 29, 32, 640, 480, isSmallGraph);
    }

    public Graph(URL fromURL, int chartType, boolean isSmallGraph, String extraTitle, int timeLine) {
        this.plotGraph(fromURL, "graph.jpeg", extraTitle, chartType, timeLine, 32, 640, 480, isSmallGraph);
    }

    public Graph(URL fromURL, String toFile, int chartType, boolean isSmallGraph) {
        this.plotGraph(fromURL, toFile, "", chartType, 29, 32, 640, 480, isSmallGraph);
    }

    public Graph(URL fromURL, int chartType, int timeLine) {
        this.plotGraph(fromURL, "graph.jpeg", "", chartType, timeLine, 32, 640, 480, false);
    }

    public Graph(URL fromURL, String toFile, int chartType, int timeLine) {
        this.plotGraph(fromURL, toFile, "", chartType, timeLine, 32, 640, 480, false);
    }

    public Graph(URL fromURL, int chartType, int timeLine, boolean isSmallGraph) {
        this.plotGraph(fromURL, "graph.jpeg", "", chartType, timeLine, 32, 640, 480, isSmallGraph);
    }

    public Graph(URL fromURL, String toFile, int chartType, int timeLine, boolean isSmallGraph) {
        this.plotGraph(fromURL, toFile, "", chartType, timeLine, 32, 640, 480, isSmallGraph);
    }

    public Graph(URL fromURL, int chartType, int timeLine, int width, int height) {
        this.plotGraph(fromURL, "graph.jpeg", "", chartType, timeLine, 32, width, height, false);
    }

    private void plotGraph(URL fromURL, String toFile, String extraTitle, int chartType, int timeLine, int rangeType, int width, int height, boolean isSmallGraph) {
        CategoryDataset histData = null;
        XYSeriesCollection chartData = null;
        String chartTitle = null;
        String domainAxisLabel = null;
        String rangeAxisLabel = null;
        int graph_width = width;
        int graph_height = height;
        JFreeChart chart = null;
        BufferedOutputStream fileOut = null;
        PdfContentByte cb = null;
        PdfTemplate tp = null;
        DefaultFontMapper mapper = new DefaultFontMapper();
        Graphics2D g2 = null;
        PdfWriter writer = null;
        String fileName = toFile;
        int graphType = this.getGraphType(chartType);
        if (fileName.equals("graph.jpeg")) {
            fileName = this.getFilenameToSave(chartType);
        }
        chartTitle = extraTitle.equals("") ? new String(this.getChartTitleFromType(chartType)) : new String(extraTitle);
        try {
            if (isSmallGraph) {
                fileName = fileName + "-sm";
            }
            fileName = fileName + ".pdf";
            switch (graphType) {
                case 40: {
                    if (isSmallGraph) {
                        graph_width = 200;
                        graph_height = 200;
                    }
                    fileOut = new BufferedOutputStream(new FileOutputStream(fileName));
                    Document pdfDoc = new Document(new Rectangle((float)graph_width, (float)graph_height));
                    writer = PdfWriter.getInstance((Document)pdfDoc, (OutputStream)fileOut);
                    histData = Datasets.getHistDataset(fromURL, chartType, timeLine, rangeType);
                    domainAxisLabel = this.getHistogramDomainLabel(chartType);
                    rangeAxisLabel = this.getRangeLabel(chartType);
                    chart = ChartFactory.createStackedBarChart(chartTitle, domainAxisLabel, rangeAxisLabel, histData, PlotOrientation.VERTICAL, false, true, false);
                    CategoryPlot catPlot = chart.getCategoryPlot();
                    this.makeReadable(catPlot, !isSmallGraph, chartType);
                    if (isSmallGraph) {
                        chart.getTitle().setFont(new Font("SansSerif", 0, 10));
                    }
                    chart.setBorderVisible(false);
                    chart.setBackgroundPaint(Color.white);
                    pdfDoc.open();
                    cb = writer.getDirectContent();
                    tp = cb.createTemplate((float)graph_width, (float)graph_height);
                    g2 = tp.createGraphics((float)graph_width, (float)graph_height, (FontMapper)mapper);
                    Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, graph_width, graph_height);
                    chart.draw(g2, r2D, null);
                    g2.dispose();
                    cb.addTemplate(tp, 0.0f, 0.0f);
                    pdfDoc.close();
                    break;
                }
                case 50: {
                    if (isSmallGraph) {
                        graph_width = 450;
                        graph_height = 200;
                        if (chartType == 21) {
                            graph_height += 10;
                        }
                    }
                    fileOut = new BufferedOutputStream(new FileOutputStream(fileName));
                    Document pdfDoc = new Document(new Rectangle((float)graph_width, (float)graph_height));
                    writer = PdfWriter.getInstance((Document)pdfDoc, (OutputStream)fileOut);
                    if (chartType == 22) {
                        rangeType = 31;
                    }
                    chartData = Datasets.getLineDataset(fromURL, chartType, timeLine, rangeType);
                    domainAxisLabel = this.getLineGraphDomainLabel(timeLine);
                    rangeAxisLabel = this.getRangeLabel(chartType);
                    chart = ChartFactory.createXYLineChart(chartTitle, domainAxisLabel, rangeAxisLabel, chartData, PlotOrientation.VERTICAL, false, true, false);
                    XYPlot xyPlot = chart.getXYPlot();
                    this.makeReadable(xyPlot, !isSmallGraph, chartType);
                    if (isSmallGraph) {
                        chart.getTitle().setFont(new Font("SansSerif", 0, 10));
                    }
                    chart.setBorderVisible(false);
                    chart.setBackgroundPaint(Color.white);
                    chart.getTitle().setHorizontalAlignment(HorizontalAlignment.CENTER);
                    chart.getTitle().setPosition(RectangleEdge.BOTTOM);
                    pdfDoc.open();
                    cb = writer.getDirectContent();
                    tp = cb.createTemplate((float)graph_width, (float)graph_height);
                    g2 = tp.createGraphics((float)graph_width, (float)graph_height, (FontMapper)mapper);
                    Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, graph_width, graph_height);
                    chart.draw(g2, r2D, null);
                    g2.dispose();
                    cb.addTemplate(tp, 0.0f, 0.0f);
                    pdfDoc.close();
                    break;
                }
                default: {
                    System.out.println("plotGraph: No such graph type");
                }
            }
            System.out.println("Done plotting: " + fileName);
        }
        catch (Exception ex) {
            System.out.println("Exception " + ex);
            ex.printStackTrace();
        }
    }

    public String getChartTitleFromType(int chartType) {
        String title = "Graph";
        switch (chartType) {
            case 1: {
                title = "Pointer Distance (\"perfect\" heap)";
                break;
            }
            case 2: {
                title = "Pointer Source (\"perfect\" heap)";
                break;
            }
            case 3: {
                title = "Pointer Target (\"perfect\" heap)";
                break;
            }
            case 4: {
                title = "Mutation Distance (\"perfect\" heap)";
                break;
            }
            case 5: {
                title = "Mutation Source (\"perfect\" heap)";
                break;
            }
            case 6: {
                title = "Mutation Target (\"perfect\" heap)";
                break;
            }
            case 7: {
                title = "Heap Composition";
                break;
            }
            case 8: {
                title = "Inverted Heap Composition";
                break;
            }
            case 9: {
                title = "Pointer Distance";
                break;
            }
            case 10: {
                title = "Pointer Source";
                break;
            }
            case 11: {
                title = "Pointer Target";
                break;
            }
            case 12: {
                title = "Mutation Distance";
                break;
            }
            case 13: {
                title = "Mutation Source";
                break;
            }
            case 14: {
                title = "Mutation Target";
                break;
            }
            case 15: {
                title = "Pointer Distance Time-series (\"perfect\" heap)";
                break;
            }
            case 16: {
                title = "Pointer Source Time-series (\"perfect\" heap)";
                break;
            }
            case 17: {
                title = "Pointer Target Time-series (\"perfect\" heap)";
                break;
            }
            case 18: {
                title = "Mutation Distance Time-series (\"perfect\" heap)";
                break;
            }
            case 19: {
                title = "Mutation Source Time-series (\"perfect\" heap)";
                break;
            }
            case 20: {
                title = "Mutation Target Time-series (\"perfect\" heap)";
                break;
            }
            case 21: {
                title = "Heap Composition Time-series";
                break;
            }
            case 22: {
                title = "Inverted Heap Composition Time-series";
                break;
            }
            case 23: {
                title = "Pointer Distance Time-series";
                break;
            }
            case 24: {
                title = "Pointer Source Time-series";
                break;
            }
            case 25: {
                title = "Pointer Target Time-series";
                break;
            }
            case 26: {
                title = "Mutation Distance Time-series";
                break;
            }
            case 27: {
                title = "Mutation Source Time-series";
                break;
            }
            case 28: {
                title = "Mutation Target Time-series";
                break;
            }
            default: {
                System.out.println("getChartTitleFromType: No such graph");
            }
        }
        return title;
    }

    public String getHistogramDomainLabel(int chartType) {
        String label = "X";
        switch (chartType) {
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                label = "Log_2 of Pointer Distances (Bytes)";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: {
                label = "Log_2 of Mutation Distances (Bytes)";
                break;
            }
            case 7: 
            case 8: {
                label = "Cohorts";
                break;
            }
            default: {
                System.out.println("getHistogramDomainLabel: No such graph");
            }
        }
        return label;
    }

    public String getLineGraphDomainLabel(int timeLine) {
        String label = "X";
        switch (timeLine) {
            case 29: {
                label = "Mutations (in millions)";
                break;
            }
            case 30: {
                label = "Allocations (KB)";
                break;
            }
            default: {
                System.out.println("getLineGraphDomainLabel: No such timeline");
            }
        }
        return label;
    }

    public String getRangeLabel(int chartType) {
        String label = "X";
        switch (chartType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                label = "Pointer Mutations (%)";
                break;
            }
            case 7: 
            case 8: {
                label = "Volume (MB)";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                label = "Distances (%)";
                break;
            }
            case 21: {
                label = "Cohort Volume (MB)";
                break;
            }
            case 22: {
                label = "Cohort Volume (KB)";
                break;
            }
            default: {
                System.out.println("getRangeLabel: No such range type");
            }
        }
        return label;
    }

    public String getFilenameToSave(int chartType) {
        String filename = "graph";
        switch (chartType) {
            case 1: {
                filename = "dst-ptr-prf-hist";
                break;
            }
            case 2: {
                filename = "src-ptr-prf-hist";
                break;
            }
            case 3: {
                filename = "tgt-ptr-prf-hist";
                break;
            }
            case 4: {
                filename = "dst-mut-prf-hist";
                break;
            }
            case 5: {
                filename = "src-mut-prf-hist";
                break;
            }
            case 6: {
                filename = "tgt-mut-prf-hist";
                break;
            }
            case 9: {
                filename = "dst-ptr-inf-hist";
                break;
            }
            case 10: {
                filename = "src-ptr-inf-hist";
                break;
            }
            case 11: {
                filename = "tgt-ptr-inf-hist";
                break;
            }
            case 12: {
                filename = "dst-mut-inf-hist";
                break;
            }
            case 13: {
                filename = "src-mut-inf-hist";
                break;
            }
            case 14: {
                filename = "tgt-mut-inf-hist";
                break;
            }
            case 15: {
                filename = "dst-ptr-prf-time";
                break;
            }
            case 16: {
                filename = "src-ptr-prf-time";
                break;
            }
            case 17: {
                filename = "tgt-ptr-prf-time";
                break;
            }
            case 18: {
                filename = "dst-mut-prf-time";
                break;
            }
            case 19: {
                filename = "src-mut-prf-time";
                break;
            }
            case 20: {
                filename = "tgt-mut-prf-time";
                break;
            }
            case 23: {
                filename = "dst-ptr-inf-time";
                break;
            }
            case 24: {
                filename = "src-ptr-inf-time";
                break;
            }
            case 25: {
                filename = "tgt-ptr-inf-time";
                break;
            }
            case 26: {
                filename = "dst-mut-inf-time";
                break;
            }
            case 27: {
                filename = "src-mut-inf-time";
                break;
            }
            case 28: {
                filename = "tgt-mut-inf-time";
                break;
            }
            case 21: {
                filename = "heap-comp-b";
                break;
            }
            case 22: {
                filename = "heap-comp-a";
                break;
            }
            default: {
                System.out.println("getFilenameToSave: No such chart type");
            }
        }
        return new String(Plotter.filePrefix + filename);
    }

    private int getGraphType(int chartType) {
        switch (chartType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 40;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return 50;
            }
        }
        System.out.println("getGraphType: No such chart type");
        return -1;
    }

    private void makeReadable(CategoryPlot plot, boolean isAxisVisible, int chartType) {
        Color lightColor = Color.lightGray;
        Color darkColor = Color.black;
        BarChartRenderer renderer = new BarChartRenderer();
        plot.setRenderer(renderer);
        plot.getDomainAxis().setVisible(isAxisVisible);
        plot.getRangeAxis().setVisible(isAxisVisible);
        plot.getDomainAxis().setLabelFont(new Font("SansSerif", 0, 10));
        plot.getRangeAxis().setLabelFont(new Font("SansSerif", 0, 10));
    }

    private void makeReadable(XYPlot plot, boolean isDomainVisible, int chartType) {
        int posSeriesCount = 0;
        int negSeriesCount = 0;
        BasicStroke light = new BasicStroke(0.8f);
        Color lightColor = Color.lightGray;
        BasicStroke dark = new BasicStroke(1.0f);
        Color darkColor = Color.black;
        XYItemRenderer renderer = plot.getRenderer();
        int counter = 0;
        switch (chartType) {
            case 15: 
            case 18: 
            case 23: 
            case 26: {
                int i;
                posSeriesCount = Datasets.getPosSeriesCount();
                negSeriesCount = Datasets.getNegSeriesCount();
                for (i = 0; i < posSeriesCount; ++i) {
                    if (i % 5 == 0) {
                        renderer.setSeriesStroke(i, dark);
                        renderer.setSeriesPaint(i, darkColor);
                        continue;
                    }
                    renderer.setSeriesStroke(i, light);
                    renderer.setSeriesPaint(i, lightColor);
                }
                for (i = posSeriesCount; i <= plot.getSeriesCount(); ++i) {
                    if (counter++ == 5) {
                        renderer.setSeriesStroke(i, dark);
                        renderer.setSeriesPaint(i, darkColor);
                        counter = 1;
                        continue;
                    }
                    renderer.setSeriesStroke(i, light);
                    renderer.setSeriesPaint(i, lightColor);
                }
                renderer.setSeriesStroke(posSeriesCount, dark);
                renderer.setSeriesPaint(posSeriesCount, darkColor);
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                for (int i = 0; i < plot.getSeriesCount(); ++i) {
                    if (i % 5 == 0) {
                        renderer.setSeriesStroke(i, dark);
                        renderer.setSeriesPaint(i, darkColor);
                        continue;
                    }
                    renderer.setSeriesStroke(i, light);
                    renderer.setSeriesPaint(i, lightColor);
                }
                break;
            }
        }
        plot.getDomainAxis().setVisible(isDomainVisible);
        plot.getDomainAxis().setLabelFont(new Font("SansSerif", 0, 10));
        plot.getRangeAxis().setLabelFont(new Font("SansSerif", 0, 10));
        if (chartType == 21 && !isDomainVisible) {
            plot.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
            plot.getDomainAxis().setVisible(true);
        }
    }
}

