/*
 * Decompiled with CFR 0.152.
 */
package dacapo.chart;

import dacapo.chart.GraphConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public abstract class Datasets
implements GraphConstants {
    private static int positiveSeriesCount = 0;
    private static int negativeSeriesCount = 0;

    public static CategoryDataset getHistDataset(URL fromFile, int chartType, int withTimeline) throws Exception {
        return Datasets.getHistDataset(fromFile, chartType, withTimeline, 32);
    }

    public static CategoryDataset getHistDataset(URL fromFile, int chartType, int withTimeline, int rangeIn) throws Exception {
        double[][] result = null;
        switch (chartType) {
            case 1: {
                result = Datasets.createPointerDistHistData(fromFile, true, false, withTimeline);
                return Datasets.createCategoryDataset("", "", result);
            }
            case 2: {
                result = Datasets.createPtrAgeHistData(fromFile, true, true, false, withTimeline);
                return Datasets.createCategoryDataset("", "", result);
            }
            case 3: {
                result = Datasets.createPtrAgeHistData(fromFile, false, true, false, withTimeline);
                return Datasets.createCategoryDataset("", "", result);
            }
            case 4: {
                result = Datasets.createPointerDistHistData(fromFile, true, true, withTimeline);
                return Datasets.createCategoryDataset("", "", result);
            }
            case 5: {
                result = Datasets.createPtrAgeHistData(fromFile, true, true, true, withTimeline);
                return Datasets.createCategoryDataset("", "", result);
            }
            case 6: {
                result = Datasets.createPtrAgeHistData(fromFile, false, true, true, withTimeline);
                return Datasets.createCategoryDataset("", "", result);
            }
            case 7: {
                result = Datasets.createHeapHistData(fromFile, rangeIn);
                return Datasets.createCategoryDataset("", "", result);
            }
            case 8: {
                result = Datasets.createHeapHistData(fromFile, rangeIn);
                return Datasets.createCategoryDataset("", "", result);
            }
            case 9: {
                result = Datasets.createPointerDistHistData(fromFile, false, false, withTimeline);
                return Datasets.createCategoryDataset("", "", result);
            }
            case 10: {
                result = Datasets.createPtrAgeHistData(fromFile, true, false, false, withTimeline);
                return Datasets.createCategoryDataset("", "", result);
            }
            case 11: {
                result = Datasets.createPtrAgeHistData(fromFile, false, false, false, withTimeline);
            }
            case 12: {
                result = Datasets.createPointerDistHistData(fromFile, false, true, withTimeline);
                return Datasets.createCategoryDataset("", "", result);
            }
            case 13: {
                result = Datasets.createPtrAgeHistData(fromFile, true, false, true, withTimeline);
                return Datasets.createCategoryDataset("", "", result);
            }
            case 14: {
                result = Datasets.createPtrAgeHistData(fromFile, false, false, true, withTimeline);
                return Datasets.createCategoryDataset("", "", result);
            }
        }
        System.out.println("getHistDataset: No such graph type");
        return null;
    }

    public static XYSeriesCollection getLineDataset(URL fromFile, int forChartType, int withTimeline) throws Exception {
        return Datasets.getLineDataset(fromFile, forChartType, withTimeline, 32);
    }

    public static XYSeriesCollection getLineDataset(URL fromFile, int forChartType, int withTimeline, int rangeIn) throws Exception {
        switch (forChartType) {
            case 15: {
                return Datasets.createPointerDistData(fromFile, true, false, withTimeline);
            }
            case 16: {
                return Datasets.createPointerAgeData(fromFile, true, true, false, withTimeline);
            }
            case 17: {
                return Datasets.createPointerAgeData(fromFile, false, true, false, withTimeline);
            }
            case 18: {
                return Datasets.createPointerDistData(fromFile, true, true, withTimeline);
            }
            case 19: {
                return Datasets.createPointerAgeData(fromFile, true, true, true, withTimeline);
            }
            case 20: {
                return Datasets.createPointerAgeData(fromFile, false, true, true, withTimeline);
            }
            case 21: {
                return Datasets.createHeapData(fromFile, false, withTimeline, rangeIn);
            }
            case 22: {
                return Datasets.createHeapData(fromFile, true, withTimeline, rangeIn);
            }
            case 23: {
                return Datasets.createPointerDistData(fromFile, false, false, withTimeline);
            }
            case 24: {
                return Datasets.createPointerAgeData(fromFile, true, false, false, withTimeline);
            }
            case 25: {
                return Datasets.createPointerAgeData(fromFile, false, false, false, withTimeline);
            }
            case 26: {
                return Datasets.createPointerDistData(fromFile, false, true, withTimeline);
            }
            case 27: {
                return Datasets.createPointerAgeData(fromFile, true, false, true, withTimeline);
            }
            case 28: {
                return Datasets.createPointerAgeData(fromFile, false, false, true, withTimeline);
            }
        }
        System.out.println("getLineDateset: No such graph type");
        return null;
    }

    private static CategoryDataset createCategoryDataset(String rowKeyPrefix, String columnKeyPrefix, double[][] data) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        for (int r = 0; r < data.length; ++r) {
            String rowKey = rowKeyPrefix + r;
            for (int c = 0; c < data[r].length; ++c) {
                String columnKey = columnKeyPrefix + c;
                result.addValue(new Double(data[r][c]), (Comparable)((Object)rowKey), (Comparable)((Object)columnKey));
            }
        }
        return result;
    }

    public static double[][] createHeapHistData(URL inURL, int rangeIn) throws IOException {
        BufferedReader file = new BufferedReader(new InputStreamReader(inURL.openStream()));
        int index = 0;
        int currCohortCount = 0;
        String line = null;
        StringTokenizer st = null;
        int maxCohort = Datasets.getMaxCohorts(inURL);
        double[] cohortHist = new double[maxCohort];
        int denom = 1;
        switch (rangeIn) {
            case 31: {
                denom = 1024;
                break;
            }
            case 32: {
                denom = 0x100000;
                break;
            }
        }
        String startTag = "<cohort data>";
        String endTag = "</cohort data>";
        while ((line = file.readLine()) != null) {
            if (!line.equals("<cohort data>")) continue;
            line = file.readLine();
            line = file.readLine();
            st = new StringTokenizer(line, ",");
            st.nextToken();
            st.nextToken(",");
            currCohortCount = Integer.parseInt(st.nextToken(","));
            double[] cohortVolumes = new double[currCohortCount];
            line = file.readLine();
            do {
                st = new StringTokenizer(line, ",");
                index = Integer.parseInt(st.nextToken());
                st.nextToken(",");
                cohortVolumes[index] = Double.parseDouble(st.nextToken(","));
            } while (!(line = file.readLine()).equals(endTag));
            for (int i = 0; i < currCohortCount; ++i) {
                cohortHist[i] = cohortVolumes[i] == 0.0 ? 0.0 : cohortVolumes[i] / (double)denom;
            }
        }
        return new double[][]{cohortHist};
    }

    private static double[][] createPointerDistHistData(URL inURL, boolean isPerfect, boolean isMutation, int timeline) throws IOException {
        BufferedReader file = new BufferedReader(new InputStreamReader(inURL.openStream()));
        String temp = null;
        String line = null;
        int posBuckets = 32;
        int negBuckets = 32;
        double[] positive = null;
        boolean totalPositive = false;
        double sum = 0.0;
        double[] negative = null;
        boolean totalNegative = false;
        boolean maxPosFound = false;
        boolean maxNegFound = false;
        double totalZero = 0.0;
        double[] totalPos = new double[posBuckets];
        double[] totalNeg = new double[negBuckets];
        double totalMutations = 0.0;
        double totalAllocs = 0.0;
        double currentMutations = 0.0;
        boolean isTimeAllocs = false;
        positive = new double[posBuckets];
        negative = new double[negBuckets];
        double zeroDistance = 0.0;
        String mutOrPoint = isMutation ? "mutation " : "pointer ";
        String primaryStartTag = "<" + mutOrPoint + "data>";
        String primaryEndTag = "</" + mutOrPoint + "data>";
        String baseTag = (isPerfect ? "perfect " : "") + mutOrPoint + "dist";
        String startTag = "<" + baseTag + ">";
        String endTag = "</" + baseTag + ">";
        switch (timeline) {
            case 29: {
                isTimeAllocs = false;
                break;
            }
            case 30: {
                isTimeAllocs = true;
                break;
            }
        }
        int READ_POS_BUCKETS = posBuckets;
        int READ_NEG_BUCKETS = negBuckets;
        boolean dataPoint = false;
        int read_pos_buckets = READ_POS_BUCKETS;
        int read_neg_buckets = READ_NEG_BUCKETS;
        while ((line = file.readLine()) != null) {
            int i;
            if (!line.equals(primaryStartTag)) continue;
            line = file.readLine();
            StringTokenizer st = new StringTokenizer(line, ",");
            totalMutations = Double.parseDouble(st.nextToken());
            totalAllocs = Double.parseDouble(st.nextToken(","));
            temp = file.readLine();
            while (!temp.equals(startTag)) {
                temp = file.readLine();
            }
            temp = file.readLine();
            do {
                st = new StringTokenizer(temp, ",");
                int index = Integer.parseInt(st.nextToken());
                double value = Double.parseDouble(st.nextToken(","));
                if (index == 0) {
                    zeroDistance = value;
                    continue;
                }
                if (index < 0) {
                    negative[-index - 1] = value;
                    continue;
                }
                positive[index - 1] = value;
            } while (!(temp = file.readLine()).equals(endTag));
            sum = zeroDistance;
            totalZero += zeroDistance;
            for (i = 0; i < read_pos_buckets; ++i) {
                sum += positive[i];
                int n = i;
                totalPos[n] = totalPos[n] + positive[i];
            }
            for (i = 0; i < read_neg_buckets; ++i) {
                sum += negative[i];
                int n = i;
                totalNeg[n] = totalNeg[n] + negative[i];
            }
            for (i = 0; i < read_pos_buckets; ++i) {
                positive[i] = 0.0;
            }
            for (i = 0; i < read_neg_buckets; ++i) {
                negative[i] = 0.0;
            }
            totalPositive = false;
            totalNegative = false;
            sum = 0.0;
            read_pos_buckets = READ_POS_BUCKETS;
            read_neg_buckets = READ_NEG_BUCKETS;
        }
        double[] posVals = new double[totalPos.length + 1];
        posVals[0] = totalZero / totalMutations * 100.0 / 2.0;
        for (int i = 1; i < posVals.length; ++i) {
            posVals[i] = totalPos[i - 1] / totalMutations * 100.0;
        }
        double[] negVals = new double[totalNeg.length + 1];
        negVals[0] = -(totalZero / totalMutations * 100.0) / 2.0;
        for (int i = 1; i < negVals.length; ++i) {
            negVals[i] = -(totalNeg[i - 1] / totalMutations) * 100.0;
        }
        return new double[][]{posVals, negVals};
    }

    public static XYSeriesCollection createHeapData(URL inURL, boolean invert, int timeLine, int rangeIn) throws IOException {
        BufferedReader file = new BufferedReader(new InputStreamReader(inURL.openStream()));
        int index = 0;
        int currCohortCount = 0;
        double totalAllocs = 0.0;
        String line = null;
        StringTokenizer st = null;
        int maxCohort = Datasets.getMaxCohorts(inURL);
        double[] cohortHist = new double[maxCohort];
        double totalMutations = 0.0;
        boolean isTimeAllocs = false;
        int denom = 1;
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries[] cohorts = new XYSeries[maxCohort];
        String startTag = "<cohort data>";
        String endTag = "</cohort data>";
        switch (timeLine) {
            case 29: {
                isTimeAllocs = false;
                break;
            }
            case 30: {
                isTimeAllocs = true;
                break;
            }
        }
        switch (rangeIn) {
            case 31: {
                denom = 1024;
                break;
            }
            case 32: {
                denom = 0x100000;
                break;
            }
        }
        while ((line = file.readLine()) != null) {
            if (!line.equals("<cohort data>")) continue;
            line = file.readLine();
            st = new StringTokenizer(line, ",");
            totalMutations = Double.parseDouble(st.nextToken());
            totalAllocs = Double.parseDouble(st.nextToken(","));
            line = file.readLine();
            st = new StringTokenizer(line, ",");
            st.nextToken();
            st.nextToken(",");
            currCohortCount = Integer.parseInt(st.nextToken(","));
            double[] cohortVolumes = new double[currCohortCount];
            line = file.readLine();
            do {
                st = new StringTokenizer(line, ",");
                index = Integer.parseInt(st.nextToken());
                st.nextToken(",");
                cohortVolumes[index] = Double.parseDouble(st.nextToken(","));
            } while (!(line = file.readLine()).equals(endTag));
            double[] tempVolumes = new double[currCohortCount];
            for (int i = 0; i < currCohortCount; ++i) {
                for (int j = currCohortCount - 1; j >= i; --j) {
                    int n = i;
                    tempVolumes[n] = tempVolumes[n] + cohortVolumes[j];
                }
            }
            int cp = 0;
            for (int i = 0; i < currCohortCount; ++i) {
                if (cohorts[i] == null) {
                    cohorts[i] = new XYSeries((Comparable)((Object)("Cohort " + (i + 1))));
                }
                cp = (int)((double)cp + cohortVolumes[i]);
                if (!isTimeAllocs) {
                    if (invert) {
                        cohorts[i].add(totalMutations / 1000000.0, cp / denom);
                    } else {
                        cohorts[i].add(totalMutations / 1000000.0, tempVolumes[i] / (double)denom);
                    }
                } else if (invert) {
                    cohorts[i].add(totalAllocs, cp / denom);
                } else {
                    cohorts[i].add(totalAllocs, tempVolumes[i] / (double)denom);
                }
                if (invert) continue;
                cohortHist[i] = cohortVolumes[i] == 0.0 ? 0.0 : cohortVolumes[i] / (double)denom;
            }
        }
        for (int i = 0; i < maxCohort && cohorts[i] != null; ++i) {
            dataset.addSeries(cohorts[i]);
        }
        return dataset;
    }

    private static XYSeriesCollection createPointerDistData(URL inURL, boolean isPerfect, boolean isMutation, int timeline) throws IOException {
        int i;
        BufferedReader file = new BufferedReader(new InputStreamReader(inURL.openStream()));
        String temp = null;
        String line = null;
        int posBuckets = 32;
        int negBuckets = 32;
        double[] positive = null;
        double sum = 0.0;
        double[] negative = null;
        boolean totalPositive = false;
        boolean totalNegative = false;
        int maxPosFound = 0;
        int maxNegFound = 0;
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries[] posdistances = new XYSeries[posBuckets];
        XYSeries[] negdistances = new XYSeries[negBuckets];
        double totalMutations = 0.0;
        double totalAllocs = 0.0;
        double currentMutations = 0.0;
        boolean isTimeAllocs = false;
        positive = new double[posBuckets];
        negative = new double[negBuckets];
        double zeroDistance = 0.0;
        String mutOrPoint = isMutation ? "mutation " : "pointer ";
        String primaryStartTag = "<" + mutOrPoint + "data>";
        String primaryEndTag = "</" + mutOrPoint + "data>";
        String baseTag = (isPerfect ? "perfect " : "") + mutOrPoint + "dist";
        String startTag = "<" + baseTag + ">";
        String endTag = "</" + baseTag + ">";
        switch (timeline) {
            case 29: {
                isTimeAllocs = false;
                break;
            }
            case 30: {
                isTimeAllocs = true;
                break;
            }
        }
        int READ_POS_BUCKETS = posBuckets;
        int READ_NEG_BUCKETS = negBuckets;
        boolean dataPoint = false;
        int read_pos_buckets = READ_POS_BUCKETS;
        int read_neg_buckets = READ_NEG_BUCKETS;
        for (i = 0; i < posBuckets; ++i) {
            posdistances[i] = null;
        }
        for (i = 0; i < negBuckets; ++i) {
            negdistances[i] = null;
        }
        while ((line = file.readLine()) != null) {
            int i2;
            if (!line.equals(primaryStartTag)) continue;
            line = file.readLine();
            StringTokenizer st = new StringTokenizer(line, ",");
            totalMutations = Double.parseDouble(st.nextToken());
            totalAllocs = Double.parseDouble(st.nextToken(","));
            temp = file.readLine();
            while (!temp.equals(startTag)) {
                temp = file.readLine();
            }
            temp = file.readLine();
            do {
                st = new StringTokenizer(temp, ",");
                int index = Integer.parseInt(st.nextToken());
                double value = Double.parseDouble(st.nextToken(","));
                if (index == 0) {
                    zeroDistance = value;
                    continue;
                }
                if (index < 0) {
                    negative[-index - 1] = value;
                    continue;
                }
                positive[index - 1] = value;
            } while (!(temp = file.readLine()).equals(endTag));
            sum = zeroDistance;
            for (i = 0; i < read_pos_buckets; ++i) {
                sum += positive[i];
            }
            for (i = 0; i < read_neg_buckets; ++i) {
                sum += negative[i];
            }
            double cp = zeroDistance / sum * 100.0 / 2.0;
            for (i2 = 0; i2 < positive.length; ++i2) {
                if (posdistances[i2] == null) {
                    posdistances[i2] = new XYSeries((Comparable)((Object)("+ve Bucket " + i2)));
                }
                cp += positive[i2] / sum * 100.0;
                if (!isTimeAllocs) {
                    posdistances[i2].add(totalMutations / 1000000.0, cp);
                    continue;
                }
                posdistances[i2].add(totalAllocs, cp);
            }
            cp = -(zeroDistance / sum * 100.0) / 2.0;
            for (i2 = 0; i2 < negative.length; ++i2) {
                if (negdistances[i2] == null) {
                    negdistances[i2] = new XYSeries((Comparable)((Object)("-ve Bucket " + i2)));
                }
                cp -= negative[i2] / sum * 100.0;
                if (!isTimeAllocs) {
                    negdistances[i2].add(totalMutations / 1000000.0, cp);
                    continue;
                }
                negdistances[i2].add(totalAllocs, cp);
            }
            for (i2 = 0; i2 < read_pos_buckets; ++i2) {
                positive[i2] = 0.0;
            }
            for (i2 = 0; i2 < read_neg_buckets; ++i2) {
                negative[i2] = 0.0;
            }
            zeroDistance = 0.0;
            totalPositive = false;
            totalNegative = false;
            sum = 0.0;
            read_pos_buckets = READ_POS_BUCKETS;
            read_neg_buckets = READ_NEG_BUCKETS;
        }
        for (i = 0; i < read_pos_buckets; ++i) {
            dataset.addSeries(posdistances[i]);
        }
        for (i = 0; i < read_neg_buckets; ++i) {
            dataset.addSeries(negdistances[i]);
        }
        positiveSeriesCount = maxPosFound;
        negativeSeriesCount = maxNegFound;
        return dataset;
    }

    private static XYSeriesCollection createPointerAgeData(URL inURL, boolean isSource, boolean isPerfect, boolean isMutation, int timeline) throws IOException {
        int READ_AGE_BUCKETS;
        BufferedReader file = new BufferedReader(new InputStreamReader(inURL.openStream()));
        String line = null;
        String temp = null;
        int maxAges = 32;
        double[] ages = null;
        int totalAges = 0;
        double sum = 0.0;
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries[] ptrages = new XYSeries[maxAges];
        int maxFound = 0;
        double[] mutationHistory = new double[maxAges];
        double totalMutations = 0.0;
        double totalAllocs = 0.0;
        double currentMutations = 0.0;
        boolean isTimeAllocs = false;
        String mutOrPoint = isMutation ? "mutation " : "pointer ";
        String primaryStartTag = "<" + mutOrPoint + "data>";
        String primaryEndTag = "</" + mutOrPoint + "data>";
        String baseTag = (isPerfect ? "perfect " : "") + mutOrPoint + (isSource ? "src" : "tgt");
        String startTag = "<" + baseTag + ">";
        String endTag = "</" + baseTag + ">";
        switch (timeline) {
            case 29: {
                isTimeAllocs = false;
                break;
            }
            case 30: {
                isTimeAllocs = true;
                break;
            }
        }
        ages = new double[maxAges];
        for (int i = 0; i < maxAges; ++i) {
            ptrages[i] = null;
        }
        int read_age_buckets = READ_AGE_BUCKETS = maxAges;
        while ((line = file.readLine()) != null) {
            int i;
            if (!line.equals(primaryStartTag)) continue;
            line = file.readLine();
            StringTokenizer st = new StringTokenizer(line, ",");
            totalMutations = Double.parseDouble(st.nextToken());
            totalAllocs = Double.parseDouble(st.nextToken(","));
            temp = file.readLine();
            while (!temp.equals(startTag)) {
                temp = file.readLine();
            }
            temp = file.readLine();
            do {
                st = new StringTokenizer(temp, ",");
                int index = Integer.parseInt(st.nextToken());
                ages[index] = Double.parseDouble(st.nextToken(","));
                temp = file.readLine();
                int n = maxFound = ++totalAges > maxFound ? totalAges : maxFound;
            } while (totalAges != read_age_buckets && !temp.equals(endTag));
            read_age_buckets = maxFound;
            for (int i2 = 0; i2 < read_age_buckets; ++i2) {
                sum += ages[i2];
                int n = i2;
                mutationHistory[n] = mutationHistory[n] + ages[i2];
            }
            double cp = 0.0;
            for (i = 0; i < read_age_buckets; ++i) {
                if (ptrages[i] == null) {
                    ptrages[i] = new XYSeries((Comparable)((Object)("Bucket " + (i + 1))));
                }
                cp += ages[i] / sum * 100.0;
                if (!isTimeAllocs) {
                    ptrages[i].add(totalMutations / 1000000.0, cp);
                    continue;
                }
                ptrages[i].add(totalAllocs, cp);
            }
            for (i = 0; i < read_age_buckets; ++i) {
                ages[i] = 0.0;
            }
            totalAges = 0;
            sum = 0.0;
            read_age_buckets = READ_AGE_BUCKETS;
        }
        double[] ageHist = new double[maxFound];
        for (int i = 0; i < read_age_buckets; ++i) {
            String series = new String("Bucket " + (i + 1));
            if (ptrages[i] == null) continue;
            ageHist[i] = mutationHistory[i] / totalMutations * 100.0;
            dataset.addSeries(ptrages[i]);
        }
        return dataset;
    }

    private static double[][] createPtrAgeHistData(URL inURL, boolean isSource, boolean isPerfect, boolean isMutation, int timeline) throws IOException {
        int READ_AGE_BUCKETS;
        BufferedReader file = new BufferedReader(new InputStreamReader(inURL.openStream()));
        String line = null;
        String temp = null;
        int maxAges = 32;
        double[] ages = null;
        int totalAges = 0;
        double sum = 0.0;
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries[] ptrages = new XYSeries[maxAges];
        int maxFound = 0;
        double[] mutationHistory = new double[maxAges];
        double totalMutations = 0.0;
        double totalAllocs = 0.0;
        double currentMutations = 0.0;
        boolean isTimeAllocs = false;
        String mutOrPoint = isMutation ? "mutation " : "pointer ";
        String primaryStartTag = "<" + mutOrPoint + "data>";
        String primaryEndTag = "</" + mutOrPoint + "data>";
        String baseTag = (isPerfect ? "perfect " : "") + mutOrPoint + (isSource ? "src" : "tgt");
        String startTag = "<" + baseTag + ">";
        String endTag = "</" + baseTag + ">";
        switch (timeline) {
            case 29: {
                isTimeAllocs = false;
                break;
            }
            case 30: {
                isTimeAllocs = true;
                break;
            }
        }
        ages = new double[maxAges];
        for (int i = 0; i < maxAges; ++i) {
            ptrages[i] = null;
        }
        int read_age_buckets = READ_AGE_BUCKETS = maxAges;
        while ((line = file.readLine()) != null) {
            int i;
            if (!line.equals(primaryStartTag)) continue;
            line = file.readLine();
            StringTokenizer st = new StringTokenizer(line, ",");
            totalMutations = Double.parseDouble(st.nextToken());
            totalAllocs = Double.parseDouble(st.nextToken(","));
            temp = file.readLine();
            while (!temp.equals(startTag)) {
                temp = file.readLine();
            }
            temp = file.readLine();
            do {
                st = new StringTokenizer(temp, ",");
                int index = Integer.parseInt(st.nextToken());
                ages[index] = Double.parseDouble(st.nextToken(","));
                temp = file.readLine();
                int n = maxFound = ++totalAges > maxFound ? totalAges : maxFound;
            } while (totalAges != read_age_buckets && !temp.equals(endTag));
            read_age_buckets = maxFound;
            for (int i2 = 0; i2 < read_age_buckets; ++i2) {
                sum += ages[i2];
                int n = i2;
                mutationHistory[n] = mutationHistory[n] + ages[i2];
            }
            double cp = 0.0;
            for (i = 0; i < read_age_buckets; ++i) {
                if (ptrages[i] == null) {
                    ptrages[i] = new XYSeries((Comparable)((Object)("Bucket " + (i + 1))));
                }
                cp += ages[i] / sum * 100.0;
                if (!isTimeAllocs) {
                    ptrages[i].add(totalMutations / 1000000.0, cp);
                    continue;
                }
                ptrages[i].add(totalAllocs, cp);
            }
            for (i = 0; i < read_age_buckets; ++i) {
                ages[i] = 0.0;
            }
            totalAges = 0;
            sum = 0.0;
            read_age_buckets = READ_AGE_BUCKETS;
        }
        double[] ageHist = new double[maxFound];
        for (int i = 0; i < read_age_buckets; ++i) {
            String series = new String("Bucket " + (i + 1));
            if (ptrages[i] == null) continue;
            ageHist[i] = mutationHistory[i] / totalMutations * 100.0;
            dataset.addSeries(ptrages[i]);
        }
        return new double[][]{ageHist};
    }

    public static int getPosSeriesCount() {
        int pos = positiveSeriesCount;
        positiveSeriesCount = 0;
        return pos;
    }

    public static int getNegSeriesCount() {
        int neg = negativeSeriesCount;
        negativeSeriesCount = 0;
        return neg;
    }

    private static int getMaxCohorts(URL inURL) throws IOException {
        int maxCohort = 20000;
        String line = null;
        BufferedReader file = new BufferedReader(new InputStreamReader(inURL.openStream()));
        while ((line = file.readLine()) != null) {
            if (!line.equals("[max cohorts]")) continue;
            maxCohort = Integer.parseInt(file.readLine());
        }
        return maxCohort;
    }
}

