/*
 * Decompiled with CFR 0.152.
 */
package dacapo;

import dacapo.Benchmark;
import dacapo.Callback;
import dacapo.parser.Config;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Vector;

public class TestHarness {
    protected Config config;
    private boolean verbose = false;
    private boolean allowOpenFromFileSystem = false;
    private boolean converge = false;
    private double target_var = 0.03;
    private int window = 3;
    private int max_iterations = 20;
    private boolean ignoreValidation = false;
    private int iterations = 1;
    private String size = "default";
    private String scratchDir = "./scratch";
    private Callback callback = null;
    private boolean info = false;
    private final DecimalFormat two_dp = this.twoDecimalPlaces();
    static /* synthetic */ Class class$dacapo$TestHarness;
    static /* synthetic */ Class class$dacapo$Benchmark;
    static /* synthetic */ Class class$dacapo$parser$Config;
    static /* synthetic */ Class class$java$io$File;

    private URL getURL(String fn) {
        ClassLoader cl = (class$dacapo$TestHarness == null ? (class$dacapo$TestHarness = TestHarness.class$("dacapo.TestHarness")) : class$dacapo$TestHarness).getClassLoader();
        if (this.verbose) {
            System.out.println("TestHarness.getURL: returns " + cl.getResource(fn));
        }
        return cl.getResource(fn);
    }

    public boolean exists(File f) {
        return this.exists(f.getPath());
    }

    public boolean exists(String fn) {
        boolean result;
        boolean bl = result = this.getURL(fn) != null;
        if (!result && this.allowOpenFromFileSystem) {
            if (this.verbose) {
                System.out.println("TestHarness.exists: going to file system for " + fn);
            }
            File file = new File(fn);
            result = file.exists();
        }
        return result;
    }

    private double coeff_of_var(long[] times) {
        double n = times.length;
        double sum = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < times.length; ++i) {
            double x = times[i];
            sum += x;
            sum2 += x * x;
        }
        double mean = sum / n;
        double sigma = Math.sqrt(1.0 / n * sum2 - mean * mean);
        return sigma / mean;
    }

    public static void main(String[] args) {
        new TestHarness().go(args);
    }

    public void go(String[] args) {
        try {
            int i;
            if (args.length == 0) {
                this.printUsage();
                return;
            }
            for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
                try {
                    if (args[i].equals("-s")) {
                        if (i == args.length - 1) {
                            System.err.println("No size specified! (\"-h\" for usage)");
                            System.exit(10);
                        }
                        this.size = args[++i];
                        continue;
                    }
                    if (args[i].equals("-i")) {
                        this.info = true;
                        continue;
                    }
                    if (args[i].equals("-h")) {
                        this.printUsage();
                        continue;
                    }
                    if (args[i].equals("-v")) {
                        this.verbose = true;
                        continue;
                    }
                    if (args[i].equals("-c")) {
                        if (i == args.length - 1) {
                            System.err.println("No callback class specified! (\"-h\" for usage)");
                            System.exit(11);
                        }
                        Class<?> cls = null;
                        try {
                            cls = Class.forName(args[++i]);
                        }
                        catch (Exception e) {
                            System.err.println(e);
                            System.err.println("Could not find callback class " + args[i]);
                            System.exit(12);
                        }
                        if (!Class.forName("dacapo.Callback").isAssignableFrom(cls)) {
                            System.err.println(args[i] + " is not an instance of dacapo.Callback");
                            System.exit(13);
                            continue;
                        }
                        this.callback = (Callback)cls.newInstance();
                        continue;
                    }
                    if (args[i].equals("-n")) {
                        if (i == args.length - 1) {
                            System.err.println("Number of iterations not specified! (\"-h\" for usage)");
                            System.exit(14);
                        }
                        this.iterations = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-converge")) {
                        this.converge = true;
                        continue;
                    }
                    if (args[i].equals("-max_iterations")) {
                        if (i == args.length - 1) {
                            System.err.println("No max specified! (\"-h\" for usage)");
                            System.exit(15);
                        }
                        this.max_iterations = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-variance")) {
                        if (i == args.length - 1) {
                            System.err.println("No variance specified! (\"-h\" for usage)");
                            System.exit(16);
                        }
                        this.target_var = Double.parseDouble(args[++i]) / 100.0;
                        continue;
                    }
                    if (args[i].equals("-window")) {
                        if (i == args.length - 1) {
                            System.err.println("No window size specified!  (\"-h\" for usage)");
                            System.exit(17);
                        }
                        this.window = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-debug")) {
                        Benchmark.setVerbose(true);
                        continue;
                    }
                    if (args[i].equals("-preserve")) {
                        Benchmark.setPreserve(true);
                        continue;
                    }
                    if (args[i].equals("-noDigestOutput")) {
                        Benchmark.setValidateOutput(false);
                        continue;
                    }
                    if (args[i].equals("-ignoreValidation")) {
                        this.ignoreValidation = true;
                        continue;
                    }
                    if (args[i].equals("-noValidation")) {
                        Benchmark.setValidate(false);
                        continue;
                    }
                    if (args[i].equals("-validationReport")) {
                        Benchmark.enableValidationReport(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-scratch")) {
                        if (i == args.length - 1) {
                            System.err.println("No scratch directory specified! (\"-h\" for usage)");
                            System.exit(18);
                        }
                        this.scratchDir = args[++i];
                        continue;
                    }
                    System.err.println("Unrecognized option " + args[i] + " (\"-h\" for usage)");
                    System.exit(1);
                    continue;
                }
                catch (NumberFormatException e) {
                    System.err.println("Could not parse numeric argument to \"" + args[i - 1] + "\"! (\"-h\" for usage)");
                    System.exit(18);
                }
            }
            if (i == args.length) {
                System.err.println("No benchmarks specified! (\"-h\" for usage)");
                System.exit(19);
            }
            if (this.callback == null) {
                this.callback = new Callback();
            }
            File scratch = new File(this.scratchDir);
            this.rmdir(scratch);
            scratch.mkdir();
            while (i < args.length) {
                String bm = args[i];
                String cnf = "cnf/" + bm + ".cnf";
                InputStream ins = (class$dacapo$TestHarness == null ? TestHarness.class$("dacapo.TestHarness") : class$dacapo$TestHarness).getClassLoader().getResourceAsStream(cnf);
                if (ins == null) {
                    System.err.println("Unknown benchmark: " + args[i]);
                    System.exit(20);
                }
                this.readStream(ins);
                if (this.info) {
                    this.bmInfo();
                } else {
                    if (this.verbose) {
                        this.dump();
                    }
                    if ((class$dacapo$Benchmark == null ? TestHarness.class$("dacapo.Benchmark") : class$dacapo$Benchmark).isAssignableFrom(this.findClass())) {
                        this.runBenchmark(scratch, bm);
                    } else {
                        this.runBenchmarkOld(bm);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    protected Benchmark loadBenchmark(File scratch) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, Exception {
        Constructor cons = this.findClass().getConstructor(class$dacapo$parser$Config == null ? (class$dacapo$parser$Config = TestHarness.class$("dacapo.parser.Config")) : class$dacapo$parser$Config, class$java$io$File == null ? (class$java$io$File = TestHarness.class$("java.io.File")) : class$java$io$File);
        return (Benchmark)cons.newInstance(this.config, scratch);
    }

    private void runBenchmark(File scratch, String bm) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, Exception {
        Benchmark b = this.loadBenchmark(scratch);
        boolean valid = true;
        if (this.converge) {
            long[] times = new long[this.window];
            int n = 0;
            while (n < this.window || n < this.max_iterations && this.coeff_of_var(times) > this.target_var) {
                long start_time = System.currentTimeMillis();
                valid = b.run(this.callback, this.size, false) && valid;
                times[n % this.window] = System.currentTimeMillis() - start_time;
                if (++n < this.window || !this.verbose) continue;
                System.err.println("Variation " + this.two_dp.format(this.coeff_of_var(times) * 100.0) + "% achieved after " + n + " iterations");
            }
            if (n < this.max_iterations) {
                valid = b.run(this.callback, this.size, true) && valid;
            } else {
                System.err.println("Benchmark failed to converge.");
            }
        } else {
            for (int n = 0; n < this.iterations - 1; ++n) {
                valid = b.run(this.callback, this.size, false) && valid;
            }
            valid = b.run(this.callback, this.size, true) && valid;
        }
        b.cleanup();
        if (!valid) {
            System.err.println("Validation FAILED for " + bm + " " + this.size);
            if (!this.ignoreValidation) {
                System.exit(-2);
            }
        }
    }

    private void runBenchmarkOld(String bm) {
        Method m = this.findMethod();
        while (this.iterations > 1) {
            this.callback.startWarmup(bm);
            this.invokeConfiguration(m, this.size);
            this.callback.stopWarmup();
            this.callback.completeWarmup(bm, true);
            --this.iterations;
        }
        this.callback.start(bm);
        this.invokeConfiguration(m, this.size);
        this.callback.stop();
        this.callback.complete(bm, true);
    }

    private DecimalFormat twoDecimalPlaces() {
        DecimalFormat two_dp = new DecimalFormat();
        two_dp.setMaximumFractionDigits(2);
        two_dp.setMinimumFractionDigits(2);
        two_dp.setGroupingUsed(true);
        return two_dp;
    }

    private void printUsage() {
        System.out.println("Usage: java -jar dacapo-<version>.jar [options ...] [benchmarks ...]");
        System.out.println("    -c <callback>           Use class <callback> to bracket benchmark runs");
        System.out.println("    -h                      Print this help");
        System.out.println("    -i                      Display benchmark information");
        System.out.println("    -s small|default|large  Size of input data");
        System.out.println();
        System.out.println("  Measurement methodology options");
        System.out.println("    -converge               Allow benchmark times to converge before timing");
        System.out.println("      -max_iterations <n>     Run a max of n iterations (default 20)");
        System.out.println("      -variance <pct>         Target coefficient of variation (default 3.0)");
        System.out.println("      -window <n>             Measure variance over n runs (default 3)");
        System.out.println("    -n <iter>               Run the benchmark <iter> times");
        System.out.println();
        System.out.println("  Debugging options (for benchmark suite maintainers)");
        System.out.println("    -debug                  Verbose debugging information");
        System.out.println("    -ignoreValidation       Don't halt on validation failure");
        System.out.println("    -noDigestOutput         Turn off SHA1 digest of stdout/stderr");
        System.out.println("    -noValidation           Don't validate at all");
        System.out.println("    -preserve               Preserve output files (debug)");
        System.out.println("    -v                      Verbose output");
        System.out.println("    -validationReport       Report digests, line counts etc");
    }

    private void rmdir(File dir) {
        String[] files = dir.list();
        if (files != null) {
            for (int f = 0; f < files.length; ++f) {
                File file = new File(dir, files[f]);
                if (file.isDirectory()) {
                    this.rmdir(file);
                }
                if (file.delete()) continue;
                System.err.println("Could not delete " + files[f]);
            }
        }
    }

    public int TEST(int i) {
        System.err.println("In TEST");
        System.err.println(i);
        return 2 * i;
    }

    private void bmInfo() {
        this.config.describe(System.err);
    }

    private void dump() {
        System.err.println("Class name: " + this.config.className);
        System.err.println("Method name: " + this.config.methodName);
        System.err.println("Configurations:");
        this.config.describe(System.err);
    }

    private void readStream(InputStream stream) {
        this.config = Config.parse(stream);
        if (this.config == null) {
            System.exit(-1);
        }
    }

    private Class findClass() {
        try {
            return Class.forName(this.config.className);
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    private Method findMethod() {
        return this.findMethod(this.config.methodName);
    }

    private Method findMethod(String methodName) {
        Method[] methods = this.findClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        System.err.println("Method not found: " + methodName);
        System.exit(-1);
        return null;
    }

    private Vector vectorise(String[] s) {
        Vector<String> result = new Vector<String>(s.length);
        for (int i = 0; i < s.length; ++i) {
            result.add(s[i]);
        }
        return result;
    }

    private void invokeConfiguration(Method m, String configuration) {
        try {
            Object result;
            Vector configArgs = this.vectorise(this.config.getArgs(configuration));
            if (configArgs == null) {
                System.err.println("Can't find configuration " + configuration);
                System.exit(-1);
            }
            Class<?>[] parameters = m.getParameterTypes();
            Object[] invocationArgs = new Object[parameters.length];
            if (parameters.length == 1 && parameters[0].isArray() && parameters[0].getComponentType() == "".getClass()) {
                String[] sArray = new String[configArgs.size()];
                for (int i = 0; i < configArgs.size(); ++i) {
                    sArray[i] = (String)configArgs.elementAt(i);
                }
                invocationArgs[0] = sArray;
            } else {
                for (int i = 0; i < parameters.length; ++i) {
                    Class<?> ptype = parameters[i];
                    Object arg = configArgs.elementAt(i);
                    if (ptype.isInstance(arg)) {
                        invocationArgs[i] = arg;
                        continue;
                    }
                    if (ptype == Boolean.TYPE) {
                        invocationArgs[i] = new Boolean((String)arg);
                        continue;
                    }
                    if (ptype == Byte.TYPE) {
                        invocationArgs[i] = new Byte(((Double)arg).byteValue());
                        continue;
                    }
                    if (ptype == Short.TYPE) {
                        invocationArgs[i] = new Short(((Double)arg).shortValue());
                        continue;
                    }
                    if (ptype == Integer.TYPE) {
                        invocationArgs[i] = new Integer(((Double)arg).intValue());
                        continue;
                    }
                    if (ptype == Long.TYPE) {
                        invocationArgs[i] = new Long(((Double)arg).longValue());
                        continue;
                    }
                    if (ptype == Float.TYPE) {
                        invocationArgs[i] = new Float(((Double)arg).floatValue());
                        continue;
                    }
                    if (ptype != Double.TYPE) continue;
                    invocationArgs[i] = new Double((Double)arg);
                }
            }
            Object instance = null;
            if (this.verbose) {
                System.out.println("method is: " + m);
            }
            if (!Modifier.isStatic(m.getModifiers())) {
                instance = m.getDeclaringClass().newInstance();
            }
            if ((result = m.invoke(instance, invocationArgs)) != null) {
                System.out.println("Invocation result was: " + result);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(-1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

