/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;

public class SearchFiles {
    private SearchFiles() {
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        usage = "Usage: java org.apache.lucene.demo.SearchFiles [-index dir] [-field f] [-repeat n] [-queries file] [-raw] [-norms field]";
        if (args.length > 0 && ("-h".equals(args[0]) || "-help".equals(args[0]))) {
            System.out.println(usage);
            System.exit(0);
        }
        index = "index";
        field = "contents";
        queries = null;
        repeat = 0;
        raw = false;
        normsField = null;
        for (i = 0; i < args.length; ++i) {
            if ("-index".equals(args[i])) {
                index = args[i + 1];
                ++i;
                continue;
            }
            if ("-field".equals(args[i])) {
                field = args[i + 1];
                ++i;
                continue;
            }
            if ("-queries".equals(args[i])) {
                queries = args[i + 1];
                ++i;
                continue;
            }
            if ("-repeat".equals(args[i])) {
                repeat = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if ("-raw".equals(args[i])) {
                raw = true;
                continue;
            }
            if (!"-norms".equals(args[i])) continue;
            normsField = args[i + 1];
            ++i;
        }
        reader = IndexReader.open(index);
        if (normsField != null) {
            reader = new OneNormsReader(reader, normsField);
        }
        searcher = new IndexSearcher(reader);
        analyzer = new StandardAnalyzer();
        in = null;
        in = queries != null ? new BufferedReader(new FileReader(queries)) : new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        block1: while (true) {
            if (queries == null) {
                System.out.print("Query: ");
            }
            if ((line = in.readLine()) == null || line.length() == -1) break;
            query = QueryParser.parse(line, field, analyzer);
            System.out.println("Searching for: " + query.toString(field));
            hits = searcher.search(query);
            if (repeat > 0) {
                start = new Date();
                for (i = 0; i < repeat; ++i) {
                    hits = searcher.search(query);
                }
                end = new Date();
                System.out.println("Time: " + (end.getTime() - start.getTime()) + "ms");
            }
            System.out.println(hits.length() + " total matching documents");
            HITS_PER_PAGE = 10;
            start = 0;
            while (true) {
                if (start >= hits.length()) continue block1;
                end = Math.min(hits.length(), start + 10);
                for (i = start; i < end; ++i) {
                    if (raw) {
                        System.out.println("doc=" + hits.id(i) + " score=" + hits.score(i));
                        continue;
                    }
                    doc = hits.doc(i);
                    path = doc.get("path");
                    if (path != null) {
                        System.out.println(i + 1 + ". " + path);
                        title = doc.get("title");
                        if (title == null) continue;
                        System.out.println("   Title: " + doc.get("title"));
                        continue;
                    }
                    System.out.println(i + 1 + ". " + "No path for this document");
                }
                if (queries != null) continue block1;
                if (hits.length() > end) {
                    System.out.print("more (y/n) ? ");
                    line = in.readLine();
                    if (line.length() != 0 && line.charAt(0) != 'n') ** break;
                    continue block1;
                }
                start += 10;
            }
            break;
        }
        reader.close();
    }

    private static class OneNormsReader
    extends FilterIndexReader {
        private String field;

        public OneNormsReader(IndexReader in, String field) {
            super(in);
            this.field = field;
        }

        public byte[] norms(String field) throws IOException {
            return this.in.norms(this.field);
        }
    }
}

