/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.osgi.framework.BundleException;

public class SystemState
extends StateImpl {
    public boolean addBundle(BundleDescription description) {
        if (!super.addBundle(description)) {
            return false;
        }
        this.updateTimeStamp();
        return true;
    }

    public boolean removeBundle(BundleDescription toRemove) {
        if (!super.removeBundle(toRemove)) {
            return false;
        }
        this.updateTimeStamp();
        return true;
    }

    public boolean updateBundle(BundleDescription newDescription) {
        if (!super.updateBundle(newDescription)) {
            return false;
        }
        this.updateTimeStamp();
        return true;
    }

    private void updateTimeStamp() {
        if (this.getTimeStamp() == Long.MAX_VALUE) {
            this.setTimeStamp(0L);
        }
        this.setTimeStamp(this.getTimeStamp() + 1L);
    }

    public StateDelta compare(State state) throws BundleException {
        throw new UnsupportedOperationException();
    }

    public StateDelta resolve() {
        StateDelta delta = super.resolve();
        if (delta.getChanges().length > 0) {
            this.updateTimeStamp();
        }
        return delta;
    }

    public StateDelta resolve(boolean incremental) {
        StateDelta delta = super.resolve(incremental);
        if (delta.getChanges().length > 0) {
            this.updateTimeStamp();
        }
        return delta;
    }

    public StateDelta resolve(BundleDescription[] reResolve) {
        StateDelta delta = super.resolve(reResolve);
        if (delta.getChanges().length > 0) {
            this.updateTimeStamp();
        }
        return delta;
    }
}

