/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.Permission;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionSet;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissions;

final class BundleCombinedPermissions
extends BundlePermissionCollection {
    private static final long serialVersionUID = 4049357526208360496L;
    private BundlePermissionCollection assigned;
    private BundlePermissionCollection implied;
    private ConditionalPermissions conditional;
    private ConditionalPermissionSet restrictedPermissions;
    private boolean isDefault;

    BundleCombinedPermissions(BundlePermissionCollection implied) {
        this.implied = implied;
        this.setReadOnly();
    }

    void setAssignedPermissions(BundlePermissionCollection assigned, boolean isDefault) {
        this.assigned = assigned;
        this.isDefault = isDefault;
    }

    void setConditionalPermissions(ConditionalPermissions conditional) {
        this.conditional = conditional;
    }

    void checkConditionalPermissionInfo(ConditionalPermissionInfoImpl cpi) {
        if (this.conditional != null) {
            this.conditional.checkConditionalPermissionInfo(cpi);
        }
    }

    void unresolvePermissions(AbstractBundle[] refreshedBundles) {
        if (this.assigned != null) {
            this.assigned.unresolvePermissions(refreshedBundles);
        }
        if (this.implied != null) {
            this.implied.unresolvePermissions(refreshedBundles);
        }
        if (this.conditional != null) {
            this.conditional.unresolvePermissions(refreshedBundles);
        }
        if (this.restrictedPermissions != null) {
            this.restrictedPermissions.unresolvePermissions(refreshedBundles);
        }
    }

    public void add(Permission permission) {
        throw new SecurityException();
    }

    public Enumeration elements() {
        return new Enumeration(){
            private int i = 0;
            private Enumeration[] enums;
            {
                this.enums = new Enumeration[]{BundleCombinedPermissions.this.assigned == null ? null : BundleCombinedPermissions.this.assigned.elements(), BundleCombinedPermissions.this.implied == null ? null : BundleCombinedPermissions.this.implied.elements()};
            }

            public boolean hasMoreElements() {
                while (this.i < this.enums.length) {
                    Enumeration perms = this.enums[this.i];
                    if (perms != null && perms.hasMoreElements()) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }

            public Object nextElement() {
                while (this.i < this.enums.length) {
                    try {
                        Enumeration perms = this.enums[this.i];
                        if (perms != null) {
                            return perms.nextElement();
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    ++this.i;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public boolean implies(Permission permission) {
        if (this.implied != null && this.implied.implies(permission)) {
            return true;
        }
        if (this.restrictedPermissions != null && !this.restrictedPermissions.implies(permission)) {
            return false;
        }
        if (!this.isDefault && this.assigned != null) {
            return this.assigned.implies(permission);
        }
        if (this.conditional != null) {
            boolean conditionalImplies = this.conditional.implies(permission);
            if (!this.conditional.isEmpty()) {
                return conditionalImplies;
            }
        }
        return this.assigned.implies(permission);
    }

    public void setRestrictedPermissions(ConditionalPermissionSet restrictedPermissions) {
        this.restrictedPermissions = restrictedPermissions;
    }
}

