/*
 * Decompiled with CFR 0.152.
 */
package dacapo;

import dacapo.Digest;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.MessageDigest;

public class FileDigest {
    private static final int BUFLEN = 8192;

    public static byte[] get(String file, boolean isText, boolean filterScratch, File scratch) throws IOException {
        if (isText) {
            return FileDigest.getText(new File(file), filterScratch, scratch);
        }
        if (filterScratch) {
            System.err.println("ERROR: Cannot filter scratch paths in a binary file");
            return Digest.create().digest("ERROR: Cannot filter scratch paths in a binary file".getBytes());
        }
        return FileDigest.getBinary(new File(file));
    }

    private static String replaceAllFixed(String line, String substr, String replacement) {
        int match;
        int start = 0;
        while ((match = line.indexOf(substr, start)) != -1) {
            line = line.substring(0, match) + replacement + line.substring(match + substr.length(), line.length());
            start = match + replacement.length();
        }
        return line;
    }

    public static byte[] getText(File file, boolean filter, File scratch) throws IOException {
        String line;
        MessageDigest digest = Digest.create();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            if (filter) {
                line = FileDigest.replaceAllFixed(line, scratch.getAbsolutePath(), "$SCRATCH");
                line = FileDigest.replaceAllFixed(line, scratch.getPath(), "$SCRATCH");
                line = FileDigest.replaceAllFixed(line, "\\", "/");
            }
            byte[] buf = line.getBytes();
            for (int i = 0; i < buf.length; ++i) {
                digest.update(buf[i]);
            }
        }
        in.close();
        return digest.digest();
    }

    public static byte[] getBinary(File file) throws IOException {
        int len;
        MessageDigest digest = Digest.create();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        byte[] buf = new byte[8192];
        while ((len = in.read()) > 0) {
            for (int i = 0; i < len; ++i) {
                digest.update(buf[i]);
            }
        }
        in.close();
        return digest.digest();
    }

    public static void main(String[] args) {
        try {
            int i;
            boolean filterScratch = false;
            String scratchDir = "";
            boolean text = false;
            for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
                if (args[i].equals("-f")) {
                    filterScratch = true;
                    scratchDir = args[++i];
                    continue;
                }
                if (args[i].equals("-t")) {
                    text = true;
                    continue;
                }
                System.err.println("invalid flag " + args[i]);
                System.err.println("Usage: FileDigest [-t [-f scratchDir]] file...");
                System.exit(1);
            }
            if (filterScratch && !text) {
                System.err.println("Can't filter scratch in binary input files");
                System.exit(2);
            }
            while (i < args.length) {
                System.out.println(args[i] + " " + Digest.toString(FileDigest.get(args[i], text, filterScratch, new File(scratchDir))));
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

