/*
 * Decompiled with CFR 0.152.
 */
package dacapo;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

class Matcher {
    private static final boolean trace = false;
    private static PrintStream err;
    private final char[] tagBuf;
    private int state = 0;
    private final String replacement;
    private static final int NOMATCH = 1;
    private static final int MATCHING = 2;
    private static final int MATCHED = 3;
    private int st = 1;
    private int outCount = 0;
    public char[] outBuf;

    public Matcher(String tag, String replacement) {
        this.tagBuf = tag.toCharArray();
        this.outBuf = new char[Math.max(tag.length(), replacement.length())];
        this.replacement = replacement;
    }

    boolean matched() {
        return this.state == this.tagBuf.length;
    }

    boolean matching() {
        return this.state != 0;
    }

    void reset() {
        this.state = 0;
    }

    public void match(char c) {
        this.outCount = 0;
        if (this.tagBuf[this.state] == c) {
            ++this.state;
            this.st = 2;
        } else {
            this.st = 1;
        }
        if (this.st == 2 && this.state == this.tagBuf.length) {
            this.st = 3;
            this.outCount = this.replacement.length();
            for (int i = 0; i < this.outCount; ++i) {
                this.outBuf[i] = this.replacement.charAt(i);
            }
            this.state = 0;
        } else if (this.state <= 0 || this.st != 2) {
            if (this.state == 0 && this.st == 1) {
                this.outCount = 1;
                this.outBuf[0] = c;
            } else {
                System.arraycopy(this.tagBuf, 0, this.outBuf, 0, this.tagBuf.length);
                int i = 1;
                --this.state;
                boolean matched = false;
                while (this.state > 0 && !matched) {
                    while (this.tagBuf[i] != this.tagBuf[0] && this.state > 0) {
                        ++i;
                        --this.state;
                    }
                    matched = true;
                    for (int j = 0; j < this.state && matched; ++j) {
                        if (this.tagBuf[j] == this.tagBuf[i + j]) continue;
                        matched = false;
                    }
                    if (!(matched = matched && this.tagBuf[this.state] == c)) continue;
                    ++this.state;
                }
                if (!matched) {
                    this.outBuf[i++] = c;
                }
                this.outCount = i;
            }
        }
    }

    public void flush() {
        for (int i = 0; i < this.state; ++i) {
            this.outBuf[i] = this.tagBuf[i];
        }
        this.outCount = this.state;
        this.state = 0;
    }

    public int emit() {
        return this.outCount;
    }

    static {
        try {
            err = new PrintStream(new FileOutputStream("/dev/stdout"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

