/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.util;

import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.Graph;
import EDU.purdue.cs.bloat.util.GraphNode;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Graph {
    private NodeMap nodes = new NodeMap();
    private NodeList preOrder = null;
    private NodeList postOrder = null;
    private Collection roots = null;
    private Collection revRoots = null;
    protected int rootEdgeModCount = 0;
    protected int revRootEdgeModCount = 0;
    protected int nodeModCount = 0;
    protected int edgeModCount = 0;
    protected int removingNode = 0;
    protected int removingEdge = 0;

    public Collection roots() {
        if (this.roots == null || this.rootEdgeModCount != this.edgeModCount) {
            this.rootEdgeModCount = this.edgeModCount;
            this.roots = new ArrayList();
            this.buildRootList(this.roots, false);
        }
        return this.roots;
    }

    public Collection reverseRoots() {
        if (this.roots == null || this.revRootEdgeModCount != this.edgeModCount) {
            this.revRootEdgeModCount = this.edgeModCount;
            this.revRoots = new ArrayList();
            this.buildRootList(this.revRoots, true);
        }
        return this.revRoots;
    }

    private void buildRootList(Collection c, boolean reverse) {
        HashSet<GraphNode> visited = new HashSet<GraphNode>(this.nodes.size() * 2);
        ArrayList<GraphNode> stack = new ArrayList<GraphNode>();
        Iterator iter = this.nodes.values().iterator();
        while (iter.hasNext()) {
            GraphNode node = (GraphNode)iter.next();
            if (visited.contains(node)) continue;
            visited.add(node);
            stack.add(node);
            while (!stack.isEmpty()) {
                Iterator preds;
                GraphNode v = (GraphNode)stack.remove(stack.size() - 1);
                boolean pushed = false;
                Iterator iterator = preds = reverse ? v.succs.iterator() : v.preds.iterator();
                while (preds.hasNext()) {
                    GraphNode w = (GraphNode)preds.next();
                    if (visited.contains(w)) continue;
                    visited.add(w);
                    stack.add(w);
                    pushed = true;
                }
                if (pushed) continue;
                c.add(v);
            }
        }
    }

    public Collection succs(GraphNode v) {
        return new EdgeSet(v, v.succs);
    }

    public Collection preds(GraphNode v) {
        return new EdgeSet(v, v.preds);
    }

    public boolean isAncestorToDescendent(GraphNode v, GraphNode w) {
        return this.preOrderIndex(v) <= this.preOrderIndex(w) && this.postOrderIndex(w) <= this.postOrderIndex(v);
    }

    public int preOrderIndex(GraphNode node) {
        if (this.preOrder == null || this.edgeModCount != this.preOrder.edgeModCount) {
            this.buildLists();
        }
        return node.preOrderIndex();
    }

    public int postOrderIndex(GraphNode node) {
        if (this.postOrder == null || this.edgeModCount != this.postOrder.edgeModCount) {
            this.buildLists();
        }
        return node.postOrderIndex();
    }

    public List preOrder() {
        if (this.preOrder == null || this.edgeModCount != this.preOrder.edgeModCount) {
            this.buildLists();
        }
        return this.preOrder;
    }

    public List postOrder() {
        if (this.postOrder == null || this.edgeModCount != this.postOrder.edgeModCount) {
            this.buildLists();
        }
        return this.postOrder;
    }

    private void buildLists() {
        Iterator<Object> iter = this.roots().iterator();
        this.preOrder = new NodeList();
        this.postOrder = new NodeList();
        HashSet visited = new HashSet();
        while (iter.hasNext()) {
            GraphNode root = (GraphNode)iter.next();
            Assert.isTrue(this.nodes.containsValue(root), "Graph does not contain " + root);
            this.number(root, visited);
        }
        iter = this.nodes.values().iterator();
        while (iter.hasNext()) {
            GraphNode node = (GraphNode)iter.next();
            if (!visited.contains(node)) {
                node.setPreOrderIndex(-1);
                node.setPostOrderIndex(-1);
                continue;
            }
            Assert.isTrue(node.preOrderIndex() >= 0);
            Assert.isTrue(node.postOrderIndex() >= 0);
        }
    }

    public void removeUnreachable() {
        if (this.preOrder == null || this.edgeModCount != this.preOrder.edgeModCount) {
            this.buildLists();
        }
        Iterator iter = this.nodes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = (Map.Entry)iter.next();
            GraphNode v = (GraphNode)e.getValue();
            if (v.preOrderIndex() != -1) continue;
            iter.remove();
        }
    }

    private void number(GraphNode node, Set visited) {
        visited.add(node);
        node.setPreOrderIndex(this.preOrder.size());
        this.preOrder.addNode(node);
        Iterator iter = this.succs(node).iterator();
        while (iter.hasNext()) {
            GraphNode succ = (GraphNode)iter.next();
            if (visited.contains(succ)) continue;
            this.number(succ, visited);
        }
        node.setPostOrderIndex(this.postOrder.size());
        this.postOrder.addNode(node);
    }

    public void addNode(Object key, GraphNode node) {
        Assert.isTrue(this.nodes.get(key) == null);
        this.nodes.putNodeInMap(key, node);
        this.preOrder = null;
        this.postOrder = null;
        ++this.nodeModCount;
        ++this.edgeModCount;
    }

    public GraphNode getNode(Object key) {
        return (GraphNode)this.nodes.get(key);
    }

    public Set keySet() {
        return this.nodes.keySet();
    }

    public void removeNode(Object key) {
        GraphNode node = this.getNode(key);
        Assert.isTrue(node != null, "No node for " + key);
        this.succs(node).clear();
        this.preds(node).clear();
        if (this.removingNode == 0) {
            this.nodes.removeNodeFromMap(key);
        } else if (this.removingNode != 1) {
            throw new RuntimeException();
        }
        this.preOrder = null;
        this.postOrder = null;
        ++this.nodeModCount;
        ++this.edgeModCount;
    }

    public void addEdge(GraphNode v, GraphNode w) {
        Assert.isTrue(this.nodes.containsValue(v), "Graph does not contain " + v);
        Assert.isTrue(this.nodes.containsValue(w), "Graph does not contain " + w);
        this.succs(v).add(w);
        ++this.edgeModCount;
    }

    public void removeEdge(GraphNode v, GraphNode w) {
        Assert.isTrue(this.nodes.containsValue(v), "Graph does not contain " + v);
        Assert.isTrue(this.nodes.containsValue(w), "Graph does not contain " + w);
        Assert.isTrue(v.succs().contains(w));
        if (this.removingEdge == 0) {
            this.succs(v).remove(w);
        } else if (this.removingEdge != 1) {
            throw new RuntimeException();
        }
        ++this.edgeModCount;
    }

    public String toString() {
        String s = "";
        Iterator iter = this.nodes.values().iterator();
        while (iter.hasNext()) {
            GraphNode node = (GraphNode)iter.next();
            s = s + "[" + node;
            s = s + " succs = " + node.succs();
            s = s + " preds = " + node.preds();
            s = s + "]\n";
        }
        return s;
    }

    public boolean hasNode(GraphNode v) {
        return this.nodes.containsValue(v);
    }

    public boolean hasEdge(GraphNode v, GraphNode w) {
        Assert.isTrue(this.nodes.containsValue(v), "Graph does not contain " + v);
        Assert.isTrue(this.nodes.containsValue(w), "Graph does not contain " + w);
        return this.succs(v).contains(w);
    }

    public Collection nodes() {
        return this.nodes.values();
    }

    public int size() {
        return this.nodes.size();
    }

    class EdgeSet
    extends AbstractSet {
        GraphNode node;
        Set set;
        int nodeModCount;

        public EdgeSet(GraphNode node, Set set) {
            this.node = node;
            this.set = set;
            this.nodeModCount = Graph.this.nodeModCount;
        }

        public int size() {
            if (this.nodeModCount != Graph.this.nodeModCount) {
                throw new ConcurrentModificationException();
            }
            return this.set.size();
        }

        public boolean retainAll(Collection c) {
            return super.retainAll(new ArrayList(c));
        }

        public boolean removeAll(Collection c) {
            return super.removeAll(new ArrayList(c));
        }

        public boolean addAll(Collection c) {
            return super.addAll(new ArrayList(c));
        }

        public boolean add(Object a) {
            if (this.nodeModCount != Graph.this.nodeModCount) {
                throw new ConcurrentModificationException();
            }
            Assert.isTrue(Graph.this.nodes.containsValue(a));
            Assert.isTrue(Graph.this.nodes.containsValue(this.node));
            GraphNode v = (GraphNode)a;
            if (this.set.add(v)) {
                ++Graph.this.edgeModCount;
                if (this.set == this.node.succs) {
                    v.preds.add(this.node);
                } else {
                    v.succs.add(this.node);
                }
                return true;
            }
            return false;
        }

        public boolean remove(Object a) {
            if (this.nodeModCount != Graph.this.nodeModCount) {
                throw new ConcurrentModificationException();
            }
            GraphNode v = (GraphNode)a;
            if (this.set.contains(v)) {
                ++Graph.this.edgeModCount;
                if (this.set == this.node.succs) {
                    ++Graph.this.removingEdge;
                    Graph.this.removeEdge(this.node, v);
                    --Graph.this.removingEdge;
                    v.preds.remove(this.node);
                } else {
                    ++Graph.this.removingEdge;
                    Graph.this.removeEdge(v, this.node);
                    --Graph.this.removingEdge;
                    v.succs.remove(this.node);
                }
                this.set.remove(v);
                return true;
            }
            return false;
        }

        public boolean contains(Object a) {
            if (this.nodeModCount != Graph.this.nodeModCount) {
                throw new ConcurrentModificationException();
            }
            Assert.isTrue(Graph.this.nodes.containsValue(a));
            Assert.isTrue(Graph.this.nodes.containsValue(this.node));
            if (a instanceof GraphNode) {
                return this.set.contains(a);
            }
            return false;
        }

        public void clear() {
            if (this.nodeModCount != Graph.this.nodeModCount) {
                throw new ConcurrentModificationException();
            }
            Iterator iter = this.set.iterator();
            while (iter.hasNext()) {
                GraphNode v = (GraphNode)iter.next();
                if (this.set == this.node.succs) {
                    ++Graph.this.removingEdge;
                    Graph.this.removeEdge(this.node, v);
                    --Graph.this.removingEdge;
                    v.preds.remove(this.node);
                    continue;
                }
                ++Graph.this.removingEdge;
                Graph.this.removeEdge(v, this.node);
                --Graph.this.removingEdge;
                v.succs.remove(this.node);
            }
            ++Graph.this.edgeModCount;
            this.set.clear();
        }

        public Iterator iterator() {
            if (this.nodeModCount != Graph.this.nodeModCount) {
                throw new ConcurrentModificationException();
            }
            Iterator iter = this.set.iterator();
            return new Iterator(this, iter){
                GraphNode last;
                int edgeModCount;
                int nodeModCount;
                private final /* synthetic */ Iterator val$iter;
                private final /* synthetic */ EdgeSet this$1;
                {
                    this.this$1 = this$1;
                    this.val$iter = val$iter;
                    this.edgeModCount = EdgeSet.access$600((EdgeSet)this.this$1).edgeModCount;
                    this.nodeModCount = this.this$1.nodeModCount;
                }

                public boolean hasNext() {
                    if (this.nodeModCount != EdgeSet.access$600((EdgeSet)this.this$1).nodeModCount) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.edgeModCount != EdgeSet.access$600((EdgeSet)this.this$1).edgeModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return this.val$iter.hasNext();
                }

                public Object next() {
                    if (this.nodeModCount != EdgeSet.access$600((EdgeSet)this.this$1).nodeModCount) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.edgeModCount != EdgeSet.access$600((EdgeSet)this.this$1).edgeModCount) {
                        throw new ConcurrentModificationException();
                    }
                    this.last = (GraphNode)this.val$iter.next();
                    Assert.isTrue(Graph.access$500(EdgeSet.access$600(this.this$1)).containsValue(this.last), this.last + " not found in graph");
                    Assert.isTrue(Graph.access$500(EdgeSet.access$600(this.this$1)).containsValue(this.this$1.node), this.this$1.node + " not found in graph");
                    return this.last;
                }

                public void remove() {
                    if (this.nodeModCount != EdgeSet.access$600((EdgeSet)this.this$1).nodeModCount) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.edgeModCount != EdgeSet.access$600((EdgeSet)this.this$1).edgeModCount) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.this$1.set == this.this$1.node.succs) {
                        ++EdgeSet.access$600((EdgeSet)this.this$1).removingEdge;
                        EdgeSet.access$600(this.this$1).removeEdge(this.this$1.node, this.last);
                        --EdgeSet.access$600((EdgeSet)this.this$1).removingEdge;
                        this.last.preds.remove(this.this$1.node);
                    } else {
                        ++EdgeSet.access$600((EdgeSet)this.this$1).removingEdge;
                        EdgeSet.access$600(this.this$1).removeEdge(this.last, this.this$1.node);
                        --EdgeSet.access$600((EdgeSet)this.this$1).removingEdge;
                        this.last.succs.remove(this.this$1.node);
                    }
                    ++EdgeSet.access$600((EdgeSet)this.this$1).edgeModCount;
                    this.edgeModCount = EdgeSet.access$600((EdgeSet)this.this$1).edgeModCount;
                    this.val$iter.remove();
                }
            };
        }

        static /* synthetic */ Graph access$600(EdgeSet x0) {
            return x0.Graph.this;
        }
    }

    class NodeList
    extends ArrayList
    implements List {
        int edgeModCount;

        NodeList() {
            super(Graph.this.size());
            this.edgeModCount = Graph.this.edgeModCount;
        }

        boolean addNode(GraphNode a) {
            return super.add(a);
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean add(Object a) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object a) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object a) {
            if (this.edgeModCount != Graph.this.edgeModCount) {
                throw new ConcurrentModificationException();
            }
            GraphNode v = (GraphNode)a;
            if (this == Graph.this.preOrder) {
                return v.preOrderIndex();
            }
            if (this == Graph.this.postOrder) {
                return v.postOrderIndex();
            }
            return super.indexOf(a);
        }

        public int indexOf(Object a, int index) {
            int i = this.indexOf(a);
            if (i >= index) {
                return i;
            }
            return -1;
        }

        public int lastIndexOf(Object a) {
            if (this.edgeModCount != Graph.this.edgeModCount) {
                throw new ConcurrentModificationException();
            }
            GraphNode v = (GraphNode)a;
            if (this == Graph.this.preOrder) {
                return v.preOrderIndex();
            }
            if (this == Graph.this.postOrder) {
                return v.postOrderIndex();
            }
            return super.lastIndexOf(a);
        }

        public int lastIndexOf(Object a, int index) {
            int i = this.indexOf(a);
            if (i <= index) {
                return i;
            }
            return -1;
        }

        public Iterator iterator() {
            if (Graph.this.edgeModCount != this.edgeModCount) {
                throw new ConcurrentModificationException();
            }
            Iterator iter = super.iterator();
            return new Iterator(this, iter){
                int edgeModCount;
                Object last;
                private final /* synthetic */ Iterator val$iter;
                private final /* synthetic */ NodeList this$1;
                {
                    this.this$1 = this$1;
                    this.val$iter = val$iter;
                    this.edgeModCount = this.this$1.edgeModCount;
                }

                public boolean hasNext() {
                    if (NodeList.access$400((NodeList)this.this$1).edgeModCount != this.edgeModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return this.val$iter.hasNext();
                }

                public Object next() {
                    if (NodeList.access$400((NodeList)this.this$1).edgeModCount != this.edgeModCount) {
                        throw new ConcurrentModificationException();
                    }
                    this.last = this.val$iter.next();
                    return this.last;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        static /* synthetic */ Graph access$400(NodeList x0) {
            return x0.Graph.this;
        }
    }

    class NodeMap
    extends AbstractMap {
        HashMap map = new HashMap();

        NodeMap() {
        }

        void removeNodeFromMap(Object key) {
            this.map.remove(key);
        }

        void putNodeInMap(Object key, Object value) {
            this.map.put(key, value);
        }

        public Object remove(Object key) {
            GraphNode v = (GraphNode)this.map.get(key);
            if (v != null) {
                Graph.this.removeNode(v);
            }
            return v;
        }

        public Object put(Object key, Object value) {
            GraphNode v = (GraphNode)this.remove(key);
            Graph.this.addNode(key, (GraphNode)value);
            return v;
        }

        public void clear() {
            Iterator iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry e = (Map.Entry)iter.next();
                GraphNode v = (GraphNode)e.getValue();
                ++Graph.this.removingNode;
                Graph.this.removeNode(e.getKey());
                --Graph.this.removingNode;
                iter.remove();
            }
        }

        public Set entrySet() {
            Set entries = this.map.entrySet();
            return new AbstractSet(this, entries){
                private final /* synthetic */ Collection val$entries;
                private final /* synthetic */ NodeMap this$1;
                {
                    this.this$1 = this$1;
                    this.val$entries = val$entries;
                }

                public int size() {
                    return this.val$entries.size();
                }

                public boolean contains(Object a) {
                    return this.val$entries.contains(a);
                }

                public boolean remove(Object a) {
                    Map.Entry e = (Map.Entry)a;
                    ++NodeMap.access$000((NodeMap)this.this$1).removingNode;
                    NodeMap.access$000(this.this$1).removeNode(e.getKey());
                    --NodeMap.access$000((NodeMap)this.this$1).removingNode;
                    return this.val$entries.remove(a);
                }

                public void clear() {
                    Iterator<E> iter = this.val$entries.iterator();
                    while (iter.hasNext()) {
                        Map.Entry e = (Map.Entry)iter.next();
                        ++NodeMap.access$000((NodeMap)this.this$1).removingNode;
                        NodeMap.access$000(this.this$1).removeNode(e.getKey());
                        --NodeMap.access$000((NodeMap)this.this$1).removingNode;
                        iter.remove();
                    }
                }

                public Iterator iterator() {
                    Iterator<E> iter = this.val$entries.iterator();
                    return new Iterator(this, iter){
                        int nodeModCount;
                        Map.Entry last;
                        private final /* synthetic */ Iterator val$iter;
                        private final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = this$2;
                            this.val$iter = val$iter;
                            this.nodeModCount = NodeMap.access$000((NodeMap)1.access$100(this.this$2)).nodeModCount;
                        }

                        public boolean hasNext() {
                            if (this.nodeModCount != NodeMap.access$000((NodeMap)1.access$100(this.this$2)).nodeModCount) {
                                throw new ConcurrentModificationException();
                            }
                            return this.val$iter.hasNext();
                        }

                        public Object next() {
                            if (this.nodeModCount != NodeMap.access$000((NodeMap)1.access$100(this.this$2)).nodeModCount) {
                                throw new ConcurrentModificationException();
                            }
                            this.last = (Map.Entry)this.val$iter.next();
                            return this.last;
                        }

                        public void remove() {
                            if (this.nodeModCount != NodeMap.access$000((NodeMap)1.access$100(this.this$2)).nodeModCount) {
                                throw new ConcurrentModificationException();
                            }
                            ++NodeMap.access$000((NodeMap)1.access$100(this.this$2)).removingNode;
                            NodeMap.access$000(1.access$100(this.this$2)).removeNode(this.last.getKey());
                            --NodeMap.access$000((NodeMap)1.access$100(this.this$2)).removingNode;
                            this.val$iter.remove();
                            this.nodeModCount = NodeMap.access$000((NodeMap)1.access$100(this.this$2)).nodeModCount;
                        }
                    };
                }

                static /* synthetic */ NodeMap access$100(1 x0) {
                    return x0.this$1;
                }
            };
        }

        static /* synthetic */ Graph access$000(NodeMap x0) {
            return x0.Graph.this;
        }
    }
}

