/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.DefInformation;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.LEGatherer;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.Type0Visitor;
import EDU.purdue.cs.bloat.tree.Type1Visitor;
import EDU.purdue.cs.bloat.tree.UseInformation;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class StackOptimizer {
    static boolean DEBUG = false;
    Hashtable defInfoMap;
    Hashtable useInfoMap;
    Block owningBlock;

    public StackOptimizer(Block owningBlock) {
        this.owningBlock = owningBlock;
        this.defInfoMap = new Hashtable();
        this.useInfoMap = new Hashtable();
    }

    public static void optimizeCFG(FlowGraph cfg) {
        List blocks = cfg.preOrder();
        Iterator it = blocks.iterator();
        while (it.hasNext()) {
            ((Block)it.next()).stackOptimizer().optimize();
        }
    }

    public void optimize() {
        Vector LEs = new LEGatherer().getLEs(this.owningBlock);
        for (int i = 0; i < LEs.size(); ++i) {
            DefInformation DI;
            LocalExpr current = (LocalExpr)LEs.elementAt(i);
            this.useInfoMap.put(current, new UseInformation());
            if (current.isDef()) {
                DI = new DefInformation(current.uses.size());
                this.defInfoMap.put(current, DI);
                continue;
            }
            if (current.def() == null || (DI = (DefInformation)this.defInfoMap.get(current.def())) == null) continue;
            ++DI.usesFound;
            if (current.parent() instanceof ArithExpr && current.parent().parent() instanceof StoreExpr && (((ArithExpr)current.parent()).left() instanceof ConstantExpr && ((ArithExpr)current.parent()).left().type().isIntegral() || ((ArithExpr)current.parent()).right() instanceof ConstantExpr && ((ArithExpr)current.parent()).left().type().isIntegral()) && ((StoreExpr)current.parent().parent()).target() instanceof LocalExpr && ((LocalExpr)((StoreExpr)current.parent().parent()).target()).index() == current.index()) {
                DI.type1s += 3;
                continue;
            }
            if (current.parent() instanceof StoreExpr && current.parent().parent() instanceof ExprStmt && ((StoreExpr)current.parent()).target() instanceof LocalExpr && ((LocalExpr)((StoreExpr)current.parent()).target()).index() == current.index()) {
                DI.type1s += 3;
                continue;
            }
            if (new Type0Visitor(this.defInfoMap, this.useInfoMap).search(current) || DI.type1s >= 3) continue;
            if (current.type().isWide()) {
                DI.type1s += 3;
                continue;
            }
            new Type1Visitor(this.defInfoMap, this.useInfoMap).search(current);
        }
    }

    public boolean shouldStore(LocalExpr expr) {
        if (expr == null) {
            return true;
        }
        DefInformation DI = (DefInformation)this.defInfoMap.get(expr);
        if (DI == null) {
            if (DEBUG) {
                System.err.println("Error in StackOptimizer.shouldStore: parameter not found in defInfoMap:");
                System.err.println(expr.toString());
            }
            return true;
        }
        return DI.type1s > 2 || DI.usesFound < DI.uses;
    }

    public int dups(LocalExpr expr) {
        int toReturn = 0;
        UseInformation UI = (UseInformation)this.useInfoMap.get(expr);
        if (UI == null) {
            if (DEBUG) {
                System.err.println("Error in StackOptimizer.dups: parameter not found in useInfoMap");
            }
            return toReturn;
        }
        toReturn += UI.type0s - UI.type0_x1s - UI.type0_x2s;
        if (expr.isDef() && !this.shouldStore(expr) || !expr.isDef() && !this.shouldStore((LocalExpr)expr.def())) {
            toReturn += UI.type1s - UI.type1_x1s - UI.type1_x2s;
        }
        return toReturn;
    }

    public int dup_x1s(LocalExpr expr) {
        int toReturn = 0;
        UseInformation UI = (UseInformation)this.useInfoMap.get(expr);
        if (UI == null) {
            if (DEBUG) {
                System.err.println("Error in StackOptimizer.dup_x1s: parameter not found in useInfoMap");
            }
            return toReturn;
        }
        toReturn += UI.type0_x1s;
        if (expr.isDef() && !this.shouldStore(expr) || !expr.isDef() && !this.shouldStore((LocalExpr)expr.def())) {
            toReturn += UI.type1_x1s;
        }
        return toReturn;
    }

    public int dup_x2s(LocalExpr expr) {
        int toReturn = 0;
        UseInformation UI = (UseInformation)this.useInfoMap.get(expr);
        if (UI == null) {
            if (DEBUG) {
                System.err.println("Error in StackOptimizer.dup_x2s: parameter not found in useInfoMap");
            }
            return toReturn;
        }
        toReturn += UI.type0_x2s;
        if (expr.isDef() && !this.shouldStore(expr) || !expr.isDef() && !this.shouldStore((LocalExpr)expr.def())) {
            toReturn += UI.type1_x2s;
        }
        return toReturn;
    }

    public boolean onStack(LocalExpr expr) {
        if (expr.isDef()) {
            return false;
        }
        UseInformation UI = (UseInformation)this.useInfoMap.get(expr);
        if (UI == null) {
            if (DEBUG) {
                System.err.println("Error in StackOptimizer.onStack: parameter not found in useInfoMap");
            }
            return false;
        }
        if (UI.type == 0) {
            return true;
        }
        return UI.type == 1 && !this.shouldStore((LocalExpr)expr.def());
    }

    public boolean shouldSwap(LocalExpr expr) {
        UseInformation UI = (UseInformation)this.useInfoMap.get(expr);
        if (UI == null) {
            if (DEBUG) {
                System.err.println("Error in StackOptimizer.onStack: parameter not found in useInfoMap");
            }
            return false;
        }
        return this.onStack(expr) && UI.type == 1;
    }

    public void infoDisplay(LocalExpr expr) {
        UseInformation UI = (UseInformation)this.useInfoMap.get(expr);
        DefInformation DI = (DefInformation)this.defInfoMap.get(expr);
        System.err.println(expr.toString());
        System.err.println(expr.parent().toString() + "-" + expr.parent().parent().toString());
        if (expr.parent().parent().parent() != null && expr.parent().parent().parent().parent() != null) {
            System.err.println(expr.parent().parent().parent().toString() + "-" + expr.parent().parent().parent().parent().toString());
        }
        if (DI == null) {
            System.err.println("not a definition");
            if (expr.def() == null) {
                System.err.println("has no definition (is parameter?)");
            } else {
                System.err.println("has definition " + expr.def());
            }
        } else {
            System.err.println("a definition with " + DI.type1s + " type1s total");
            System.err.println("uses: " + DI.uses);
            System.err.println("uses found: " + DI.usesFound);
            if (this.shouldStore(expr)) {
                System.err.println("should store");
            }
        }
        if (UI == null) {
            System.err.println("No use information entry. trouble");
        } else {
            if (DI == null) {
                System.err.println("type on stack: " + UI.type);
            }
            System.err.println("type0s for this instance: " + UI.type0s);
            System.err.println("of above, number of x1s: " + UI.type0_x1s);
            System.err.println("of above, number of x2s: " + UI.type0_x2s);
            System.err.println("type1s for this instance: " + UI.type1s);
            System.err.println("of above, number of x1s: " + UI.type1_x1s);
            System.err.println("of above, number of x2s: " + UI.type1_x2s);
        }
    }
}

