/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.tree.Assign;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.TreeVisitor;

public class StackManipStmt
extends Stmt
implements Assign {
    StackExpr[] target;
    StackExpr[] source;
    int kind;
    public static final int SWAP = 0;
    public static final int DUP = 1;
    public static final int DUP_X1 = 2;
    public static final int DUP_X2 = 3;
    public static final int DUP2 = 4;
    public static final int DUP2_X1 = 5;
    public static final int DUP2_X2 = 6;

    public StackManipStmt(StackExpr[] target, StackExpr[] source, int kind) {
        int i;
        this.kind = kind;
        this.target = target;
        for (i = 0; i < target.length; ++i) {
            this.target[i].setParent(this);
        }
        this.source = source;
        for (i = 0; i < source.length; ++i) {
            this.source[i].setParent(this);
        }
    }

    public DefExpr[] defs() {
        return this.target;
    }

    public StackExpr[] target() {
        return this.target;
    }

    public StackExpr[] source() {
        return this.source;
    }

    public int kind() {
        return this.kind;
    }

    public void visit(TreeVisitor visitor) {
        visitor.visitStackManipStmt(this);
    }

    public void visitForceChildren(TreeVisitor visitor) {
        if (visitor.reverse()) {
            int i;
            for (i = this.target.length - 1; i >= 0; --i) {
                this.target[i].visit(visitor);
            }
            for (i = this.source.length - 1; i >= 0; --i) {
                this.source[i].visit(visitor);
            }
        } else {
            int i;
            for (i = 0; i < this.source.length; ++i) {
                this.source[i].visit(visitor);
            }
            for (i = 0; i < this.target.length; ++i) {
                this.target[i].visit(visitor);
            }
        }
    }

    public Object clone() {
        StackExpr[] t = new StackExpr[this.target.length];
        for (int i = 0; i < this.target.length; ++i) {
            t[i] = (StackExpr)this.target[i].clone();
        }
        StackExpr[] s = new StackExpr[this.source.length];
        for (int i = 0; i < this.source.length; ++i) {
            s[i] = (StackExpr)this.source[i].clone();
        }
        return this.copyInto(new StackManipStmt(t, s, this.kind));
    }
}

