/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.tree.AddressStoreStmt;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayLengthExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallMethodExpr;
import EDU.purdue.cs.bloat.tree.CallStaticExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.CatchExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.GotoStmt;
import EDU.purdue.cs.bloat.tree.IfCmpStmt;
import EDU.purdue.cs.bloat.tree.IfZeroStmt;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.InstanceOfExpr;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemExpr;
import EDU.purdue.cs.bloat.tree.MonitorStmt;
import EDU.purdue.cs.bloat.tree.NegExpr;
import EDU.purdue.cs.bloat.tree.NewArrayExpr;
import EDU.purdue.cs.bloat.tree.NewExpr;
import EDU.purdue.cs.bloat.tree.NewMultiArrayExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.RCExpr;
import EDU.purdue.cs.bloat.tree.RetStmt;
import EDU.purdue.cs.bloat.tree.ReturnAddressExpr;
import EDU.purdue.cs.bloat.tree.ReturnExprStmt;
import EDU.purdue.cs.bloat.tree.ReturnStmt;
import EDU.purdue.cs.bloat.tree.SCStmt;
import EDU.purdue.cs.bloat.tree.SRStmt;
import EDU.purdue.cs.bloat.tree.ShiftExpr;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StackManipStmt;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.SwitchStmt;
import EDU.purdue.cs.bloat.tree.ThrowStmt;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.UCExpr;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.tree.ZeroCheckExpr;
import java.util.Iterator;
import java.util.ListIterator;

public class ReplaceVisitor
extends TreeVisitor {
    Node from;
    Node to;

    public ReplaceVisitor(Node from, Node to) {
        this.from = from;
        this.to = to;
        if (Tree.DEBUG) {
            System.out.println("replace " + from + " VN=" + from.valueNumber() + " in " + from.parent + " with " + to);
        }
    }

    public void visitTree(Tree tree) {
        if (this.to instanceof Stmt) {
            ((Stmt)this.to).setParent(tree);
            ListIterator iter = tree.stmts.listIterator(tree.stmts.size());
            while (iter.hasPrevious()) {
                Stmt s = (Stmt)iter.previous();
                if (s != this.from) continue;
                iter.set(this.to);
                break;
            }
        } else {
            tree.visitChildren(this);
        }
    }

    public void visitExprStmt(ExprStmt stmt) {
        if (stmt.expr == this.from) {
            stmt.expr = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else {
            stmt.visitChildren(this);
        }
    }

    public void visitInitStmt(InitStmt stmt) {
        for (int i = 0; i < stmt.targets.length; ++i) {
            if (stmt.targets[i] != this.from) continue;
            stmt.targets[i] = (LocalExpr)this.to;
            ((LocalExpr)this.to).setParent(stmt);
            return;
        }
        stmt.visitChildren(this);
    }

    public void visitGotoStmt(GotoStmt stmt) {
        stmt.visitChildren(this);
    }

    public void visitMonitorStmt(MonitorStmt stmt) {
        if (stmt.object == this.from) {
            stmt.object = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else {
            stmt.visitChildren(this);
        }
    }

    public void visitStackManipStmt(StackManipStmt stmt) {
        int i;
        for (i = 0; i < stmt.target.length; ++i) {
            if (stmt.target[i] != this.from) continue;
            stmt.target[i] = (StackExpr)this.to;
            ((Expr)this.to).setParent(stmt);
            return;
        }
        for (i = 0; i < stmt.source.length; ++i) {
            if (stmt.source[i] != this.from) continue;
            stmt.source[i] = (StackExpr)this.to;
            ((Expr)this.to).setParent(stmt);
            return;
        }
        stmt.visitChildren(this);
    }

    public void visitCatchExpr(CatchExpr expr) {
        expr.visitChildren(this);
    }

    public void visitPhiJoinStmt(PhiJoinStmt stmt) {
        if (stmt.target == this.from) {
            stmt.target = (VarExpr)this.to;
            ((VarExpr)this.to).setParent(stmt);
        } else {
            Iterator e = stmt.operands.keySet().iterator();
            while (e.hasNext()) {
                Block block = (Block)e.next();
                if (stmt.operandAt(block) != this.from) continue;
                stmt.setOperandAt(block, (Expr)this.to);
                ((Expr)this.to).setParent(stmt);
                return;
            }
            stmt.visitChildren(this);
        }
    }

    public void visitPhiCatchStmt(PhiCatchStmt stmt) {
        if (stmt.target == this.from) {
            stmt.target = (LocalExpr)this.to;
            ((LocalExpr)this.to).setParent(stmt);
        } else {
            ListIterator<Node> e = stmt.operands.listIterator();
            while (e.hasNext()) {
                LocalExpr expr = (LocalExpr)e.next();
                if (expr != this.from) continue;
                e.set(this.to);
                this.from.cleanup();
                ((LocalExpr)this.to).setParent(stmt);
                return;
            }
            stmt.visitChildren(this);
        }
    }

    public void visitRetStmt(RetStmt stmt) {
        stmt.visitChildren(this);
    }

    public void visitReturnExprStmt(ReturnExprStmt stmt) {
        if (stmt.expr == this.from) {
            stmt.expr = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else {
            stmt.visitChildren(this);
        }
    }

    public void visitReturnStmt(ReturnStmt stmt) {
        stmt.visitChildren(this);
    }

    public void visitAddressStoreStmt(AddressStoreStmt stmt) {
        stmt.visitChildren(this);
    }

    public void visitStoreExpr(StoreExpr expr) {
        if (expr.target == this.from) {
            expr.target = (MemExpr)this.to;
            ((MemExpr)this.to).setParent(expr);
        } else if (expr.expr == this.from) {
            expr.expr = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitSwitchStmt(SwitchStmt stmt) {
        if (stmt.index == this.from) {
            stmt.index = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else {
            stmt.visitChildren(this);
        }
    }

    public void visitThrowStmt(ThrowStmt stmt) {
        if (stmt.expr == this.from) {
            stmt.expr = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else {
            stmt.visitChildren(this);
        }
    }

    public void visitSCStmt(SCStmt stmt) {
        if (stmt.array == this.from) {
            stmt.array = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else if (stmt.index == this.from) {
            stmt.index = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else {
            stmt.visitChildren(this);
        }
    }

    public void visitSRStmt(SRStmt stmt) {
        if (stmt.array == this.from) {
            stmt.array = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else if (stmt.start == this.from) {
            stmt.start = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else if (stmt.end == this.from) {
            stmt.end = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else {
            stmt.visitChildren(this);
        }
    }

    public void visitDefExpr(DefExpr expr) {
        expr.visitChildren(this);
    }

    public void visitArrayLengthExpr(ArrayLengthExpr expr) {
        if (expr.array == this.from) {
            expr.array = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitArithExpr(ArithExpr expr) {
        if (expr.left == this.from) {
            expr.left = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else if (expr.right == this.from) {
            expr.right = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitArrayRefExpr(ArrayRefExpr expr) {
        if (expr.array == this.from) {
            expr.array = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else if (expr.index == this.from) {
            expr.index = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitCallMethodExpr(CallMethodExpr expr) {
        if (expr.receiver == this.from) {
            expr.receiver = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            for (int i = 0; i < expr.params.length; ++i) {
                if (expr.params[i] != this.from) continue;
                expr.params[i] = (Expr)this.to;
                ((Expr)this.to).setParent(expr);
                return;
            }
            expr.visitChildren(this);
        }
    }

    public void visitCallStaticExpr(CallStaticExpr expr) {
        for (int i = 0; i < expr.params.length; ++i) {
            if (expr.params[i] != this.from) continue;
            expr.params[i] = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
            return;
        }
        expr.visitChildren(this);
    }

    public void visitCastExpr(CastExpr expr) {
        if (expr.expr == this.from) {
            expr.expr = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitConstantExpr(ConstantExpr expr) {
        expr.visitChildren(this);
    }

    public void visitFieldExpr(FieldExpr expr) {
        if (expr.object == this.from) {
            expr.object = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitInstanceOfExpr(InstanceOfExpr expr) {
        if (expr.expr == this.from) {
            expr.expr = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitLocalExpr(LocalExpr expr) {
        expr.visitChildren(this);
    }

    public void visitNegExpr(NegExpr expr) {
        if (expr.expr == this.from) {
            expr.expr = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitNewArrayExpr(NewArrayExpr expr) {
        if (expr.size == this.from) {
            expr.size = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitNewExpr(NewExpr expr) {
        expr.visitChildren(this);
    }

    public void visitNewMultiArrayExpr(NewMultiArrayExpr expr) {
        for (int i = 0; i < expr.dimensions.length; ++i) {
            if (expr.dimensions[i] != this.from) continue;
            expr.dimensions[i] = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
            return;
        }
        expr.visitChildren(this);
    }

    public void visitIfZeroStmt(IfZeroStmt stmt) {
        if (stmt.expr == this.from) {
            stmt.expr = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else {
            stmt.visitChildren(this);
        }
    }

    public void visitIfCmpStmt(IfCmpStmt stmt) {
        if (stmt.left == this.from) {
            stmt.left = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else if (stmt.right == this.from) {
            stmt.right = (Expr)this.to;
            ((Expr)this.to).setParent(stmt);
        } else {
            stmt.visitChildren(this);
        }
    }

    public void visitReturnAddressExpr(ReturnAddressExpr expr) {
        expr.visitChildren(this);
    }

    public void visitShiftExpr(ShiftExpr expr) {
        if (expr.expr == this.from) {
            expr.expr = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else if (expr.bits == this.from) {
            expr.bits = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitZeroCheckExpr(ZeroCheckExpr expr) {
        if (expr.expr == this.from) {
            expr.expr = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitRCExpr(RCExpr expr) {
        if (expr.expr == this.from) {
            expr.expr = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitUCExpr(UCExpr expr) {
        if (expr.expr == this.from) {
            expr.expr = (Expr)this.to;
            ((Expr)this.to).setParent(expr);
        } else {
            expr.visitChildren(this);
        }
    }

    public void visitStackExpr(StackExpr expr) {
        expr.visitChildren(this);
    }

    public void visitStaticFieldExpr(StaticFieldExpr expr) {
        expr.visitChildren(this);
    }
}

