/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.cfg.Handler;
import EDU.purdue.cs.bloat.tree.AddressStoreStmt;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayLengthExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallMethodExpr;
import EDU.purdue.cs.bloat.tree.CallStaticExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.CatchExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.GotoStmt;
import EDU.purdue.cs.bloat.tree.IfCmpStmt;
import EDU.purdue.cs.bloat.tree.IfZeroStmt;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.InstanceOfExpr;
import EDU.purdue.cs.bloat.tree.JsrStmt;
import EDU.purdue.cs.bloat.tree.LabelStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MonitorStmt;
import EDU.purdue.cs.bloat.tree.NegExpr;
import EDU.purdue.cs.bloat.tree.NewArrayExpr;
import EDU.purdue.cs.bloat.tree.NewExpr;
import EDU.purdue.cs.bloat.tree.NewMultiArrayExpr;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.RCExpr;
import EDU.purdue.cs.bloat.tree.RetStmt;
import EDU.purdue.cs.bloat.tree.ReturnAddressExpr;
import EDU.purdue.cs.bloat.tree.ReturnExprStmt;
import EDU.purdue.cs.bloat.tree.ReturnStmt;
import EDU.purdue.cs.bloat.tree.SCStmt;
import EDU.purdue.cs.bloat.tree.SRStmt;
import EDU.purdue.cs.bloat.tree.ShiftExpr;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StackManipStmt;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.SwitchStmt;
import EDU.purdue.cs.bloat.tree.ThrowStmt;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.UCExpr;
import EDU.purdue.cs.bloat.tree.ZeroCheckExpr;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public class PrintVisitor
extends TreeVisitor {
    protected PrintWriter out;

    public PrintVisitor() {
        this(System.out);
    }

    public PrintVisitor(Writer out) {
        this.out = new PrintWriter(out);
    }

    public PrintVisitor(PrintStream out) {
        this.out = new PrintWriter(out);
    }

    protected void println() {
        this.out.println();
    }

    protected void println(Object s) {
        this.out.println(s);
    }

    protected void print(Object s) {
        this.out.print(s);
    }

    public void visitFlowGraph(FlowGraph cfg) {
        cfg.source().visit(this);
        Iterator e = cfg.trace().iterator();
        while (e.hasNext()) {
            Block block = (Block)e.next();
            block.visit(this);
        }
        cfg.sink().visit(this);
        this.out.flush();
    }

    public void visitBlock(Block block) {
        this.println();
        this.println(block);
        Handler handler = (Handler)block.graph().handlersMap().get(block);
        if (handler != null) {
            this.println("catches " + handler.catchType());
            this.println("protects " + handler.protectedBlocks());
        }
        block.visitChildren(this);
    }

    public void visitExprStmt(ExprStmt stmt) {
        this.print("eval ");
        stmt.expr().visit(this);
        this.println();
    }

    public void visitIfZeroStmt(IfZeroStmt stmt) {
        this.print("if0 (");
        stmt.expr().visit(this);
        this.print(" ");
        switch (stmt.comparison()) {
            case 0: {
                this.print("==");
                break;
            }
            case 1: {
                this.print("!=");
                break;
            }
            case 2: {
                this.print(">");
                break;
            }
            case 3: {
                this.print(">=");
                break;
            }
            case 4: {
                this.print("<");
                break;
            }
            case 5: {
                this.print("<=");
            }
        }
        if (stmt.expr().type().isReference()) {
            this.print(" null");
        } else {
            this.print(" 0");
        }
        this.print(") then " + stmt.trueTarget() + " else " + stmt.falseTarget());
        this.println(" caught by " + stmt.catchTargets());
    }

    public void visitIfCmpStmt(IfCmpStmt stmt) {
        this.print("if (");
        stmt.left().visit(this);
        this.print(" ");
        switch (stmt.comparison()) {
            case 0: {
                this.print("==");
                break;
            }
            case 1: {
                this.print("!=");
                break;
            }
            case 2: {
                this.print(">");
                break;
            }
            case 3: {
                this.print(">=");
                break;
            }
            case 4: {
                this.print("<");
                break;
            }
            case 5: {
                this.print("<=");
            }
        }
        this.print(" ");
        if (stmt.right() != null) {
            stmt.right().visit(this);
        }
        this.print(") then " + stmt.trueTarget() + " else " + stmt.falseTarget());
        this.println(" caught by " + stmt.catchTargets());
    }

    public void visitInitStmt(InitStmt stmt) {
        this.print("INIT");
        LocalExpr[] t = stmt.targets();
        if (t != null) {
            for (int i = 0; i < t.length; ++i) {
                if (t[i] == null) continue;
                this.print(" ");
                t[i].visit(this);
            }
        }
        this.println();
    }

    public void visitGotoStmt(GotoStmt stmt) {
        this.print("goto " + stmt.target().label());
        this.println(" caught by " + stmt.catchTargets());
    }

    public void visitLabelStmt(LabelStmt stmt) {
        if (stmt.label() != null) {
            this.println(stmt.label());
        }
    }

    public void visitMonitorStmt(MonitorStmt stmt) {
        if (stmt.kind() == 0) {
            this.print("enter ");
        } else {
            this.print("exit ");
        }
        this.print("monitor (");
        if (stmt.object() != null) {
            stmt.object().visit(this);
        }
        this.println(")");
    }

    public void visitCatchExpr(CatchExpr expr) {
        this.print("Catch(" + expr.catchType() + ")");
    }

    public void visitStackManipStmt(StackManipStmt stmt) {
        this.print("(");
        StackExpr[] target = stmt.target();
        if (target != null) {
            for (int i = 0; i < target.length; ++i) {
                target[i].visit(this);
                if (i == target.length - 1) continue;
                this.print(", ");
            }
        }
        String[] str = new String[]{"swap", "dup", "dup_x1", "dup_x2", "dup2", "dup2_x1", "dup2_x2"};
        this.print(") := " + str[stmt.kind()] + "(");
        StackExpr[] source = stmt.source();
        if (source != null) {
            for (int i = 0; i < source.length; ++i) {
                source[i].visit(this);
                if (i == source.length - 1) continue;
                this.print(", ");
            }
        }
        this.println(")");
    }

    public void visitPhiJoinStmt(PhiJoinStmt stmt) {
        if (stmt.target() != null) {
            stmt.target().visit(this);
        }
        this.print(" := Phi(");
        if (stmt.hasParent()) {
            Tree tree = (Tree)stmt.parent();
            Block block = tree.block();
            Iterator e = block.graph().preds(block).iterator();
            while (e.hasNext()) {
                Block pred = (Block)e.next();
                Expr operand = stmt.operandAt(pred);
                this.print(pred.label() + "=");
                operand.visit(this);
                if (!e.hasNext()) continue;
                this.print(", ");
            }
        } else {
            Iterator e = stmt.operands().iterator();
            while (e.hasNext()) {
                Expr operand = (Expr)e.next();
                operand.visit(this);
                if (!e.hasNext()) continue;
                this.print(", ");
            }
        }
        this.println(")");
    }

    public void visitPhiCatchStmt(PhiCatchStmt stmt) {
        if (stmt.target() != null) {
            stmt.target().visit(this);
        }
        this.print(" := Phi-Catch(");
        Iterator e = stmt.operands().iterator();
        while (e.hasNext()) {
            Expr operand = (Expr)e.next();
            operand.visit(this);
            if (!e.hasNext()) continue;
            this.print(", ");
        }
        this.println(")");
    }

    public void visitRetStmt(RetStmt stmt) {
        this.print("ret from " + stmt.sub());
        this.println(" caught by " + stmt.catchTargets());
    }

    public void visitReturnExprStmt(ReturnExprStmt stmt) {
        this.print("return ");
        if (stmt.expr() != null) {
            stmt.expr().visit(this);
        }
        this.println(" caught by " + stmt.catchTargets());
    }

    public void visitReturnStmt(ReturnStmt stmt) {
        this.print("return");
        this.println(" caught by " + stmt.catchTargets());
    }

    public void visitStoreExpr(StoreExpr expr) {
        this.print("(");
        if (expr.target() != null) {
            expr.target().visit(this);
        }
        this.print(" := ");
        if (expr.expr() != null) {
            expr.expr().visit(this);
        }
        this.print(")");
    }

    public void visitAddressStoreStmt(AddressStoreStmt stmt) {
        this.print("La");
        if (stmt.sub() != null) {
            this.print(new Integer(stmt.sub().returnAddress().index()));
        } else {
            this.print("???");
        }
        this.println(" := returnAddress");
    }

    public void visitJsrStmt(JsrStmt stmt) {
        this.print("jsr ");
        if (stmt.sub() != null) {
            this.print(stmt.sub().entry());
        }
        if (stmt.follow() != null) {
            this.print(" ret to " + stmt.follow());
        }
        this.println(" caught by " + stmt.catchTargets());
    }

    public void visitSwitchStmt(SwitchStmt stmt) {
        this.print("switch (");
        if (stmt.index() != null) {
            stmt.index().visit(this);
        }
        this.print(")");
        this.println(" caught by " + stmt.catchTargets());
        if (stmt.values() != null && stmt.targets() != null) {
            for (int i = 0; i < stmt.values().length; ++i) {
                this.println("    case " + stmt.values()[i] + ": " + stmt.targets()[i]);
            }
        }
        Block t = stmt.defaultTarget();
        this.println("    default: " + stmt.defaultTarget());
    }

    public void visitThrowStmt(ThrowStmt stmt) {
        this.print("throw ");
        if (stmt.expr() != null) {
            stmt.expr().visit(this);
        }
        this.println(" caught by " + stmt.catchTargets());
    }

    public void visitSCStmt(SCStmt stmt) {
        this.print("aswizzle ");
        if (stmt.array() != null) {
            stmt.array().visit(this);
        }
        if (stmt.index() != null) {
            stmt.index().visit(this);
        }
    }

    public void visitSRStmt(SRStmt stmt) {
        this.print("aswrange array: ");
        if (stmt.array() != null) {
            stmt.array().visit(this);
        }
        this.print(" start: ");
        if (stmt.start() != null) {
            stmt.start().visit(this);
        }
        this.print(" end: ");
        if (stmt.end() != null) {
            stmt.end().visit(this);
        }
        this.println("");
    }

    public void visitArithExpr(ArithExpr expr) {
        this.print("(");
        if (expr.left() != null) {
            expr.left().visit(this);
        }
        this.print(" ");
        switch (expr.operation()) {
            case 43: {
                this.print("+");
                break;
            }
            case 45: {
                this.print("-");
                break;
            }
            case 47: {
                this.print("/");
                break;
            }
            case 42: {
                this.print("*");
                break;
            }
            case 37: {
                this.print("%");
                break;
            }
            case 38: {
                this.print("&");
                break;
            }
            case 124: {
                this.print("|");
                break;
            }
            case 94: {
                this.print("^");
                break;
            }
            case 63: {
                this.print("<=>");
                break;
            }
            case 60: {
                this.print("<l=>");
                break;
            }
            case 62: {
                this.print("<g=>");
            }
        }
        this.print(" ");
        if (expr.right() != null) {
            expr.right().visit(this);
        }
        this.print(")");
    }

    public void visitArrayLengthExpr(ArrayLengthExpr expr) {
        if (expr.array() != null) {
            expr.array().visit(this);
        }
        this.print(".length");
    }

    public void visitArrayRefExpr(ArrayRefExpr expr) {
        if (expr.array() != null) {
            expr.array().visit(this);
        }
        this.print("[");
        if (expr.index() != null) {
            expr.index().visit(this);
        }
        this.print("]");
    }

    public void visitCallMethodExpr(CallMethodExpr expr) {
        if (expr.receiver() != null) {
            expr.receiver().visit(this);
        }
        this.print(".");
        if (expr.method() != null) {
            this.print(expr.method().nameAndType().name());
        }
        this.print("(");
        if (expr.params() != null) {
            for (int i = 0; i < expr.params().length; ++i) {
                expr.params()[i].visit(this);
                if (i == expr.params().length - 1) continue;
                this.print(", ");
            }
        }
        this.print(")");
    }

    public void visitCallStaticExpr(CallStaticExpr expr) {
        if (expr.method() != null) {
            this.print(expr.method().declaringClass());
        }
        this.print(".");
        if (expr.method() != null) {
            this.print(expr.method().nameAndType().name());
        }
        this.print("(");
        if (expr.params() != null) {
            for (int i = 0; i < expr.params().length; ++i) {
                expr.params()[i].visit(this);
                if (i == expr.params().length - 1) continue;
                this.print(", ");
            }
        }
        this.print(")");
    }

    public void visitCastExpr(CastExpr expr) {
        this.print("((" + expr.castType() + ") ");
        if (expr.expr() != null) {
            expr.expr().visit(this);
        }
        this.print(")");
    }

    public void visitConstantExpr(ConstantExpr expr) {
        if (expr.value() instanceof String) {
            StringBuffer sb = new StringBuffer();
            String s = (String)expr.value();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (Character.isWhitespace(c) || ' ' <= c && c <= '~') {
                    sb.append(c);
                } else {
                    sb.append("\\u");
                    sb.append(Integer.toHexString(c));
                }
                if (sb.length() <= 50) continue;
                sb.append("...");
                break;
            }
            this.print("'" + sb.toString() + "'");
        } else if (expr.value() instanceof Float) {
            this.print(expr.value() + "F");
        } else if (expr.value() instanceof Long) {
            this.print(expr.value() + "L");
        } else {
            this.print(expr.value());
        }
    }

    public void visitFieldExpr(FieldExpr expr) {
        if (expr.object() != null) {
            expr.object().visit(this);
        }
        this.print(".");
        if (expr.field() != null) {
            this.print(expr.field().nameAndType().name());
        }
    }

    public void visitInstanceOfExpr(InstanceOfExpr expr) {
        if (expr.expr() != null) {
            expr.expr().visit(this);
        }
        this.print(" instanceof " + expr.checkType());
    }

    public void visitLocalExpr(LocalExpr expr) {
        if (expr.fromStack()) {
            this.print("T");
        } else {
            this.print("L");
        }
        this.print(expr.type().shortName().toLowerCase());
        this.print(Integer.toString(expr.index()));
        DefExpr def = expr.def();
        if (def == null || def.version() == -1) {
            this.print("_undef");
        } else {
            this.print("_" + def.version());
        }
    }

    public void visitNegExpr(NegExpr expr) {
        this.print("-");
        if (expr.expr() != null) {
            expr.expr().visit(this);
        }
    }

    public void visitNewArrayExpr(NewArrayExpr expr) {
        this.print("new " + expr.elementType() + "[");
        if (expr.size() != null) {
            expr.size().visit(this);
        }
        this.print("]");
    }

    public void visitNewExpr(NewExpr expr) {
        this.print("new " + expr.objectType());
    }

    public void visitNewMultiArrayExpr(NewMultiArrayExpr expr) {
        this.print("new " + expr.elementType());
        if (expr.dimensions() != null) {
            for (int i = 0; i < expr.dimensions().length; ++i) {
                this.print("[" + expr.dimensions()[i] + "]");
            }
        }
    }

    public void visitZeroCheckExpr(ZeroCheckExpr expr) {
        if (expr.expr().type().isReference()) {
            this.print("notNull(");
        } else {
            this.print("notZero(");
        }
        if (expr.expr() != null) {
            expr.expr().visit(this);
        }
        this.print(")");
    }

    public void visitRCExpr(RCExpr expr) {
        this.print("rc(");
        if (expr.expr() != null) {
            expr.expr().visit(this);
        }
        this.print(")");
    }

    public void visitUCExpr(UCExpr expr) {
        if (expr.kind() == 1) {
            this.print("aupdate(");
        } else {
            this.print("supdate(");
        }
        if (expr.expr() != null) {
            expr.expr().visit(this);
        }
        this.print(")");
    }

    public void visitReturnAddressExpr(ReturnAddressExpr expr) {
        this.print("returnAddress");
    }

    public void visitShiftExpr(ShiftExpr expr) {
        this.print("(");
        if (expr.expr() != null) {
            expr.expr().visit(this);
        }
        if (expr.dir() == 0) {
            this.print("<<");
        } else if (expr.dir() == 1) {
            this.print(">>");
        } else if (expr.dir() == 2) {
            this.print(">>>");
        }
        if (expr.bits() != null) {
            expr.bits().visit(this);
        }
        this.print(")");
    }

    public void visitStackExpr(StackExpr expr) {
        this.print("S" + expr.type().shortName().toLowerCase() + expr.index());
        DefExpr def = expr.def();
        if (def == null || def.version() == -1) {
            this.print("_undef");
        } else {
            this.print("_" + def.version());
        }
    }

    public void visitStaticFieldExpr(StaticFieldExpr expr) {
        if (expr.field() != null) {
            this.print(expr.field().declaringClass() + "." + expr.field().nameAndType().name());
        }
    }

    public void visitExpr(Expr expr) {
        this.print("EXPR");
    }

    public void visitStmt(Stmt stmt) {
        this.print("STMT");
    }
}

