/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.PrintVisitor;
import EDU.purdue.cs.bloat.tree.ReplaceVisitor;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.util.Assert;
import java.io.StringWriter;

public abstract class Node {
    protected Node parent = null;
    int key = 0;
    int valueNumber = -1;

    public int valueNumber() {
        return this.valueNumber;
    }

    public void setValueNumber(int valueNumber) {
        this.valueNumber = valueNumber;
    }

    public int key() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public abstract void visitForceChildren(TreeVisitor var1);

    public abstract void visit(TreeVisitor var1);

    public void visitChildren(TreeVisitor visitor) {
        if (!visitor.prune()) {
            this.visitForceChildren(visitor);
        }
    }

    public void visitOnly(TreeVisitor visitor) {
        visitor.setPrune(true);
        this.visit(visitor);
        visitor.setPrune(false);
    }

    public Block block() {
        Node p = this;
        while (p != null) {
            if (p instanceof Tree) {
                return ((Tree)p).block();
            }
            p = p.parent;
        }
        throw new RuntimeException(this + " is not in a block");
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Node parent() {
        Assert.isTrue(this.parent != null, "Null parent for " + this.getClass().toString() + " node " + System.identityHashCode(this));
        return this.parent;
    }

    protected Node copyInto(Node node) {
        node.setValueNumber(this.valueNumber);
        return node;
    }

    public abstract void cleanupOnly();

    public void cleanup() {
        this.visit(new TreeVisitor(){

            public void visitNode(Node node) {
                node.setParent(null);
                node.cleanupOnly();
                node.visitChildren(this);
            }
        });
    }

    public void replaceWith(Node node) {
        this.replaceWith(node, true);
    }

    public void replaceWith(Node node, boolean cleanup) {
        Assert.isTrue(node.parent == null, node + " already has a parent");
        Assert.isTrue(this.parent != null, this + " has no parent");
        Node oldParent = this.parent;
        if (this instanceof Stmt) {
            Assert.isTrue(node instanceof Stmt, "Attempt to replace " + this + " with " + node);
        }
        if (this instanceof Expr) {
            Assert.isTrue(node instanceof Expr, "Attempt to replace " + this + " with " + node);
            Expr expr1 = (Expr)this;
            Expr expr2 = (Expr)node;
            Assert.isTrue(expr1.type().simple().equals(expr2.type().simple()), "Type mismatch when replacing " + expr1 + " with " + expr2 + ": " + expr1.type() + " != " + expr2.type());
        }
        this.parent.visit(new ReplaceVisitor(this, node));
        Assert.isTrue(node.parent == oldParent, node + " parent == " + node.parent + " != " + oldParent);
        if (cleanup) {
            this.cleanup();
        }
    }

    public String toString() {
        StringWriter w = new StringWriter();
        this.visit(new PrintVisitor(w){

            protected void println(Object s) {
                this.print(s);
            }

            protected void println() {
            }
        });
        w.flush();
        return w.toString();
    }
}

