/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;

public class NewMultiArrayExpr
extends Expr {
    Expr[] dimensions;
    Type elementType;

    public NewMultiArrayExpr(Expr[] dimensions, Type elementType, Type type) {
        super(type);
        this.elementType = elementType;
        this.dimensions = dimensions;
        for (int i = 0; i < dimensions.length; ++i) {
            dimensions[i].setParent(this);
        }
    }

    public Expr[] dimensions() {
        return this.dimensions;
    }

    public Type elementType() {
        return this.elementType;
    }

    public void visitForceChildren(TreeVisitor visitor) {
        if (visitor.reverse()) {
            for (int i = this.dimensions.length - 1; i >= 0; --i) {
                this.dimensions[i].visit(visitor);
            }
        } else {
            for (int i = 0; i < this.dimensions.length; ++i) {
                this.dimensions[i].visit(visitor);
            }
        }
    }

    public void visit(TreeVisitor visitor) {
        visitor.visitNewMultiArrayExpr(this);
    }

    public int exprHashCode() {
        int v = 17;
        for (int i = 0; i < this.dimensions.length; ++i) {
            v ^= this.dimensions[i].hashCode();
        }
        return v;
    }

    public boolean equalsExpr(Expr other) {
        return false;
    }

    public Object clone() {
        Expr[] d = new Expr[this.dimensions.length];
        for (int i = 0; i < this.dimensions.length; ++i) {
            d[i] = (Expr)this.dimensions[i].clone();
        }
        return this.copyInto(new NewMultiArrayExpr(d, this.elementType, this.type));
    }
}

