/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.util.Assert;

public abstract class Expr
extends Node
implements Cloneable {
    protected Type type;
    private DefExpr def = null;
    private Object comparator = new ExprComparator(this);

    public Expr(Type type) {
        this.type = type;
    }

    public boolean setType(Type type) {
        if (!this.type.equals(type)) {
            this.type = type;
            return true;
        }
        return false;
    }

    public boolean isDef() {
        return false;
    }

    public Stmt stmt() {
        Node p = this.parent;
        while (!(p instanceof Stmt)) {
            Assert.isTrue(!(p instanceof Tree), "Invalid ancestor of " + this);
            Assert.isTrue(p != null, "Null ancestor of " + this);
            p = p.parent;
        }
        return (Stmt)p;
    }

    public Type type() {
        return this.type;
    }

    public void cleanupOnly() {
        this.setDef(null);
    }

    public void setDef(DefExpr def) {
        if (this.def == def) {
            return;
        }
        if (this.def != null) {
            this.def.removeUse(this);
        }
        if (this.isDef()) {
            Assert.isTrue(def == this || def == null);
            this.def = null;
            return;
        }
        this.def = def;
        if (this.def != null) {
            this.def.addUse(this);
        }
    }

    public DefExpr def() {
        return this.def;
    }

    public abstract int exprHashCode();

    public abstract boolean equalsExpr(Expr var1);

    public abstract Object clone();

    protected Expr copyInto(Expr expr) {
        expr = (Expr)super.copyInto(expr);
        DefExpr def = this.def();
        if (this.isDef()) {
            expr.setDef(null);
        } else {
            expr.setDef(def);
        }
        return expr;
    }

    public Object comparator() {
        return this.comparator;
    }

    private class ExprComparator {
        Expr expr;
        private final /* synthetic */ Expr this$0;

        private ExprComparator(Expr this$0) {
            this.expr = this.this$0 = this$0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExprComparator) {
                Expr other = ((ExprComparator)obj).expr;
                return this.expr.equalsExpr(other) && this.expr.type.simple().equals(other.type.simple());
            }
            return false;
        }

        public int hashCode() {
            return this.this$0.exprHashCode();
        }
    }
}

