/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.tree.AddressStoreStmt;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayLengthExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallExpr;
import EDU.purdue.cs.bloat.tree.CallMethodExpr;
import EDU.purdue.cs.bloat.tree.CallStaticExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.CatchExpr;
import EDU.purdue.cs.bloat.tree.CheckExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.GotoStmt;
import EDU.purdue.cs.bloat.tree.IfCmpStmt;
import EDU.purdue.cs.bloat.tree.IfZeroStmt;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.InstanceOfExpr;
import EDU.purdue.cs.bloat.tree.JsrStmt;
import EDU.purdue.cs.bloat.tree.LabelStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemExpr;
import EDU.purdue.cs.bloat.tree.MemRefExpr;
import EDU.purdue.cs.bloat.tree.MonitorStmt;
import EDU.purdue.cs.bloat.tree.NegExpr;
import EDU.purdue.cs.bloat.tree.NewArrayExpr;
import EDU.purdue.cs.bloat.tree.NewExpr;
import EDU.purdue.cs.bloat.tree.NewMultiArrayExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.RCExpr;
import EDU.purdue.cs.bloat.tree.RetStmt;
import EDU.purdue.cs.bloat.tree.ReturnAddressExpr;
import EDU.purdue.cs.bloat.tree.ReturnExprStmt;
import EDU.purdue.cs.bloat.tree.ReturnStmt;
import EDU.purdue.cs.bloat.tree.SCStmt;
import EDU.purdue.cs.bloat.tree.SRStmt;
import EDU.purdue.cs.bloat.tree.ShiftExpr;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StackManipStmt;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.SwitchStmt;
import EDU.purdue.cs.bloat.tree.ThrowStmt;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.UCExpr;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.tree.ZeroCheckExpr;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;

public abstract class AscendVisitor
extends TreeVisitor {
    Hashtable defInfoMap;
    Hashtable useInfoMap;
    LocalExpr start;
    Node previous;
    Vector visited;

    public AscendVisitor(Hashtable defInfoMap, Hashtable useInfoMap) {
        this.defInfoMap = defInfoMap;
        this.useInfoMap = useInfoMap;
        this.visited = new Vector();
    }

    public abstract void check(Node var1);

    public void visitTree(Tree tree) {
        ListIterator iter = tree.stmts().listIterator(tree.stmts().lastIndexOf(this.previous));
        if (iter.hasPrevious()) {
            Stmt p = (Stmt)iter.previous();
            this.check(p);
        }
    }

    public void visitExprStmt(ExprStmt stmt) {
        this.previous = stmt;
        stmt.parent().visit(this);
    }

    public void visitIfCmpStmt(IfCmpStmt stmt) {
        if (stmt.right() == this.previous) {
            this.check(stmt.left());
        } else if (stmt.left() == this.previous) {
            this.previous = stmt;
            stmt.parent().visit(this);
        }
    }

    public void visitIfZeroStmt(IfZeroStmt stmt) {
        this.previous = stmt;
        stmt.parent.visit(this);
    }

    public void visitInitStmt(InitStmt stmt) {
        LocalExpr[] targets = stmt.targets();
        for (int i = 0; i < targets.length; ++i) {
            if (targets[i] != this.previous) continue;
            if (i <= 0) break;
            this.check(targets[i - 1]);
        }
    }

    public void visitGotoStmt(GotoStmt stmt) {
    }

    public void visitLabelStmt(LabelStmt stmt) {
    }

    public void visitMonitorStmt(MonitorStmt stmt) {
        this.previous = stmt;
        stmt.parent().visit(this);
    }

    public void visitPhiStmt(PhiStmt stmt) {
        if (stmt instanceof PhiCatchStmt) {
            this.visitPhiCatchStmt((PhiCatchStmt)stmt);
        } else if (stmt instanceof PhiJoinStmt) {
            this.visitPhiJoinStmt((PhiJoinStmt)stmt);
        }
    }

    public void visitCatchExpr(CatchExpr expr) {
    }

    public void visitDefExpr(DefExpr expr) {
        if (expr instanceof MemExpr) {
            this.visitMemExpr((MemExpr)expr);
        }
    }

    public void visitStackManipStmt(StackManipStmt stmt) {
    }

    public void visitPhiCatchStmt(PhiCatchStmt stmt) {
    }

    public void visitPhiJoinStmt(PhiJoinStmt stmt) {
    }

    public void visitRetStmt(RetStmt stmt) {
    }

    public void visitReturnExprStmt(ReturnExprStmt stmt) {
        this.previous = stmt;
        stmt.parent.visit(this);
    }

    public void visitReturnStmt(ReturnStmt stmt) {
    }

    public void visitAddressStoreStmt(AddressStoreStmt stmt) {
    }

    public void visitStoreExpr(StoreExpr expr) {
        if (expr.target() instanceof LocalExpr || expr.target() instanceof StaticFieldExpr) {
            if (this.previous == expr.expr()) {
                this.previous = expr;
                expr.parent.visit(this);
            }
        } else if (expr.target() instanceof ArrayRefExpr) {
            if (this.previous == expr.expr()) {
                this.check(((ArrayRefExpr)expr.target()).index());
            } else if (this.previous == expr.target()) {
                this.previous = expr;
                expr.parent.visit(this);
            }
        } else if (expr.target() instanceof FieldExpr) {
            if (this.previous == expr.expr()) {
                this.check(expr.target());
            } else if (this.previous == expr.target()) {
                this.previous = expr;
                expr.parent.visit(this);
            }
        }
    }

    public void visitJsrStmt(JsrStmt stmt) {
    }

    public void visitSwitchStmt(SwitchStmt stmt) {
        if (this.previous == stmt.index()) {
            this.previous = stmt;
            stmt.parent.visit(this);
        }
    }

    public void visitThrowStmt(ThrowStmt stmt) {
    }

    public void visitStmt(Stmt stmt) {
    }

    public void visitSCStmt(SCStmt stmt) {
    }

    public void visitSRStmt(SRStmt stmt) {
    }

    public void visitArithExpr(ArithExpr expr) {
        if (this.previous == expr.left()) {
            this.previous = expr;
            expr.parent.visit(this);
        } else if (this.previous == expr.right()) {
            this.check(expr.left());
        }
    }

    public void visitArrayLengthExpr(ArrayLengthExpr expr) {
    }

    public void visitMemExpr(MemExpr expr) {
        if (expr instanceof MemRefExpr) {
            this.visitMemRefExpr((MemRefExpr)expr);
        } else if (expr instanceof VarExpr) {
            this.visitVarExpr((VarExpr)expr);
        }
    }

    public void visitMemRefExpr(MemRefExpr expr) {
        if (expr instanceof FieldExpr) {
            this.visitFieldExpr((FieldExpr)expr);
        } else if (expr instanceof StaticFieldExpr) {
            this.visitStaticFieldExpr((StaticFieldExpr)expr);
        } else if (expr instanceof ArrayRefExpr) {
            this.visitArrayRefExpr((ArrayRefExpr)expr);
        }
    }

    public void visitArrayRefExpr(ArrayRefExpr expr) {
        if (this.previous == expr.array()) {
            this.previous = expr;
            expr.parent().visit(this);
        } else if (this.previous == expr.index()) {
            this.check(expr.array());
        }
    }

    public void visitCallExpr(CallExpr expr) {
        if (expr instanceof CallMethodExpr) {
            this.visitCallMethodExpr((CallMethodExpr)expr);
        }
        if (expr instanceof CallStaticExpr) {
            this.visitCallStaticExpr((CallStaticExpr)expr);
        }
    }

    public void visitCallMethodExpr(CallMethodExpr expr) {
        if (this.previous == expr.receiver()) {
            this.previous = expr;
            expr.parent.visit(this);
        } else {
            Expr[] params = expr.params();
            for (int i = 0; i < params.length; ++i) {
                if (params[i] != this.previous) continue;
                if (i > 0) {
                    this.check(params[i - 1]);
                    continue;
                }
                this.check(expr.receiver());
            }
        }
    }

    public void visitCallStaticExpr(CallStaticExpr expr) {
        Expr[] params = expr.params();
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != this.previous) continue;
            if (i > 0) {
                this.check(params[i - 1]);
                break;
            }
            this.previous = expr;
            expr.parent().visit(this);
            break;
        }
    }

    public void visitCastExpr(CastExpr expr) {
        this.previous = expr;
        expr.parent.visit(this);
    }

    public void visitConstantExpr(ConstantExpr expr) {
    }

    public void visitFieldExpr(FieldExpr expr) {
        if (this.previous == expr.object()) {
            this.previous = expr;
            expr.parent.visit(this);
        }
    }

    public void visitInstanceOfExpr(InstanceOfExpr expr) {
        if (this.previous == expr.expr()) {
            this.previous = expr;
            expr.parent.visit(this);
        }
    }

    public void visitLocalExpr(LocalExpr expr) {
    }

    public void visitNegExpr(NegExpr expr) {
        if (this.previous == expr.expr()) {
            this.previous = expr;
            expr.parent.visit(this);
        }
    }

    public void visitNewArrayExpr(NewArrayExpr expr) {
        if (this.previous == expr.size()) {
            this.previous = expr;
            expr.parent.visit(this);
        }
    }

    public void visitNewExpr(NewExpr expr) {
    }

    public void visitNewMultiArrayExpr(NewMultiArrayExpr expr) {
        Expr[] dims = expr.dimensions;
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] != this.previous) continue;
            if (i > 0) {
                this.check(dims[i - 1]);
                continue;
            }
            this.previous = expr;
            expr.parent().visit(this);
        }
    }

    public void visitCheckExpr(CheckExpr expr) {
        if (expr instanceof ZeroCheckExpr) {
            this.visitZeroCheckExpr((ZeroCheckExpr)expr);
        } else if (expr instanceof RCExpr) {
            this.visitRCExpr((RCExpr)expr);
        } else if (expr instanceof UCExpr) {
            this.visitUCExpr((UCExpr)expr);
        }
    }

    public void visitZeroCheckExpr(ZeroCheckExpr expr) {
    }

    public void visitRCExpr(RCExpr expr) {
    }

    public void visitUCExpr(UCExpr expr) {
    }

    public void visitReturnAddressExpr(ReturnAddressExpr expr) {
    }

    public void visitShiftExpr(ShiftExpr expr) {
        if (this.previous == expr.expr()) {
            this.previous = expr;
            expr.parent().visit(this);
        } else if (this.previous == expr.bits()) {
            this.check(expr.expr());
        }
    }

    public void visitStackExpr(StackExpr expr) {
    }

    public void visitVarExpr(VarExpr expr) {
        if (expr instanceof LocalExpr) {
            this.visitLocalExpr((LocalExpr)expr);
        }
        if (expr instanceof StackExpr) {
            this.visitStackExpr((StackExpr)expr);
        }
    }

    public void visitStaticFieldExpr(StaticFieldExpr expr) {
    }

    public void visitExpr(Expr expr) {
    }

    public void visitNode(Node node) {
    }
}

