/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.ssa.ComponentVisitor;
import EDU.purdue.cs.bloat.ssa.SSAGraph;
import EDU.purdue.cs.bloat.trans.SideEffectChecker;
import EDU.purdue.cs.bloat.trans.ValueFolder;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ValueFolding {
    public static boolean DEBUG = false;
    SideEffectChecker sideEffects;
    ValueFolder folder;
    boolean changed;
    public static boolean DUMP = false;
    public static boolean SAVEDUMP = false;
    PrintWriter vn;
    PrintWriter dump;
    int next = 1;

    public void transform(FlowGraph cfg) {
        File dir = new File("ValueFoldingOutdir");
        Object cfgFile = null;
        Object dotFile = null;
        Object vnFile = null;
        Object dumpFile = null;
        if (DUMP) {
            this.vn = new PrintWriter(System.out, true);
            this.dump = new PrintWriter(System.out, true);
        }
        EditorContext context = cfg.method().declaringClass().context();
        this.sideEffects = new SideEffectChecker(context);
        this.folder = new ValueFolder(true, context);
        SSAGraph ssaGraph = new SSAGraph(cfg);
        ssaGraph.visitComponents(new ComponentVisitor(){

            public void visitComponent(List scc) {
                HashMap map = new HashMap(scc.size() * 2 + 1);
                boolean changed = true;
                while (changed) {
                    changed = false;
                    Iterator iter = scc.iterator();
                    int x = 0;
                    while (iter.hasNext()) {
                        Node node = (Node)iter.next();
                        if (DUMP) {
                            ValueFolding.this.dump.println("Folding SCC Node " + node + " (" + ++x + " of " + scc.size() + ")");
                        }
                        if (!ValueFolding.this.fold(map, node)) continue;
                        changed = true;
                    }
                    if (DUMP) {
                        ValueFolding.this.dump.println("");
                    }
                    if (scc.size() != 1) continue;
                    break;
                }
            }
        });
        cfg.removeUnreachable();
        this.folder = null;
        this.sideEffects = null;
        if (!DUMP || !SAVEDUMP) {
            // empty if block
        }
    }

    boolean fold(Map map, Node sccNode) {
        int v;
        Node node = (Node)map.get(sccNode);
        if (DUMP) {
            this.dump.println("  SCC Node " + sccNode + " is mapped to node " + node);
        }
        if (node == null) {
            node = sccNode;
        }
        if (!node.hasParent()) {
            return false;
        }
        if (DEBUG) {
            System.out.println("folding --- " + node + " in " + node.parent());
        }
        if (DUMP) {
            this.dump.println("  Folding " + node + " (" + "VN=" + node.valueNumber() + ") in " + node.parent());
        }
        if ((v = node.valueNumber()) == -1) {
            return false;
        }
        this.folder.values.ensureSize(v + 1);
        ConstantExpr oldValue = (ConstantExpr)this.folder.values.get(v);
        ConstantExpr value = null;
        if (DUMP) {
            this.dump.println("    Node " + node + " is mapped to constant " + oldValue);
        }
        if (node instanceof ConstantExpr) {
            value = (ConstantExpr)node;
            if (oldValue == null || !oldValue.equalsExpr(value)) {
                if (DEBUG) {
                    System.out.println("changed " + oldValue + " to " + value);
                }
                if (DUMP) {
                    this.dump.println("      Changed " + oldValue + " to " + value);
                }
                this.folder.values.set(v, value);
                return true;
            }
            return false;
        }
        if (node instanceof Expr && oldValue != null) {
            if (node.parent() instanceof PhiCatchStmt) {
                return false;
            }
            this.sideEffects.reset();
            node.visit(this.sideEffects);
            if (!this.sideEffects.hasSideEffects()) {
                value = (ConstantExpr)oldValue.clone();
                node.replaceWith(value);
                map.put(sccNode, value);
                return false;
            }
        }
        if (value == null) {
            this.folder.node = null;
            node.visit(this.folder);
            if (DEBUG) {
                System.out.println("folded " + node + " to " + this.folder.node);
            }
            if (DUMP) {
                this.dump.println("    Using ValueFolder to determine new value");
                this.dump.println("      Folded " + node + " to " + this.folder.node);
            }
            if (this.folder.node != null) {
                map.put(sccNode, this.folder.node);
            }
            if (this.folder.node instanceof ConstantExpr) {
                value = (ConstantExpr)this.folder.node;
                this.folder.values.set(v, value);
                return true;
            }
        }
        return false;
    }
}

