/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.ssa.SSA;
import EDU.purdue.cs.bloat.ssa.SSAConstructionInfo;
import EDU.purdue.cs.bloat.trans.StackPRE;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.LabelStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemRefExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.PrintVisitor;
import EDU.purdue.cs.bloat.tree.ReplaceVisitor;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StackManipStmt;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.GraphNode;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class StackPRE {
    public static boolean DEBUG = false;
    protected FlowGraph cfg;
    protected List[] varphis;
    protected List[] stackvars;
    protected Worklist worklist;
    int next = 0;

    public StackPRE(FlowGraph cfg) {
        this.cfg = cfg;
    }

    public void transform() {
        int i;
        this.stackvars = new ArrayList[this.cfg.size()];
        for (i = 0; i < this.stackvars.length; ++i) {
            this.stackvars[i] = new ArrayList();
        }
        this.varphis = new ArrayList[this.cfg.size()];
        for (i = 0; i < this.varphis.length; ++i) {
            this.varphis[i] = new ArrayList();
        }
        this.worklist = new Worklist();
        this.cfg.visit(new TreeVisitor(){

            public void visitPhiJoinStmt(PhiJoinStmt stmt) {
                StackPRE.this.worklist.addVarPhi(stmt);
            }

            public void visitPhiCatchStmt(PhiCatchStmt stmt) {
                StackPRE.this.worklist.addLocalVar((LocalExpr)stmt.target());
            }

            public void visitLocalExpr(LocalExpr expr) {
                StackPRE.this.worklist.addLocalVar(expr);
            }

            public void visitStackExpr(StackExpr expr) {
                StackPRE.this.worklist.addStackVar(expr);
            }
        });
        while (!this.worklist.isEmpty()) {
            ExprInfo exprInfo = this.worklist.removeFirst();
            if (DEBUG) {
                System.out.println("PRE for " + exprInfo.def() + " -------------------------");
                System.out.println("Placing Phis for " + exprInfo.def() + " -------------------------");
            }
            this.placePhiFunctions(exprInfo);
            if (DEBUG) {
                exprInfo.print();
                System.out.println("Renaming for " + exprInfo.def() + " -------------------------");
            }
            this.rename(exprInfo);
            if (DEBUG) {
                exprInfo.print();
                System.out.println("Down safety for " + exprInfo.def() + " -------------------------");
            }
            this.downSafety(exprInfo);
            if (DEBUG) {
                System.out.println("Will be available for " + exprInfo.def() + " -------------------------");
            }
            this.willBeAvail(exprInfo);
            if (DEBUG) {
                System.out.println("Finalize for " + exprInfo.def() + " -------------------------");
            }
            this.finalize(exprInfo);
            if (DEBUG) {
                System.out.println("Code motion for " + exprInfo.def() + " -------------------------");
            }
            Type type = exprInfo.def().type();
            StackExpr tmp = new StackExpr(0, type);
            SSAConstructionInfo consInfo = new SSAConstructionInfo(this.cfg, tmp);
            this.codeMotion(exprInfo, tmp, consInfo);
            if (DEBUG) {
                System.out.println("Performing incremental SSA for " + exprInfo.def() + " -------------------------");
            }
            SSA.transform(this.cfg, consInfo);
            Collection defBlocks = consInfo.defBlocks();
            Iterator e = this.cfg.iteratedDomFrontier(defBlocks).iterator();
            block3: while (e.hasNext()) {
                Block block = (Block)e.next();
                Iterator stmts = block.tree().stmts().iterator();
                while (stmts.hasNext()) {
                    Stmt stmt = (Stmt)stmts.next();
                    if (stmt instanceof PhiJoinStmt) {
                        this.worklist.prependVarPhi((PhiJoinStmt)stmt);
                        continue;
                    }
                    if (stmt instanceof LabelStmt) continue;
                    continue block3;
                }
            }
            if (DEBUG) {
                exprInfo.print();
                System.out.println("Done with PRE for " + exprInfo.def() + " -------------------------");
            }
            exprInfo.cleanup();
        }
        this.varphis = null;
        this.worklist = null;
    }

    private void placePhiFunctions(ExprInfo exprInfo) {
        ArrayList<Block> w = new ArrayList<Block>(this.cfg.size());
        Iterator uses = exprInfo.def().uses().iterator();
        w.add(exprInfo.def().block());
        block0: while (uses.hasNext()) {
            LocalExpr use = (LocalExpr)uses.next();
            if (use.parent() instanceof PhiJoinStmt) {
                PhiJoinStmt phi = (PhiJoinStmt)use.parent();
                Iterator preds = this.cfg.preds(use.block()).iterator();
                while (preds.hasNext()) {
                    Block pred = (Block)preds.next();
                    if (phi.operandAt(pred) != use) continue;
                    w.add(pred);
                    continue block0;
                }
                continue;
            }
            if (use.parent() instanceof PhiCatchStmt) continue;
            w.add(use.block());
        }
        Iterator df = this.cfg.iteratedDomFrontier(w).iterator();
        while (df.hasNext()) {
            Block block = (Block)df.next();
            exprInfo.addPhi(block);
        }
    }

    private void rename(ExprInfo exprInfo) {
        this.search(this.cfg.source(), exprInfo, null, 0, false);
    }

    private void search(Block block, ExprInfo exprInfo, Def top, int totalBalance, boolean seenDef) {
        Block succ;
        Phi phi;
        if (DEBUG) {
            System.out.println("    renaming in " + block);
        }
        if (this.cfg.catchBlocks().contains(block)) {
            if (top != null) {
                top.setDownSafe(false);
            }
            top = null;
        }
        if ((phi = exprInfo.exprPhiAtBlock(block)) != null) {
            if (top != null) {
                top.setDownSafe(false);
            }
            top = phi;
            if (!seenDef) {
                top.setDownSafe(false);
            }
        }
        Node parent = null;
        int balance = 0;
        Iterator iter = exprInfo.varsAtBlock(block).iterator();
        while (iter.hasNext()) {
            VarExpr node = (VarExpr)iter.next();
            Node p = node.parent();
            if (p instanceof MemRefExpr && ((MemRefExpr)p).isDef()) {
                p = p.parent();
            }
            if (parent != p) {
                parent = p;
                balance = 0;
                if (top != null && (totalBalance += balance) < 0) {
                    top.setDownSafe(false);
                }
            }
            if (node instanceof StackExpr) {
                if (parent instanceof StackManipStmt) {
                    switch (((StackManipStmt)parent).kind()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            ++balance;
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            balance += 2;
                            break;
                        }
                    }
                } else {
                    balance = node.isDef() ? (balance += node.type().stackHeight()) : (balance -= node.type().stackHeight());
                }
            } else {
                LocalExpr var = (LocalExpr)node;
                if (var.isDef()) {
                    seenDef = true;
                }
                if (DEBUG) {
                    System.out.println("node = " + var + " in " + parent);
                }
                if (totalBalance == 0 && this.onBottom(var, false)) {
                    exprInfo.setDef(var, top);
                    top = new RealDef(var);
                    if (balance != 0 || !this.onBottom(var, true)) {
                        top.setDownSafe(false);
                    }
                    if (DEBUG) {
                        System.out.println("New def " + top + " with balance " + totalBalance + " + " + balance);
                    }
                } else {
                    exprInfo.setDef(var, null);
                }
            }
            if (!DEBUG) continue;
            System.out.println("after " + parent + " top = " + top);
        }
        if (top != null && (totalBalance += balance) < 0) {
            top.setDownSafe(false);
        }
        if ((block == this.cfg.sink() || this.cfg.succs(block).contains(this.cfg.sink())) && top != null) {
            top.setDownSafe(false);
        }
        Iterator succs = this.cfg.succs(block).iterator();
        while (succs.hasNext()) {
            succ = (Block)succs.next();
            Phi succPhi = exprInfo.exprPhiAtBlock(succ);
            if (succPhi == null) continue;
            succPhi.setOperandAt(block, top);
        }
        succs = this.cfg.succs(block).iterator();
        while (succs.hasNext()) {
            succ = (Block)succs.next();
            Iterator phis = this.varPhisAtBlock(succ).iterator();
            while (phis.hasNext()) {
                PhiJoinStmt stmt = (PhiJoinStmt)phis.next();
                Expr operand = stmt.operandAt(block);
                if (operand instanceof StackExpr) {
                    balance += operand.type().stackHeight();
                }
                if (stmt.target() instanceof StackExpr) {
                    balance -= stmt.target().type().stackHeight();
                    if (top != null) {
                        top.setDownSafe(false);
                        top = null;
                    }
                }
                if (operand != null && operand.def() == exprInfo.def()) {
                    exprInfo.setDef((LocalExpr)operand, top);
                    top = null;
                }
                if (stmt.target() == exprInfo.def()) {
                    exprInfo.setDef((LocalExpr)stmt.target(), top);
                    top = new RealDef((LocalExpr)stmt.target());
                }
                if (top == null || (totalBalance += balance) >= 0) continue;
                top.setDownSafe(false);
            }
        }
        Iterator children = this.cfg.domChildren(block).iterator();
        while (children.hasNext()) {
            Block child = (Block)children.next();
            this.search(child, exprInfo, top, totalBalance, seenDef);
        }
    }

    private boolean onBottom(final LocalExpr var, final boolean really) {
        if (var.stmt() instanceof InitStmt || var.stmt() instanceof PhiStmt) {
            return true;
        }
        class Bool {
            boolean value = true;

            Bool() {
            }
        }
        final Bool bottom = new Bool();
        var.stmt().visitChildren(new TreeVisitor(){
            boolean seen = false;
            {
            }

            public void visitExpr(Expr expr) {
                if (DEBUG) {
                    System.out.println("Checking " + expr + " seen=" + this.seen + " bottom=" + bottom.value);
                }
                if (!this.seen) {
                    expr.visitChildren(this);
                }
                if (!this.seen) {
                    bottom.value = false;
                    this.seen = true;
                }
                if (DEBUG) {
                    System.out.println("Done with " + expr + " seen=" + this.seen + " bottom=" + bottom.value);
                }
            }

            public void visitLocalExpr(LocalExpr expr) {
                if (DEBUG) {
                    System.out.println("Checking " + expr + " seen=" + this.seen + " bottom=" + bottom.value);
                }
                if (!this.seen) {
                    if (expr == var) {
                        this.seen = true;
                    } else if (expr.def() != var.def()) {
                        bottom.value = false;
                        this.seen = true;
                    }
                }
                if (DEBUG) {
                    System.out.println("Done with " + expr + " seen=" + this.seen + " bottom=" + bottom.value);
                }
            }

            public void visitStackExpr(StackExpr expr) {
                if (DEBUG) {
                    System.out.println("Checking " + expr + " seen=" + this.seen + " bottom=" + bottom.value);
                }
                if (really && !this.seen) {
                    bottom.value = false;
                    this.seen = true;
                }
                if (DEBUG) {
                    System.out.println("Done with " + expr + " seen=" + this.seen + " bottom=" + bottom.value);
                }
            }
        });
        return bottom.value;
    }

    private void downSafety(ExprInfo exprInfo) {
        Iterator blocks = this.cfg.nodes().iterator();
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            Phi phi = exprInfo.exprPhiAtBlock(block);
            if (phi == null) continue;
            if (DEBUG) {
                System.out.println("    down safety for " + phi + " in " + block);
            }
            if (phi.downSafe()) {
                if (!DEBUG) continue;
                System.out.println("    already down safe");
                continue;
            }
            Iterator e = phi.operands().iterator();
            while (e.hasNext()) {
                Def def = (Def)e.next();
                if (def == null) continue;
                this.resetDownSafe(def);
            }
        }
    }

    private void resetDownSafe(Def def) {
        if (DEBUG) {
            System.out.println("        reset down safe for " + def);
        }
        if (def instanceof Phi) {
            Phi phi = (Phi)def;
            if (phi.downSafe()) {
                phi.setDownSafe(false);
                Iterator e = phi.operands().iterator();
                while (e.hasNext()) {
                    Def operand = (Def)e.next();
                    if (operand == null) continue;
                    this.resetDownSafe(operand);
                }
            }
        } else {
            def.setDownSafe(false);
        }
    }

    private void willBeAvail(ExprInfo exprInfo) {
        this.computeCanBeAvail(exprInfo);
        this.computeLater(exprInfo);
    }

    private void computeCanBeAvail(ExprInfo exprInfo) {
        Iterator blocks = this.cfg.nodes().iterator();
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            Phi phi = exprInfo.exprPhiAtBlock(block);
            if (phi == null || phi.downSafe() || !phi.canBeAvail()) continue;
            this.resetCanBeAvail(exprInfo, phi);
        }
    }

    private void resetCanBeAvail(ExprInfo exprInfo, Phi phi) {
        phi.setCanBeAvail(false);
        Iterator blocks = this.cfg.nodes().iterator();
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            Phi other = exprInfo.exprPhiAtBlock(block);
            if (other == null) continue;
            Iterator e = this.cfg.preds(other.block()).iterator();
            while (e.hasNext()) {
                Block pred = (Block)e.next();
                Def def = other.operandAt(pred);
                if (def != phi) continue;
                other.setOperandAt(pred, null);
                if (other.downSafe() || !other.canBeAvail()) continue;
                this.resetCanBeAvail(exprInfo, other);
            }
        }
    }

    private void computeLater(ExprInfo exprInfo) {
        Phi phi;
        Block block;
        Iterator blocks = this.cfg.nodes().iterator();
        while (blocks.hasNext()) {
            block = (Block)blocks.next();
            phi = exprInfo.exprPhiAtBlock(block);
            if (phi == null) continue;
            phi.setLater(phi.canBeAvail());
        }
        blocks = this.cfg.nodes().iterator();
        block1: while (blocks.hasNext()) {
            block = (Block)blocks.next();
            phi = exprInfo.exprPhiAtBlock(block);
            if (phi == null || !phi.later()) continue;
            Iterator e = phi.operands().iterator();
            while (e.hasNext()) {
                Def def = (Def)e.next();
                if (!(def instanceof RealDef)) continue;
                this.resetLater(exprInfo, phi);
                continue block1;
            }
        }
    }

    private void resetLater(ExprInfo exprInfo, Phi phi) {
        phi.setLater(false);
        Iterator blocks = this.cfg.nodes().iterator();
        block0: while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            Phi other = exprInfo.exprPhiAtBlock(block);
            if (other == null) continue;
            Iterator e = other.operands().iterator();
            while (e.hasNext()) {
                Def def = (Def)e.next();
                if (def != phi || !other.later()) continue;
                this.resetLater(exprInfo, other);
                continue block0;
            }
        }
    }

    private void finalize(ExprInfo exprInfo) {
        Iterator uses = exprInfo.def().uses().iterator();
        while (uses.hasNext()) {
            LocalExpr use = (LocalExpr)uses.next();
            if (!(use.parent() instanceof PhiCatchStmt)) continue;
            exprInfo.setSave(true);
            break;
        }
        this.finalizeVisit(exprInfo, this.cfg.source());
    }

    private void finalizeVisit(ExprInfo exprInfo, Block block) {
        Block succ;
        if (DEBUG) {
            System.out.println("    finalizing " + block);
        }
        Iterator reals = exprInfo.varsAtBlock(block).iterator();
        while (reals.hasNext()) {
            Def def;
            VarExpr node = (VarExpr)reals.next();
            if (!(node instanceof LocalExpr)) continue;
            LocalExpr real = (LocalExpr)node;
            if (DEBUG) {
                System.out.println("        -----------");
            }
            if ((def = exprInfo.def(real)) != null && def.downSafe()) {
                if (def instanceof Phi) {
                    if (((Phi)def).willBeAvail()) {
                        exprInfo.setPop(real, true);
                        continue;
                    }
                    exprInfo.setSave(true);
                    continue;
                }
                exprInfo.setPush(((RealDef)def).var, true);
                exprInfo.setPop(real, true);
                continue;
            }
            if (real == exprInfo.def()) continue;
            exprInfo.setSave(true);
        }
        Iterator succs = this.cfg.succs(block).iterator();
        while (succs.hasNext()) {
            succ = (Block)succs.next();
            Phi succPhi = exprInfo.exprPhiAtBlock(succ);
            if (succPhi == null || !succPhi.willBeAvail()) continue;
            if (succPhi.insert(block)) {
                succPhi.setPushOperand(block, true);
                continue;
            }
            Def def = succPhi.operandAt(block);
            if (def instanceof RealDef) {
                Assert.isTrue(def.downSafe(), succPhi + " operand for " + block + " is not DS: " + def);
                exprInfo.setPush(((RealDef)def).var, true);
                continue;
            }
            Assert.isTrue(def instanceof Phi, succPhi + " operand for " + block + " is not a phi: " + def);
            Assert.isTrue(((Phi)def).willBeAvail(), succPhi + " operand for " + block + " is not WBA: " + def);
        }
        succs = this.cfg.succs(block).iterator();
        while (succs.hasNext()) {
            succ = (Block)succs.next();
            Iterator phis = this.varPhisAtBlock(succ).iterator();
            while (phis.hasNext()) {
                LocalExpr var;
                Def def;
                PhiJoinStmt stmt = (PhiJoinStmt)phis.next();
                Expr operand = stmt.operandAt(block);
                if (operand == null || operand.def() != exprInfo.def() || (def = exprInfo.def(var = (LocalExpr)operand)) == null || !def.downSafe()) continue;
                if (def instanceof Phi) {
                    if (((Phi)def).willBeAvail()) {
                        exprInfo.setPop(var, true);
                        continue;
                    }
                    exprInfo.setSave(true);
                    continue;
                }
                exprInfo.setPush(((RealDef)def).var, true);
                exprInfo.setPop(var, true);
            }
        }
        Iterator children = this.cfg.domChildren(block).iterator();
        while (children.hasNext()) {
            Block child = (Block)children.next();
            this.finalizeVisit(exprInfo, child);
        }
    }

    private void codeMotion(ExprInfo exprInfo, StackExpr tmp, SSAConstructionInfo consInfo) {
        Iterator blocks = this.cfg.preOrder().iterator();
        while (blocks.hasNext()) {
            StoreExpr store;
            VarExpr t2;
            StackExpr t1;
            Block block = (Block)blocks.next();
            if (block == this.cfg.source() || block == this.cfg.sink()) continue;
            boolean added = false;
            Iterator reals = exprInfo.varsAtBlock(block).iterator();
            while (reals.hasNext()) {
                VarExpr node = (VarExpr)reals.next();
                if (!(node instanceof LocalExpr)) continue;
                LocalExpr var = (LocalExpr)node;
                boolean push = exprInfo.push(var);
                boolean pop = exprInfo.pop(var);
                if (var.isDef() && exprInfo.save()) {
                    pop = false;
                }
                if (push && pop) {
                    Assert.isTrue(var != exprInfo.def());
                    t1 = (StackExpr)tmp.clone();
                    t2 = (StackExpr)tmp.clone();
                    store = new StoreExpr(t1, t2, t2.type());
                    var.replaceWith(store);
                    consInfo.addReal(t2);
                    consInfo.addReal(t1);
                    added = true;
                    continue;
                }
                if (push) {
                    t1 = (StackExpr)tmp.clone();
                    t2 = (LocalExpr)var.clone();
                    t2.setDef(exprInfo.def());
                    store = new StoreExpr(t1, t2, t2.type());
                    if (var != exprInfo.def()) {
                        var.replaceWith(store);
                    } else {
                        Node parent = var.parent();
                        if (parent instanceof Stmt) {
                            ExprStmt stmt = new ExprStmt(store);
                            block.tree().addStmtAfter(stmt, (Stmt)parent);
                        } else {
                            Assert.isTrue(parent instanceof StoreExpr);
                            Expr rhs = ((StoreExpr)parent).expr();
                            parent.visit(new ReplaceVisitor(rhs, store));
                            store.visit(new ReplaceVisitor(t2, rhs));
                            t2.cleanup();
                        }
                    }
                    consInfo.addReal(t1);
                    added = true;
                    continue;
                }
                if (!pop) continue;
                t1 = (StackExpr)tmp.clone();
                var.replaceWith(t1);
                consInfo.addReal(t1);
                added = true;
            }
            final List s = this.stackvars[this.cfg.preOrderIndex(block)];
            if (added) {
                s.clear();
                block.tree().visitChildren(new TreeVisitor(){

                    public void visitStackExpr(StackExpr expr) {
                        s.add(expr);
                    }
                });
            }
            Iterator succs = this.cfg.succs(block).iterator();
            while (succs.hasNext()) {
                Block succ = (Block)succs.next();
                Phi succPhi = exprInfo.exprPhiAtBlock(succ);
                if (succPhi == null || !succPhi.pushOperand(block)) continue;
                t1 = (StackExpr)tmp.clone();
                t2 = (LocalExpr)exprInfo.def().clone();
                t2.setDef(exprInfo.def());
                store = new StoreExpr(t1, t2, t1.type());
                block.tree().addStmtBeforeJump(new ExprStmt(store));
                s.add(t1);
                consInfo.addReal(t1);
                if (!DEBUG) continue;
                System.out.println("insert at end of " + block + ": " + store);
            }
            succs = this.cfg.succs(block).iterator();
            while (succs.hasNext()) {
                Block succ = (Block)succs.next();
                Iterator phis = this.varPhisAtBlock(succ).iterator();
                while (phis.hasNext()) {
                    PhiJoinStmt stmt = (PhiJoinStmt)phis.next();
                    Expr operand = stmt.operandAt(block);
                    if (operand == null || operand.def() != exprInfo.def()) continue;
                    LocalExpr var = (LocalExpr)operand;
                    Assert.isFalse(exprInfo.push(var));
                    if (!exprInfo.pop(var)) continue;
                    StackExpr t12 = (StackExpr)tmp.clone();
                    var.replaceWith(t12);
                    consInfo.addReal(t12);
                }
            }
        }
    }

    public List varPhisAtBlock(Block block) {
        return this.varphis[this.cfg.preOrderIndex(block)];
    }

    class Worklist {
        Map exprInfos = new HashMap();
        LinkedList exprs = new LinkedList();

        public boolean isEmpty() {
            return this.exprs.isEmpty();
        }

        public ExprInfo removeFirst() {
            ExprInfo exprInfo = (ExprInfo)this.exprs.removeFirst();
            this.exprInfos.remove(exprInfo.def());
            return exprInfo;
        }

        public void addLocalVar(LocalExpr var) {
            ExprInfo exprInfo;
            int blockIndex = StackPRE.this.cfg.preOrderIndex(var.block());
            if (DEBUG) {
                System.out.println("add var " + var);
            }
            if ((exprInfo = (ExprInfo)this.exprInfos.get(var.def())) == null) {
                exprInfo = new ExprInfo((LocalExpr)var.def());
                this.exprs.add(exprInfo);
                this.exprInfos.put(var.def(), exprInfo);
                if (DEBUG) {
                    System.out.println("    add info for " + var);
                }
            }
            exprInfo.vars[blockIndex].add(var);
        }

        public void addStackVar(StackExpr var) {
            int blockIndex = StackPRE.this.cfg.preOrderIndex(var.block());
            if (DEBUG) {
                System.out.println("add var " + var);
            }
            StackPRE.this.stackvars[blockIndex].add(var);
        }

        public void addVarPhi(PhiJoinStmt stmt) {
            StackPRE.this.varphis[StackPRE.this.cfg.preOrderIndex(stmt.block())].add(stmt);
        }

        public void prependVarPhi(PhiJoinStmt stmt) {
            List v = StackPRE.this.varphis[StackPRE.this.cfg.preOrderIndex(stmt.block())];
            if (!v.contains(stmt)) {
                v.add(0, stmt);
            }
        }
    }

    private final class ExprInfo {
        ArrayList[] vars;
        Phi[] phis;
        boolean save;
        Map pushes;
        Map pops;
        Map defs;
        LocalExpr def;
        ArrayList cleanup;

        public ExprInfo(LocalExpr def) {
            this.def = def;
            this.vars = new ArrayList[StackPRE.this.cfg.size()];
            for (int i = 0; i < this.vars.length; ++i) {
                this.vars[i] = new ArrayList();
            }
            this.phis = new Phi[StackPRE.this.cfg.size()];
            this.save = false;
            this.pushes = new HashMap();
            this.pops = new HashMap();
            this.defs = new HashMap();
            this.cleanup = new ArrayList();
        }

        public void cleanup() {
            Iterator iter = this.cleanup.iterator();
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                node.cleanup();
            }
            this.vars = null;
            this.phis = null;
            this.pushes = null;
            this.pops = null;
            this.defs = null;
            this.def = null;
            this.cleanup = null;
        }

        public void registerForCleanup(Node node) {
            this.cleanup.add(node);
        }

        public void setSave(boolean flag) {
            this.save = flag;
        }

        public boolean save() {
            return this.save;
        }

        public void setPush(LocalExpr expr, boolean flag) {
            this.pushes.put(expr, new Boolean(flag));
        }

        public boolean push(LocalExpr expr) {
            Boolean b = (Boolean)this.pushes.get(expr);
            return b != null && b != false;
        }

        public void setPop(LocalExpr expr, boolean flag) {
            this.pops.put(expr, new Boolean(flag));
        }

        public boolean pop(LocalExpr expr) {
            Boolean b = (Boolean)this.pops.get(expr);
            return b != null && b != false;
        }

        public void setDef(LocalExpr expr, Def def) {
            if (DEBUG) {
                System.out.println("        setting def for " + expr + " to " + def);
            }
            if (def != null) {
                this.defs.put(expr, def);
            } else {
                this.defs.remove(expr);
            }
        }

        public Def def(LocalExpr expr) {
            Def def = (Def)this.defs.get(expr);
            if (DEBUG) {
                System.out.println("        def for " + expr + " is " + def);
            }
            return def;
        }

        public LocalExpr def() {
            return this.def;
        }

        public void addPhi(Block block) {
            Phi phi = this.phis[StackPRE.this.cfg.preOrderIndex(block)];
            if (phi == null) {
                if (DEBUG) {
                    System.out.println("    add phi for " + this.def + " at " + block);
                }
                this.phis[StackPRE.this.cfg.preOrderIndex((GraphNode)block)] = phi = new Phi(block);
            }
        }

        public List varsAtBlock(Block block) {
            int blockIndex = StackPRE.this.cfg.preOrderIndex(block);
            ArrayList list = new ArrayList(this.vars[blockIndex].size() + StackPRE.this.stackvars[blockIndex].size());
            Iterator viter = this.vars[blockIndex].iterator();
            Iterator siter = StackPRE.this.stackvars[blockIndex].iterator();
            if (!viter.hasNext() && !siter.hasNext()) {
                return new ArrayList(0);
            }
            block.tree().visitChildren(new TreeVisitor(this, viter, siter, list){
                VarExpr vnext;
                VarExpr snext;
                private final /* synthetic */ Iterator val$viter;
                private final /* synthetic */ Iterator val$siter;
                private final /* synthetic */ List val$list;
                private final /* synthetic */ ExprInfo this$1;
                {
                    this.this$1 = this$1;
                    this.val$viter = val$viter;
                    this.val$siter = val$siter;
                    this.val$list = val$list;
                    this.vnext = null;
                    this.snext = null;
                    if (this.val$viter.hasNext()) {
                        this.vnext = (VarExpr)this.val$viter.next();
                    }
                    if (this.val$siter.hasNext()) {
                        this.snext = (VarExpr)this.val$siter.next();
                    }
                }

                public void visitStmt(Stmt stmt) {
                    if (this.vnext != null && this.vnext.stmt() == stmt || this.snext != null && this.snext.stmt() == stmt) {
                        super.visitStmt(stmt);
                    }
                }

                public void visitVarExpr(VarExpr expr) {
                    super.visitExpr(expr);
                    if (expr == this.vnext) {
                        this.vnext = this.val$viter.hasNext() ? (VarExpr)this.val$viter.next() : null;
                        if (expr == this.snext) {
                            this.snext = this.val$siter.hasNext() ? (VarExpr)this.val$siter.next() : null;
                        }
                        this.val$list.add(expr);
                    } else if (expr == this.snext) {
                        this.snext = this.val$siter.hasNext() ? (VarExpr)this.val$siter.next() : null;
                        this.val$list.add(expr);
                    }
                }
            });
            return list;
        }

        public Phi exprPhiAtBlock(Block block) {
            return this.phis[StackPRE.this.cfg.preOrderIndex(block)];
        }

        protected void print() {
            System.out.println("Print for " + this.def + "------------------");
            StackPRE.this.cfg.visit(new PrintVisitor(this){
                Phi phi;
                private final /* synthetic */ ExprInfo this$1;
                {
                    this.this$1 = this$1;
                    this.phi = null;
                }

                public void visitBlock(Block block) {
                    this.phi = this.this$1.exprPhiAtBlock(block);
                    super.visitBlock(block);
                }

                public void visitLabelStmt(LabelStmt stmt) {
                    super.visitLabelStmt(stmt);
                    if (stmt.label().startsBlock() && this.phi != null) {
                        this.println(this.phi);
                    }
                }

                public void visitLocalExpr(LocalExpr expr) {
                    super.visitLocalExpr(expr);
                    if (expr.def() == this.this$1.def) {
                        super.print("{" + this.this$1.defs.get(expr) + "}");
                    }
                }
            });
            System.out.println("End Print ----------------------------");
        }
    }

    class Phi
    extends Def {
        Block block;
        HashMap operands;
        HashMap saveOperand;
        boolean live;
        boolean downSafe;
        boolean canBeAvail;
        boolean later;

        public Phi(Block block) {
            this.block = block;
            this.operands = new HashMap(StackPRE.this.cfg.preds(block).size() * 2);
            this.saveOperand = new HashMap(StackPRE.this.cfg.preds(block).size() * 2);
            this.downSafe = true;
            this.canBeAvail = true;
            this.later = true;
        }

        public Block block() {
            return this.block;
        }

        public Collection operands() {
            return new AbstractCollection(this){
                private final /* synthetic */ Phi this$1;
                {
                    this.this$1 = this$1;
                }

                public int size() {
                    return Phi.access$000((Phi)this.this$1).cfg.preds(this.this$1.block).size();
                }

                public boolean contains(Object obj) {
                    if (obj == null) {
                        return this.this$1.operands.size() != Phi.access$000((Phi)this.this$1).cfg.preds(this.this$1.block).size();
                    }
                    return this.this$1.operands.containsValue(obj);
                }

                public Iterator iterator() {
                    Iterator<E> iter = Phi.access$000((Phi)this.this$1).cfg.preds(this.this$1.block).iterator();
                    return new Iterator(this, iter){
                        private final /* synthetic */ Iterator val$iter;
                        private final /* synthetic */ 4 this$2;
                        {
                            this.this$2 = this$2;
                            this.val$iter = val$iter;
                        }

                        public boolean hasNext() {
                            return this.val$iter.hasNext();
                        }

                        public Object next() {
                            Block block = (Block)this.val$iter.next();
                            return 4.access$100(this.this$2).operandAt(block);
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                static /* synthetic */ Phi access$100(4 x0) {
                    return x0.this$1;
                }
            };
        }

        public Def operandAt(Block block) {
            return (Def)this.operands.get(block);
        }

        public void setOperandAt(Block block, Def def) {
            if (def != null) {
                this.operands.put(block, def);
            } else {
                this.operands.remove(block);
            }
        }

        public void setPushOperand(Block block, boolean flag) {
            if (DEBUG) {
                System.out.println("    operand " + block + " save=" + flag);
            }
            this.saveOperand.put(block, new Boolean(flag));
        }

        public boolean pushOperand(Block block) {
            Boolean flag = (Boolean)this.saveOperand.get(block);
            return flag != null && flag != false;
        }

        public boolean insert(Block block) {
            Def def = this.operandAt(block);
            if (def == null) {
                return true;
            }
            if (!def.downSafe()) {
                return true;
            }
            return def instanceof Phi && !((Phi)def).willBeAvail();
        }

        public boolean willBeAvail() {
            return this.canBeAvail && !this.later;
        }

        public void setCanBeAvail(boolean flag) {
            if (DEBUG) {
                System.out.println(this + " CBA = " + flag);
            }
            this.canBeAvail = flag;
        }

        public boolean canBeAvail() {
            return this.canBeAvail;
        }

        public void setLater(boolean flag) {
            if (DEBUG) {
                System.out.println(this + " Later = " + flag);
            }
            this.later = flag;
        }

        public boolean later() {
            return this.later;
        }

        public String toString() {
            String s = "";
            Iterator iter = StackPRE.this.cfg.preds(this.block).iterator();
            while (iter.hasNext()) {
                Block pred = (Block)iter.next();
                Def def = this.operandAt(pred);
                s = s + pred.label() + "=";
                s = def == null ? s + "null" : s + def.version;
                if (!iter.hasNext()) continue;
                s = s + ", ";
            }
            return "phi{" + this.version + "," + (this.downSafe() ? "" : "!") + "DS," + (this.canBeAvail() ? "" : "!") + "CBA," + (this.later() ? "" : "!") + "Later}(" + s + ")";
        }

        static /* synthetic */ StackPRE access$000(Phi x0) {
            return x0.StackPRE.this;
        }
    }

    class RealDef
    extends Def {
        LocalExpr var;

        public RealDef(LocalExpr var) {
            this.var = var;
            if (DEBUG) {
                System.out.println("new def for " + var + " in " + var.parent());
            }
        }

        public LocalExpr var() {
            return this.var;
        }

        public String toString() {
            return this.var.toString() + "{" + this.version + "," + (this.downSafe() ? "" : "!") + "DS}";
        }
    }

    abstract class Def {
        int version;
        boolean downSafe;

        public Def() {
            this.version = StackPRE.this.next++;
            this.downSafe = true;
        }

        public void setDownSafe(boolean flag) {
            if (DEBUG) {
                System.out.println(this + " DS = " + flag);
            }
            this.downSafe = flag;
        }

        public boolean downSafe() {
            return this.downSafe;
        }
    }
}

