/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.InstructionAdapter;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.MultiArrayOperand;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.editor.UseMap;

public class StackOpt
extends InstructionAdapter
implements Opcode {
    int stackHeight;
    int minStackHeight;
    UseMap uMap;
    static final boolean DEBUG = false;

    public void transform(MethodEditor method) {
        this.uMap = method.uMap();
        block3: for (int i = method.codeLength() - 1; i > 0; --i) {
            boolean isWide;
            Object codeEl = method.codeElementAt(i);
            if (!(codeEl instanceof Instruction) || !((Instruction)codeEl).isLoad()) continue;
            Instruction inst = (Instruction)codeEl;
            switch (inst.opcodeClass()) {
                case 21: 
                case 23: 
                case 25: 
                case 46: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    isWide = false;
                    break;
                }
                default: {
                    isWide = true;
                }
            }
            this.stackHeight = 0;
            for (int j = i - 1; j > 0 && !(method.codeElementAt(j) instanceof Label); --j) {
                if (this.stackHeight == -1 && (this.uMap.hasSameDef(inst, (Instruction)method.codeElementAt(j)) && ((Instruction)method.codeElementAt(j)).isLoad() || this.dupRun(method, j, inst))) {
                    if (!this.forwardCountCheck(method, j, i, -1)) continue block3;
                    if (isWide) {
                        method.insertCodeAt(new Instruction(92), j + 1);
                    } else {
                        method.insertCodeAt(new Instruction(89), j + 1);
                    }
                    method.removeCodeAt(++i);
                    continue block3;
                }
                if (this.stackHeight == 0 && this.uMap.hasSameDef(inst, (Instruction)method.codeElementAt(j))) {
                    if (((Instruction)method.codeElementAt(j)).isStore()) {
                        if (!this.forwardCountCheck(method, j, i, 0)) continue block3;
                        if (isWide) {
                            method.insertCodeAt(new Instruction(92), j);
                        } else {
                            method.insertCodeAt(new Instruction(89), j);
                        }
                        method.removeCodeAt(++i);
                        continue block3;
                    }
                    if (((Instruction)method.codeElementAt(j)).isLoad() && !isWide) {
                        if (!this.forwardCountCheck(method, j, i, -1)) continue block3;
                        method.insertCodeAt(new Instruction(89), j + 1);
                        method.replaceCodeAt(new Instruction(95), ++i);
                        continue block3;
                    }
                } else if (this.stackHeight == 1 && this.uMap.hasSameDef(inst, (Instruction)method.codeElementAt(j)) && ((Instruction)method.codeElementAt(j)).isStore() && !isWide) {
                    if (!this.forwardCountCheck(method, j, i, 0)) continue block3;
                    method.insertCodeAt(new Instruction(89), j);
                    method.replaceCodeAt(new Instruction(95), ++i);
                    continue block3;
                }
                this.heightChange(method.codeElementAt(j));
            }
        }
    }

    boolean forwardCountCheck(MethodEditor m, int j, int i, int bound) {
        this.stackHeight = 0;
        this.minStackHeight = 0;
        for (int k = j + 1; k < i; ++k) {
            this.heightChange(m.codeElementAt(k));
            if (this.minStackHeight >= bound) continue;
            return false;
        }
        return true;
    }

    boolean dupRun(MethodEditor m, int j, Instruction inst) {
        if (((Instruction)m.codeElementAt(j)).opcodeClass() == 89) {
            int k = j - 1;
            while (m.codeElementAt(k) instanceof Instruction) {
                if (((Instruction)m.codeElementAt(k)).opcodeClass() != 89) {
                    if (!((Instruction)m.codeElementAt(k)).isLoad() || !this.uMap.hasSameDef(inst, (Instruction)m.codeElementAt(k))) break;
                    return true;
                }
                --k;
            }
        }
        return false;
    }

    void heightChange(Object inst) {
        if (inst instanceof Instruction) {
            ((Instruction)inst).visit(this);
        }
    }

    public void visit_nop(Instruction inst) {
        this.stackHeight += 0;
    }

    public void visit_ldc(Instruction inst) {
        Object operand = inst.operand();
        this.stackHeight = operand instanceof Long || operand instanceof Double ? (this.stackHeight += 2) : ++this.stackHeight;
    }

    public void visit_iload(Instruction inst) {
        ++this.stackHeight;
    }

    public void visit_lload(Instruction inst) {
        this.stackHeight += 2;
    }

    public void visit_fload(Instruction inst) {
        ++this.stackHeight;
    }

    public void visit_dload(Instruction inst) {
        this.stackHeight += 2;
    }

    public void visit_aload(Instruction inst) {
        ++this.stackHeight;
    }

    public void visit_iaload(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_laload(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_faload(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_daload(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_aaload(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_baload(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_caload(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_saload(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_istore(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_lstore(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_fstore(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_dstore(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_astore(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_iastore(Instruction inst) {
        this.stackHeight -= 3;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_lastore(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_fastore(Instruction inst) {
        this.stackHeight -= 3;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_dastore(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_aastore(Instruction inst) {
        this.stackHeight -= 3;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_bastore(Instruction inst) {
        this.stackHeight -= 3;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_castore(Instruction inst) {
        this.stackHeight -= 3;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_sastore(Instruction inst) {
        this.stackHeight -= 3;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_pop(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_pop2(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_dup(Instruction inst) {
        ++this.stackHeight;
    }

    public void visit_dup_x1(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 3;
    }

    public void visit_dup_x2(Instruction inst) {
        this.stackHeight -= 3;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 4;
    }

    public void visit_dup2(Instruction inst) {
        this.stackHeight += 2;
    }

    public void visit_dup2_x1(Instruction inst) {
        this.stackHeight -= 3;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 5;
    }

    public void visit_dup2_x2(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 6;
    }

    public void visit_swap(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_iadd(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_ladd(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_fadd(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_dadd(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_isub(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_lsub(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_fsub(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_dsub(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_imul(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_lmul(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_fmul(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_dmul(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_idiv(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_ldiv(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_fdiv(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_ddiv(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_irem(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_lrem(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_frem(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_drem(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_ineg(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_lneg(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_fneg(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_dneg(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_ishl(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_lshl(Instruction inst) {
        this.stackHeight -= 3;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_ishr(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_lshr(Instruction inst) {
        this.stackHeight -= 3;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_iushr(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_lushr(Instruction inst) {
        this.stackHeight -= 3;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_iand(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_land(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_ior(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_lor(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_ixor(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_lxor(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_iinc(Instruction inst) {
    }

    public void visit_i2l(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_i2f(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_i2d(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_l2i(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_l2f(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_l2d(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_f2i(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_f2l(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_f2d(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_d2i(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_d2l(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += 2;
    }

    public void visit_d2f(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_i2b(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_i2c(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_i2s(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_lcmp(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_fcmpl(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_fcmpg(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_dcmpl(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_dcmpg(Instruction inst) {
        this.stackHeight -= 4;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_ifeq(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_ifne(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_iflt(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_ifge(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_ifgt(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_ifle(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_if_icmpeq(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_if_icmpne(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_if_icmplt(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_if_icmpge(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_if_icmpgt(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_if_icmple(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_if_acmpeq(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_if_acmpne(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_goto(Instruction inst) {
    }

    public void visit_jsr(Instruction inst) {
        ++this.stackHeight;
    }

    public void visit_ret(Instruction inst) {
    }

    public void visit_switch(Instruction inst) {
        --this.stackHeight;
    }

    public void visit_ireturn(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_lreturn(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_freturn(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_dreturn(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_areturn(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_return(Instruction inst) {
    }

    public void visit_getstatic(Instruction inst) {
        Type type = ((MemberRef)inst.operand()).nameAndType().type();
        this.stackHeight += type.stackHeight();
    }

    public void visit_putstatic(Instruction inst) {
        Type type = ((MemberRef)inst.operand()).nameAndType().type();
        this.stackHeight -= type.stackHeight();
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_putstatic_nowb(Instruction inst) {
        Type type = ((MemberRef)inst.operand()).nameAndType().type();
        this.stackHeight -= type.stackHeight();
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_getfield(Instruction inst) {
        Type type = ((MemberRef)inst.operand()).nameAndType().type();
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += type.stackHeight();
    }

    public void visit_putfield(Instruction inst) {
        Type type = ((MemberRef)inst.operand()).nameAndType().type();
        this.stackHeight -= type.stackHeight() + 1;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_putfield_nowb(Instruction inst) {
        Type type = ((MemberRef)inst.operand()).nameAndType().type();
        this.stackHeight -= type.stackHeight() + 1;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_invokevirtual(Instruction inst) {
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        this.stackHeight -= type.stackHeight() + 1;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += type.returnType().stackHeight();
    }

    public void visit_invokespecial(Instruction inst) {
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        this.stackHeight -= type.stackHeight() + 1;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += type.returnType().stackHeight();
    }

    public void visit_invokestatic(Instruction inst) {
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        this.stackHeight -= type.stackHeight();
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += type.returnType().stackHeight();
    }

    public void visit_invokeinterface(Instruction inst) {
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        this.stackHeight -= type.stackHeight() + 1;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        this.stackHeight += type.returnType().stackHeight();
    }

    public void visit_new(Instruction inst) {
        ++this.stackHeight;
    }

    public void visit_newarray(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_arraylength(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_athrow(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_checkcast(Instruction inst) {
    }

    public void visit_instanceof(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_monitorenter(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_monitorexit(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_multianewarray(Instruction inst) {
        MultiArrayOperand operand = (MultiArrayOperand)inst.operand();
        int dim = operand.dimensions();
        this.stackHeight -= dim;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
        ++this.stackHeight;
    }

    public void visit_ifnull(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_ifnonnull(Instruction inst) {
        --this.stackHeight;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_rc(Instruction inst) {
    }

    public void visit_aupdate(Instruction inst) {
    }

    public void visit_supdate(Instruction inst) {
    }

    public void visit_aswizzle(Instruction inst) {
        this.stackHeight -= 2;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }

    public void visit_aswrange(Instruction inst) {
        this.stackHeight -= 3;
        if (this.stackHeight < this.minStackHeight) {
            this.minStackHeight = this.stackHeight;
        }
    }
}

