/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.cfg.Handler;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.ssa.SSA;
import EDU.purdue.cs.bloat.ssa.SSAConstructionInfo;
import EDU.purdue.cs.bloat.tbaa.TBAA;
import EDU.purdue.cs.bloat.trans.NodeComparator;
import EDU.purdue.cs.bloat.trans.SSAPRE;
import EDU.purdue.cs.bloat.trans.SideEffectChecker;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayLengthExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.CatchExpr;
import EDU.purdue.cs.bloat.tree.CheckExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.InstanceOfExpr;
import EDU.purdue.cs.bloat.tree.LabelStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemRefExpr;
import EDU.purdue.cs.bloat.tree.MonitorStmt;
import EDU.purdue.cs.bloat.tree.NegExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.PrintVisitor;
import EDU.purdue.cs.bloat.tree.ReplaceVisitor;
import EDU.purdue.cs.bloat.tree.ShiftExpr;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.ResizeableArrayList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SSAPRE {
    public static boolean DEBUG = false;
    public static boolean NO_THREAD = false;
    public static boolean NO_PRECISE = false;
    public static boolean NO_ACCESS_PATHS = false;
    protected FlowGraph cfg;
    protected int nextValueNumber;
    protected EditorContext context;
    protected ResizeableArrayList[] kills;
    protected boolean[] killsSorted;
    protected SideEffectChecker sideEffects;
    protected ExprWorklist worklist;
    protected HashMap phiRelated;
    int next = 0;

    public SSAPRE(FlowGraph cfg, EditorContext context) {
        this.cfg = cfg;
        this.context = context;
    }

    public void transform() {
        this.sideEffects = new SideEffectChecker(this.context);
        this.kills = new ResizeableArrayList[this.cfg.size()];
        this.killsSorted = new boolean[this.cfg.size()];
        for (int i = 0; i < this.kills.length; ++i) {
            this.kills[i] = new ResizeableArrayList();
            this.killsSorted[i] = false;
        }
        this.worklist = new ExprWorklist();
        this.phiRelated = new HashMap();
        this.collectOccurrences();
        while (!this.worklist.isEmpty()) {
            ExprInfo exprInfo = this.worklist.removeFirst();
            this.transform(exprInfo);
        }
        this.sideEffects = null;
        this.kills = null;
        this.worklist = null;
    }

    private void transform(ExprInfo exprInfo) {
        if (DEBUG) {
            System.out.println("PRE for " + exprInfo.prototype() + " -------------------------");
        }
        if (exprInfo.numUses() == 0) {
            if (DEBUG) {
                System.out.println("Skipping...all occurrences are as targets. -------------------------");
            }
            exprInfo.cleanup();
            return;
        }
        if (DEBUG) {
            System.out.println("Placing Phis for " + exprInfo.prototype() + " -------------------------");
        }
        this.placePhis(exprInfo);
        if (DEBUG) {
            exprInfo.print();
            System.out.println("Renaming for " + exprInfo.prototype() + " -------------------------");
        }
        this.rename(exprInfo);
        if (DEBUG) {
            exprInfo.print();
            System.out.println("Down safety for " + exprInfo.prototype() + " -------------------------");
        }
        this.downSafety(exprInfo);
        if (DEBUG) {
            System.out.println("Will be available for " + exprInfo.prototype() + " -------------------------");
        }
        this.willBeAvail(exprInfo);
        if (DEBUG) {
            System.out.println("Finalize for " + exprInfo.prototype() + " -------------------------");
        }
        this.finalize(exprInfo);
        if (DEBUG) {
            System.out.println("Code motion for " + exprInfo.prototype() + " -------------------------");
        }
        Type type = exprInfo.prototype().type();
        LocalVariable v = this.cfg.method().newLocal(type);
        LocalExpr tmp = new LocalExpr(v.index(), type);
        SSAConstructionInfo consInfo = new SSAConstructionInfo(this.cfg, tmp);
        this.codeMotion(exprInfo, tmp, consInfo);
        if (DEBUG) {
            System.out.println("Performing incremental SSA for " + exprInfo.prototype() + " -------------------------");
        }
        SSA.transform(this.cfg, consInfo);
        this.setValueNumbers(consInfo);
        this.enqueueParents(consInfo);
        if (DEBUG) {
            exprInfo.print();
            System.out.println("Done with PRE for " + exprInfo.prototype() + " -------------------------");
        }
        exprInfo.cleanup();
    }

    private void collectOccurrences() {
        final Int count = new Int();
        final Int maxValue = new Int();
        final Set beginTry = this.beginTry();
        this.cfg.visit(new TreeVisitor(){

            public void visitBlock(Block block) {
                if (beginTry.contains(block)) {
                    SSAPRE.this.worklist.addKill(block, new ExceptionKill(count.value++));
                }
                block.visitChildren(this);
            }

            public void visitPhiStmt(PhiStmt stmt) {
                if (maxValue.value < stmt.valueNumber()) {
                    maxValue.value = stmt.valueNumber();
                }
                stmt.visitChildren(this);
                int v = stmt.target().valueNumber();
                Iterator iter = stmt.operands().iterator();
                while (iter.hasNext()) {
                    Expr operand = (Expr)iter.next();
                    if (!(operand instanceof VarExpr) || operand.def() == null) continue;
                    SSAPRE.this.phiRelatedUnion(operand.def(), stmt.target());
                }
            }

            public void visitConstantExpr(ConstantExpr expr) {
                if (maxValue.value < expr.valueNumber()) {
                    maxValue.value = expr.valueNumber();
                }
                expr.setKey(count.value++);
            }

            public void visitVarExpr(VarExpr expr) {
                if (maxValue.value < expr.valueNumber()) {
                    maxValue.value = expr.valueNumber();
                }
                expr.setKey(count.value++);
            }

            public void visitCatchExpr(CatchExpr expr) {
                if (maxValue.value < expr.valueNumber()) {
                    maxValue.value = expr.valueNumber();
                }
                expr.visitChildren(this);
                expr.setKey(count.value++);
                SSAPRE.this.worklist.addKill(expr.block(), new ExceptionKill(expr.key()));
            }

            public void visitMonitorStmt(MonitorStmt stmt) {
                if (maxValue.value < stmt.valueNumber()) {
                    maxValue.value = stmt.valueNumber();
                }
                if (!NO_THREAD) {
                    stmt.visitChildren(this);
                    stmt.setKey(count.value++);
                    SSAPRE.this.worklist.addKill(stmt.block(), new MemRefKill(stmt.key()));
                }
            }

            public void visitCallExpr(CallExpr expr) {
                if (maxValue.value < expr.valueNumber()) {
                    maxValue.value = expr.valueNumber();
                }
                expr.visitChildren(this);
                expr.setKey(count.value++);
                SSAPRE.this.worklist.addKill(expr.block(), new MemRefKill(expr.key()));
            }

            public void visitMemRefExpr(MemRefExpr expr) {
                boolean firstOrder;
                if (maxValue.value < expr.valueNumber()) {
                    maxValue.value = expr.valueNumber();
                }
                if (!(firstOrder = SSAPRE.this.isFirstOrder(expr))) {
                    expr.visitChildren(this);
                }
                expr.setKey(count.value++);
                if (expr.isDef()) {
                    SSAPRE.this.worklist.addKill(expr.block(), new MemRefKill(expr, expr.key()));
                }
                if (firstOrder) {
                    SSAPRE.this.worklist.addReal(expr);
                }
            }

            public void visitStmt(Stmt stmt) {
                if (maxValue.value < stmt.valueNumber()) {
                    maxValue.value = stmt.valueNumber();
                }
                stmt.visitChildren(this);
            }

            public void visitExpr(Expr expr) {
                if (maxValue.value < expr.valueNumber()) {
                    maxValue.value = expr.valueNumber();
                }
                if (SSAPRE.this.isFirstOrder(expr)) {
                    SSAPRE.this.worklist.addReal(expr);
                } else {
                    expr.visitChildren(this);
                }
                expr.setKey(count.value++);
            }
        });
        this.nextValueNumber = maxValue.value + 1;
    }

    private Set beginTry() {
        HashSet beginTry = new HashSet();
        Iterator blocks = this.cfg.catchBlocks().iterator();
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            Handler handler = (Handler)this.cfg.handlersMap().get(block);
            if (handler == null) continue;
            HashSet p = new HashSet();
            Iterator prots = handler.protectedBlocks().iterator();
            while (prots.hasNext()) {
                Block prot = (Block)prots.next();
                p.addAll(this.cfg.preds(prot));
            }
            p.removeAll(handler.protectedBlocks());
            Iterator preds = p.iterator();
            while (preds.hasNext()) {
                Block pred = (Block)preds.next();
                beginTry.addAll(this.cfg.succs(pred));
            }
        }
        return beginTry;
    }

    private void enqueueParents(SSAConstructionInfo consInfo) {
        HashSet<Node> seen = new HashSet<Node>();
        Iterator iter = this.cfg.nodes().iterator();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            Iterator e = consInfo.realsAtBlock(block).iterator();
            while (e.hasNext()) {
                VarExpr real = (VarExpr)e.next();
                Node p = real.parent();
                if (p instanceof StoreExpr && real.isDef()) {
                    p = p.parent();
                }
                if (!(p instanceof Expr) || seen.contains(p)) continue;
                Expr expr = (Expr)p;
                seen.add(p);
                if (!this.isFirstOrder(expr)) continue;
                this.worklist.addReal(expr);
            }
        }
    }

    private void setValueNumbers(SSAConstructionInfo consInfo) {
        Expr operand;
        Iterator operands;
        boolean changed = true;
        while (changed) {
            changed = false;
            List postOrder = this.cfg.postOrder();
            ListIterator iter = postOrder.listIterator(postOrder.size());
            while (iter.hasPrevious()) {
                VarExpr def;
                Block block = (Block)iter.previous();
                PhiStmt phi = consInfo.phiAtBlock(block);
                if (phi != null) {
                    if (phi.target().valueNumber() == -1) {
                        phi.target().setValueNumber(this.nextValueNumber++);
                        changed = true;
                    }
                    operands = phi.operands().iterator();
                    while (operands.hasNext()) {
                        operand = (VarExpr)operands.next();
                        if (operand == null) continue;
                        def = (VarExpr)((VarExpr)operand).def();
                        if (def == null) {
                            if (operand.valueNumber() != -1) continue;
                            operand.setValueNumber(this.nextValueNumber++);
                            changed = true;
                            continue;
                        }
                        if (def.valueNumber() == -1) {
                            def.setValueNumber(this.nextValueNumber++);
                            changed = true;
                        }
                        if (def.valueNumber() == operand.valueNumber()) continue;
                        operand.setValueNumber(def.valueNumber());
                        changed = true;
                    }
                }
                Iterator e = consInfo.realsAtBlock(block).iterator();
                while (e.hasNext()) {
                    VarExpr real = (VarExpr)e.next();
                    if (real.isDef()) {
                        Assert.isTrue(real.parent() instanceof StoreExpr);
                        StoreExpr store = (StoreExpr)real.parent();
                        Expr rhs = store.expr();
                        if (rhs.valueNumber() == -1) {
                            rhs.setValueNumber(this.nextValueNumber++);
                            changed = true;
                        }
                        if (store.valueNumber() != rhs.valueNumber()) {
                            store.setValueNumber(rhs.valueNumber());
                            changed = true;
                        }
                        if (real.valueNumber() == rhs.valueNumber()) continue;
                        real.setValueNumber(rhs.valueNumber());
                        changed = true;
                        continue;
                    }
                    def = (VarExpr)real.def();
                    if (def == null) {
                        if (real.valueNumber() != -1) continue;
                        real.setValueNumber(this.nextValueNumber++);
                        changed = true;
                        continue;
                    }
                    if (def.valueNumber() == -1) {
                        def.setValueNumber(this.nextValueNumber++);
                        changed = true;
                    }
                    if (def.valueNumber() == real.valueNumber()) continue;
                    real.setValueNumber(def.valueNumber());
                    changed = true;
                }
            }
        }
        Iterator iter = this.cfg.nodes().iterator();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            PhiStmt phi = consInfo.phiAtBlock(block);
            if (phi == null) continue;
            int v = phi.target().valueNumber();
            operands = phi.operands().iterator();
            while (operands.hasNext()) {
                operand = (Expr)operands.next();
                if (!(operand instanceof VarExpr) || operand.def() == null) continue;
                this.phiRelatedUnion(operand.def(), phi.target());
            }
        }
    }

    private void placePhis(ExprInfo exprInfo) {
        ArrayList<Block> w = new ArrayList<Block>(this.cfg.size());
        Iterator blocks = this.cfg.nodes().iterator();
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            if (exprInfo.occurrencesAtBlock(block).size() <= 0) continue;
            w.add(block);
        }
        HashSet<Block> df = new HashSet<Block>(this.cfg.iteratedDomFrontier(w));
        final ArrayList<Node> worklist = new ArrayList<Node>();
        final HashSet<Node> inWorklist = new HashSet<Node>();
        blocks = this.cfg.nodes().iterator();
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            Iterator e = exprInfo.realsAtBlock(block).iterator();
            while (e.hasNext()) {
                Expr real = (Expr)e.next();
                real.visit(new TreeVisitor(){

                    public void visitVarExpr(VarExpr var) {
                        DefExpr def = var.def();
                        if (def == null) {
                            return;
                        }
                        Node p = def.parent();
                        if (p instanceof PhiStmt && !inWorklist.contains(p)) {
                            worklist.add(p);
                            inWorklist.add(p);
                        }
                    }
                });
            }
        }
        while (!worklist.isEmpty()) {
            PhiStmt phi = (PhiStmt)worklist.remove(worklist.size() - 1);
            df.add(phi.block());
            Iterator iter = phi.operands().iterator();
            while (iter.hasNext()) {
                Node p;
                VarExpr var;
                DefExpr def;
                Expr expr = (Expr)iter.next();
                if (!(expr instanceof VarExpr) || (def = (var = (VarExpr)expr).def()) == null || !((p = def.parent()) instanceof PhiStmt) || inWorklist.contains(p)) continue;
                worklist.add(p);
                inWorklist.add(p);
            }
        }
        Iterator iter = df.iterator();
        while (iter.hasNext()) {
            Block block = (Block)iter.next();
            exprInfo.addPhi(block);
        }
    }

    private void rename(ExprInfo exprInfo) {
        ArrayList renameWorklist = new ArrayList();
        this.search(this.cfg.source(), exprInfo, null, null, renameWorklist);
        HashSet<Pair> seen = new HashSet<Pair>();
        LinkedList<Phi> leavesWorklist = new LinkedList<Phi>();
        Iterator iter = renameWorklist.iterator();
        while (iter.hasNext()) {
            Expr real = (Expr)iter.next();
            Phi phi = (Phi)exprInfo.def(real);
            final ArrayList leaves = new ArrayList();
            real.visitChildren(new TreeVisitor(){

                public void visitStoreExpr(StoreExpr expr) {
                    throw new RuntimeException();
                }

                public void visitConstantExpr(ConstantExpr expr) {
                    leaves.add(expr);
                }

                public void visitVarExpr(VarExpr expr) {
                    leaves.add(expr.def());
                }

                public void visitExpr(Expr expr) {
                    throw new RuntimeException();
                }
            });
            phi.setLeaves(leaves);
            leavesWorklist.add(phi);
        }
        while (!leavesWorklist.isEmpty()) {
            final Phi phi = (Phi)leavesWorklist.removeFirst();
            phi.setLive(true);
            List leaves = phi.leaves();
            Iterator preds = this.cfg.preds(phi.block()).iterator();
            block2: while (preds.hasNext()) {
                Iterator leafIter;
                final Block pred = (Block)preds.next();
                Def operand = phi.operandAt(pred);
                if (operand instanceof RealDef) {
                    Expr expr = ((RealDef)operand).expr;
                    final Bool match = new Bool();
                    match.value = true;
                    leafIter = leaves.iterator();
                    expr.visitChildren(new TreeVisitor(){

                        public void visitExpr(Expr expr) {
                            throw new RuntimeException();
                        }

                        public void visitStoreExpr(StoreExpr expr) {
                            expr.target().visit(this);
                        }

                        public void visitConstantExpr(ConstantExpr expr) {
                            this.visitLeaf(expr);
                        }

                        public void visitVarExpr(VarExpr expr) {
                            this.visitLeaf(expr);
                        }

                        public void visitLeaf(Expr expr) {
                            if (!leafIter.hasNext()) {
                                match.value = false;
                                return;
                            }
                            Expr leaf = (Expr)leafIter.next();
                            if (leaf instanceof VarExpr) {
                                PhiJoinStmt leafPhi;
                                Assert.isTrue(((VarExpr)leaf).isDef());
                                if (leaf.parent() instanceof PhiJoinStmt && (leafPhi = (PhiJoinStmt)leaf.parent()).block() == phi.block()) {
                                    leaf = leafPhi.operandAt(pred);
                                }
                            }
                            if (!(leaf instanceof ConstantExpr) && !(leaf instanceof VarExpr)) {
                                match.value = false;
                                return;
                            }
                            if (expr.valueNumber() != leaf.valueNumber()) {
                                match.value = false;
                                return;
                            }
                        }
                    });
                    if (match.value && !leafIter.hasNext()) continue;
                    phi.setOperandAt(pred, null);
                    phi.setHasRealUse(pred, false);
                    continue;
                }
                if (!(operand instanceof Phi)) continue;
                ArrayList<Expr> newLeaves = new ArrayList<Expr>(leaves.size());
                Phi opPhi = (Phi)operand;
                leafIter = leaves.iterator();
                while (leafIter.hasNext()) {
                    Expr leaf = (Expr)leafIter.next();
                    if (leaf instanceof VarExpr) {
                        PhiJoinStmt leafPhi;
                        Assert.isTrue(((VarExpr)leaf).isDef());
                        if (leaf.parent() instanceof PhiJoinStmt && (leafPhi = (PhiJoinStmt)leaf.parent()).block() == phi.block()) {
                            leaf = leafPhi.operandAt(pred);
                        }
                    }
                    if (leaf instanceof VarExpr) {
                        if ((leaf = leaf.def()).block() == opPhi.block()) {
                            if (leaf.parent() instanceof PhiJoinStmt) {
                                newLeaves.add(leaf);
                                continue;
                            }
                        } else if (leaf.block().dominates(opPhi.block())) {
                            newLeaves.add(leaf);
                            continue;
                        }
                    }
                    phi.setOperandAt(pred, null);
                    phi.setHasRealUse(pred, false);
                    continue block2;
                }
                Assert.isTrue(leaves.size() == newLeaves.size());
                Pair pair = new Pair(phi, opPhi);
                if (seen.contains(pair)) continue;
                seen.add(pair);
                opPhi.setLeaves(newLeaves);
                leavesWorklist.add(opPhi);
            }
        }
        Iterator blocks = this.cfg.nodes().iterator();
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            Phi phi = exprInfo.exprPhiAtBlock(block);
            if (phi == null || phi.live()) continue;
            if (DEBUG) {
                System.out.println("    dead Phi at " + block);
            }
            exprInfo.removePhi(block);
        }
    }

    private void search(Block block, ExprInfo exprInfo, Expr top, Def topdef, List renameWorklist) {
        Phi phi;
        if (DEBUG) {
            System.out.println("    renaming in " + block);
        }
        if ((phi = exprInfo.exprPhiAtBlock(block)) != null) {
            top = null;
            topdef = phi;
            if (exprInfo.hasStackVariable()) {
                phi.setDownSafe(false);
            }
            if (!NO_PRECISE && exprInfo.hasSideEffects()) {
                phi.setDownSafe(false);
            }
        }
        if (block == this.cfg.sink()) {
            if (topdef instanceof Phi && top == null) {
                ((Phi)topdef).setDownSafe(false);
            }
            return;
        }
        if (this.cfg.catchBlocks().contains(block)) {
            if (topdef instanceof Phi && top == null) {
                ((Phi)topdef).setDownSafe(false);
            }
            if (DEBUG) {
                System.out.println("Top killed at catch " + block);
            }
            top = null;
            topdef = null;
        }
        Iterator e = exprInfo.occurrencesAtBlock(block).iterator();
        while (e.hasNext()) {
            Object obj = e.next();
            if (obj instanceof Kill) {
                if (topdef == null) continue;
                Kill kill = (Kill)obj;
                if (DEBUG) {
                    System.out.println("Kill " + kill.expr);
                }
                boolean die = false;
                if (exprInfo.prototype() instanceof MemRefExpr && kill instanceof MemRefKill) {
                    MemRefExpr k = (MemRefExpr)kill.expr;
                    MemRefExpr p = (MemRefExpr)exprInfo.prototype();
                    if (kill.expr == null) {
                        die = true;
                    } else if (TBAA.canAlias(this.context, k, p)) {
                        die = true;
                    }
                }
                if (!die && exprInfo.hasSideEffects() && kill instanceof ExceptionKill) {
                    die = true;
                }
                if (!die) continue;
                if (DEBUG) {
                    System.out.println("Killed");
                }
                if (topdef instanceof Phi && top == null) {
                    ((Phi)topdef).setDownSafe(false);
                }
                top = null;
                topdef = null;
                continue;
            }
            Expr real = (Expr)obj;
            final Bool hasStore = new Bool();
            if (real.isDef()) {
                hasStore.value = true;
            } else {
                real.visit(new TreeVisitor(){

                    public void visitStoreExpr(StoreExpr expr) {
                        hasStore.value = true;
                    }

                    public void visitExpr(Expr expr) {
                        if (!hasStore.value) {
                            expr.visitChildren(this);
                        }
                    }
                });
            }
            boolean matches = true;
            if (hasStore.value) {
                matches = false;
                if (DEBUG) {
                    System.out.println("real has store");
                }
            }
            if (matches && topdef == null) {
                matches = false;
                if (DEBUG) {
                    System.out.println("null topdef");
                }
            }
            if (matches && topdef instanceof Phi && !this.matchesPhi(real, (Phi)topdef)) {
                matches = false;
                if (DEBUG) {
                    System.out.println("uses var defined after topdef");
                }
            }
            if (matches && top != null && !this.matches(top, real)) {
                matches = false;
                if (DEBUG) {
                    System.out.println("mismatch " + top + " != " + real);
                }
            }
            if (!matches) {
                if (top == null && topdef instanceof Phi) {
                    ((Phi)topdef).setDownSafe(false);
                }
                RealDef def = new RealDef(real);
                exprInfo.setDef(real, def);
                topdef = def;
            } else {
                Assert.isTrue(topdef != null);
                if (DEBUG) {
                    System.out.println("copying top def");
                }
                if (topdef instanceof Phi) {
                    renameWorklist.add(real);
                }
                exprInfo.setDef(real, topdef);
            }
            top = real;
        }
        Iterator succs = this.cfg.succs(block).iterator();
        while (succs.hasNext()) {
            Phi succPhi;
            Block succ = (Block)succs.next();
            if (succ == this.cfg.sink() && top == null && topdef instanceof Phi) {
                ((Phi)topdef).setDownSafe(false);
            }
            if ((succPhi = exprInfo.exprPhiAtBlock(succ)) == null) continue;
            succPhi.setOperandAt(block, topdef);
            if (top == null) continue;
            succPhi.setHasRealUse(block, true);
        }
        Iterator children = this.cfg.domChildren(block).iterator();
        while (children.hasNext()) {
            Block child = (Block)children.next();
            this.search(child, exprInfo, top, topdef, renameWorklist);
        }
    }

    private boolean matchesPhi(Expr real, final Phi phi) {
        final Bool match = new Bool();
        match.value = true;
        real.visitChildren(new TreeVisitor(){

            public void visitExpr(Expr expr) {
                if (match.value) {
                    expr.visitChildren(this);
                }
            }

            public void visitStoreExpr(StoreExpr expr) {
                match.value = false;
            }

            public void visitVarExpr(VarExpr expr) {
                Node p;
                if (!match.value) {
                    return;
                }
                VarExpr def = (VarExpr)expr.def();
                if (def == null) {
                    match.value = false;
                    return;
                }
                Block block = phi.block();
                if (block == (p = def.parent()).block() ? p instanceof PhiJoinStmt : p.block().dominates(block)) {
                    return;
                }
                match.value = false;
            }
        });
        return match.value;
    }

    private boolean matches(Expr expr1, Expr expr2) {
        final LinkedList leaves = new LinkedList();
        expr1.visit(new TreeVisitor(){

            public void visitStoreExpr(StoreExpr expr) {
                expr.target().visit(this);
            }

            public void visitConstantExpr(ConstantExpr expr) {
                leaves.add(expr);
            }

            public void visitVarExpr(VarExpr expr) {
                leaves.add(expr);
            }
        });
        final Bool match = new Bool();
        match.value = true;
        expr2.visit(new TreeVisitor(){

            public void visitExpr(Expr expr) {
                if (match.value) {
                    expr.visitChildren(this);
                }
            }

            public void visitStoreExpr(StoreExpr expr) {
                if (match.value) {
                    expr.target().visit(this);
                }
            }

            public void visitConstantExpr(ConstantExpr expr) {
                this.visitLeaf(expr);
            }

            public void visitVarExpr(VarExpr expr) {
                this.visitLeaf(expr);
            }

            public void visitLeaf(Expr expr) {
                if (leaves.isEmpty()) {
                    match.value = false;
                    return;
                }
                Expr leaf = (Expr)leaves.removeFirst();
                if (leaf == null || expr.valueNumber() != leaf.valueNumber()) {
                    match.value = false;
                }
            }
        });
        return match.value;
    }

    private Expr buildPhiOperand(ExprInfo exprInfo, final Phi phi, final Block pred) {
        final Iterator leaves = phi.leaves().iterator();
        Expr expr = (Expr)exprInfo.prototype().clone();
        expr.visit(new TreeVisitor(){

            public void visitExpr(StoreExpr expr) {
                throw new RuntimeException();
            }

            public void visitConstantExpr(ConstantExpr expr) {
                this.visitLeaf(expr);
            }

            public void visitVarExpr(VarExpr expr) {
                this.visitLeaf(expr);
            }

            public void visitLeaf(Expr expr) {
                Expr copy;
                if (leaves.hasNext()) {
                    Expr leaf = (Expr)leaves.next();
                    if (leaf instanceof VarExpr) {
                        PhiJoinStmt leafPhi;
                        Assert.isTrue(((VarExpr)leaf).isDef());
                        if (leaf.parent() instanceof PhiJoinStmt && (leafPhi = (PhiJoinStmt)leaf.parent()).block() == phi.block() && (leaf = leafPhi.operandAt(pred)) instanceof VarExpr) {
                            leaf = leaf.def();
                        }
                    }
                    Assert.isTrue(leaf != null);
                    copy = (Expr)leaf.clone();
                    if (leaf.isDef()) {
                        copy.setDef((VarExpr)leaf);
                    }
                } else {
                    throw new RuntimeException();
                }
                expr.replaceWith(copy);
            }
        });
        expr.setValueNumber(this.nextValueNumber++);
        return expr;
    }

    private void downSafety(ExprInfo exprInfo) {
        Iterator blocks = this.cfg.nodes().iterator();
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            Phi phi = exprInfo.exprPhiAtBlock(block);
            if (phi == null || phi.downSafe()) continue;
            Iterator e = this.cfg.preds(block).iterator();
            while (e.hasNext()) {
                Block pred = (Block)e.next();
                this.resetDownSafe(phi, pred);
            }
        }
    }

    private void resetDownSafe(Phi phi, Block block) {
        Phi phidef;
        if (phi.hasRealUse(block)) {
            return;
        }
        Def def = phi.operandAt(block);
        if (def instanceof Phi && (phidef = (Phi)def).downSafe()) {
            phidef.setDownSafe(false);
            if (DEBUG) {
                System.out.println("            def = Phi in " + phidef.block());
                System.out.println("            def made not down safe");
            }
            Iterator e = this.cfg.preds(block).iterator();
            while (e.hasNext()) {
                Block pred = (Block)e.next();
                this.resetDownSafe(phidef, pred);
            }
        }
    }

    private void willBeAvail(ExprInfo exprInfo) {
        this.computeCanBeAvail(exprInfo);
        this.computeLater(exprInfo);
    }

    private void computeCanBeAvail(ExprInfo exprInfo) {
        Iterator blocks = this.cfg.nodes().iterator();
        block0: while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            Phi phi = exprInfo.exprPhiAtBlock(block);
            if (phi == null || !phi.canBeAvail() || phi.downSafe()) continue;
            Iterator e = this.cfg.preds(block).iterator();
            while (e.hasNext()) {
                Block pred = (Block)e.next();
                Def operand = phi.operandAt(pred);
                if (operand != null) continue;
                this.resetCanBeAvail(exprInfo, phi);
                continue block0;
            }
        }
    }

    private void resetCanBeAvail(ExprInfo exprInfo, Phi phi) {
        phi.setCanBeAvail(false);
        Iterator blocks = this.cfg.nodes().iterator();
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            Phi other = exprInfo.exprPhiAtBlock(block);
            if (other == null) continue;
            Iterator e = this.cfg.preds(block).iterator();
            while (e.hasNext()) {
                Block pred = (Block)e.next();
                Def operand = other.operandAt(pred);
                if (operand != phi || other.hasRealUse(pred)) continue;
                other.setOperandAt(pred, null);
                if (other.downSafe() || !other.canBeAvail()) continue;
                this.resetCanBeAvail(exprInfo, other);
            }
        }
    }

    private void computeLater(ExprInfo exprInfo) {
        Phi phi;
        Block block;
        Iterator blocks = this.cfg.nodes().iterator();
        while (blocks.hasNext()) {
            block = (Block)blocks.next();
            phi = exprInfo.exprPhiAtBlock(block);
            if (phi == null) continue;
            phi.setLater(phi.canBeAvail());
        }
        blocks = this.cfg.nodes().iterator();
        block1: while (blocks.hasNext()) {
            block = (Block)blocks.next();
            phi = exprInfo.exprPhiAtBlock(block);
            if (phi == null || !phi.later()) continue;
            Iterator e = this.cfg.preds(block).iterator();
            while (e.hasNext()) {
                Block pred = (Block)e.next();
                Def operand = phi.operandAt(pred);
                if (operand == null || !phi.hasRealUse(pred)) continue;
                this.resetLater(exprInfo, phi);
                continue block1;
            }
        }
    }

    private void resetLater(ExprInfo exprInfo, Phi phi) {
        phi.setLater(false);
        Iterator blocks = this.cfg.nodes().iterator();
        block0: while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            Phi other = exprInfo.exprPhiAtBlock(block);
            if (other == null) continue;
            Iterator e = this.cfg.preds(block).iterator();
            while (e.hasNext()) {
                Block pred = (Block)e.next();
                Def operand = other.operandAt(pred);
                if (operand != phi || !other.later()) continue;
                this.resetLater(exprInfo, other);
                continue block0;
            }
        }
    }

    private void finalize(ExprInfo exprInfo) {
        this.finalizeVisit(exprInfo, this.cfg.source(), null);
    }

    private void finalizeVisit(ExprInfo exprInfo, Block block, Def top) {
        Phi phi;
        if (DEBUG) {
            System.out.println("    finalizing " + block);
        }
        if ((phi = exprInfo.exprPhiAtBlock(block)) != null) {
            if (phi.willBeAvail()) {
                exprInfo.setAvailDef(phi, phi);
                top = phi;
            } else {
                top = null;
            }
        }
        Iterator reals = exprInfo.realsAtBlock(block).iterator();
        while (reals.hasNext()) {
            Def def;
            Expr real = (Expr)reals.next();
            if (DEBUG) {
                System.out.println("        -----------");
            }
            Assert.isTrue((def = exprInfo.def(real)) != null, real + " is undefined");
            Def availDef = exprInfo.availDef(def);
            if (availDef == null || availDef != top) {
                top = new RealDef(real);
                exprInfo.setAvailDef(def, top);
                continue;
            }
            if (availDef instanceof RealDef) {
                exprInfo.setReload(real, true);
                exprInfo.setSave(((RealDef)availDef).expr, true);
                continue;
            }
            Assert.isTrue(availDef instanceof Phi);
            exprInfo.setReload(real, true);
        }
        Iterator succs = this.cfg.succs(block).iterator();
        while (succs.hasNext()) {
            Block succ = (Block)succs.next();
            Phi succPhi = exprInfo.exprPhiAtBlock(succ);
            if (succPhi == null || !succPhi.willBeAvail()) continue;
            if (succPhi.canInsert(block)) {
                succPhi.setSaveOperand(block, true);
                continue;
            }
            Def operand = succPhi.operandAt(block);
            Assert.isTrue(operand != null);
            Def availDef = exprInfo.availDef(operand);
            if (!(availDef instanceof RealDef)) continue;
            exprInfo.setSave(((RealDef)availDef).expr, true);
        }
        Iterator children = this.cfg.domChildren(block).iterator();
        while (children.hasNext()) {
            Block child = (Block)children.next();
            this.finalizeVisit(exprInfo, child, top);
        }
    }

    private void codeMotion(ExprInfo exprInfo, VarExpr tmp, SSAConstructionInfo consInfo) {
        Block block;
        List[] targets = new List[this.cfg.size()];
        Iterator blocks = this.cfg.nodes().iterator();
        while (blocks.hasNext()) {
            block = (Block)blocks.next();
            Phi phi = exprInfo.exprPhiAtBlock(block);
            if (phi != null) {
                Iterator preds = this.cfg.preds(block).iterator();
                while (preds.hasNext()) {
                    int predIndex;
                    Block pred = (Block)preds.next();
                    if (!phi.saveOperand(pred)) continue;
                    Expr operand = this.buildPhiOperand(exprInfo, phi, pred);
                    Assert.isTrue(operand != null);
                    VarExpr t = (VarExpr)tmp.clone();
                    t.setValueNumber(operand.valueNumber());
                    StoreExpr store = new StoreExpr(t, operand, t.type());
                    store.setValueNumber(operand.valueNumber());
                    pred.tree().addStmtBeforeJump(new ExprStmt(store));
                    if (DEBUG) {
                        System.out.println("Created new store: " + store);
                    }
                    if (targets[predIndex = this.cfg.preOrderIndex(pred)] == null) {
                        targets[predIndex] = new ArrayList();
                    }
                    targets[predIndex].add(t);
                    if (!DEBUG) continue;
                    System.out.println("insert at end of " + pred + ": " + store);
                }
            }
            Iterator e = exprInfo.realsAtBlock(block).iterator();
            while (e.hasNext()) {
                Expr real = (Expr)e.next();
                if (exprInfo.save(real)) {
                    if (!real.isDef()) {
                        this.save(exprInfo, tmp, real, consInfo);
                        continue;
                    }
                    this.saveTarget(exprInfo, tmp, real, consInfo);
                    continue;
                }
                if (!exprInfo.reload(real)) continue;
                Assert.isFalse(real.isDef(), "Can't reload a def: " + real + " in " + real.parent());
                this.reload(exprInfo, tmp, real, consInfo);
            }
        }
        blocks = this.cfg.nodes().iterator();
        while (blocks.hasNext()) {
            block = (Block)blocks.next();
            int blockIndex = this.cfg.preOrderIndex(block);
            if (targets[blockIndex] == null) continue;
            Iterator iter = targets[blockIndex].iterator();
            while (iter.hasNext()) {
                VarExpr t = (VarExpr)iter.next();
                consInfo.addReal(t);
            }
        }
    }

    private void save(ExprInfo exprInfo, VarExpr tmp, Expr real, SSAConstructionInfo consInfo) {
        if (DEBUG) {
            System.out.println("SAVE: " + real + " to " + tmp + "--------------------------------");
        }
        if (real instanceof CheckExpr && exprInfo.hasStackVariable()) {
            return;
        }
        Node parent = real.parent();
        VarExpr t = (VarExpr)tmp.clone();
        t.setValueNumber(real.valueNumber());
        StoreExpr store = new StoreExpr(t, real, real.type());
        store.setValueNumber(real.valueNumber());
        parent.visit(new ReplaceVisitor(real, store));
        consInfo.addReal(t);
        if (DEBUG) {
            System.out.println("END SAVE--------------------------------");
        }
    }

    private void reload(ExprInfo exprInfo, VarExpr tmp, Expr real, SSAConstructionInfo consInfo) {
        Expr t;
        if (DEBUG) {
            System.out.println("RELOAD: " + real + " to " + tmp + "--------------------------------");
        }
        if (real instanceof CheckExpr && exprInfo.hasStackVariable()) {
            t = ((CheckExpr)real).expr();
            real.parent().visit(new ReplaceVisitor(real, t));
            real.cleanupOnly();
        } else {
            t = (VarExpr)tmp.clone();
            t.setValueNumber(real.valueNumber());
            real.replaceWith(t);
            consInfo.addReal((VarExpr)t);
        }
        if (DEBUG) {
            System.out.println("reload t " + t + " in " + t.parent());
        }
        if (DEBUG) {
            System.out.println("END RELOAD--------------------------------");
        }
    }

    private void saveTarget(ExprInfo exprInfo, VarExpr tmp, Expr real, SSAConstructionInfo consInfo) {
        if (DEBUG) {
            System.out.println("SAVE TARGET: " + real + " to " + tmp + "--------------------------------");
        }
        Assert.isTrue(real instanceof MemRefExpr);
        VarExpr t = (VarExpr)tmp.clone();
        t.setValueNumber(real.valueNumber());
        StoreExpr store = (StoreExpr)real.parent();
        Expr rhs = store.expr();
        StoreExpr rhsStore = new StoreExpr(t, rhs, rhs.type());
        rhsStore.setValueNumber(real.valueNumber());
        store.visit(new ReplaceVisitor(rhs, rhsStore));
        consInfo.addReal(t);
        if (DEBUG) {
            System.out.println("save target " + store);
        }
        if (DEBUG) {
            System.out.println("END SAVE TARGET------------------------------");
        }
    }

    boolean isFirstOrder(Expr expr) {
        FirstOrderChecker f = new FirstOrderChecker();
        expr.visit(f);
        return f.firstOrder;
    }

    Expr phiRelatedFind(Expr a) {
        ArrayList<Expr> stack = new ArrayList<Expr>();
        while (a != null) {
            Object p = this.phiRelated.get(a);
            if (p == a || p == null) {
                Iterator iter = stack.iterator();
                while (iter.hasNext()) {
                    p = iter.next();
                    if (p == a) continue;
                    this.phiRelated.put(p, a);
                }
                return a;
            }
            stack.add(a);
            a = (Expr)p;
        }
        return null;
    }

    void phiRelatedUnion(Expr a, Expr b) {
        Expr q;
        Expr p = this.phiRelatedFind(a);
        if (p != (q = this.phiRelatedFind(b))) {
            this.phiRelated.put(p, q);
        }
    }

    class ExprKey {
        Expr expr;
        int hash;

        public ExprKey(Expr expr) {
            this.expr = expr;
            this.hash = NodeComparator.hashCode(expr) + expr.type().hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        private List listChildren(Expr expr) {
            ArrayList children = new ArrayList();
            if (expr instanceof StoreExpr) {
                expr = ((StoreExpr)expr).target();
            }
            expr.visitChildren(new TreeVisitor(this, children){
                private final /* synthetic */ List val$children;
                private final /* synthetic */ ExprKey this$1;
                {
                    this.this$1 = this$1;
                    this.val$children = val$children;
                }

                public void visitStoreExpr(StoreExpr expr) {
                    this.val$children.add(expr.target());
                }

                public void visitExpr(Expr expr) {
                    this.val$children.add(expr);
                }
            });
            return children;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExprKey) {
                ExprKey other = (ExprKey)obj;
                if (!this.expr.type().equals(other.expr.type())) {
                    return false;
                }
                if (!NodeComparator.equals(this.expr, other.expr)) {
                    return false;
                }
                List children = this.listChildren(this.expr);
                List otherChildren = this.listChildren(other.expr);
                if (children.size() != otherChildren.size()) {
                    return false;
                }
                Iterator iter1 = children.iterator();
                Iterator iter2 = otherChildren.iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    Expr child2;
                    Expr child1 = (Expr)iter1.next();
                    if (child1 instanceof StackExpr != (child2 = (Expr)iter2.next()) instanceof StackExpr) {
                        return false;
                    }
                    if (child1 instanceof VarExpr && child2 instanceof VarExpr) {
                        if (SSAPRE.this.phiRelatedFind(child1.def()) == SSAPRE.this.phiRelatedFind(child2.def())) continue;
                        return false;
                    }
                    Assert.isTrue(child1 instanceof ConstantExpr || child2 instanceof ConstantExpr, "neither " + child1 + " nor " + child2 + " are constants");
                    if (child1.valueNumber() == child2.valueNumber()) continue;
                    return false;
                }
                return !iter1.hasNext() && !iter2.hasNext();
            }
            return false;
        }
    }

    class MemRefKill
    extends Kill {
        public MemRefKill(Expr expr, int key) {
            super(expr, key);
        }

        public MemRefKill(int key) {
            super(key);
        }
    }

    class ExceptionKill
    extends Kill {
        public ExceptionKill(Expr expr, int key) {
            super(expr, key);
        }

        public ExceptionKill(int key) {
            super(key);
        }
    }

    abstract class Kill {
        int key;
        Expr expr;

        public Kill(Expr expr, int key) {
            this.expr = expr;
            this.key = key;
        }

        public Kill(int key) {
            this(null, key);
        }

        public int key() {
            return this.key;
        }
    }

    class ExprWorklist {
        Map exprInfos = new HashMap();
        LinkedList exprs = new LinkedList();

        public boolean isEmpty() {
            return this.exprs.isEmpty();
        }

        public ExprInfo removeFirst() {
            ExprInfo exprInfo = (ExprInfo)this.exprs.removeFirst();
            this.exprInfos.remove(exprInfo.key);
            return exprInfo;
        }

        public void addReal(Expr real) {
            ExprKey key;
            ExprInfo exprInfo;
            if (DEBUG) {
                System.out.println("    add to worklist=" + real);
            }
            if ((exprInfo = (ExprInfo)this.exprInfos.get(key = new ExprKey(real))) == null) {
                exprInfo = new ExprInfo(real, key);
                this.exprs.add(exprInfo);
                this.exprInfos.put(key, exprInfo);
                if (DEBUG) {
                    System.out.println("    add info");
                }
            }
            exprInfo.addReal(real);
        }

        public void addKill(Block block, Kill kill) {
            if (DEBUG) {
                System.out.println("    add alias to worklist=" + kill.expr + " " + kill);
            }
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            SSAPRE.this.kills[blockIndex].add(kill);
            SSAPRE.this.killsSorted[blockIndex] = false;
        }
    }

    class FinalChecker
    extends TreeVisitor {
        public boolean isFinal = true;

        FinalChecker() {
        }

        public void visitExpr(Expr expr) {
            if (this.isFinal) {
                expr.visitChildren(this);
            }
        }

        public void visitArrayRefExpr(ArrayRefExpr expr) {
            this.isFinal = false;
        }

        public void visitFieldExpr(FieldExpr expr) {
            MemberRef field = expr.field();
            try {
                FieldEditor e = SSAPRE.this.context.editField(field);
                if (!e.isFinal()) {
                    this.isFinal = false;
                }
                SSAPRE.this.context.release(e.fieldInfo());
            }
            catch (NoSuchFieldException e) {
                this.isFinal = false;
            }
            if (this.isFinal) {
                expr.visitChildren(this);
            }
        }

        public void visitStaticFieldExpr(StaticFieldExpr expr) {
            MemberRef field = expr.field();
            try {
                FieldEditor e = SSAPRE.this.context.editField(field);
                if (!e.isFinal()) {
                    this.isFinal = false;
                }
                SSAPRE.this.context.release(e.fieldInfo());
            }
            catch (NoSuchFieldException e) {
                this.isFinal = false;
            }
            if (this.isFinal) {
                expr.visitChildren(this);
            }
        }
    }

    private final class ExprInfo {
        ExprKey key;
        private int numUses;
        private List[] reals;
        private boolean[] realsSorted;
        private Phi[] phis;
        Map defs;
        Map availDefs;
        Map saves;
        Map reloads;
        private Expr prototype;
        private boolean isFinal;
        private boolean hasSideEffects;
        private boolean hasStackVariable;

        public ExprInfo(Expr expr, ExprKey key) {
            this.key = key;
            this.prototype = (Expr)expr.clone();
            this.prototype.visitChildren(new TreeVisitor(this){
                private final /* synthetic */ ExprInfo this$1;
                {
                    this.this$1 = this$1;
                }

                public void visitStoreExpr(StoreExpr expr) {
                    expr.target().setDef(null);
                    expr.target().setParent(null);
                    expr.replaceWith(expr.target(), false);
                    expr.cleanupOnly();
                    expr.expr().cleanup();
                }

                public void visitVarExpr(VarExpr expr) {
                    expr.setDef(null);
                }

                public void visitConstantExpr(ConstantExpr expr) {
                }

                public void visitExpr(Expr expr) {
                    throw new RuntimeException();
                }
            });
            this.numUses = 0;
            this.reals = new ArrayList[SSAPRE.this.cfg.size()];
            this.realsSorted = new boolean[SSAPRE.this.cfg.size()];
            for (int i = 0; i < this.reals.length; ++i) {
                this.reals[i] = new ArrayList();
                this.realsSorted[i] = false;
            }
            this.phis = new Phi[SSAPRE.this.cfg.size()];
            this.defs = new HashMap();
            this.availDefs = new HashMap();
            this.saves = new HashMap();
            this.reloads = new HashMap();
            if (this.prototype instanceof MemRefExpr) {
                FinalChecker fch = new FinalChecker();
                this.prototype.visit(fch);
                this.isFinal = fch.isFinal;
            } else {
                this.isFinal = true;
            }
            SSAPRE.this.sideEffects.reset();
            this.prototype.visit(SSAPRE.this.sideEffects);
            int flag = SSAPRE.this.sideEffects.sideEffects();
            flag &= 0xFFFFFF7F;
            flag &= 0xFFFFFEFF;
            flag &= 0xFFFFFFDF;
            boolean bl = this.hasSideEffects = (flag &= 0xFFFFFFBF) != 0;
            if ((flag & 1) != 0) {
                Assert.isTrue(this.prototype instanceof CheckExpr);
                this.hasStackVariable = true;
            }
        }

        public boolean hasStackVariable() {
            return this.hasStackVariable;
        }

        public boolean hasSideEffects() {
            return this.hasSideEffects;
        }

        public int numUses() {
            return this.numUses;
        }

        public void cleanup() {
            this.reals = null;
            this.phis = null;
            this.saves = null;
            this.reloads = null;
            this.defs = null;
            this.availDefs = null;
            this.prototype = null;
        }

        public void setReload(Expr expr, boolean flag) {
            if (DEBUG) {
                System.out.println("        setting reload for " + expr + " to " + flag);
            }
            this.reloads.put(expr, new Boolean(flag));
        }

        public boolean reload(Expr expr) {
            Boolean flag = (Boolean)this.reloads.get(expr);
            return flag != null && flag != false;
        }

        public void setSave(Expr expr, boolean flag) {
            if (DEBUG) {
                System.out.println("        setting save for " + expr + " to " + flag);
            }
            this.saves.put(expr, new Boolean(flag));
        }

        public boolean save(Expr expr) {
            Boolean flag = (Boolean)this.saves.get(expr);
            return flag != null && flag != false;
        }

        public void setAvailDef(Def def, Def availDef) {
            if (DEBUG) {
                System.out.println("        setting avail def for " + def + " to " + availDef);
            }
            this.availDefs.put(def, availDef);
        }

        public Def availDef(Def def) {
            Def availDef = (Def)this.availDefs.get(def);
            if (DEBUG) {
                System.out.println("        avail def for " + def + " is " + availDef);
            }
            return availDef;
        }

        public void setDef(Expr expr, Def def) {
            if (DEBUG) {
                System.out.println("        setting def for " + expr + " to " + def);
            }
            if (def != null) {
                this.defs.put(expr, def);
            } else {
                this.defs.remove(expr);
            }
        }

        public Def def(Expr expr) {
            Def def = (Def)this.defs.get(expr);
            if (DEBUG) {
                System.out.println("        def for " + expr + " is " + def);
            }
            return def;
        }

        public Expr prototype() {
            return this.prototype;
        }

        public void addReal(Expr real) {
            if (!real.isDef()) {
                ++this.numUses;
            }
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(real.block());
            this.reals[blockIndex].add(real);
            this.realsSorted[blockIndex] = false;
        }

        public void addPhi(Block block) {
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            if (this.phis[blockIndex] == null) {
                if (DEBUG) {
                    System.out.println("    add phi for " + this.prototype + " at " + block);
                }
                this.phis[blockIndex] = new Phi(this, block);
            }
        }

        public void removePhi(Block block) {
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            this.phis[blockIndex] = null;
        }

        public Phi exprPhiAtBlock(Block block) {
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            return this.phis[blockIndex];
        }

        public List realsAtBlock(Block block) {
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            List r = this.reals[blockIndex];
            if (!this.realsSorted[blockIndex]) {
                this.sortExprs(r);
                this.realsSorted[blockIndex] = true;
            }
            return r;
        }

        public List occurrencesAtBlock(Block block) {
            if (this.isFinal && !this.hasSideEffects) {
                return this.realsAtBlock(block);
            }
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            ResizeableArrayList a = SSAPRE.this.kills[blockIndex];
            List r = this.reals[blockIndex];
            if (!SSAPRE.this.killsSorted[blockIndex]) {
                this.sortKills(a);
                SSAPRE.this.killsSorted[blockIndex] = true;
            }
            if (!this.realsSorted[blockIndex]) {
                this.sortExprs(r);
                this.realsSorted[blockIndex] = true;
            }
            return new AbstractList(this, r, a){
                private final /* synthetic */ List val$r;
                private final /* synthetic */ List val$a;
                private final /* synthetic */ ExprInfo this$1;
                {
                    this.this$1 = this$1;
                    this.val$r = val$r;
                    this.val$a = val$a;
                }

                public int size() {
                    return this.val$r.size() + this.val$a.size();
                }

                public boolean contains(Object obj) {
                    if (obj instanceof Kill) {
                        return this.val$a.contains(obj);
                    }
                    if (obj instanceof Expr) {
                        return this.val$r.contains(obj);
                    }
                    return false;
                }

                public Object get(int index) {
                    throw new UnsupportedOperationException();
                }

                public Iterator iterator() {
                    return new Iterator(this){
                        Iterator aiter;
                        Iterator riter;
                        Kill anext;
                        Expr rnext;
                        private final /* synthetic */ 11 this$2;
                        {
                            this.this$2 = this$2;
                            this.aiter = 11.access$100(this.this$2).iterator();
                            this.riter = 11.access$200(this.this$2).iterator();
                            this.anext = this.aiter.hasNext() ? (Kill)this.aiter.next() : null;
                            this.rnext = this.riter.hasNext() ? (Expr)this.riter.next() : null;
                        }

                        public boolean hasNext() {
                            return this.anext != null || this.rnext != null;
                        }

                        public Object next() {
                            boolean real = false;
                            if (this.anext == null) {
                                if (this.rnext == null) {
                                    throw new NoSuchElementException();
                                }
                                real = true;
                            } else {
                                real = this.rnext == null ? false : this.anext.key() > this.rnext.key();
                            }
                            if (real) {
                                Expr t = this.rnext;
                                this.rnext = this.riter.hasNext() ? (Expr)this.riter.next() : null;
                                return t;
                            }
                            Kill t = this.anext;
                            this.anext = this.aiter.hasNext() ? (Kill)this.aiter.next() : null;
                            return t;
                        }

                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public ListIterator listIterator() {
                    throw new UnsupportedOperationException();
                }

                static /* synthetic */ List access$100(11 x0) {
                    return x0.val$a;
                }

                static /* synthetic */ List access$200(11 x0) {
                    return x0.val$r;
                }
            };
        }

        private void sortExprs(List list) {
            Collections.sort(list, new Comparator(this){
                private final /* synthetic */ ExprInfo this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object a, Object b) {
                    if (a == b) {
                        return 0;
                    }
                    int ka = ((Expr)a).key();
                    int kb = ((Expr)b).key();
                    return ka - kb;
                }
            });
        }

        private void sortKills(List list) {
            Collections.sort(list, new Comparator(this){
                private final /* synthetic */ ExprInfo this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object a, Object b) {
                    if (a == b) {
                        return 0;
                    }
                    int ka = ((Kill)a).key();
                    int kb = ((Kill)b).key();
                    return ka - kb;
                }
            });
        }

        protected void print() {
            System.out.println("Print for " + this.prototype + "------------------");
            SSAPRE.this.cfg.visit(new PrintVisitor(this){
                Phi phi;
                private final /* synthetic */ ExprInfo this$1;
                {
                    this.this$1 = this$1;
                    this.phi = null;
                }

                public void visitBlock(Block block) {
                    this.phi = this.this$1.exprPhiAtBlock(block);
                    super.visitBlock(block);
                }

                public void visitLabelStmt(LabelStmt stmt) {
                    super.visitLabelStmt(stmt);
                    if (stmt.label().startsBlock() && this.phi != null) {
                        this.println(this.phi);
                        this.phi = null;
                    }
                }
            });
            System.out.println("End Print ----------------------------");
        }
    }

    class Phi
    extends Def {
        Block block;
        Def[] operands;
        boolean[] hasRealUse;
        boolean[] saveOperand;
        boolean downSafe;
        boolean canBeAvail;
        boolean later;
        boolean live;
        List leaves;

        public Phi(ExprInfo exprInfo, Block block) {
            this.block = block;
            int size = SSAPRE.this.cfg.size();
            this.operands = new Def[size];
            this.hasRealUse = new boolean[size];
            this.saveOperand = new boolean[size];
            this.leaves = null;
            this.downSafe = true;
            this.canBeAvail = true;
            this.later = true;
            this.live = false;
        }

        public Block block() {
            return this.block;
        }

        public void setLeaves(List leaves) {
            if (DEBUG) {
                System.out.println("setting leaves of " + this + " to " + leaves);
            }
            this.leaves = new ArrayList(leaves);
        }

        public List leaves() {
            Assert.isTrue(this.leaves != null);
            Iterator iter = this.leaves.iterator();
            while (iter.hasNext()) {
                Expr e = (Expr)iter.next();
                Assert.isTrue(e instanceof VarExpr || e instanceof ConstantExpr, "not a leaf: " + e);
            }
            return this.leaves;
        }

        public Collection operands() {
            LinkedList<Def> v = new LinkedList<Def>();
            Iterator preds = SSAPRE.this.cfg.preds(this.block).iterator();
            while (preds.hasNext()) {
                Block pred = (Block)preds.next();
                v.addFirst(this.operandAt(pred));
            }
            return v;
        }

        public void setOperandAt(Block block, Def def) {
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            this.operands[blockIndex] = def;
            if (DEBUG) {
                System.out.println(this);
            }
        }

        public Def operandAt(Block block) {
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            return this.operands[blockIndex];
        }

        public void setHasRealUse(Block block, boolean flag) {
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            this.hasRealUse[blockIndex] = flag;
            if (DEBUG) {
                System.out.println(this);
            }
        }

        public boolean hasRealUse(Block block) {
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            return this.hasRealUse[blockIndex];
        }

        public void setSaveOperand(Block block, boolean flag) {
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            this.saveOperand[blockIndex] = flag;
            if (DEBUG) {
                System.out.println(this);
            }
        }

        public boolean saveOperand(Block block) {
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            return this.saveOperand[blockIndex];
        }

        public boolean canInsert(Block block) {
            Phi phi;
            int blockIndex = SSAPRE.this.cfg.preOrderIndex(block);
            Def def = this.operands[blockIndex];
            if (def == null) {
                return true;
            }
            return !this.hasRealUse[blockIndex] && def instanceof Phi && !(phi = (Phi)def).willBeAvail();
        }

        public boolean willBeAvail() {
            return this.canBeAvail && !this.later;
        }

        public void setCanBeAvail(boolean flag) {
            this.canBeAvail = flag;
            if (DEBUG) {
                System.out.println(this);
            }
        }

        public boolean canBeAvail() {
            return this.canBeAvail;
        }

        public void setLater(boolean flag) {
            this.later = flag;
            if (DEBUG) {
                System.out.println(this);
            }
        }

        public boolean later() {
            return this.later;
        }

        public void setLive(boolean flag) {
            this.live = flag;
        }

        public boolean live() {
            return this.live;
        }

        public void setDownSafe(boolean flag) {
            this.downSafe = flag;
            if (DEBUG) {
                System.out.println(this);
            }
        }

        public boolean downSafe() {
            return this.downSafe;
        }

        public String toString() {
            String s = "Phi_" + this.version + "[";
            if (!this.downSafe) {
                s = s + "!";
            }
            s = s + "DS,";
            if (!this.canBeAvail) {
                s = s + "!";
            }
            s = s + "CBA,";
            if (!this.later) {
                s = s + "!";
            }
            s = s + "later](";
            if (this.operands != null) {
                Iterator e = SSAPRE.this.cfg.preds(this.block).iterator();
                while (e.hasNext()) {
                    Block pred = (Block)e.next();
                    int predIndex = SSAPRE.this.cfg.preOrderIndex(pred);
                    s = s + pred.label() + "=";
                    Def operand = this.operands[predIndex];
                    s = operand == null ? s + "undef[" : s + operand.version + "[";
                    if (!this.hasRealUse[predIndex]) {
                        s = s + "!";
                    }
                    s = s + "HRU,";
                    if (!this.saveOperand[predIndex]) {
                        s = s + "!";
                    }
                    s = s + "save,";
                    if (!this.canInsert(pred)) {
                        s = s + "!";
                    }
                    s = s + "insert]";
                    if (!e.hasNext()) continue;
                    s = s + ", ";
                }
            }
            s = s + ")";
            return s;
        }
    }

    class RealDef
    extends Def {
        Expr expr;

        public RealDef(Expr expr) {
            this.expr = expr;
        }

        public String toString() {
            return "[" + this.expr + "]_" + this.version;
        }
    }

    abstract class Def {
        int version;

        Def() {
            this.version = SSAPRE.this.next++;
        }
    }

    class Bool {
        boolean value = false;

        Bool() {
        }
    }

    class Int {
        int value = 0;

        Int() {
        }
    }

    private final class FirstOrderChecker
    extends TreeVisitor {
        boolean firstOrder = false;

        private FirstOrderChecker() {
        }

        public void visitExpr(Expr expr) {
        }

        private boolean isLeaf(Expr expr) {
            if (expr instanceof StoreExpr) {
                return ((StoreExpr)expr).target() instanceof LocalExpr;
            }
            return expr instanceof LocalExpr || expr instanceof ConstantExpr;
        }

        public void visitCheckExpr(CheckExpr expr) {
            if (this.isLeaf(expr.expr()) || expr.expr() instanceof StackExpr) {
                this.firstOrder = true;
            }
        }

        public void visitArithExpr(ArithExpr expr) {
            if (this.isLeaf(expr.left()) && this.isLeaf(expr.right())) {
                this.firstOrder = true;
            }
        }

        public void visitArrayLengthExpr(ArrayLengthExpr expr) {
            if (this.isLeaf(expr.array())) {
                this.firstOrder = true;
            }
        }

        public void visitArrayRefExpr(ArrayRefExpr expr) {
            if (NO_ACCESS_PATHS) {
                return;
            }
            if (this.isLeaf(expr.array()) && this.isLeaf(expr.index())) {
                this.firstOrder = true;
            }
        }

        public void visitCastExpr(CastExpr expr) {
            if (this.isLeaf(expr.expr())) {
                this.firstOrder = true;
            }
        }

        public void visitFieldExpr(FieldExpr expr) {
            if (NO_ACCESS_PATHS) {
                return;
            }
            if (this.isLeaf(expr.object())) {
                try {
                    FieldEditor e = SSAPRE.this.context.editField(expr.field());
                    if (!e.isVolatile()) {
                        this.firstOrder = true;
                    }
                    SSAPRE.this.context.release(e.fieldInfo());
                }
                catch (NoSuchFieldException e) {
                    this.firstOrder = false;
                }
            }
        }

        public void visitInstanceOfExpr(InstanceOfExpr expr) {
            if (this.isLeaf(expr.expr())) {
                this.firstOrder = true;
            }
        }

        public void visitNegExpr(NegExpr expr) {
            if (this.isLeaf(expr.expr())) {
                this.firstOrder = true;
            }
        }

        public void visitShiftExpr(ShiftExpr expr) {
            if (this.isLeaf(expr.expr()) && this.isLeaf(expr.bits())) {
                this.firstOrder = true;
            }
        }

        public void visitStaticFieldExpr(StaticFieldExpr expr) {
            if (NO_ACCESS_PATHS) {
                return;
            }
            try {
                FieldEditor e = SSAPRE.this.context.editField(expr.field());
                if (!e.isVolatile()) {
                    this.firstOrder = true;
                }
                SSAPRE.this.context.release(e.fieldInfo());
            }
            catch (NoSuchFieldException e) {
                this.firstOrder = false;
            }
        }
    }

    class Pair {
        Object a;
        Object b;

        Pair(Object a, Object b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            return o instanceof Pair && ((Pair)o).a.equals(this.a) && ((Pair)o).b.equals(this.b);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode();
        }
    }
}

