/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.Switch;
import EDU.purdue.cs.bloat.editor.TryCatch;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;

public class Peephole
implements Opcode {
    public static boolean DEBUG = false;

    public static void transform(MethodEditor method) {
        if (DEBUG) {
            System.out.println("Peephole optimizing " + method);
        }
        HashMap targets = new HashMap();
        LinkedList<Instruction> jumps = new LinkedList<Instruction>();
        Instruction next = null;
        Instruction nextInst = null;
        List code = method.code();
        block0: for (int i = code.size() - 1; i >= 0; --i) {
            Object ce = code.get(i);
            if (ce instanceof Label) {
                if (nextInst != null) {
                    targets.put(ce, nextInst);
                }
                next = null;
                continue;
            }
            if (!(ce instanceof Instruction)) continue;
            Instruction inst = (Instruction)ce;
            Filter peep = null;
            boolean seenLabel = false;
            if (inst.isGoto()) {
                Label target = (Label)inst.operand();
                for (int j = i + 1; j < code.size(); ++j) {
                    Object t = code.get(j);
                    if (t instanceof Label) {
                        if (((Label)t).startsBlock()) {
                            seenLabel = true;
                        }
                        if (!target.equals(t)) continue;
                        code.remove(i);
                        next = null;
                        nextInst = null;
                        continue block0;
                    }
                    if (!(t instanceof Instruction)) continue;
                    if (seenLabel) break;
                    code.remove(j);
                    --j;
                }
            }
            if (inst.isGoto() || inst.isSwitch()) {
                jumps.add(inst);
            }
            if (next != null) {
                peep = Peephole.filter(inst, next);
            }
            if (peep != null) {
                if (ClassEditor.DEBUG) {
                    if (peep.replace.length == 0) {
                        System.out.println("eliminate " + code.get(i) + "-" + code.get(i + 1));
                    } else {
                        System.out.println("replace " + code.get(i) + "-" + code.get(i + 1));
                        System.out.println("   with");
                        for (int j = 0; j < peep.replace.length; ++j) {
                            System.out.println("   " + peep.replace[j]);
                        }
                    }
                }
                code.remove(i + 1);
                code.remove(i);
                for (int j = peep.replace.length - 1; j >= 0; --j) {
                    code.add(i, peep.replace[j]);
                }
                next = i < code.size() && code.get(i) instanceof Instruction ? (Instruction)code.get(i) : null;
            } else {
                next = inst;
            }
            nextInst = next;
        }
        while (!jumps.isEmpty()) {
            Instruction target;
            Instruction inst = (Instruction)jumps.removeFirst();
            if (!inst.isGoto() || (target = (Instruction)targets.get(inst.operand())) == null) continue;
            if (target.isGoto() && !target.operand().equals(inst.operand())) {
                if (ClassEditor.DEBUG) {
                    System.out.println("replace " + inst);
                }
                inst.setOperand(target.operand());
                if (ClassEditor.DEBUG) {
                    System.out.println("   with " + inst);
                }
                jumps.add(inst);
                continue;
            }
            if (!target.isSwitch() && !target.isReturn() && !target.isThrow()) continue;
            if (ClassEditor.DEBUG) {
                System.out.println("replace " + inst);
            }
            inst.setOpcodeClass(target.opcodeClass());
            inst.setOperand(target.operand());
            if (!ClassEditor.DEBUG) continue;
            System.out.println("   with " + inst);
        }
        Peephole.removeUnreachable(method, code);
        if (ClassEditor.DEBUG) {
            System.out.println("END PEEPHOLE---------------------------------");
        }
    }

    private static void removeUnreachable(MethodEditor method, List code) {
        Label label;
        HashMap labelPos = new HashMap();
        Iterator iter = code.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Object ce = iter.next();
            if (ce instanceof Label) {
                labelPos.put(ce, new Integer(i));
            }
            ++i;
        }
        HashSet<Label> visited = new HashSet<Label>();
        Stack<Label> stack = new Stack<Label>();
        if (code.size() > 0) {
            label = (Label)code.get(0);
            visited.add(label);
            stack.push(label);
        }
        Iterator e = method.tryCatches().iterator();
        while (e.hasNext()) {
            TryCatch tc = (TryCatch)e.next();
            visited.add(tc.handler());
            stack.push(tc.handler());
        }
        block2: while (!stack.isEmpty()) {
            label = (Label)stack.pop();
            Integer labelIndex = (Integer)labelPos.get(label);
            Assert.isTrue(labelIndex != null, "Index of " + label + " not found");
            i = labelIndex;
            ListIterator blockIter = code.listIterator(i + 1);
            while (blockIter.hasNext()) {
                Object ce = blockIter.next();
                ++i;
                if (ce instanceof Instruction) {
                    Instruction inst = (Instruction)ce;
                    if (inst.isReturn() || inst.isThrow()) continue block2;
                    if (inst.isConditionalJump() || inst.isJsr()) {
                        label = (Label)inst.operand();
                        if (visited.contains(label)) continue;
                        visited.add(label);
                        stack.push(label);
                        continue;
                    }
                    if (inst.isGoto()) {
                        label = (Label)inst.operand();
                        if (visited.contains(label)) continue block2;
                        visited.add(label);
                        stack.push(label);
                        continue block2;
                    }
                    if (inst.isRet()) continue block2;
                    if (!inst.isSwitch()) continue;
                    Switch sw = (Switch)inst.operand();
                    label = sw.defaultTarget();
                    if (!visited.contains(label)) {
                        visited.add(label);
                        stack.push(label);
                    }
                    Label[] targets = sw.targets();
                    for (int j = 0; j < targets.length; ++j) {
                        label = targets[j];
                        if (visited.contains(label)) continue;
                        visited.add(label);
                        stack.push(label);
                    }
                    continue block2;
                }
                if (!(ce instanceof Label)) continue;
                label = (Label)ce;
                visited.add(label);
            }
        }
        boolean reachable = false;
        iter = code.iterator();
        while (iter.hasNext()) {
            Object ce = iter.next();
            if (ce instanceof Label) {
                reachable = visited.contains(ce);
                continue;
            }
            if (reachable) continue;
            if (ClassEditor.DEBUG) {
                System.out.println("Removing unreachable " + ce);
            }
            iter.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Filter filter(Instruction first, Instruction second) {
        switch (second.opcodeClass()) {
            case 95: {
                if (first.opcodeClass() == 95) {
                    return new Filter();
                }
                if (first.opcodeClass() != 89) break;
                return new Filter(first);
            }
            case 87: {
                switch (first.opcodeClass()) {
                    case 18: {
                        Assert.isTrue(!(first.operand() instanceof Long) && !(first.operand() instanceof Double), "Cannot pop a 2-word operand");
                    }
                    case 21: 
                    case 23: 
                    case 25: 
                    case 89: {
                        return new Filter();
                    }
                    case 90: {
                        return new Filter(new Instruction(95));
                    }
                }
                break;
            }
            case 88: {
                switch (first.opcodeClass()) {
                    case 18: {
                        Assert.isTrue(first.operand() instanceof Long || first.operand() instanceof Double, "Cannot pop2 a 1-word operand");
                    }
                    case 22: 
                    case 24: 
                    case 92: {
                        return new Filter();
                    }
                }
                break;
            }
            case 54: {
                if (first.opcodeClass() != 21 || !first.operand().equals(second.operand())) break;
                return new Filter();
            }
            case 56: {
                if (first.opcodeClass() != 23 || !first.operand().equals(second.operand())) break;
                return new Filter();
            }
            case 58: {
                if (first.opcodeClass() != 25 || !first.operand().equals(second.operand())) break;
                return new Filter();
            }
            case 55: {
                if (first.opcodeClass() != 22 || !first.operand().equals(second.operand())) break;
                return new Filter();
            }
            case 57: {
                if (first.opcodeClass() != 24 || !first.operand().equals(second.operand())) break;
                return new Filter();
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                switch (first.opcodeClass()) {
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: {
                        return new Filter(second);
                    }
                }
                break;
            }
            case 96: {
                if (first.opcodeClass() != 116) break;
                return new Filter(new Instruction(100));
            }
            case 100: {
                if (first.opcodeClass() != 116) break;
                return new Filter(new Instruction(96));
            }
            case 97: {
                if (first.opcodeClass() != 117) break;
                return new Filter(new Instruction(101));
            }
            case 101: {
                if (first.opcodeClass() != 117) break;
                return new Filter(new Instruction(97));
            }
            case 159: {
                Object op;
                if (first.opcodeClass() != 18 || !((op = first.operand()) instanceof Integer) || (Integer)op != 0) break;
                return new Filter(new Instruction(153, second.operand()));
            }
            case 160: {
                Object op;
                if (first.opcodeClass() != 18 || !((op = first.operand()) instanceof Integer) || (Integer)op != 0) break;
                return new Filter(new Instruction(154, second.operand()));
            }
            case 161: {
                Object op;
                if (first.opcodeClass() != 18 || !((op = first.operand()) instanceof Integer) || (Integer)op != 0) break;
                return new Filter(new Instruction(155, second.operand()));
            }
            case 162: {
                Object op;
                if (first.opcodeClass() != 18 || !((op = first.operand()) instanceof Integer) || (Integer)op != 0) break;
                return new Filter(new Instruction(156, second.operand()));
            }
            case 163: {
                Object op;
                if (first.opcodeClass() != 18 || !((op = first.operand()) instanceof Integer) || (Integer)op != 0) break;
                return new Filter(new Instruction(157, second.operand()));
            }
            case 164: {
                Object op;
                if (first.opcodeClass() != 18 || !((op = first.operand()) instanceof Integer) || (Integer)op != 0) break;
                return new Filter(new Instruction(158, second.operand()));
            }
            case 165: {
                if (first.opcodeClass() != 18 || first.operand() != null) break;
                return new Filter(new Instruction(198, second.operand()));
            }
            case 166: {
                if (first.opcodeClass() != 18 || first.operand() != null) break;
                return new Filter(new Instruction(199, second.operand()));
            }
            case 153: {
                Object op;
                if (first.opcodeClass() != 18 || !((op = first.operand()) instanceof Integer)) break;
                if ((Integer)op == 0) {
                    return new Filter(new Instruction(167, second.operand()));
                }
                return new Filter();
            }
            case 154: {
                Object op;
                if (first.opcodeClass() != 18 || !((op = first.operand()) instanceof Integer)) break;
                if ((Integer)op != 0) {
                    return new Filter(new Instruction(167, second.operand()));
                }
                return new Filter();
            }
            case 155: {
                Object op;
                if (first.opcodeClass() != 18 || !((op = first.operand()) instanceof Integer)) break;
                if ((Integer)op < 0) {
                    return new Filter(new Instruction(167, second.operand()));
                }
                return new Filter();
            }
            case 156: {
                Object op;
                if (first.opcodeClass() != 18 || !((op = first.operand()) instanceof Integer)) break;
                if ((Integer)op >= 0) {
                    return new Filter(new Instruction(167, second.operand()));
                }
                return new Filter();
            }
            case 157: {
                Object op;
                if (first.opcodeClass() != 18 || !((op = first.operand()) instanceof Integer)) break;
                if ((Integer)op > 0) {
                    return new Filter(new Instruction(167, second.operand()));
                }
                return new Filter();
            }
            case 158: {
                Object op;
                if (first.opcodeClass() != 18 || !((op = first.operand()) instanceof Integer)) break;
                if ((Integer)op <= 0) {
                    return new Filter(new Instruction(167, second.operand()));
                }
                return new Filter();
            }
        }
        switch (second.opcodeClass()) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                switch (first.opcodeClass()) {
                    case 54: 
                    case 56: 
                    case 58: {
                        if (!first.operand().equals(second.operand())) break;
                        return new Filter(new Instruction(87), first);
                    }
                    case 55: 
                    case 57: {
                        if (!first.operand().equals(second.operand())) break;
                        return new Filter(new Instruction(88), first);
                    }
                }
                break;
            }
        }
        switch (second.opcodeClass()) {
            case 21: {
                if (first.opcodeClass() == 54 && first.operand().equals(second.operand())) {
                    return new Filter(new Instruction(89), first);
                }
                if (first.opcodeClass() != 21 || !first.operand().equals(second.operand())) break;
                return new Filter(first, new Instruction(89));
            }
            case 23: {
                if (first.opcodeClass() == 56 && first.operand().equals(second.operand())) {
                    return new Filter(new Instruction(89), first);
                }
                if (first.opcodeClass() != 23 || !first.operand().equals(second.operand())) break;
                return new Filter(first, new Instruction(89));
            }
            case 25: {
                if (first.opcodeClass() == 58 && first.operand().equals(second.operand())) {
                    return new Filter(new Instruction(89), first);
                }
                if (first.opcodeClass() != 25 || !first.operand().equals(second.operand())) break;
                return new Filter(first, new Instruction(89));
            }
            case 22: {
                if (first.opcodeClass() == 55 && first.operand().equals(second.operand())) {
                    return new Filter(new Instruction(92), first);
                }
                if (first.opcodeClass() != 22 || !first.operand().equals(second.operand())) break;
                return new Filter(first, new Instruction(92));
            }
            case 24: {
                if (first.opcodeClass() == 57 && first.operand().equals(second.operand())) {
                    return new Filter(new Instruction(92), first);
                }
                if (first.opcodeClass() != 24 || !first.operand().equals(second.operand())) break;
                return new Filter(first, new Instruction(92));
            }
        }
        return null;
    }

    static class Filter {
        Instruction[] replace;

        Filter() {
            this.replace = new Instruction[0];
        }

        Filter(Instruction replace) {
            this.replace = new Instruction[]{replace};
        }

        Filter(Instruction replace1, Instruction replace2) {
            this.replace = new Instruction[]{replace1, replace2};
        }
    }
}

