/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.LeafExpr;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemExpr;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.ReplaceVisitor;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.VarExpr;
import java.util.Iterator;

public class ExprPropagation {
    public static boolean DEBUG = false;
    FlowGraph cfg;
    boolean changed;

    public ExprPropagation(FlowGraph cfg) {
        this.cfg = cfg;
    }

    public void transform() {
        this.changed = true;
        while (this.changed) {
            this.changed = false;
            this.propagate();
        }
    }

    private void propagate() {
        this.cfg.visit(new TreeVisitor(){
            Iterator iter;

            public void visitTree(Tree tree) {
                this.iter = tree.stmts().iterator();
                while (this.iter.hasNext()) {
                    Stmt stmt = (Stmt)this.iter.next();
                    stmt.visit(this);
                }
            }

            public void visitStoreExpr(StoreExpr expr) {
                expr.visitChildren(this);
                if (!(expr.target() instanceof LocalExpr)) {
                    return;
                }
                LocalExpr lhs = (LocalExpr)expr.target();
                Expr rhs = expr.expr();
                if (rhs instanceof StoreExpr) {
                    StoreExpr store = (StoreExpr)rhs;
                    MemExpr rhsLHS = store.target();
                    Expr rhsRHS = store.expr();
                    if (rhsLHS instanceof LocalExpr) {
                        LocalExpr copy = (LocalExpr)lhs.clone();
                        copy.setDef(lhs);
                        if (ExprPropagation.this.propExpr(expr.block(), (LocalExpr)rhsLHS, copy)) {
                            ExprPropagation.this.changed = true;
                            expr.visit(new ReplaceVisitor(rhs, rhsRHS));
                            rhsLHS.cleanup();
                            rhs.cleanupOnly();
                        }
                        copy.cleanup();
                    }
                }
            }

            public void visitPhiStmt(PhiStmt stmt) {
                VarExpr lhs = stmt.target();
                if (!(lhs instanceof LocalExpr)) {
                    return;
                }
                Iterator e = stmt.operands().iterator();
                if (!e.hasNext()) {
                    return;
                }
                Expr rhs = (Expr)e.next();
                if (!(rhs instanceof LeafExpr)) {
                    return;
                }
                while (e.hasNext()) {
                    Expr operand = (Expr)e.next();
                    if (rhs instanceof LocalExpr) {
                        if (operand instanceof LocalExpr) {
                            if (rhs.def() == operand.def()) continue;
                            return;
                        }
                        return;
                    }
                    if (rhs instanceof ConstantExpr) {
                        if (rhs.equalsExpr(operand)) continue;
                        return;
                    }
                    return;
                }
                if (ExprPropagation.this.propExpr(stmt.block(), (LocalExpr)lhs, rhs)) {
                    ExprPropagation.this.changed = true;
                    this.iter.remove();
                }
            }
        });
    }

    boolean propExpr(Block block, LocalExpr lhs, Expr rhs) {
        if (DEBUG) {
            System.out.println("prop " + rhs + " to uses of " + lhs);
            System.out.println("    uses of lhs = " + lhs.uses());
        }
        if (rhs instanceof LocalExpr) {
            LocalExpr use;
            Iterator e = lhs.uses().iterator();
            while (e.hasNext()) {
                use = (LocalExpr)e.next();
                if (!(use.parent() instanceof PhiStmt)) continue;
                return false;
            }
            e = lhs.uses().iterator();
            while (e.hasNext()) {
                use = (LocalExpr)e.next();
                use.replaceWith((Expr)rhs.clone());
            }
            return true;
        }
        boolean replacedAll = true;
        Iterator e = lhs.uses().iterator();
        while (e.hasNext()) {
            LocalExpr use = (LocalExpr)e.next();
            if (use.parent() instanceof PhiCatchStmt) {
                replacedAll = false;
                continue;
            }
            use.replaceWith((Expr)rhs.clone());
        }
        return replacedAll;
    }
}

