/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.editor.IncOperand;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.trans.ArrayList2;
import java.util.ArrayList;
import java.util.Iterator;

public class CompactArrayInitializer
implements Opcode {
    public static boolean DEBUG = false;
    private static final MemberRef GET_CHARS;
    private static final int EXPECT_SIZE = 0;
    private static final int EXPECT_NEW = 1;
    private static final int EXPECT_DUP = 2;
    private static final int EXPECT_INDEX_OR_SIZE = 3;
    private static final int EXPECT_VALUE_OR_SIZE_OR_NEW = 4;
    private static final int EXPECT_STORE_OR_NEW = 5;
    private static final int EXPECT_PUT_OR_DUP = 6;
    private static final int THRESHOLD = 16;
    private static final String[] STATES;

    public static boolean transform(MethodEditor method) {
        if (DEBUG) {
            System.out.println("Compacting array initializer in " + method);
        }
        boolean filled = false;
        int state = 0;
        int size = 0;
        int value = 0;
        int index = 0;
        int[] data = null;
        Type elementType = null;
        ArrayList2 buf = new ArrayList2(method.code().size());
        Iterator iter = method.code().iterator();
        while (iter.hasNext()) {
            Object ce = iter.next();
            if (DEBUG) {
                System.out.println("Examining " + ce);
                System.out.println("state = " + STATES[state]);
            }
            if (ce instanceof Instruction) {
                Instruction inst = (Instruction)ce;
                block0 : switch (state) {
                    case 0: {
                        switch (inst.opcodeClass()) {
                            case 18: {
                                if (!(inst.operand() instanceof Byte) && !(inst.operand() instanceof Short) && !(inst.operand() instanceof Integer)) break block0;
                                size = ((Number)inst.operand()).intValue();
                                state = 1;
                                break block0;
                            }
                        }
                        state = 0;
                        break;
                    }
                    case 1: {
                        switch (inst.opcodeClass()) {
                            case 188: {
                                elementType = (Type)inst.operand();
                                if (elementType.isIntegral()) {
                                    data = new int[size];
                                    state = 2;
                                    break block0;
                                }
                                state = 0;
                                break block0;
                            }
                            case 18: {
                                if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                    size = ((Number)inst.operand()).intValue();
                                    state = 1;
                                    break block0;
                                }
                                state = 0;
                                break block0;
                            }
                        }
                        state = 0;
                        break;
                    }
                    case 2: {
                        switch (inst.opcodeClass()) {
                            case 89: {
                                state = 3;
                                break block0;
                            }
                            case 18: {
                                if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                    size = ((Number)inst.operand()).intValue();
                                    state = 1;
                                    break block0;
                                }
                                state = 0;
                                break block0;
                            }
                        }
                        state = 0;
                        break;
                    }
                    case 3: {
                        switch (inst.opcodeClass()) {
                            case 18: {
                                if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                    index = ((Number)inst.operand()).intValue();
                                    if (index < data.length) {
                                        state = 4;
                                        break block0;
                                    }
                                    size = index;
                                    state = 1;
                                    break block0;
                                }
                                state = 0;
                                break block0;
                            }
                        }
                        state = 0;
                        break;
                    }
                    case 4: {
                        switch (inst.opcodeClass()) {
                            case 18: {
                                if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                    value = ((Number)inst.operand()).intValue();
                                    state = 5;
                                    break block0;
                                }
                                if (inst.operand() instanceof Character) {
                                    Character ch = (Character)inst.operand();
                                    value = ch.charValue();
                                    state = 5;
                                    break block0;
                                }
                                state = 0;
                                break block0;
                            }
                            case 188: {
                                size = index;
                                elementType = (Type)inst.operand();
                                if (elementType.isIntegral()) {
                                    data = new int[size];
                                    state = 2;
                                    break block0;
                                }
                                state = 0;
                                break block0;
                            }
                        }
                        state = 0;
                        break;
                    }
                    case 5: {
                        switch (inst.opcodeClass()) {
                            case 84: {
                                if (!elementType.equals(Type.BYTE) && !elementType.equals(Type.BOOLEAN)) break block0;
                                data[index] = value;
                                state = 6;
                                break block0;
                            }
                            case 85: {
                                if (!elementType.equals(Type.CHARACTER)) break block0;
                                data[index] = value;
                                state = 6;
                                break block0;
                            }
                            case 86: {
                                if (!elementType.equals(Type.SHORT)) break block0;
                                data[index] = value;
                                state = 6;
                                break block0;
                            }
                            case 79: {
                                if (!elementType.equals(Type.INTEGER)) break block0;
                                data[index] = value;
                                state = 6;
                                break block0;
                            }
                            case 18: {
                                if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                    size = ((Number)inst.operand()).intValue();
                                    state = 1;
                                    break block0;
                                }
                                state = 0;
                                break block0;
                            }
                            case 188: {
                                size = value;
                                elementType = (Type)inst.operand();
                                if (elementType.isIntegral()) {
                                    data = new int[size];
                                    state = 2;
                                    break block0;
                                }
                                state = 0;
                                break block0;
                            }
                        }
                        state = 0;
                        break;
                    }
                    case 6: {
                        switch (inst.opcodeClass()) {
                            case 89: {
                                state = 3;
                                break block0;
                            }
                            case 18: {
                                if (inst.operand() instanceof Byte || inst.operand() instanceof Short || inst.operand() instanceof Integer) {
                                    size = ((Number)inst.operand()).intValue();
                                    state = 1;
                                    break block0;
                                }
                                state = 0;
                                break block0;
                            }
                            case 58: 
                            case 83: 
                            case 179: 
                            case 181: 
                            case 204: 
                            case 205: {
                                if (data.length >= 16) {
                                    CompactArrayInitializer.fillArray(method, buf, elementType, data);
                                    filled = true;
                                }
                                state = 0;
                                break block0;
                            }
                        }
                        state = 0;
                    }
                }
            } else {
                Label label = (Label)ce;
                if (label.startsBlock()) {
                    state = 0;
                }
            }
            if (DEBUG) {
                System.out.println("     -> " + STATES[state]);
            }
            buf.add(ce);
        }
        if (filled) {
            method.code().clear();
            method.code().addAll(buf);
            if (DEBUG) {
                for (int i = 0; i < method.code().size(); ++i) {
                    System.out.println("code[" + i + "] " + method.code().get(i));
                }
            }
        }
        return filled;
    }

    /*
     * WARNING - void declaration
     */
    private static void fillArray(MethodEditor m, ArrayList2 buf, Type elementType, int[] data) {
        LocalVariable array;
        void var4_4;
        int i;
        int j;
        int i2;
        char[] c;
        if (elementType.equals(Type.CHARACTER)) {
            c = new char[data.length];
            for (i2 = 0; i2 < data.length; ++i2) {
                c[i2] = (char)data[i2];
            }
        } else if (elementType.equals(Type.BYTE) || elementType.equals(Type.BOOLEAN)) {
            c = new char[(data.length + 1) / 2];
            j = 0;
            i = 0;
            while (i + 1 < data.length) {
                c[j++] = (char)(data[i] << 8 | data[i + 1] & 0xFF);
                i += 2;
            }
            if (j != c.length) {
                c[j++] = (char)(data[data.length - 1] << 8);
            }
        } else if (elementType.equals(Type.SHORT)) {
            c = new char[data.length];
            for (i2 = 0; i2 < data.length; ++i2) {
                c[i2] = (char)(data[i2] + 32768);
            }
        } else if (elementType.equals(Type.INTEGER)) {
            c = new char[data.length * 2];
            j = 0;
            for (i = 0; i < data.length; ++i) {
                int n = data[i];
                c[j++] = (char)(n >>> 16 & 0xFFFF);
                c[j++] = (char)(n >>> 0 & 0xFFFF);
            }
        } else {
            return;
        }
        ArrayList<String> image = new ArrayList<String>();
        ArrayList<Integer> startIndex = new ArrayList<Integer>();
        ArrayList<Integer> endIndex = new ArrayList<Integer>();
        StringBuffer sb = new StringBuffer();
        int utfLength = 0;
        startIndex.add(new Integer(0));
        for (int i3 = 0; i3 < ((void)var4_4).length; ++i3) {
            void n = var4_4[i3];
            int len = 0;
            len = n == false ? 2 : (n < 2048 ? 1 : (n < 32768 ? 2 : 3));
            if (utfLength + len > Short.MAX_VALUE) {
                image.add(sb.toString());
                endIndex.add(new Integer(i3));
                sb = new StringBuffer();
                utfLength = 0;
                startIndex.add(new Integer(i3));
            }
            sb.append((char)n);
            utfLength += len;
        }
        if (sb.length() > 0) {
            image.add(sb.toString());
            endIndex.add(new Integer(data.length));
        } else {
            startIndex.remove(startIndex.size() - 1);
        }
        int bufStart = -1;
        for (int i4 = buf.size() - 1; i4 >= 0; --i4) {
            Instruction inst = (Instruction)buf.get(i4);
            if (inst.opcodeClass() != 188) continue;
            buf.removeRange(i4 + 1, buf.size());
            bufStart = i4;
            break;
        }
        if (bufStart == -1) {
            return;
        }
        if (elementType.equals(Type.CHARACTER)) {
            array = m.newLocal(Type.OBJECT);
            buf.add(new Instruction(89, array));
            buf.add(new Instruction(58, array));
            for (int i5 = 0; i5 < image.size(); ++i5) {
                String im = (String)image.get(i5);
                Integer start = (Integer)startIndex.get(i5);
                Integer end = (Integer)endIndex.get(i5);
                buf.add(new Instruction(18, im));
                buf.add(new Instruction(18, new Integer(0)));
                buf.add(new Instruction(18, new Integer(im.length())));
                buf.add(new Instruction(25, array));
                buf.add(new Instruction(18, start));
                buf.add(new Instruction(182, GET_CHARS));
            }
        } else {
            array = m.newLocal(Type.OBJECT);
            LocalVariable index1 = m.newLocal(Type.INTEGER);
            LocalVariable index2 = m.newLocal(Type.INTEGER);
            LocalVariable tmp = null;
            if (elementType.equals(Type.BYTE) || elementType.equals(Type.BOOLEAN)) {
                tmp = m.newLocal(Type.CHARACTER);
            }
            for (int i6 = 0; i6 < image.size(); ++i6) {
                Label top = m.newLabel();
                top.setStartsBlock(true);
                Label bottom = m.newLabel();
                bottom.setStartsBlock(true);
                String im = (String)image.get(i6);
                Integer start = (Integer)startIndex.get(i6);
                Integer end = (Integer)endIndex.get(i6);
                if (DEBUG) {
                    System.out.println("image " + im);
                    System.out.println("start " + start);
                    System.out.println("end   " + end);
                }
                buf.add(new Instruction(18, start));
                buf.add(new Instruction(54, index1));
                buf.add(new Instruction(18, new Integer(0)));
                buf.add(new Instruction(54, index2));
                buf.add(new Instruction(18, new Integer(im.length())));
                buf.add(new Instruction(188, Type.CHARACTER));
                buf.add(new Instruction(58, array));
                buf.add(new Instruction(18, im));
                buf.add(new Instruction(18, new Integer(0)));
                buf.add(new Instruction(18, new Integer(im.length())));
                buf.add(new Instruction(25, array));
                buf.add(new Instruction(18, new Integer(0)));
                buf.add(new Instruction(182, GET_CHARS));
                buf.add(top);
                if (elementType.equals(Type.SHORT)) {
                    buf.add(new Instruction(89));
                    buf.add(new Instruction(21, index1));
                    buf.add(new Instruction(132, new IncOperand(index1, 1)));
                    buf.add(new Instruction(25, array));
                    buf.add(new Instruction(21, index2));
                    buf.add(new Instruction(132, new IncOperand(index2, 1)));
                    buf.add(new Instruction(52));
                    buf.add(new Instruction(18, new Integer(32768)));
                    buf.add(new Instruction(100));
                    buf.add(new Instruction(147));
                    buf.add(new Instruction(86));
                } else if (elementType.equals(Type.BYTE) || elementType.equals(Type.BOOLEAN)) {
                    buf.add(new Instruction(25, array));
                    buf.add(new Instruction(21, index2));
                    buf.add(new Instruction(132, new IncOperand(index2, 1)));
                    buf.add(new Instruction(52));
                    buf.add(new Instruction(54, tmp));
                    buf.add(new Instruction(89));
                    buf.add(new Instruction(21, index1));
                    buf.add(new Instruction(132, new IncOperand(index1, 1)));
                    buf.add(new Instruction(21, tmp));
                    buf.add(new Instruction(18, new Integer(8)));
                    buf.add(new Instruction(124));
                    buf.add(new Instruction(145));
                    buf.add(new Instruction(84));
                    buf.add(new Instruction(21, index1));
                    buf.add(new Instruction(18, end));
                    buf.add(new Instruction(162, bottom));
                    Label nobreak = m.newLabel();
                    nobreak.setStartsBlock(true);
                    buf.add(nobreak);
                    buf.add(new Instruction(89));
                    buf.add(new Instruction(21, index1));
                    buf.add(new Instruction(132, new IncOperand(index1, 1)));
                    buf.add(new Instruction(21, tmp));
                    buf.add(new Instruction(18, new Integer(255)));
                    buf.add(new Instruction(126));
                    buf.add(new Instruction(145));
                    buf.add(new Instruction(84));
                } else if (elementType.equals(Type.INTEGER)) {
                    buf.add(new Instruction(89));
                    buf.add(new Instruction(21, index1));
                    buf.add(new Instruction(132, new IncOperand(index1, 1)));
                    buf.add(new Instruction(25, array));
                    buf.add(new Instruction(21, index2));
                    buf.add(new Instruction(132, new IncOperand(index2, 1)));
                    buf.add(new Instruction(52));
                    buf.add(new Instruction(18, new Integer(16)));
                    buf.add(new Instruction(120));
                    buf.add(new Instruction(25, array));
                    buf.add(new Instruction(21, index2));
                    buf.add(new Instruction(132, new IncOperand(index2, 1)));
                    buf.add(new Instruction(52));
                    buf.add(new Instruction(128));
                    buf.add(new Instruction(79));
                }
                buf.add(new Instruction(21, index1));
                buf.add(new Instruction(18, end));
                buf.add(new Instruction(161, top));
                buf.add(bottom);
            }
        }
        if (DEBUG) {
            for (int i7 = bufStart; i7 < buf.size(); ++i7) {
                System.out.println("fill[" + i7 + "] " + buf.get(i7));
            }
        }
    }

    static {
        STATES = new String[]{"EXPECT_SIZE", "EXPECT_NEW", "EXPECT_DUP", "EXPECT_INDEX_OR_SIZE", "EXPECT_VALUE_OR_SIZE_OR_NEW", "EXPECT_STORE_OR_NEW", "EXPECT_PUT_OR_DUP"};
        GET_CHARS = new MemberRef(Type.STRING, new NameAndType("getChars", Type.getType("(II[CI)V")));
    }
}

