/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tbaa;

import EDU.purdue.cs.bloat.editor.ClassHierarchy;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.ssa.SSAGraph;
import EDU.purdue.cs.bloat.tbaa.TypeInference;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayLengthExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallMethodExpr;
import EDU.purdue.cs.bloat.tree.CallStaticExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.CatchExpr;
import EDU.purdue.cs.bloat.tree.CheckExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.InstanceOfExpr;
import EDU.purdue.cs.bloat.tree.NegExpr;
import EDU.purdue.cs.bloat.tree.NewArrayExpr;
import EDU.purdue.cs.bloat.tree.NewExpr;
import EDU.purdue.cs.bloat.tree.NewMultiArrayExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.ReturnAddressExpr;
import EDU.purdue.cs.bloat.tree.ShiftExpr;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StackManipStmt;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;

class TypeInferenceVisitor
extends TreeVisitor {
    public boolean changed;
    public ClassHierarchy hier;
    SSAGraph ssaGraph;

    public TypeInferenceVisitor(ClassHierarchy hier, SSAGraph ssaGraph) {
        this.hier = hier;
        this.ssaGraph = ssaGraph;
    }

    public void visitExpr(Expr expr) {
        throw new RuntimeException(expr + " not supported");
    }

    public void visitShiftExpr(ShiftExpr expr) {
        if (expr.expr().type().isIntegral() || expr.expr().type().equals(ClassHierarchy.POS_SHORT) || expr.expr().type().equals(ClassHierarchy.POS_BYTE)) {
            this.start(expr, Type.INTEGER);
        } else {
            this.prop(expr, expr.expr());
        }
    }

    public void visitArithExpr(ArithExpr expr) {
        if (expr.left().type().isIntegral() || expr.left().type().equals(ClassHierarchy.POS_SHORT) || expr.left().type().equals(ClassHierarchy.POS_BYTE)) {
            this.start(expr, Type.INTEGER);
        } else if (expr.right().type().isIntegral() || expr.right().type().equals(ClassHierarchy.POS_SHORT) || expr.right().type().equals(ClassHierarchy.POS_BYTE)) {
            this.start(expr, Type.INTEGER);
        } else {
            Assert.isTrue(expr.left().type().equals(TypeInference.UNDEF) || expr.right().type().equals(TypeInference.UNDEF) || expr.left().type().equals(expr.right().type()), expr.left() + ".type() = " + expr.left().type() + " != " + expr.right() + ".type() = " + expr.right().type());
            if (expr.operation() == 63 || expr.operation() == 60 || expr.operation() == 62) {
                this.start(expr, Type.INTEGER);
            } else {
                this.prop(expr, expr.left());
            }
        }
    }

    public void visitNegExpr(NegExpr expr) {
        if (expr.expr().type().isIntegral() || expr.expr().type().equals(ClassHierarchy.POS_SHORT) || expr.expr().type().equals(ClassHierarchy.POS_BYTE)) {
            this.start(expr, Type.INTEGER);
        } else {
            this.prop(expr, expr.expr());
        }
    }

    public void visitReturnAddressExpr(ReturnAddressExpr expr) {
        this.start(expr, Type.ADDRESS);
    }

    public void visitCheckExpr(CheckExpr expr) {
        this.prop(expr, expr.expr());
    }

    public void visitInstanceOfExpr(InstanceOfExpr expr) {
        this.start(expr, Type.INTEGER);
    }

    public void visitArrayLengthExpr(ArrayLengthExpr expr) {
        this.start(expr, Type.INTEGER);
    }

    public void visitVarExpr(VarExpr expr) {
        if (!expr.isDef() && expr.def() != null) {
            this.prop(expr, expr.def());
        }
    }

    public void visitStackManipStmt(StackManipStmt stmt) {
        StackExpr[] target = stmt.target();
        StackExpr[] source = stmt.source();
        switch (stmt.kind()) {
            case 0: {
                Assert.isTrue(source.length == 2 && target.length == 2, "Illegal statement: " + stmt);
                this.manip(source, target, new int[]{1, 0});
                break;
            }
            case 1: {
                Assert.isTrue(source.length == 1 && target.length == 2, "Illegal statement: " + stmt);
                this.manip(source, target, new int[]{0, 0});
                break;
            }
            case 2: {
                Assert.isTrue(source.length == 2 && target.length == 3, "Illegal statement: " + stmt);
                this.manip(source, target, new int[]{1, 0, 1});
                break;
            }
            case 3: {
                if (source.length == 3) {
                    Assert.isTrue(source.length == 3 && target.length == 4, "Illegal statement: " + stmt);
                    this.manip(source, target, new int[]{2, 0, 1, 2});
                    break;
                }
                Assert.isTrue(source.length == 2 && target.length == 3, "Illegal statement: " + stmt);
                this.manip(source, target, new int[]{1, 0, 1});
                break;
            }
            case 4: {
                if (source.length == 2) {
                    Assert.isTrue(target.length == 4, "Illegal statement: " + stmt);
                    this.manip(source, target, new int[]{0, 1, 0, 1});
                    break;
                }
                Assert.isTrue(source.length == 1 && target.length == 2, "Illegal statement: " + stmt);
                this.manip(source, target, new int[]{0, 0});
                break;
            }
            case 5: {
                if (source.length == 3) {
                    Assert.isTrue(target.length == 5, "Illegal statement: " + stmt);
                    this.manip(source, target, new int[]{1, 2, 0, 1, 2});
                    break;
                }
                Assert.isTrue(source.length == 2 && target.length == 3, "Illegal statement: " + stmt);
                this.manip(source, target, new int[]{1, 0, 1});
                break;
            }
            case 6: {
                if (source.length == 4) {
                    Assert.isTrue(target.length == 6, "Illegal statement: " + stmt);
                    this.manip(source, target, new int[]{2, 3, 0, 1, 2, 3});
                    break;
                }
                if (source.length == 3) {
                    if (target.length == 5) {
                        this.manip(source, target, new int[]{1, 2, 0, 1, 2});
                        break;
                    }
                    Assert.isTrue(target.length == 4, "Illegal statement: " + stmt);
                    this.manip(source, target, new int[]{2, 0, 1, 2});
                    break;
                }
                Assert.isTrue(source.length == 2 && target.length == 3, "Illegal statement: " + stmt);
                this.manip(source, target, new int[]{1, 0, 1});
            }
        }
        stmt.visitChildren(this);
    }

    private void manip(StackExpr[] source, StackExpr[] target, int[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.prop(target[i], source[s[i]]);
        }
    }

    public void visitStoreExpr(StoreExpr expr) {
        this.prop(expr.target(), expr.expr());
        this.prop(expr, expr.target());
    }

    public void visitCatchExpr(CatchExpr expr) {
        Type catchType = expr.catchType();
        if (catchType == Type.NULL) {
            catchType = Type.THROWABLE;
        }
        this.start(expr, catchType);
    }

    public void visitPhiStmt(PhiStmt stmt) {
        Expr expr;
        ArrayList<Expr> back = new ArrayList<Expr>(stmt.operands().size());
        Iterator e = stmt.operands().iterator();
        while (e.hasNext()) {
            expr = (Expr)e.next();
            if (expr instanceof VarExpr && expr.def() == null) {
                back.add(expr);
                continue;
            }
            this.prop(stmt.target(), expr);
        }
        e = back.iterator();
        while (e.hasNext()) {
            expr = (Expr)e.next();
            if (expr.def() != null) continue;
            this.prop(expr, stmt.target());
        }
    }

    public void visitArrayRefExpr(ArrayRefExpr expr) {
        Expr array = expr.array();
        Expr index = expr.index();
        if (!(expr.isDef() || array.type().equals(TypeInference.UNDEF) || array.type().equals(Type.OBJECT) || array.type().equals(Type.SERIALIZABLE) || array.type().equals(Type.CLONEABLE) || array.type().isNull())) {
            Assert.isTrue(array.type().isArray(), array + " in " + expr + " (" + array.type() + ") is not an array");
            this.start(expr, expr.array().type().elementType());
        }
    }

    public void visitCallMethodExpr(CallMethodExpr expr) {
        MemberRef method = expr.method();
        Type[] paramTypes = method.type().paramTypes();
        Type returnType = method.type().returnType();
        this.start(expr, returnType);
    }

    public void visitCallStaticExpr(CallStaticExpr expr) {
        MemberRef method = expr.method();
        Type[] paramTypes = method.type().paramTypes();
        Type returnType = method.type().returnType();
        this.start(expr, returnType);
    }

    public void visitCastExpr(CastExpr expr) {
        this.start(expr, expr.castType());
    }

    /*
     * WARNING - void declaration
     */
    public void visitConstantExpr(ConstantExpr expr) {
        void var3_3;
        short v;
        Object value = expr.value();
        if (value == null) {
            this.start(expr, Type.NULL);
            return;
        }
        if (value instanceof String) {
            this.start(expr, Type.STRING);
            return;
        }
        if (value instanceof Boolean) {
            this.start(expr, Type.BOOLEAN);
            return;
        }
        if (value instanceof Integer) {
            this.start(expr, Type.INTEGER);
            return;
        }
        if (value instanceof Long) {
            this.start(expr, Type.LONG);
            return;
        }
        if (value instanceof Float) {
            this.start(expr, Type.FLOAT);
            return;
        }
        if (value instanceof Double) {
            this.start(expr, Type.DOUBLE);
            return;
        }
        if (value instanceof Byte) {
            v = ((Byte)value).byteValue();
        } else if (value instanceof Short) {
            v = (Short)value;
        } else if (value instanceof Character) {
            v = (short)((Character)value).charValue();
        } else {
            throw new RuntimeException();
        }
        if (var3_3 >= 0) {
            if (var3_3 <= true) {
                this.start(expr, Type.BOOLEAN);
            } else if (var3_3 <= 127) {
                this.start(expr, ClassHierarchy.POS_BYTE);
            } else if (var3_3 <= Short.MAX_VALUE) {
                this.start(expr, ClassHierarchy.POS_SHORT);
            } else if (var3_3 <= 65535) {
                this.start(expr, Type.CHARACTER);
            } else {
                this.start(expr, Type.INTEGER);
            }
        } else if (-128 <= var3_3) {
            this.start(expr, Type.BYTE);
        } else if (Short.MIN_VALUE <= var3_3) {
            this.start(expr, Type.SHORT);
        } else {
            this.start(expr, Type.INTEGER);
        }
    }

    public void visitFieldExpr(FieldExpr expr) {
        MemberRef field = expr.field();
        if (!expr.isDef()) {
            this.start(expr, field.type());
        }
    }

    public void visitNewArrayExpr(NewArrayExpr expr) {
        if (!expr.elementType().equals(TypeInference.UNDEF)) {
            this.start(expr, expr.elementType().arrayType());
        }
    }

    public void visitNewExpr(NewExpr expr) {
        this.start(expr, expr.objectType());
    }

    public void visitNewMultiArrayExpr(NewMultiArrayExpr expr) {
        if (!expr.elementType().equals(TypeInference.UNDEF)) {
            this.start(expr, expr.elementType().arrayType(expr.dimensions().length));
        }
    }

    public void visitStaticFieldExpr(StaticFieldExpr expr) {
        MemberRef field = expr.field();
        if (!expr.isDef()) {
            this.start(expr, field.type());
        }
    }

    private void start(Expr expr, Type type) {
        if (TypeInference.DEBUG) {
            System.out.println("start " + expr + " <- " + type);
        }
        if (type.equals(TypeInference.UNDEF)) {
            return;
        }
        if (!expr.type().equals(TypeInference.UNDEF)) {
            if (TypeInference.DEBUG) {
                System.out.print("union of " + expr.type() + " and " + type);
            }
            if (!(type.isIntegral() || type.equals(ClassHierarchy.POS_BYTE) || type.equals(ClassHierarchy.POS_SHORT))) {
                Assert.isTrue(type.simple().equals(expr.type().simple()));
                if (type.isReference()) {
                    type = this.hier.unionType(type, expr.type());
                }
            } else {
                BitSet v1 = ClassHierarchy.typeToSet(type);
                BitSet v2 = ClassHierarchy.typeToSet(expr.type());
                v1.or(v2);
                type = ClassHierarchy.setToType(v1);
            }
            if (TypeInference.DEBUG) {
                System.out.println(" is " + type);
            }
        }
        Iterator iter = this.ssaGraph.equivalent(expr).iterator();
        while (iter.hasNext()) {
            Expr e;
            Node node = (Node)iter.next();
            if (!(node instanceof Expr) || !(e = (Expr)node).setType(type)) continue;
            this.changed = true;
        }
    }

    private void prop(Expr expr, Expr source) {
        if (TypeInference.DEBUG) {
            System.out.println("prop " + expr + " <- " + source);
        }
        this.start(expr, source.type());
    }
}

