/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tbaa;

import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.editor.ClassHierarchy;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.ssa.ComponentVisitor;
import EDU.purdue.cs.bloat.ssa.SSAGraph;
import EDU.purdue.cs.bloat.tbaa.TypeInferenceVisitor;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.Iterator;
import java.util.List;

public class TypeInference {
    public static boolean DEBUG = false;
    static final Type UNDEF = Type.getType("Lundef!;");

    public static void transform(FlowGraph cfg, ClassHierarchy hier) {
        cfg.visit(new TreeVisitor(){

            public void visitInitStmt(InitStmt stmt) {
                MethodEditor method = stmt.block().graph().method();
                LocalExpr[] t = stmt.targets();
                for (int i = 0; i < t.length; ++i) {
                    LocalExpr var = t[i];
                    int index = var.index();
                    if (!method.isStatic()) {
                        --index;
                    }
                    Type type = index == -1 ? method.declaringClass().type() : method.type().indexedParamTypes()[index];
                    var.setType(type);
                    Iterator uses = var.uses().iterator();
                    while (uses.hasNext()) {
                        LocalExpr use = (LocalExpr)uses.next();
                        use.setType(type);
                    }
                }
            }

            public void visitExpr(Expr expr) {
                expr.visitChildren(this);
                expr.setType(UNDEF);
            }
        });
        SSAGraph ssaGraph = new SSAGraph(cfg);
        final TypeInferenceVisitor visitor = new TypeInferenceVisitor(hier, ssaGraph);
        ssaGraph.visitComponents(new ComponentVisitor(){

            public void visitComponent(List scc) {
                visitor.changed = true;
                while (visitor.changed) {
                    visitor.changed = false;
                    Iterator iter = scc.iterator();
                    while (iter.hasNext()) {
                        Node node = (Node)iter.next();
                        node.visit(visitor);
                    }
                }
            }
        });
        cfg.visit(new TreeVisitor(){

            public void visitExpr(Expr expr) {
                expr.visitChildren(this);
                if (expr.type().equals(ClassHierarchy.POS_SHORT)) {
                    expr.setType(Type.SHORT);
                } else if (expr.type().equals(ClassHierarchy.POS_BYTE)) {
                    expr.setType(Type.BYTE);
                }
            }
        });
        if (DEBUG) {
            cfg.visit(new TreeVisitor(){

                public void visitExpr(Expr expr) {
                    expr.visitChildren(this);
                    System.out.println("typeof(" + expr + ") = " + expr.type());
                    if (expr.type().equals(UNDEF)) {
                        System.out.println("WARNING: typeof(" + expr + ") = UNDEF");
                    }
                    Assert.isFalse(expr.type().equals(ClassHierarchy.POS_SHORT));
                    Assert.isFalse(expr.type().equals(ClassHierarchy.POS_BYTE));
                }
            });
        }
    }
}

