/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.strip;

import EDU.purdue.cs.bloat.context.CachingBloatContext;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.ClassHierarchy;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.file.ClassFile;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Main
implements Opcode {
    private static int VERBOSE = 0;
    private static boolean FORCE = false;
    private static boolean CLOSURE = false;
    private static List SKIP = new ArrayList();
    private static List ONLY = new ArrayList();

    public static void main(String[] args) {
        ClassFileLoader loader = new ClassFileLoader();
        ArrayList<String> classes = new ArrayList<String>();
        boolean gotdir = false;
        for (int i = 0; i < args.length; ++i) {
            String pkg;
            String classpath;
            if (args[i].equals("-v") || args[i].equals("-verbose")) {
                ++VERBOSE;
                continue;
            }
            if (args[i].equals("-help")) {
                Main.usage();
                continue;
            }
            if (args[i].equals("-classpath")) {
                if (++i >= args.length) {
                    Main.usage();
                }
                classpath = args[i];
                loader.setClassPath(classpath);
                continue;
            }
            if (args[i].equals("-classpath/p")) {
                if (++i >= args.length) {
                    Main.usage();
                }
                classpath = args[i];
                loader.prependClassPath(classpath);
                continue;
            }
            if (args[i].equals("-skip")) {
                if (++i >= args.length) {
                    Main.usage();
                }
                pkg = args[i].replace('.', '/');
                SKIP.add(pkg);
                continue;
            }
            if (args[i].equals("-only")) {
                if (++i >= args.length) {
                    Main.usage();
                }
                pkg = args[i].replace('.', '/');
                ONLY.add(pkg);
                continue;
            }
            if (args[i].equals("-closure")) {
                CLOSURE = true;
                continue;
            }
            if (args[i].equals("-relax-loading")) {
                ClassHierarchy.RELAX = true;
                continue;
            }
            if (args[i].equals("-f")) {
                FORCE = true;
                continue;
            }
            if (args[i].startsWith("-")) {
                Main.usage();
                continue;
            }
            if (i == args.length - 1) {
                File f = new File(args[i]);
                if (f.exists() && !f.isDirectory()) {
                    System.err.println("No such directory: " + f.getPath());
                    System.exit(2);
                }
                loader.setOutputDir(f);
                gotdir = true;
                continue;
            }
            classes.add(args[i]);
        }
        if (!gotdir) {
            Main.usage();
        }
        if (classes.size() == 0) {
            Main.usage();
        }
        if (VERBOSE > 3) {
            ClassFileLoader.DEBUG = true;
            ClassEditor.DEBUG = true;
        }
        boolean errors = false;
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            try {
                loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Couldn't find class: " + ex.getMessage());
                errors = true;
            }
        }
        if (errors) {
            System.exit(1);
        }
        CachingBloatContext context = new CachingBloatContext(loader, classes, CLOSURE);
        if (!CLOSURE) {
            Iterator e = classes.iterator();
            while (e.hasNext()) {
                String name = (String)e.next();
                try {
                    ClassInfo info = loader.loadClass(name);
                    Main.decorateClass(context, info);
                }
                catch (ClassNotFoundException ex) {
                    System.err.println("Couldn't find class: " + ex.getMessage());
                    System.exit(1);
                }
            }
        } else {
            classes = null;
            ClassHierarchy hier = context.getHierarchy();
            Iterator e = hier.classes().iterator();
            while (e.hasNext()) {
                Type t = (Type)e.next();
                if (!t.isObject()) continue;
                try {
                    ClassInfo info = loader.loadClass(t.className());
                    Main.decorateClass(context, info);
                }
                catch (ClassNotFoundException ex) {
                    System.err.println("Couldn't find class: " + ex.getMessage());
                    System.exit(1);
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java EDU.purdue.cs.bloat.decorate.Main \n            [-options] classes output_dir\n\nwhere options include:\n    -help             print out this message\n    -v -verbose       turn on verbose mode (can be given multiple times)\n    -classpath <directories separated by colons>\n                      list directories in which to look for classes\n    -f                decorate files even if up-to-date\n    -closure          recursively decorate referenced classes\n    -relax-loading    don't report errors if a class is not found\n    -skip <class|package.*>\n                      skip the given class or package\n                      (this option can be given more than once)\n    -only <class|package.*>\n                      skip all but the given class or package\n                      (this option can be given more than once)");
        System.exit(0);
    }

    private static void decorateClass(EditorContext editor, ClassInfo info) {
        String pkg;
        int i;
        ClassFile classFile = (ClassFile)info;
        if (!FORCE) {
            File source = classFile.file();
            File target = classFile.outputFile();
            if (source != null && target != null && source.exists() && target.exists() && source.lastModified() < target.lastModified()) {
                if (VERBOSE > 1) {
                    System.out.println(classFile.name() + " is up to date");
                }
                return;
            }
        }
        if (VERBOSE > 2) {
            classFile.print(System.out);
        }
        ClassEditor c = editor.editClass(info);
        boolean skip = false;
        String name = c.type().className();
        String qual = c.type().qualifier() + "/*";
        if (ONLY.size() > 0) {
            skip = true;
            for (i = 0; i < ONLY.size(); ++i) {
                pkg = (String)ONLY.get(i);
                if (!name.equals(pkg) && !qual.equals(pkg)) continue;
                skip = false;
                break;
            }
        }
        if (!skip) {
            for (i = 0; i < SKIP.size(); ++i) {
                pkg = (String)SKIP.get(i);
                if (!name.equals(pkg) && !qual.equals(pkg)) continue;
                skip = true;
                break;
            }
        }
        if (skip) {
            if (VERBOSE > 0) {
                System.out.println("Skipping " + c.type().className());
            }
            editor.release(info);
            return;
        }
        if (VERBOSE > 0) {
            System.out.println("Stripping class " + c.type().className());
        }
        if (VERBOSE > 2) {
            ((ClassFile)info).print(System.out);
        }
        MethodInfo[] methods = c.methods();
        for (int j = 0; j < methods.length; ++j) {
            methods[j].setLineNumbers(null);
            methods[j].setLocals(null);
            editor.commit(methods[j]);
        }
        editor.commit(info);
    }
}

