/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.ssa;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.ssa.ComponentVisitor;
import EDU.purdue.cs.bloat.tree.CheckExpr;
import EDU.purdue.cs.bloat.tree.MemExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StackManipStmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.util.Assert;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class SSAGraph {
    public static boolean DEBUG = false;
    FlowGraph cfg;
    HashMap equiv;

    public SSAGraph(FlowGraph cfg, boolean useless) {
        this(cfg);
    }

    public SSAGraph(FlowGraph cfg) {
        this.cfg = cfg;
        this.equiv = new HashMap();
        cfg.visit(new TreeVisitor(){

            public void visitCheckExpr(CheckExpr expr) {
                expr.visitChildren(this);
                SSAGraph.this.makeEquiv(expr, expr.expr());
            }

            public void visitPhiStmt(PhiStmt stmt) {
                stmt.visitChildren(this);
                SSAGraph.this.makeEquiv(stmt.target(), stmt);
            }

            public void visitVarExpr(VarExpr expr) {
                VarExpr def;
                if (!expr.isDef() && (def = (VarExpr)expr.def()) != null) {
                    SSAGraph.this.makeEquiv(expr, def);
                }
            }

            public void visitStackManipStmt(StackManipStmt stmt) {
                StackExpr[] target = stmt.target();
                StackExpr[] source = stmt.source();
                switch (stmt.kind()) {
                    case 0: {
                        Assert.isTrue(source.length == 2 && target.length == 2, "Illegal statement: " + stmt);
                        this.manip(source, target, new int[]{1, 0});
                        break;
                    }
                    case 1: {
                        Assert.isTrue(source.length == 1 && target.length == 2, "Illegal statement: " + stmt);
                        this.manip(source, target, new int[]{0, 0});
                        break;
                    }
                    case 2: {
                        Assert.isTrue(source.length == 2 && target.length == 3, "Illegal statement: " + stmt);
                        this.manip(source, target, new int[]{1, 0, 1});
                        break;
                    }
                    case 3: {
                        if (source.length == 3) {
                            Assert.isTrue(source.length == 3 && target.length == 4, "Illegal statement: " + stmt);
                            this.manip(source, target, new int[]{2, 0, 1, 2});
                            break;
                        }
                        Assert.isTrue(source.length == 2 && target.length == 3, "Illegal statement: " + stmt);
                        this.manip(source, target, new int[]{1, 0, 1});
                        break;
                    }
                    case 4: {
                        if (source.length == 2) {
                            Assert.isTrue(target.length == 4, "Illegal statement: " + stmt);
                            this.manip(source, target, new int[]{0, 1, 0, 1});
                            break;
                        }
                        Assert.isTrue(source.length == 1 && target.length == 2, "Illegal statement: " + stmt);
                        this.manip(source, target, new int[]{0, 0});
                        break;
                    }
                    case 5: {
                        if (source.length == 3) {
                            Assert.isTrue(target.length == 5, "Illegal statement: " + stmt);
                            this.manip(source, target, new int[]{1, 2, 0, 1, 2});
                            break;
                        }
                        Assert.isTrue(source.length == 2 && target.length == 3, "Illegal statement: " + stmt);
                        this.manip(source, target, new int[]{1, 0, 1});
                        break;
                    }
                    case 6: {
                        if (source.length == 4) {
                            Assert.isTrue(target.length == 6, "Illegal statement: " + stmt);
                            this.manip(source, target, new int[]{2, 3, 0, 1, 2, 3});
                            break;
                        }
                        if (source.length == 3) {
                            if (target.length == 5) {
                                this.manip(source, target, new int[]{1, 2, 0, 1, 2});
                                break;
                            }
                            Assert.isTrue(target.length == 4, "Illegal statement: " + stmt);
                            this.manip(source, target, new int[]{2, 0, 1, 2});
                            break;
                        }
                        Assert.isTrue(source.length == 2 && target.length == 3, "Illegal statement: " + stmt);
                        this.manip(source, target, new int[]{1, 0, 1});
                    }
                }
                stmt.visitChildren(this);
            }

            private void manip(StackExpr[] source, StackExpr[] target, int[] s) {
                for (int i = 0; i < s.length; ++i) {
                    SSAGraph.this.makeEquiv(target[i], source[s[i]]);
                }
            }

            public void visitStoreExpr(StoreExpr expr) {
                expr.visitChildren(this);
                SSAGraph.this.makeEquiv(expr, expr.expr());
                if (expr.target() instanceof VarExpr) {
                    SSAGraph.this.makeEquiv(expr.target(), expr.expr());
                }
            }
        });
    }

    public FlowGraph cfg() {
        return this.cfg;
    }

    public Set equivalent(Node node) {
        HashSet<Node> s = (HashSet<Node>)this.equiv.get(node);
        if (s == null) {
            s = new HashSet<Node>(1);
            s.add(node);
            this.equiv.put(node, s);
        }
        return s;
    }

    void makeEquiv(Node node1, Node node2) {
        Set s2;
        Set s1 = this.equivalent(node1);
        if (s1 != (s2 = this.equivalent(node2))) {
            s1.addAll(s2);
            Iterator iter = s2.iterator();
            while (iter.hasNext()) {
                Node n = (Node)iter.next();
                this.equiv.put(n, s1);
            }
        }
    }

    public List children(Node node) {
        final ArrayList<MemExpr> c = new ArrayList<MemExpr>();
        if (node instanceof StoreExpr) {
            StoreExpr store = (StoreExpr)node;
            store.expr().visitChildren(new TreeVisitor(){

                public void visitNode(Node node) {
                    c.add(node);
                }
            });
            if (!(store.target() instanceof VarExpr)) {
                c.add(store.target());
            }
        } else if (node instanceof PhiStmt) {
            PhiStmt phi = (PhiStmt)node;
            c.addAll(phi.operands());
        } else {
            node.visitChildren(new TreeVisitor(){

                public void visitNode(Node node) {
                    c.add(node);
                }
            });
        }
        return c;
    }

    public Collection equivalences() {
        return this.equiv.values();
    }

    public void visitComponents(final ComponentVisitor visitor) {
        final Count count = new Count();
        final List postOrder = this.cfg.postOrder();
        ListIterator iter = postOrder.listIterator(postOrder.size());
        while (iter.hasPrevious()) {
            Block block = (Block)iter.previous();
            block.visit(new TreeVisitor(){

                public void visitTree(Tree tree) {
                    tree.visitChildren(this);
                }

                public void visitNode(Node node) {
                    node.visitChildren(this);
                    node.setKey(count.value++);
                }
            });
        }
        this.cfg.visit(new TreeVisitor(){
            ArrayList stack = new ArrayList();
            BitSet onStack;
            int[] low;
            int[] dfs;
            int dfsNumber;
            Node parent;
            {
                this.onStack = new BitSet(count.value + 1);
                this.low = new int[count.value + 1];
                this.dfs = new int[count.value + 1];
                this.dfsNumber = 1;
            }

            public void visitFlowGraph(FlowGraph cfg) {
                ListIterator e = postOrder.listIterator(postOrder.size());
                while (e.hasPrevious()) {
                    Block block = (Block)e.previous();
                    block.visit(this);
                }
            }

            public void visitTree(Tree tree) {
                this.parent = null;
                tree.visitChildren(this);
            }

            public void visitNode(Node node) {
                int parentDfn;
                int dfn = this.dfs[node.key()];
                if (dfn == 0) {
                    this.low[dfn] = dfn = this.dfsNumber++;
                    this.stack.add(node);
                    this.onStack.set(dfn);
                    Iterator equiv = SSAGraph.this.equivalent(node).iterator();
                    while (equiv.hasNext()) {
                        Node e = (Node)equiv.next();
                        this.dfs[e.key()] = dfn;
                    }
                    Node grandParent = this.parent;
                    this.parent = node;
                    equiv = SSAGraph.this.equivalent(node).iterator();
                    while (equiv.hasNext()) {
                        Node e = (Node)equiv.next();
                        Iterator children = SSAGraph.this.children(e).iterator();
                        while (children.hasNext()) {
                            Node child = (Node)children.next();
                            child.visit(this);
                        }
                    }
                    this.parent = grandParent;
                    if (this.low[dfn] == dfn) {
                        ArrayList scc = new ArrayList();
                        while (!this.stack.isEmpty()) {
                            Node v = (Node)this.stack.remove(this.stack.size() - 1);
                            this.onStack.clear(this.dfs[v.key()]);
                            scc.addAll(SSAGraph.this.equivalent(v));
                            if (v != node) continue;
                            break;
                        }
                        Collections.sort(scc, new Comparator(this){
                            private final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public int compare(Object a, Object b) {
                                int ka = ((Node)a).key();
                                int kb = ((Node)b).key();
                                return ka - kb;
                            }
                        });
                        if (DEBUG) {
                            System.out.print("SCC =");
                            Iterator e = scc.iterator();
                            while (e.hasNext()) {
                                Node v = (Node)e.next();
                                System.out.print(" " + v + "{" + v.key() + "}");
                            }
                            System.out.println();
                        }
                        visitor.visitComponent(scc);
                    }
                    if (this.parent != null) {
                        int parentDfn2 = this.dfs[this.parent.key()];
                        this.low[parentDfn2] = Math.min(this.low[parentDfn2], this.low[dfn]);
                    }
                } else if (this.parent != null && dfn < (parentDfn = this.dfs[this.parent.key()]) && this.onStack.get(dfn)) {
                    this.low[parentDfn] = Math.min(this.low[parentDfn], dfn);
                }
            }
        });
    }

    public void visitComponent(final Node startNode, final ComponentVisitor visitor) {
        final Count count = new Count();
        final List postOrder = this.cfg.postOrder();
        ListIterator iter = postOrder.listIterator(postOrder.size());
        while (iter.hasPrevious()) {
            Block block = (Block)iter.previous();
            block.visit(new TreeVisitor(){

                public void visitTree(Tree tree) {
                    tree.visitChildren(this);
                }

                public void visitNode(Node node) {
                    node.visitChildren(this);
                    node.setKey(count.value++);
                }
            });
        }
        this.cfg.visit(new TreeVisitor(){
            ArrayList stack = new ArrayList();
            BitSet onStack;
            int[] low;
            int[] dfs;
            int dfsNumber;
            Node parent;
            {
                this.onStack = new BitSet(count.value + 1);
                this.low = new int[count.value + 1];
                this.dfs = new int[count.value + 1];
                this.dfsNumber = 1;
            }

            public void visitFlowGraph(FlowGraph cfg) {
                ListIterator e = postOrder.listIterator(postOrder.size());
                while (e.hasPrevious()) {
                    Block block = (Block)e.previous();
                    block.visit(this);
                }
            }

            public void visitTree(Tree tree) {
                this.parent = null;
                tree.visitChildren(this);
            }

            public void visitNode(Node node) {
                int parentDfn;
                int dfn = this.dfs[node.key()];
                if (dfn == 0) {
                    if (!SSAGraph.this.equivalent(node).contains(startNode)) {
                        return;
                    }
                    this.low[dfn] = dfn = this.dfsNumber++;
                    this.stack.add(node);
                    this.onStack.set(dfn);
                    Iterator equiv = SSAGraph.this.equivalent(node).iterator();
                    while (equiv.hasNext()) {
                        Node e = (Node)equiv.next();
                        this.dfs[e.key()] = dfn;
                    }
                    Node grandParent = this.parent;
                    this.parent = node;
                    equiv = SSAGraph.this.equivalent(node).iterator();
                    while (equiv.hasNext()) {
                        Node e = (Node)equiv.next();
                        Iterator children = SSAGraph.this.children(e).iterator();
                        while (children.hasNext()) {
                            Node child = (Node)children.next();
                            child.visit(this);
                        }
                    }
                    this.parent = grandParent;
                    if (this.low[dfn] == dfn) {
                        ArrayList scc = new ArrayList();
                        while (!this.stack.isEmpty()) {
                            Node v = (Node)this.stack.remove(this.stack.size() - 1);
                            this.onStack.clear(this.dfs[v.key()]);
                            scc.addAll(SSAGraph.this.equivalent(v));
                            if (v != node) continue;
                            break;
                        }
                        Collections.sort(scc, new Comparator(this){
                            private final /* synthetic */ 8 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public int compare(Object a, Object b) {
                                int ka = ((Node)a).key();
                                int kb = ((Node)b).key();
                                return ka - kb;
                            }
                        });
                        if (DEBUG) {
                            System.out.print("SCC =");
                            Iterator e = scc.iterator();
                            while (e.hasNext()) {
                                Node v = (Node)e.next();
                                System.out.print(" " + v + "{" + v.key() + "}");
                            }
                            System.out.println();
                        }
                        visitor.visitComponent(scc);
                    }
                    if (this.parent != null) {
                        int parentDfn2 = this.dfs[this.parent.key()];
                        this.low[parentDfn2] = Math.min(this.low[parentDfn2], this.low[dfn]);
                    }
                } else if (this.parent != null && dfn < (parentDfn = this.dfs[this.parent.key()]) && this.onStack.get(dfn)) {
                    this.low[parentDfn] = Math.min(this.low[parentDfn], dfn);
                }
            }
        });
    }

    public void printSCCs(PrintWriter pw) {
        Collection equivs = this.equivalences();
        Iterator iter = equivs.iterator();
        pw.println("Strongly Connected Components of the SSAGraph");
        int i = 1;
        while (iter.hasNext()) {
            Set scc = (Set)iter.next();
            Iterator sccIter = scc.iterator();
            pw.println("  Component " + i);
            while (sccIter.hasNext()) {
                Node node = (Node)sccIter.next();
                pw.println("    " + node + " [VN = " + node.valueNumber() + ", ID = " + System.identityHashCode(node) + "]");
            }
            ++i;
        }
    }

    class Count {
        int value = 0;

        Count() {
        }
    }
}

