/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.ssa;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.cfg.Handler;
import EDU.purdue.cs.bloat.cfg.Subroutine;
import EDU.purdue.cs.bloat.ssa.PhiReturnStmt;
import EDU.purdue.cs.bloat.ssa.SSAConstructionInfo;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;

public class SSA {
    public static boolean DEBUG = false;

    public static void transform(FlowGraph cfg) {
        Iterator e = SSA.collectVars(cfg);
        while (e.hasNext()) {
            SSAConstructionInfo info = (SSAConstructionInfo)e.next();
            SSA.transform(cfg, info);
        }
    }

    public static void transform(FlowGraph cfg, SSAConstructionInfo info) {
        if (DEBUG) {
            System.out.println("transforming " + info.prototype + " (" + info.prototype.type() + ")");
        }
        SSA.placePhiFunctions(cfg, info);
        SSA.rename(cfg, info);
        SSA.insertCode(cfg, info);
    }

    private static Iterator collectVars(final FlowGraph cfg) {
        final HashMap infos = new HashMap();
        cfg.visit(new TreeVisitor(){

            public void visitTree(Tree tree) {
                Iterator iter = tree.stmts().iterator();
                while (iter.hasNext()) {
                    Stmt stmt = (Stmt)iter.next();
                    if (stmt instanceof PhiStmt) {
                        iter.remove();
                        continue;
                    }
                    stmt.visit(this);
                }
            }

            public void visitVarExpr(VarExpr expr) {
                expr.visitChildren(this);
                expr.setDef(null);
                Object key = expr.comparator();
                SSAConstructionInfo info = (SSAConstructionInfo)infos.get(key);
                if (info == null) {
                    info = new SSAConstructionInfo(cfg, expr);
                    infos.put(key, info);
                }
                info.addReal(expr);
            }
        });
        return infos.values().iterator();
    }

    private static void placePhiFunctions(FlowGraph cfg, SSAConstructionInfo info) {
        Block block;
        if (DEBUG) {
            System.out.println("Placing phi-functions for " + info);
        }
        BitSet killed = new BitSet(cfg.size());
        boolean nonLocal = false;
        Iterator reals = info.reals().iterator();
        while (reals.hasNext()) {
            VarExpr real = (VarExpr)reals.next();
            block = real.block();
            if (real.isDef()) {
                killed.set(cfg.preOrderIndex(block));
                continue;
            }
            if (killed.get(cfg.preOrderIndex(block))) continue;
            nonLocal = true;
            break;
        }
        if (!nonLocal) {
            return;
        }
        Iterator catchBlocks = cfg.catchBlocks().iterator();
        while (catchBlocks.hasNext()) {
            block = (Block)catchBlocks.next();
            info.addCatchPhi(block);
            info.addDefBlock(block);
        }
        Iterator subs = cfg.subroutines().iterator();
        while (subs.hasNext()) {
            Subroutine sub = (Subroutine)subs.next();
            info.addRetPhis(sub);
            Iterator paths = sub.paths().iterator();
            while (paths.hasNext()) {
                Block[] path = (Block[])paths.next();
                info.addDefBlock(path[1]);
            }
        }
        Iterator df = cfg.iteratedDomFrontier(info.defBlocks()).iterator();
        while (df.hasNext()) {
            Block block2 = (Block)df.next();
            if (block2 == cfg.sink()) continue;
            info.addPhi(block2);
        }
    }

    private static void addCatchPhiOperands(SSAConstructionInfo info, Block block, LocalExpr def) {
        Iterator handlers = block.graph().handlers().iterator();
        while (handlers.hasNext()) {
            PhiCatchStmt phi;
            Handler handler = (Handler)handlers.next();
            if (!handler.protectedBlocks().contains(block) || (phi = (PhiCatchStmt)info.phiAtBlock(handler.catchBlock())) == null || phi.hasOperandDef(def)) continue;
            LocalExpr operand = (LocalExpr)info.prototype.clone();
            operand.setDef(def);
            phi.addOperand(operand);
        }
    }

    private static void rename(FlowGraph cfg, SSAConstructionInfo info) {
        Iterator paths;
        Subroutine sub;
        Iterator subs;
        SSA.search(cfg, info, null, cfg.source());
        boolean changed = true;
        while (changed) {
            changed = false;
            subs = cfg.subroutines().iterator();
            while (subs.hasNext()) {
                sub = (Subroutine)subs.next();
                paths = sub.paths().iterator();
                PhiJoinStmt entry = (PhiJoinStmt)info.phiAtBlock(sub.entry());
                if (entry == null) continue;
                while (paths.hasNext()) {
                    DefExpr def;
                    Block[] path = (Block[])paths.next();
                    PhiReturnStmt ret = (PhiReturnStmt)info.phiAtBlock(path[1]);
                    if (ret == null || (def = ret.operand().def()) != entry.target()) continue;
                    def = ((VarExpr)entry.operandAt(path[0])).def();
                    Iterator uses = ret.target().uses().iterator();
                    while (uses.hasNext()) {
                        VarExpr use = (VarExpr)uses.next();
                        use.setDef(def);
                    }
                    info.removePhiAtBlock(path[1]);
                    changed = true;
                }
            }
        }
        subs = cfg.subroutines().iterator();
        while (subs.hasNext()) {
            sub = (Subroutine)subs.next();
            paths = sub.paths().iterator();
            while (paths.hasNext()) {
                Block[] path = (Block[])paths.next();
                PhiReturnStmt ret = (PhiReturnStmt)info.phiAtBlock(path[1]);
                if (ret == null) continue;
                DefExpr def = ret.operand().def();
                Iterator uses = ret.target().uses().iterator();
                while (uses.hasNext()) {
                    VarExpr use = (VarExpr)uses.next();
                    use.setDef(def);
                }
                info.removePhiAtBlock(path[1]);
            }
        }
    }

    private static void search(FlowGraph cfg, SSAConstructionInfo info, VarExpr top, Block block) {
        PhiStmt phi;
        if (DEBUG) {
            System.out.println("  renaming " + info.prototype + " in " + block);
        }
        if (top instanceof LocalExpr) {
            SSA.addCatchPhiOperands(info, block, (LocalExpr)top);
        }
        if ((phi = info.phiAtBlock(block)) != null && (top = phi.target()) instanceof LocalExpr) {
            SSA.addCatchPhiOperands(info, block, (LocalExpr)top);
        }
        if (cfg.catchBlocks().contains(block) && info.prototype instanceof StackExpr) {
            if (DEBUG) {
                System.out.println("  Killing TOS at " + block);
            }
            top = null;
        }
        Iterator e = info.realsAtBlock(block).iterator();
        while (e.hasNext()) {
            VarExpr real = (VarExpr)e.next();
            if (real.isDef()) {
                real.setDef(null);
                top = real;
                if (top instanceof LocalExpr) {
                    SSA.addCatchPhiOperands(info, block, (LocalExpr)top);
                }
                if (!DEBUG) continue;
                System.out.println("  TOS = " + top);
                continue;
            }
            Assert.isTrue(top != null, "Null def for " + real);
            real.setDef(top);
        }
        Iterator succs = cfg.succs(block).iterator();
        while (succs.hasNext()) {
            VarExpr operand;
            PhiStmt f;
            Block succ = (Block)succs.next();
            PhiStmt succPhi = info.phiAtBlock(succ);
            if (succPhi instanceof PhiJoinStmt) {
                f = (PhiJoinStmt)succPhi;
                operand = (VarExpr)((PhiJoinStmt)f).operandAt(block);
                operand.setDef(top);
            } else if (succPhi instanceof PhiReturnStmt) {
                f = (PhiReturnStmt)succPhi;
                operand = (VarExpr)((PhiReturnStmt)f).operand();
                operand.setDef(top);
            }
            if (!(top instanceof LocalExpr)) continue;
            SSA.addCatchPhiOperands(info, succ, (LocalExpr)top);
        }
        Iterator children = cfg.domChildren(block).iterator();
        while (children.hasNext()) {
            Block child = (Block)children.next();
            SSA.search(cfg, info, top, child);
        }
    }

    private static void insertCode(FlowGraph cfg, SSAConstructionInfo info) {
        Iterator blocks = cfg.nodes().iterator();
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            PhiStmt phi = info.phiAtBlock(block);
            if (phi == null) continue;
            Assert.isFalse(phi instanceof PhiReturnStmt);
            block.tree().prependStmt(phi);
        }
    }
}

