/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.inline;

import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.InstructionAdapter;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.MultiArrayOperand;
import EDU.purdue.cs.bloat.editor.Switch;
import EDU.purdue.cs.bloat.editor.TryCatch;
import EDU.purdue.cs.bloat.editor.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class StackHeightCounter
extends InstructionAdapter {
    public static boolean DEBUG = false;
    private int height;
    private HashMap labelHeights;
    private MethodEditor method;
    Set tryCatches;

    private static void db(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }

    public StackHeightCounter(MethodEditor method) {
        this.method = method;
        this.height = 0;
        this.labelHeights = new HashMap();
        this.tryCatches = new HashSet();
    }

    public int height() {
        return this.height;
    }

    public void handle(Label label) {
        Integer labelHeight = (Integer)this.labelHeights.get(label);
        if (labelHeight != null) {
            this.height = labelHeight;
        }
        Iterator tryCatches = this.method.tryCatches().iterator();
        while (tryCatches.hasNext()) {
            TryCatch tc = (TryCatch)tryCatches.next();
            if (tc.handler().equals(label)) {
                label.setStartsBlock(true);
                this.height = 1;
                break;
            }
            if (tc.start().equals(label)) {
                this.tryCatches.add(tc);
            }
            if (!tc.end().equals(label)) continue;
            this.tryCatches.remove(tc);
        }
    }

    public void handle(Instruction inst) {
        inst.visit(this);
        if (inst.isJump()) {
            Label target = (Label)inst.operand();
            target.setStartsBlock(true);
            Integer targetHeight = (Integer)this.labelHeights.get(target);
            if (targetHeight != null) {
                if (targetHeight != this.height) {
                    StackHeightCounter.db("Stack height mismatch (" + targetHeight + " != " + this.height + ") at " + inst);
                }
            } else {
                this.labelHeights.put(target, new Integer(this.height));
            }
        } else if (inst.isSwitch()) {
            Switch sw = (Switch)inst.operand();
            Label defaultTarget = sw.defaultTarget();
            defaultTarget.setStartsBlock(true);
            Integer dTargetHeight = (Integer)this.labelHeights.get(defaultTarget);
            if (dTargetHeight != null) {
                if (dTargetHeight != this.height) {
                    StackHeightCounter.db("Stack height mismatch (" + dTargetHeight + " != " + this.height + ") at " + inst);
                }
            } else {
                this.labelHeights.put(defaultTarget, new Integer(this.height));
            }
            Label[] targets = sw.targets();
            for (int t = 0; t < targets.length; ++t) {
                Label target = targets[t];
                target.setStartsBlock(true);
                Integer targetHeight = (Integer)this.labelHeights.get(target);
                if (targetHeight != null) {
                    if (targetHeight == this.height) continue;
                    StackHeightCounter.db("Stack height mismatch (" + targetHeight + " != " + this.height + ") at " + inst);
                    continue;
                }
                this.labelHeights.put(target, new Integer(this.height));
            }
        } else if (inst.isJsr()) {
            Label subroutine = (Label)inst.operand();
            subroutine.setStartsBlock(true);
            Integer subHeight = (Integer)this.labelHeights.get(subroutine);
            if (subHeight != null) {
                if (subHeight != this.height + 1) {
                    StackHeightCounter.db("Stack height mismatch at subroutine (" + subHeight + " != " + (this.height + 1) + ") at " + inst);
                }
            } else {
                this.labelHeights.put(subroutine, new Integer(this.height + 1));
            }
        } else if (inst.isThrow() || inst.isReturn()) {
            this.height = 0;
        }
    }

    public void unhandle(Instruction inst) {
        this.height = -this.height;
        this.handle(inst);
        this.height = -this.height;
    }

    public Set tryCatches() {
        return this.tryCatches;
    }

    public void visit_ldc(Instruction inst) {
        Object operand = inst.operand();
        this.height = operand instanceof Long || operand instanceof Double ? (this.height += 2) : ++this.height;
    }

    public void visit_iload(Instruction inst) {
        ++this.height;
    }

    public void visit_lload(Instruction inst) {
        this.height += 2;
    }

    public void visit_fload(Instruction inst) {
        ++this.height;
    }

    public void visit_dload(Instruction inst) {
        this.height += 2;
    }

    public void visit_aload(Instruction inst) {
        ++this.height;
    }

    public void visit_iaload(Instruction inst) {
        --this.height;
    }

    public void visit_laload(Instruction inst) {
        this.height -= 0;
    }

    public void visit_faload(Instruction inst) {
        --this.height;
    }

    public void visit_daload(Instruction inst) {
        this.height -= 0;
    }

    public void visit_aaload(Instruction inst) {
        --this.height;
    }

    public void visit_baload(Instruction inst) {
        --this.height;
    }

    public void visit_caload(Instruction inst) {
        --this.height;
    }

    public void visit_saload(Instruction inst) {
        --this.height;
    }

    public void visit_istore(Instruction inst) {
        --this.height;
    }

    public void visit_lstore(Instruction inst) {
        this.height -= 2;
    }

    public void visit_fstore(Instruction inst) {
        --this.height;
    }

    public void visit_dstore(Instruction inst) {
        this.height -= 2;
    }

    public void visit_astore(Instruction inst) {
        --this.height;
    }

    public void visit_iastore(Instruction inst) {
        this.height -= 3;
    }

    public void visit_lastore(Instruction inst) {
        this.height -= 4;
    }

    public void visit_fastore(Instruction inst) {
        this.height -= 3;
    }

    public void visit_dastore(Instruction inst) {
        this.height -= 4;
    }

    public void visit_aastore(Instruction inst) {
        this.height -= 3;
    }

    public void visit_bastore(Instruction inst) {
        this.height -= 3;
    }

    public void visit_castore(Instruction inst) {
        this.height -= 3;
    }

    public void visit_sastore(Instruction inst) {
        this.height -= 3;
    }

    public void visit_pop(Instruction inst) {
        --this.height;
    }

    public void visit_pop2(Instruction inst) {
        this.height -= 2;
    }

    public void visit_dup(Instruction inst) {
        ++this.height;
    }

    public void visit_dup_x1(Instruction inst) {
        ++this.height;
    }

    public void visit_dup_x2(Instruction inst) {
        ++this.height;
    }

    public void visit_dup2(Instruction inst) {
        this.height += 2;
    }

    public void visit_dup2_x1(Instruction inst) {
        this.height += 2;
    }

    public void visit_dup2_x2(Instruction inst) {
        this.height += 2;
    }

    public void visit_iadd(Instruction inst) {
        --this.height;
    }

    public void visit_ladd(Instruction inst) {
        this.height -= 2;
    }

    public void visit_fadd(Instruction inst) {
        --this.height;
    }

    public void visit_dadd(Instruction inst) {
        this.height -= 2;
    }

    public void visit_isub(Instruction inst) {
        --this.height;
    }

    public void visit_lsub(Instruction inst) {
        this.height -= 2;
    }

    public void visit_fsub(Instruction inst) {
        --this.height;
    }

    public void visit_dsub(Instruction inst) {
        this.height -= 2;
    }

    public void visit_imul(Instruction inst) {
        --this.height;
    }

    public void visit_lmul(Instruction inst) {
        this.height -= 2;
    }

    public void visit_fmul(Instruction inst) {
        --this.height;
    }

    public void visit_dmul(Instruction inst) {
        this.height -= 2;
    }

    public void visit_idiv(Instruction inst) {
        --this.height;
    }

    public void visit_ldiv(Instruction inst) {
        this.height -= 2;
    }

    public void visit_fdiv(Instruction inst) {
        --this.height;
    }

    public void visit_ddiv(Instruction inst) {
        this.height -= 2;
    }

    public void visit_irem(Instruction inst) {
        --this.height;
    }

    public void visit_lrem(Instruction inst) {
        this.height -= 2;
    }

    public void visit_frem(Instruction inst) {
        --this.height;
    }

    public void visit_drem(Instruction inst) {
        this.height -= 2;
    }

    public void visit_ishl(Instruction inst) {
        --this.height;
    }

    public void visit_lshl(Instruction inst) {
        --this.height;
    }

    public void visit_ishr(Instruction inst) {
        --this.height;
    }

    public void visit_lshr(Instruction inst) {
        --this.height;
    }

    public void visit_iushr(Instruction inst) {
        --this.height;
    }

    public void visit_lushr(Instruction inst) {
        --this.height;
    }

    public void visit_iand(Instruction inst) {
        --this.height;
    }

    public void visit_land(Instruction inst) {
        this.height -= 2;
    }

    public void visit_ior(Instruction inst) {
        --this.height;
    }

    public void visit_lor(Instruction inst) {
        this.height -= 2;
    }

    public void visit_ixor(Instruction inst) {
        --this.height;
    }

    public void visit_lxor(Instruction inst) {
        this.height -= 2;
    }

    public void visit_i2l(Instruction inst) {
        ++this.height;
    }

    public void visit_i2d(Instruction inst) {
        ++this.height;
    }

    public void visit_l2i(Instruction inst) {
        --this.height;
    }

    public void visit_l2f(Instruction inst) {
        --this.height;
    }

    public void visit_f2l(Instruction inst) {
        ++this.height;
    }

    public void visit_f2d(Instruction inst) {
        ++this.height;
    }

    public void visit_d2i(Instruction inst) {
        --this.height;
    }

    public void visit_d2f(Instruction inst) {
        --this.height;
    }

    public void visit_lcmp(Instruction inst) {
        this.height -= 3;
    }

    public void visit_fcmpl(Instruction inst) {
        --this.height;
    }

    public void visit_fcmpg(Instruction inst) {
        --this.height;
    }

    public void visit_dcmpl(Instruction inst) {
        this.height -= 3;
    }

    public void visit_dcmpg(Instruction inst) {
        this.height -= 3;
    }

    public void visit_ifeq(Instruction inst) {
        --this.height;
    }

    public void visit_ifne(Instruction inst) {
        --this.height;
    }

    public void visit_iflt(Instruction inst) {
        --this.height;
    }

    public void visit_ifge(Instruction inst) {
        --this.height;
    }

    public void visit_ifgt(Instruction inst) {
        --this.height;
    }

    public void visit_ifle(Instruction inst) {
        --this.height;
    }

    public void visit_if_icmpeq(Instruction inst) {
        this.height -= 2;
    }

    public void visit_if_icmpne(Instruction inst) {
        this.height -= 2;
    }

    public void visit_if_icmplt(Instruction inst) {
        this.height -= 2;
    }

    public void visit_if_icmpge(Instruction inst) {
        this.height -= 2;
    }

    public void visit_if_icmpgt(Instruction inst) {
        this.height -= 2;
    }

    public void visit_if_icmple(Instruction inst) {
        this.height -= 2;
    }

    public void visit_if_acmpeq(Instruction inst) {
        this.height -= 2;
    }

    public void visit_if_acmpne(Instruction inst) {
        this.height -= 2;
    }

    public void visit_jsr(Instruction inst) {
        this.height += 0;
    }

    public void visit_switch(Instruction inst) {
        --this.height;
    }

    public void visit_ireturn(Instruction inst) {
        this.height = 0;
    }

    public void visit_lreturn(Instruction inst) {
        this.height = 0;
    }

    public void visit_freturn(Instruction inst) {
        this.height = 0;
    }

    public void visit_dreturn(Instruction inst) {
        this.height = 0;
    }

    public void visit_areturn(Instruction inst) {
        this.height = 0;
    }

    public void visit_return(Instruction inst) {
        this.height = 0;
    }

    public void visit_getstatic(Instruction inst) {
        Type type = ((MemberRef)inst.operand()).nameAndType().type();
        this.height += type.stackHeight();
    }

    public void visit_putstatic(Instruction inst) {
        Type type = ((MemberRef)inst.operand()).nameAndType().type();
        this.height -= type.stackHeight();
    }

    public void visit_putstatic_nowb(Instruction inst) {
        Type type = ((MemberRef)inst.operand()).nameAndType().type();
        this.height -= type.stackHeight();
    }

    public void visit_getfield(Instruction inst) {
        Type type = ((MemberRef)inst.operand()).nameAndType().type();
        this.height += type.stackHeight() - 1;
    }

    public void visit_putfield(Instruction inst) {
        Type type = ((MemberRef)inst.operand()).nameAndType().type();
        this.height -= type.stackHeight() + 1;
    }

    public void visit_putfield_nowb(Instruction inst) {
        Type type = ((MemberRef)inst.operand()).nameAndType().type();
        this.height -= type.stackHeight() + 1;
    }

    public void visit_invokevirtual(Instruction inst) {
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        this.height += type.returnType().stackHeight() - type.stackHeight() - 1;
    }

    public void visit_invokespecial(Instruction inst) {
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        this.height += type.returnType().stackHeight() - type.stackHeight() - 1;
    }

    public void visit_invokestatic(Instruction inst) {
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        this.height += type.returnType().stackHeight() - type.stackHeight();
    }

    public void visit_invokeinterface(Instruction inst) {
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        this.height += type.returnType().stackHeight() - type.stackHeight() - 1;
    }

    public void visit_new(Instruction inst) {
        ++this.height;
    }

    public void visit_monitorenter(Instruction inst) {
        --this.height;
    }

    public void visit_monitorexit(Instruction inst) {
        --this.height;
    }

    public void visit_multianewarray(Instruction inst) {
        MultiArrayOperand operand = (MultiArrayOperand)inst.operand();
        int dim = operand.dimensions();
        this.height += 1 - dim;
    }

    public void visit_ifnull(Instruction inst) {
        --this.height;
    }

    public void visit_ifnonnull(Instruction inst) {
        --this.height;
    }

    public void visit_aswizzle(Instruction inst) {
        this.height -= 2;
    }

    public void visit_aswrange(Instruction inst) {
        this.height -= 3;
    }

    public Object clone() {
        StackHeightCounter clone = new StackHeightCounter(this.method);
        clone.height = this.height;
        clone.labelHeights = (HashMap)this.labelHeights.clone();
        return clone;
    }
}

