/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.inline;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.ClassHierarchy;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.inline.CallGraph;
import EDU.purdue.cs.bloat.inline.InlineContext;
import EDU.purdue.cs.bloat.inline.InlineStats;
import EDU.purdue.cs.bloat.inline.InstructionStack;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Specialize
implements Opcode {
    public static boolean DEBUG = false;
    public static boolean DB_STATIC = false;
    public static boolean PRINTCODE = false;
    public static boolean STATS = false;
    public static boolean NOSTATIC = false;
    public static boolean USE_PREEXISTS = true;
    private Map staticMethods = new HashMap();
    private Set specialized = new HashSet();
    private InlineStats stats;
    public static int MAX_MORPH = 5;
    public static boolean MONO = false;
    private InlineContext context;

    private static void db(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }

    public Specialize(InlineContext context) {
        this.context = context;
        this.stats = context.getInlineStats();
    }

    public boolean specialize(MethodEditor method) {
        Object o;
        if (method.isNative()) {
            return false;
        }
        if (this.context.ignoreMethod(method.memberRef())) {
            return false;
        }
        Specialize.db("\nSpecializing " + method.declaringClass().name() + "." + method.name() + method.type());
        CallGraph cg = this.context.getCallGraph();
        boolean changed = false;
        InstructionStack stack = new InstructionStack(method);
        List code = method.code();
        for (int i = 0; i < code.size(); ++i) {
            Iterator iter;
            o = code.get(i);
            if (o instanceof Instruction) {
                Instruction inst;
                block59: {
                    MethodEditor me;
                    MemberRef callee;
                    inst = (Instruction)o;
                    if (inst.opcodeClass() == 182 || inst.opcodeClass() == 185) {
                        boolean mono;
                        Specialize.db("  Call: " + inst);
                        callee = (MemberRef)inst.operand();
                        if (this.context.ignoreMethod(callee)) {
                            Specialize.db("    Explicitly ignoring this method");
                            stack.handle(inst);
                            continue;
                        }
                        me = null;
                        try {
                            me = this.context.editMethod(callee);
                        }
                        catch (NoSuchMethodException ex0) {
                            System.err.println("** Cannot find method " + callee);
                            ex0.printStackTrace(System.err);
                            System.exit(1);
                        }
                        if (me.isFinal() && !me.isNative()) {
                            Specialize.db("  Converting final method " + callee + " to static");
                            int index = code.indexOf(inst);
                            Instruction newInst = new Instruction(183, me.memberRef());
                            code.add(index, newInst);
                            code.remove(inst);
                            stack.handle(newInst);
                            continue;
                        }
                        int nArgs = callee.nameAndType().type().paramTypes().length;
                        Set pushes = stack.atDepth(nArgs);
                        if (DEBUG) {
                            Specialize.db("    Receiver on stack after: " + (stack.preexistsAtDepth(nArgs) != null ? " (preexists)" : ""));
                            Iterator pushies = pushes.iterator();
                            while (pushies.hasNext()) {
                                Instruction push = (Instruction)pushies.next();
                                Specialize.db("      " + code.indexOf(push) + ") " + push);
                            }
                        }
                        Set set = null;
                        if (USE_PREEXISTS) {
                            HashSet preexists = stack.preexistsAtDepth(nArgs);
                            if (preexists == null) {
                                stack.handle(inst);
                                if (STATS) {
                                    this.stats.noteNoPreexist();
                                }
                                Specialize.db("    Receiver does not preexist");
                                continue;
                            }
                            if (!preexists.isEmpty()) {
                                set = cg.resolvesTo(callee, preexists);
                                if (DEBUG) {
                                    StringBuffer sb = new StringBuffer("  retaining: ");
                                    Iterator iter2 = preexists.iterator();
                                    while (iter2.hasNext()) {
                                        Type type = (Type)iter2.next();
                                        sb.append(Type.truncatedName(type));
                                        if (!iter2.hasNext()) continue;
                                        sb.append(", ");
                                    }
                                    Specialize.db(sb.toString());
                                }
                            }
                        }
                        if (set == null) {
                            set = cg.resolvesTo(callee);
                        }
                        if (set == null || set.isEmpty() || this.specialized.contains(inst)) {
                            Specialize.db("    " + (this.specialized.contains(inst) ? "Call already handled" : "Resolves to no methods") + ".  Ignoring.");
                            stack.handle(inst);
                            continue;
                        }
                        this.specialized.add(inst);
                        if (STATS) {
                            this.stats.noteMorphicity(set.size());
                        }
                        if (set.size() > MAX_MORPH) {
                            stack.handle(inst);
                            continue;
                        }
                        changed = true;
                        LocalVariable var = method.newLocal(callee.declaringClass());
                        Specialize.db("  New local: " + var + " " + var.type() + " (from method " + method.name() + method.type() + ", max " + method.maxLocals() + ")");
                        Iterator iter3 = pushes.iterator();
                        Assert.isTrue(iter3.hasNext(), "No instruction pushes receiver for " + inst);
                        Instruction newInst = null;
                        boolean bl = mono = set.size() == 1;
                        while (!mono && iter3.hasNext()) {
                            Instruction push = (Instruction)iter3.next();
                            int index = code.indexOf(push);
                            Assert.isTrue(index != -1, push + " not found in code");
                            newInst = new Instruction(89);
                            code.add(index + 1, newInst);
                            Instruction store = new Instruction(58, var);
                            code.add(index + 2, store);
                        }
                        i = code.indexOf(inst) - 1;
                        Specialize.db("    Specializing call site...");
                        Label nextLabel = null;
                        Label endLabel = method.newLabel();
                        endLabel.setStartsBlock(true);
                        endLabel.setComment("End Specialization");
                        int index = code.indexOf(inst);
                        Assert.isTrue(index != -1, "Call " + inst + " not found in code");
                        --index;
                        Assert.isTrue(set != null, "Call to " + callee + " should resolve to something");
                        Object[] sortedSites = set.toArray();
                        if (sortedSites.length == 1) {
                            Specialize.db("    Monomorphic call site");
                            MemberRef resolvesTo = (MemberRef)sortedSites[0];
                            MethodEditor resolvesToMethod = null;
                            try {
                                resolvesToMethod = this.context.editMethod(resolvesTo);
                            }
                            catch (NoSuchMethodException ex) {
                                System.err.println("** No such method " + resolvesTo);
                                System.exit(1);
                            }
                            if (resolvesToMethod.isNative()) {
                                newInst = new Instruction(183, resolvesTo);
                                code.add(++index, newInst);
                            } else {
                                if (NOSTATIC) {
                                    newInst = new Instruction(inst.opcodeClass(), inst.operand());
                                    this.specialized.add(newInst);
                                } else {
                                    newInst = new Instruction(183, resolvesToMethod.memberRef());
                                }
                                code.add(++index, newInst);
                            }
                            code.remove(inst);
                            continue;
                        }
                        for (int s = 0; s < sortedSites.length && s <= MAX_MORPH; ++s) {
                            MemberRef resolvesTo = (MemberRef)sortedSites[s];
                            if (this.context.ignoreMethod(resolvesTo)) continue;
                            Specialize.db("    Resolves to " + resolvesTo + ")");
                            Type rType = resolvesTo.declaringClass();
                            if (nextLabel != null) {
                                nextLabel.setComment("Type " + rType);
                                code.add(++index, nextLabel);
                            }
                            newInst = new Instruction(25, var);
                            code.add(++index, newInst);
                            newInst = new Instruction(193, rType);
                            code.add(++index, newInst);
                            nextLabel = method.newLabel();
                            nextLabel.setStartsBlock(true);
                            newInst = new Instruction(153, nextLabel);
                            code.add(++index, newInst);
                            Label grumble = method.newLabel();
                            grumble.setStartsBlock(true);
                            code.add(++index, grumble);
                            MethodEditor resolvesToMethod = null;
                            try {
                                resolvesToMethod = this.context.editMethod(resolvesTo);
                            }
                            catch (NoSuchMethodException ex) {
                                System.err.println("** No such method " + resolvesTo);
                                System.exit(1);
                            }
                            if (resolvesToMethod.isNative()) {
                                newInst = new Instruction(183, resolvesTo);
                                code.add(++index, newInst);
                            } else {
                                if (NOSTATIC) {
                                    newInst = new Instruction(inst.opcodeClass(), inst.operand());
                                    this.specialized.add(newInst);
                                } else {
                                    newInst = new Instruction(183, resolvesToMethod.memberRef());
                                }
                                code.add(++index, newInst);
                            }
                            newInst = new Instruction(167, endLabel);
                            code.add(++index, newInst);
                        }
                        if (nextLabel != null) {
                            nextLabel.setComment("Default invocation");
                            code.add(++index, nextLabel);
                        }
                        ++index;
                        newInst = new Instruction(167, endLabel);
                        code.add(++index, newInst);
                        code.add(++index, endLabel);
                        if (!DEBUG) continue;
                        System.out.println("  Code after specializing " + callee.name() + callee.type());
                        for (int j = 0; j <= index + 2 && j < code.size(); ++j) {
                            Object q = code.get(j);
                            if (q instanceof Label) {
                                Label label = (Label)q;
                                System.out.println("      " + j + ") " + label + (label.startsBlock() ? " (starts block)" : ""));
                                continue;
                            }
                            System.out.println("      " + j + ") " + q);
                        }
                        continue;
                    }
                    if (inst.opcodeClass() == 183) {
                        callee = (MemberRef)inst.operand();
                        me = null;
                        try {
                            me = this.context.editMethod(callee);
                            if (me.isNative() || me.isSynchronized() || me.isConstructor()) {
                                stack.handle(inst);
                                break block59;
                            }
                            Type calleeType = callee.declaringClass();
                            Type callerType = method.declaringClass().type();
                            ClassHierarchy hier = this.context.getHierarchy();
                            if (calleeType.equals(callerType) || hier.subclassOf(callerType, calleeType)) {
                                Specialize.db("  Making special " + inst + " static");
                                int index = code.indexOf(inst);
                                Instruction newInst = new Instruction(183, me.memberRef());
                                code.add(index, newInst);
                                code.remove(inst);
                                stack.handle(newInst);
                                break block59;
                            }
                            stack.handle(inst);
                        }
                        catch (NoSuchMethodException ex2) {
                            System.err.println("** Couldn't find method " + callee);
                            ex2.printStackTrace(System.err);
                            System.exit(1);
                        }
                    } else {
                        stack.handle(inst);
                    }
                }
                if (!DEBUG) continue;
                Specialize.db("    " + code.indexOf(inst) + ") " + inst);
                for (int q = 0; q < stack.height(); ++q) {
                    iter = stack.atDepth(q).iterator();
                    if (iter.hasNext()) {
                        System.out.print("      ");
                    }
                    while (iter.hasNext()) {
                        System.out.print(code.indexOf(iter.next()));
                        if (!iter.hasNext()) continue;
                        System.out.print(", ");
                    }
                    if (stack.preexistsAtDepth(q) != null) {
                        System.out.print(" (preexists)");
                    } else {
                        System.out.print(" (does not preexist)");
                    }
                    System.out.println("");
                }
                continue;
            }
            if (o instanceof Label) {
                Label label = (Label)o;
                stack.handle(label);
                Specialize.db("    " + o);
                if (!DEBUG) continue;
                for (int q = 0; q < stack.height(); ++q) {
                    iter = stack.atDepth(q).iterator();
                    if (iter.hasNext()) {
                        System.out.print("      ");
                    }
                    while (iter.hasNext()) {
                        System.out.print(code.indexOf(iter.next()));
                        if (!iter.hasNext()) continue;
                        System.out.print(", ");
                    }
                    System.out.println("");
                }
                continue;
            }
            Assert.isTrue(false, "What is " + o + " doing in the instruction stream?");
        }
        if (DEBUG || PRINTCODE) {
            System.out.println("Specialized code for " + method.declaringClass().name() + "." + method.name() + method.type());
            Iterator iter2 = code.iterator();
            while (iter2.hasNext()) {
                o = iter2.next();
                if (o instanceof Label) {
                    System.out.println("");
                }
                System.out.println("  " + o);
            }
        }
        if (changed) {
            method.setDirty(true);
        }
        return changed;
    }

    private MemberRef makeStatic(MethodEditor method) {
        Assert.isFalse(method.isAbstract() || method.isNative() || method.isStatic(), "Method " + method.declaringClass().name() + "." + method.name() + method.type() + " is not concrete virtual: " + (method.isAbstract() ? " abstract" : "") + (method.isNative() ? " native" : "") + (method.isStatic() ? " static" : ""));
        MemberRef ref = (MemberRef)this.staticMethods.get(method);
        if (ref == null) {
            ClassEditor ce = method.declaringClass();
            NameAndType nat = method.nameAndType();
            Type type = nat.type();
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            sb.append(ce.type().descriptor());
            Type[] params = type.paramTypes();
            for (int i = 0; i < params.length; ++i) {
                sb.append(params[i].descriptor());
            }
            sb.append(")");
            sb.append(type.returnType());
            Type newType = Type.getType(sb.toString());
            String newName = nat.name() + "$$BLOAT_" + newType.hashCode();
            newName = newName.replace('-', '$');
            NameAndType newNat = new NameAndType(newName, newType);
            ref = new MemberRef(ce.type(), newNat);
            this.staticMethods.put(method, ref);
        }
        return ref;
    }
}

