/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.file;

import EDU.purdue.cs.bloat.file.Attribute;
import EDU.purdue.cs.bloat.file.Code;
import EDU.purdue.cs.bloat.file.Exceptions;
import EDU.purdue.cs.bloat.file.GenericAttribute;
import EDU.purdue.cs.bloat.reflect.Catch;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.Constant;
import EDU.purdue.cs.bloat.reflect.LineNumberDebugInfo;
import EDU.purdue.cs.bloat.reflect.LocalDebugInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import EDU.purdue.cs.bloat.util.Assert;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Method
implements MethodInfo {
    private ClassInfo classInfo;
    private int modifiers;
    private int name;
    private int type;
    private Attribute[] attrs;
    private Code code;
    private Exceptions exceptions;
    public static boolean DEBUG = Boolean.getBoolean("Method.DEBUG");

    Method(ClassInfo classInfo, int modifiers, int name, int type, Attribute[] attrs, Code code, Exceptions exceptions) {
        this.classInfo = classInfo;
        this.modifiers = modifiers;
        this.name = name;
        this.type = type;
        Assert.isNotNull(attrs, "Every method must have at least a Code attribute");
        this.attrs = attrs;
        this.code = code;
        this.exceptions = exceptions;
    }

    public Method(DataInputStream in, ClassInfo classInfo) throws IOException {
        this.classInfo = classInfo;
        this.modifiers = in.readUnsignedShort();
        this.name = in.readUnsignedShort();
        this.type = in.readUnsignedShort();
        int numAttributes = in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            int nameIndex = in.readUnsignedShort();
            int length = in.readInt();
            Constant name = classInfo.constants()[nameIndex];
            if (name != null) {
                if ("Code".equals(name.value())) {
                    this.code = new Code(classInfo, in, nameIndex, length);
                    this.attrs[i] = this.code;
                } else if ("Exceptions".equals(name.value())) {
                    this.exceptions = new Exceptions(classInfo, in, nameIndex, length);
                    this.attrs[i] = this.exceptions;
                }
            }
            if (this.attrs[i] != null) continue;
            this.attrs[i] = new GenericAttribute(in, nameIndex, length);
        }
    }

    public ClassInfo declaringClass() {
        return this.classInfo;
    }

    public void setNameIndex(int name) {
        this.name = name;
    }

    public void setTypeIndex(int type) {
        this.type = type;
    }

    public int nameIndex() {
        return this.name;
    }

    public int typeIndex() {
        return this.type;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public int maxStack() {
        if (this.code != null) {
            return this.code.maxStack();
        }
        return 0;
    }

    public void setMaxStack(int maxStack) {
        if (this.code != null) {
            this.code.setMaxStack(maxStack);
        }
    }

    public int maxLocals() {
        if (this.code != null) {
            return this.code.maxLocals();
        }
        return 0;
    }

    public void setMaxLocals(int maxLocals) {
        if (this.code != null) {
            this.code.setMaxLocals(maxLocals);
        }
    }

    public byte[] code() {
        if (this.code != null) {
            return this.code.code();
        }
        return new byte[0];
    }

    public int codeLength() {
        if (this.code != null) {
            return this.code.codeLength();
        }
        return 0;
    }

    public void setCode(byte[] bytes) {
        if (this.code != null) {
            this.code.setCode(bytes);
            if (DEBUG) {
                System.out.println("Set code with " + bytes.length + " bytes");
            }
        }
    }

    public int[] exceptionTypes() {
        if (this.exceptions != null) {
            return this.exceptions.exceptionTypes();
        }
        return new int[0];
    }

    public void setLineNumbers(LineNumberDebugInfo[] lineNumbers) {
        if (this.code != null) {
            this.code.setLineNumbers(lineNumbers);
        }
    }

    public void setLocals(LocalDebugInfo[] locals) {
        if (this.code != null) {
            this.code.setLocals(locals);
        }
    }

    public LineNumberDebugInfo[] lineNumbers() {
        if (this.code != null) {
            return this.code.lineNumbers();
        }
        return new LineNumberDebugInfo[0];
    }

    public LocalDebugInfo[] locals() {
        if (this.code != null) {
            return this.code.locals();
        }
        return new LocalDebugInfo[0];
    }

    public Catch[] exceptionHandlers() {
        if (this.code != null) {
            return this.code.exceptionHandlers();
        }
        return new Catch[0];
    }

    public void setExceptionHandlers(Catch[] handlers) {
        if (this.code != null) {
            this.code.setExceptionHandlers(handlers);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        if (DEBUG) {
            System.out.println("Writing method " + this);
            System.out.println("  Masked Modifiers: " + (this.modifiers & 0xF000));
        }
        out.writeShort(this.modifiers);
        out.writeShort(this.name);
        out.writeShort(this.type);
        out.writeShort(this.attrs.length);
        for (int i = 0; i < this.attrs.length; ++i) {
            if (DEBUG) {
                System.out.println("  " + this.attrs[i]);
            }
            out.writeShort(this.attrs[i].nameIndex());
            out.writeInt(this.attrs[i].length());
            this.attrs[i].writeData(out);
        }
    }

    public String toString() {
        String x = "";
        x = x + " (modifiers";
        if ((this.modifiers & 1) != 0) {
            x = x + " PUBLIC";
        }
        if ((this.modifiers & 2) != 0) {
            x = x + " PRIVATE";
        }
        if ((this.modifiers & 4) != 0) {
            x = x + " PROTECTED";
        }
        if ((this.modifiers & 8) != 0) {
            x = x + " STATIC";
        }
        if ((this.modifiers & 0x10) != 0) {
            x = x + " FINAL";
        }
        if ((this.modifiers & 0x20) != 0) {
            x = x + " SYNCHRONIZED";
        }
        if ((this.modifiers & 0x40) != 0) {
            x = x + " VOLATILE";
        }
        if ((this.modifiers & 0x80) != 0) {
            x = x + " TRANSIENT";
        }
        if ((this.modifiers & 0x100) != 0) {
            x = x + " NATIVE";
        }
        if ((this.modifiers & 0x200) != 0) {
            x = x + " INTERFACE";
        }
        if ((this.modifiers & 0x400) != 0) {
            x = x + " ABSTRACT";
        }
        x = x + ")";
        return "(method " + this.name + " " + this.type + x + (this.code != null ? "\n      " + this.code : "") + (this.exceptions != null ? "\n      " + this.exceptions : "") + ")";
    }

    private Method(ClassInfo classInfo, int modifiers, int name, int type, Attribute[] attrs) {
        this.classInfo = classInfo;
        this.modifiers = modifiers;
        this.name = name;
        this.type = type;
        if (attrs != null) {
            this.attrs = new Attribute[attrs.length];
            for (int i = 0; i < attrs.length; ++i) {
                Attribute attr = (Attribute)attrs[i].clone();
                if (attr instanceof Code) {
                    this.code = (Code)attr;
                } else if (attr instanceof Exceptions) {
                    this.exceptions = (Exceptions)attr;
                }
                this.attrs[i] = attr;
            }
        }
        Assert.isTrue(this.code != null, "No Code in attributes");
        Assert.isTrue(this.exceptions != null, "No Exceptions in attributes");
    }

    public Object clone() {
        return new Method(this.classInfo, this.modifiers, this.name, this.type, this.attrs);
    }
}

