/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.file;

import EDU.purdue.cs.bloat.file.Attribute;
import EDU.purdue.cs.bloat.reflect.LineNumberDebugInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LineNumberTable
extends Attribute {
    private LineNumberDebugInfo[] lineNumbers;

    public LineNumberTable(DataInputStream in, int nameIndex, int length) throws IOException {
        super(nameIndex, length);
        int numLines = in.readUnsignedShort();
        this.lineNumbers = new LineNumberDebugInfo[numLines];
        for (int i = 0; i < this.lineNumbers.length; ++i) {
            int startPC = in.readUnsignedShort();
            int lineNumber = in.readUnsignedShort();
            this.lineNumbers[i] = new LineNumberDebugInfo(startPC, lineNumber);
        }
    }

    public LineNumberDebugInfo[] lineNumbers() {
        return this.lineNumbers;
    }

    public void setLineNumbers(LineNumberDebugInfo[] lineNumbers) {
        this.lineNumbers = lineNumbers;
    }

    public int length() {
        return 2 + this.lineNumbers.length * 4;
    }

    public String toString() {
        String x = "(lines";
        for (int i = 0; i < this.lineNumbers.length; ++i) {
            x = x + "\n          (line #" + this.lineNumbers[i].lineNumber() + " pc=" + this.lineNumbers[i].startPC() + ")";
        }
        return x + ")";
    }

    public void writeData(DataOutputStream out) throws IOException {
        out.writeShort(this.lineNumbers.length);
        for (int i = 0; i < this.lineNumbers.length; ++i) {
            out.writeShort(this.lineNumbers[i].startPC());
            out.writeShort(this.lineNumbers[i].lineNumber());
        }
    }

    private LineNumberTable(LineNumberTable other) {
        super(other.nameIndex, other.length);
        this.lineNumbers = new LineNumberDebugInfo[other.lineNumbers.length];
        for (int i = 0; i < other.lineNumbers.length; ++i) {
            this.lineNumbers[i] = (LineNumberDebugInfo)other.lineNumbers[i].clone();
        }
    }

    public Object clone() {
        return new LineNumberTable(this);
    }
}

