/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.file;

import EDU.purdue.cs.bloat.file.Attribute;
import EDU.purdue.cs.bloat.file.ConstantValue;
import EDU.purdue.cs.bloat.file.GenericAttribute;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.Constant;
import EDU.purdue.cs.bloat.reflect.FieldInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Field
implements FieldInfo {
    private ClassInfo classInfo;
    private int modifiers;
    private int name;
    private int type;
    private Attribute[] attrs;
    private ConstantValue constantValue;

    Field(ClassInfo classInfo, int modifiers, int typeIndex, int nameIndex) {
        this.classInfo = classInfo;
        this.modifiers = modifiers;
        this.name = nameIndex;
        this.type = typeIndex;
        this.attrs = new Attribute[0];
        this.constantValue = null;
    }

    Field(ClassInfo classInfo, int modifiers, int typeIndex, int nameIndex, int cvNameIndex, int constantValueIndex) {
        this.classInfo = classInfo;
        this.modifiers = modifiers;
        this.name = nameIndex;
        this.type = typeIndex;
        this.constantValue = new ConstantValue(cvNameIndex, 2, constantValueIndex);
        this.attrs = new Attribute[1];
        this.attrs[0] = this.constantValue;
    }

    public Field(DataInputStream in, ClassInfo classInfo) throws IOException {
        this.classInfo = classInfo;
        this.modifiers = in.readUnsignedShort();
        this.name = in.readUnsignedShort();
        this.type = in.readUnsignedShort();
        int numAttributes = in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            int nameIndex = in.readUnsignedShort();
            int length = in.readInt();
            Constant name = classInfo.constants()[nameIndex];
            if (name != null && "ConstantValue".equals(name.value())) {
                this.constantValue = new ConstantValue(in, nameIndex, length);
                this.attrs[i] = this.constantValue;
            }
            if (this.attrs[i] != null) continue;
            this.attrs[i] = new GenericAttribute(in, nameIndex, length);
        }
    }

    public ClassInfo declaringClass() {
        return this.classInfo;
    }

    public void setNameIndex(int name) {
        this.name = name;
    }

    public void setTypeIndex(int type) {
        this.type = type;
    }

    public int nameIndex() {
        return this.name;
    }

    public int typeIndex() {
        return this.type;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public int constantValue() {
        if (this.constantValue != null) {
            return this.constantValue.constantValueIndex();
        }
        return 0;
    }

    public void setConstantValue(int index) {
        if (this.constantValue != null) {
            this.constantValue.setConstantValueIndex(index);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.modifiers);
        out.writeShort(this.name);
        out.writeShort(this.type);
        out.writeShort(this.attrs.length);
        for (int i = 0; i < this.attrs.length; ++i) {
            out.writeShort(this.attrs[i].nameIndex());
            out.writeInt(this.attrs[i].length());
            this.attrs[i].writeData(out);
        }
    }

    public String toString() {
        String x = "";
        x = x + " (modifiers";
        if ((this.modifiers & 1) != 0) {
            x = x + " PUBLIC";
        }
        if ((this.modifiers & 2) != 0) {
            x = x + " PRIVATE";
        }
        if ((this.modifiers & 4) != 0) {
            x = x + " PROTECTED";
        }
        if ((this.modifiers & 8) != 0) {
            x = x + " STATIC";
        }
        if ((this.modifiers & 0x10) != 0) {
            x = x + " FINAL";
        }
        if ((this.modifiers & 0x20) != 0) {
            x = x + " SYNCHRONIZED";
        }
        if ((this.modifiers & 0x40) != 0) {
            x = x + " VOLATILE";
        }
        if ((this.modifiers & 0x80) != 0) {
            x = x + " TRANSIENT";
        }
        if ((this.modifiers & 0x100) != 0) {
            x = x + " NATIVE";
        }
        if ((this.modifiers & 0x200) != 0) {
            x = x + " INTERFACE";
        }
        if ((this.modifiers & 0x400) != 0) {
            x = x + " ABSTRACT";
        }
        x = x + ")";
        if (this.constantValue != null) {
            x = x + " " + this.constantValue;
        }
        return "(field " + this.name + " " + this.type + x + ")";
    }
}

