/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.file;

import EDU.purdue.cs.bloat.file.Attribute;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Exceptions
extends Attribute {
    private int[] exceptions;
    private ClassInfo classInfo;

    Exceptions(ClassInfo info, int nameIndex, int[] exceptions) {
        super(nameIndex, 2 * exceptions.length + 2);
        this.classInfo = this.classInfo;
        this.exceptions = exceptions;
    }

    public Exceptions(ClassInfo classInfo, DataInputStream in, int nameIndex, int length) throws IOException {
        super(nameIndex, length);
        this.classInfo = classInfo;
        int count = in.readUnsignedShort();
        this.exceptions = new int[count];
        for (int i = 0; i < count; ++i) {
            this.exceptions[i] = in.readUnsignedShort();
        }
    }

    public void writeData(DataOutputStream out) throws IOException {
        out.writeShort(this.exceptions.length);
        for (int i = 0; i < this.exceptions.length; ++i) {
            out.writeShort(this.exceptions[i]);
        }
    }

    public int[] exceptionTypes() {
        return this.exceptions;
    }

    public int length() {
        return 2 + this.exceptions.length * 2;
    }

    private Exceptions(Exceptions other) {
        super(other.nameIndex, other.length);
        this.exceptions = new int[other.exceptions.length];
        System.arraycopy(other.exceptions, 0, this.exceptions, 0, other.exceptions.length);
        this.classInfo = other.classInfo;
    }

    public Object clone() {
        return new Exceptions(this);
    }

    public String toString() {
        return "(exceptions)";
    }
}

